/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit;

import com.ibm.wssvt.acme.annuity.common.bean.IAddress;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.bean.IBeneContact;
import com.ibm.wssvt.acme.annuity.common.bean.IBeneficiary;
import com.ibm.wssvt.acme.annuity.common.bean.IConfigData;
import com.ibm.wssvt.acme.annuity.common.bean.IContact;
import com.ibm.wssvt.acme.annuity.common.bean.IEquityAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IFixedAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IFund;
import com.ibm.wssvt.acme.annuity.common.bean.IPayor;
import com.ibm.wssvt.acme.annuity.common.bean.IPayout;
import com.ibm.wssvt.acme.annuity.common.bean.IPolicy;
import com.ibm.wssvt.acme.annuity.common.bean.IRider;
import com.ibm.wssvt.acme.annuity.common.bean.Identifiable;
import com.ibm.wssvt.acme.annuity.common.bean.jpa.BeneContactId;
import com.ibm.wssvt.acme.common.executionunit.ExecutionUnitVerificationException;
import com.ibm.wssvt.acme.common.executionunit.IExecutionUnit;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class ExecutionUnitVerificationHelper {
    private static final String VERIFY_EXACT_DATES = "verifyExactDates";
    private static DecimalFormat decimalFormat = new DecimalFormat("#.##");

    public static void assertNotNull(IExecutionUnit executionUnit, Object o, String preMsg, String postMsg) throws ExecutionUnitVerificationException {
        if (o == null) {
            throw new ExecutionUnitVerificationException(ExecutionUnitVerificationHelper.formatMessage(executionUnit.getDescription(), preMsg, postMsg, "The object is null"));
        }
    }

    public static void assertValidId(IExecutionUnit executionUnit, Identifiable o, String preMsg, String postMsg) throws ExecutionUnitVerificationException {
        ExecutionUnitVerificationHelper.assertNotNull(executionUnit, o, preMsg, postMsg);
        ExecutionUnitVerificationHelper.assertNotNull(executionUnit, o.getId(), preMsg, postMsg);
    }

    public static void assertEquals(IExecutionUnit executionUnit, Comparable param1, Comparable results, String preMsg, String postMsg) throws ExecutionUnitVerificationException {
        ExecutionUnitVerificationHelper.assertNullabilityAndClass(executionUnit, param1, results, preMsg, postMsg);
        if (results == null) {
            return;
        }
        if (param1.compareTo(results) == 0) {
            return;
        }
        throw new ExecutionUnitVerificationException(ExecutionUnitVerificationHelper.formatMessage(executionUnit.getDescription(), preMsg, postMsg, "The parameters are not equal.  Param:" + param1 + " is not equal to results: " + results));
    }

    public static void assertCalendarYYYYMMDDEquals(IExecutionUnit executionUnit, Calendar date, Calendar results, String preMsg, String postMsg) throws ExecutionUnitVerificationException {
        ExecutionUnitVerificationHelper.assertNullabilityAndClass(executionUnit, date, results, preMsg, postMsg);
        if (results == null) {
            return;
        }
        if ("true".equalsIgnoreCase((String)executionUnit.getConfiguration().getParameterValue((Object)VERIFY_EXACT_DATES)) && (date.get(1) != results.get(1) || date.get(2) != results.get(2) || date.get(5) != results.get(5))) {
            throw new ExecutionUnitVerificationException(ExecutionUnitVerificationHelper.formatMessage(executionUnit.getDescription(), preMsg, postMsg, date + " is not equal to results: " + results + " One of these attributes is different: Year, Month or Day"));
        }
    }

    public static void assertDateHHMMSSEquals(IExecutionUnit executionUnit, Date date, Date results, String preMsg, String postMsg) throws ExecutionUnitVerificationException {
        ExecutionUnitVerificationHelper.assertNullabilityAndClass(executionUnit, date, results, preMsg, postMsg);
        if (results == null) {
            return;
        }
        if ("true".equalsIgnoreCase((String)executionUnit.getConfiguration().getParameterValue((Object)VERIFY_EXACT_DATES))) {
            Calendar dateCal = Calendar.getInstance();
            dateCal.setTime(date);
            Calendar resultsCal = Calendar.getInstance();
            resultsCal.setTime(results);
            if (dateCal.get(10) != resultsCal.get(10) || dateCal.get(12) != resultsCal.get(12) || dateCal.get(13) != resultsCal.get(13)) {
                throw new ExecutionUnitVerificationException(ExecutionUnitVerificationHelper.formatMessage(executionUnit.getDescription(), preMsg, postMsg, date + " is not equal to results: " + results));
            }
        }
    }

    public static void assertDateYYYYMMDDEquals(IExecutionUnit executionUnit, Date date, Date results, String preMsg, String postMsg) throws ExecutionUnitVerificationException {
        ExecutionUnitVerificationHelper.assertNullabilityAndClass(executionUnit, date, results, preMsg, postMsg);
        if (results == null) {
            return;
        }
        if ("true".equalsIgnoreCase((String)executionUnit.getConfiguration().getParameterValue((Object)VERIFY_EXACT_DATES))) {
            Calendar dateCal = Calendar.getInstance();
            dateCal.setTime(date);
            Calendar resultsCal = Calendar.getInstance();
            resultsCal.setTime(results);
            if (dateCal.get(1) != resultsCal.get(1) || dateCal.get(2) != resultsCal.get(2) || dateCal.get(5) != resultsCal.get(5)) {
                throw new ExecutionUnitVerificationException(ExecutionUnitVerificationHelper.formatMessage(executionUnit.getDescription(), preMsg, postMsg, date + " is not equal to results: " + results));
            }
        }
    }

    public static void assertDateGTorEquals(IExecutionUnit executionUnit, Date d1, Date d2, String preMsg, String postMsg) throws ExecutionUnitVerificationException {
        if (d1.compareTo(d2) < 0) {
            throw new ExecutionUnitVerificationException(ExecutionUnitVerificationHelper.formatMessage(executionUnit.getDescription(), preMsg, postMsg, "date1 is less than d2"));
        }
    }

    public static void assertIdContains(IExecutionUnit executionUnit, String id1, String id2, String preMsg, String postMsg) throws ExecutionUnitVerificationException {
        if (!id1.contains(id2)) {
            throw new ExecutionUnitVerificationException(ExecutionUnitVerificationHelper.formatMessage(executionUnit.getDescription(), preMsg, postMsg, "Object id is not a subset"));
        }
    }

    public static void assertEqual(IExecutionUnit executionUnit, IAnnuityHolder annuityHolder, IAnnuityHolder results, String preMsg, String postMsg) throws ExecutionUnitVerificationException {
        ExecutionUnitVerificationHelper.assertNullabilityAndClass(executionUnit, annuityHolder, results, preMsg, postMsg);
        if (results == null) {
            return;
        }
        ExecutionUnitVerificationHelper.assertEqual(executionUnit, annuityHolder.getPicture(), results.getPicture(), preMsg, postMsg + " for AnnuityHolder Picture");
        ExecutionUnitVerificationHelper.assertNotNull(executionUnit, results.getLastUpdateDate(), preMsg + " AnnuityHolder:" + (String)annuityHolder.getId() + " lastUpdateDate validation error", " results value is null.");
        ExecutionUnitVerificationHelper.assertEquals(executionUnit, (Comparable)annuityHolder.getId(), (Comparable)results.getId(), preMsg + " AnnuityHolder:" + (String)annuityHolder.getId() + "  Id validation error", postMsg);
        ExecutionUnitVerificationHelper.assertEquals(executionUnit, (Comparable)((Object)annuityHolder.getFirstName()), (Comparable)((Object)results.getFirstName()), preMsg + " AnnuityHolder:" + (String)annuityHolder.getId() + "  first Name validation error", postMsg);
        ExecutionUnitVerificationHelper.assertEquals(executionUnit, (Comparable)((Object)annuityHolder.getGovernmentId()), (Comparable)((Object)results.getGovernmentId()), preMsg + " AnnuityHolder:" + (String)annuityHolder.getId() + "  government id validation error", postMsg);
        ExecutionUnitVerificationHelper.assertEquals(executionUnit, (Comparable)((Object)annuityHolder.getLastName()), (Comparable)((Object)results.getLastName()), preMsg + " AnnuityHolder:" + (String)annuityHolder.getId() + "  last Name validation error", postMsg);
        ExecutionUnitVerificationHelper.assertEquals(executionUnit, (Comparable)((Object)annuityHolder.getCategory()), (Comparable)((Object)results.getCategory()), preMsg + " AnnuityHolder:" + (String)annuityHolder.getId() + "  Category validation error", postMsg);
        ExecutionUnitVerificationHelper.assertDateYYYYMMDDEquals(executionUnit, annuityHolder.getDateOfBirth(), results.getDateOfBirth(), preMsg + " AnnuityHolder:" + (String)annuityHolder.getId() + "  date of birth validation error", postMsg);
        ExecutionUnitVerificationHelper.assertDateHHMMSSEquals(executionUnit, annuityHolder.getTimeOfBirth(), results.getTimeOfBirth(), preMsg + " AnnuityHolder:" + (String)annuityHolder.getId() + "  time of birth validation error", postMsg);
    }

    public static void assertEqual(IExecutionUnit executionUnit, Byte[] param1, Byte[] results, String preMsg, String postMsg) throws ExecutionUnitVerificationException {
        ExecutionUnitVerificationHelper.assertNullabilityAndClass(executionUnit, param1, results, preMsg, postMsg);
        if (results == null) {
            return;
        }
        if (param1.length != results.length) {
            throw new ExecutionUnitVerificationException(ExecutionUnitVerificationHelper.formatMessage(executionUnit.getDescription(), preMsg, postMsg, "Array param1 size is not equal to array param2 size.  param1 length:" + param1.length + " param2 length: " + results.length));
        }
        for (int i = 0; i < param1.length; ++i) {
            if (param1[i].compareTo(results[i]) == 0) continue;
            throw new ExecutionUnitVerificationException(ExecutionUnitVerificationHelper.formatMessage(executionUnit.getDescription(), preMsg, postMsg, "Array param1 byte at location: " + i + " is not equal to array param2 value at the same location." + " param1 value: " + param1[i] + " param2 value: " + results[i]));
        }
    }

    public static void assertEqual(IExecutionUnit executionUnit, IContact contact, IContact results, String preMsg, String postMsg) throws ExecutionUnitVerificationException {
        ExecutionUnitVerificationHelper.assertNullabilityAndClass(executionUnit, contact, results, preMsg, postMsg);
        if (results == null) {
            return;
        }
        ExecutionUnitVerificationHelper.assertNotNull(executionUnit, results.getLastUpdateDate(), preMsg + " Contact:" + (String)contact.getId() + " lastUpdateDate validation error", "results value is null.");
        ExecutionUnitVerificationHelper.assertEquals(executionUnit, (Comparable)contact.getId(), (Comparable)results.getId(), preMsg + " Contact:" + (String)contact.getId() + "  Id validation error", postMsg);
        ExecutionUnitVerificationHelper.assertEquals(executionUnit, (Comparable)((Object)contact.getEmail()), (Comparable)((Object)results.getEmail()), preMsg + " Contact:" + (String)contact.getId() + "  Email validation error", postMsg);
        ExecutionUnitVerificationHelper.assertEquals(executionUnit, (Comparable)((Object)contact.getPhone()), (Comparable)((Object)results.getPhone()), preMsg + " Contact:" + (String)contact.getId() + "  Phone validation error", postMsg);
        ExecutionUnitVerificationHelper.assertEquals(executionUnit, (Comparable)((Object)contact.getContactType()), (Comparable)((Object)results.getContactType()), preMsg + " Contact:" + (String)contact.getId() + "  ContactType validation error", postMsg);
        ExecutionUnitVerificationHelper.assertEqual(executionUnit, contact.getAddress(), results.getAddress(), preMsg, postMsg);
    }

    public static void assertEqual(IExecutionUnit executionUnit, IAddress address, IAddress results, String preMsg, String postMsg) throws ExecutionUnitVerificationException {
        ExecutionUnitVerificationHelper.assertNullabilityAndClass(executionUnit, address, results, preMsg, postMsg);
        if (results == null) {
            return;
        }
        ExecutionUnitVerificationHelper.assertEquals(executionUnit, (Comparable)((Object)address.getLine1()), (Comparable)((Object)results.getLine1()), preMsg + " Contact.Address Line1 validation error", postMsg);
        ExecutionUnitVerificationHelper.assertEquals(executionUnit, (Comparable)((Object)address.getLine2()), (Comparable)((Object)results.getLine2()), preMsg + " Contact.Address Line2 validation error", postMsg);
        ExecutionUnitVerificationHelper.assertEquals(executionUnit, (Comparable)((Object)address.getCity()), (Comparable)((Object)results.getCity()), preMsg + " Contact.Address City validation error", postMsg);
        ExecutionUnitVerificationHelper.assertEquals(executionUnit, (Comparable)((Object)address.getState()), (Comparable)((Object)results.getState()), preMsg + " Contact.Address State validation error", postMsg);
        ExecutionUnitVerificationHelper.assertEquals(executionUnit, (Comparable)((Object)address.getCountry()), (Comparable)((Object)results.getCountry()), preMsg + " Contact.Address Country validation error", postMsg);
        ExecutionUnitVerificationHelper.assertEquals(executionUnit, (Comparable)((Object)address.getZipCode()), (Comparable)((Object)results.getZipCode()), preMsg + " Contact.Address Zip Code validation error", postMsg);
    }

    public static void assertEqual(IExecutionUnit executionUnit, IPayor payor, IPayor results, String preMsg, String postMsg) throws ExecutionUnitVerificationException {
        ExecutionUnitVerificationHelper.assertNullabilityAndClass(executionUnit, payor, results, preMsg, postMsg);
        if (results == null) {
            return;
        }
        ExecutionUnitVerificationHelper.assertNotNull(executionUnit, results.getLastUpdateDate(), preMsg + " Payor:" + (String)payor.getId() + " lastUpdateDate validation error", "results value is null.");
        ExecutionUnitVerificationHelper.assertEquals(executionUnit, (Comparable)payor.getId(), (Comparable)results.getId(), preMsg + " Payor:" + (String)payor.getId() + "  id validation error", postMsg);
        ExecutionUnitVerificationHelper.assertEquals(executionUnit, (Comparable)((Object)payor.getName()), (Comparable)((Object)results.getName()), preMsg + " Payor:" + (String)payor.getId() + "  name validation error", postMsg);
    }

    public static void assertEqual(IExecutionUnit executionUnit, IFixedAnnuity annuity, IFixedAnnuity results, String preMsg, String postMsg) throws ExecutionUnitVerificationException {
        ExecutionUnitVerificationHelper.assertNullabilityAndClass(executionUnit, annuity, results, preMsg, postMsg);
        if (results == null) {
            return;
        }
        ExecutionUnitVerificationHelper.assertEqual(executionUnit, (IAnnuity)annuity, (IAnnuity)results, preMsg, postMsg);
        Double d = annuity.getRate();
        if (d != null) {
            d = new Double(decimalFormat.format(d));
        }
        ExecutionUnitVerificationHelper.assertEquals(executionUnit, d, results.getRate(), preMsg, postMsg);
    }

    public static void assertEqual(IExecutionUnit executionUnit, IEquityAnnuity annuity, IEquityAnnuity results, String preMsg, String postMsg) throws ExecutionUnitVerificationException {
        ExecutionUnitVerificationHelper.assertNullabilityAndClass(executionUnit, annuity, results, preMsg, postMsg);
        if (results == null) {
            return;
        }
        ExecutionUnitVerificationHelper.assertEqual(executionUnit, (IAnnuity)annuity, (IAnnuity)results, preMsg, postMsg);
        Double d = annuity.getIndexRate();
        if (d != null) {
            d = new Double(decimalFormat.format(d));
        }
        ExecutionUnitVerificationHelper.assertEquals(executionUnit, d, results.getIndexRate(), preMsg, postMsg);
        ExecutionUnitVerificationHelper.assertEquals(executionUnit, (Comparable)((Object)annuity.getFundNames()), (Comparable)((Object)results.getFundNames()), preMsg, postMsg);
    }

    public static void assertEqual(IExecutionUnit executionUnit, IAnnuity annuity, IAnnuity results, String preMsg, String postMsg) throws ExecutionUnitVerificationException {
        ExecutionUnitVerificationHelper.assertNullabilityAndClass(executionUnit, annuity, results, preMsg, postMsg);
        if (results == null) {
            return;
        }
        ExecutionUnitVerificationHelper.assertNotNull(executionUnit, results.getLastUpdateDate(), preMsg + "Annuity:" + (String)annuity.getId() + " AnnuitylastUpdateDate validation error", "results value is null.");
        ExecutionUnitVerificationHelper.assertEquals(executionUnit, (Comparable)annuity.getId(), (Comparable)results.getId(), preMsg + "Annuity:" + (String)annuity.getId() + " Annuityid validation error", postMsg);
        ExecutionUnitVerificationHelper.assertEquals(executionUnit, (Comparable)((Object)annuity.getAccountNumber()), (Comparable)((Object)results.getAccountNumber()), preMsg + "Annuity:" + (String)annuity.getId() + " Annuity account number validation error", postMsg);
        ExecutionUnitVerificationHelper.assertEquals(executionUnit, (Comparable)((Object)annuity.getAnnuityHolderId()), (Comparable)((Object)results.getAnnuityHolderId()), preMsg + "Annuity:" + (String)annuity.getId() + " Annuity'annuity holder id' validation error", postMsg);
        Double d = annuity.getAmount();
        if (d != null) {
            d = new Double(decimalFormat.format(d));
        }
        ExecutionUnitVerificationHelper.assertEquals(executionUnit, d, results.getAmount(), preMsg + "Annuity:" + (String)annuity.getId() + " Annuity amount validation error", postMsg);
        d = annuity.getLastPaidAmt();
        if (d != null) {
            d = new Double(decimalFormat.format(d));
        }
        ExecutionUnitVerificationHelper.assertEquals(executionUnit, d, results.getLastPaidAmt(), preMsg + "Annuity:" + (String)annuity.getId() + " Annuity last paid amount validation error", postMsg);
    }

    public static void assertEqual(IExecutionUnit executionUnit, List list, List results, String preMsg, String postMsg) throws ExecutionUnitVerificationException {
        ExecutionUnitVerificationHelper.assertNullabilityAndClass(executionUnit, list, results, preMsg, postMsg);
        if (results == null) {
            return;
        }
        if (list.size() != results.size()) {
            throw new ExecutionUnitVerificationException(ExecutionUnitVerificationHelper.formatMessage(executionUnit.getDescription(), preMsg, postMsg, "List size is not equal to results list size.list size is: " + list.size() + " results size is: " + results.size()));
        }
    }

    public static void assertEqual(IExecutionUnit executionUnit, IRider rider, IRider results, String preMsg, String postMsg) throws ExecutionUnitVerificationException {
        ExecutionUnitVerificationHelper.assertNullabilityAndClass(executionUnit, rider, results, preMsg, postMsg);
        if (results == null) {
            return;
        }
        ExecutionUnitVerificationHelper.assertNotNull(executionUnit, results.getLastUpdateDate(), preMsg + " Rider:" + (String)rider.getId() + " lastUpdateDate validation error", "results value is null.");
        ExecutionUnitVerificationHelper.assertEquals(executionUnit, (Comparable)rider.getId(), (Comparable)results.getId(), preMsg + " Rider:" + (String)rider.getId() + " id validation error", postMsg);
        ExecutionUnitVerificationHelper.assertDateYYYYMMDDEquals(executionUnit, rider.getEffectiveDate(), results.getEffectiveDate(), preMsg + " Rider:" + (String)rider.getId() + " effective date validation error", postMsg);
        ExecutionUnitVerificationHelper.assertEquals(executionUnit, (Comparable)((Object)rider.getRule()), (Comparable)((Object)results.getRule()), preMsg + " Rider:" + (String)rider.getId() + " rule validation error", postMsg);
        ExecutionUnitVerificationHelper.assertEquals(executionUnit, (Comparable)((Object)rider.getType()), (Comparable)((Object)results.getType()), preMsg + " Rider:" + (String)rider.getId() + " type validation error", postMsg);
    }

    public static void assertEqual(IExecutionUnit executionUnit, IPayout payout, IPayout results, String preMsg, String postMsg) throws ExecutionUnitVerificationException {
        ExecutionUnitVerificationHelper.assertNullabilityAndClass(executionUnit, payout, results, preMsg, postMsg);
        if (results == null) {
            return;
        }
        ExecutionUnitVerificationHelper.assertNotNull(executionUnit, results.getLastUpdateDate(), preMsg + " Payout:" + (String)payout.getId() + " lastUpdateDate validation error", "results value is null.");
        ExecutionUnitVerificationHelper.assertCalendarYYYYMMDDEquals(executionUnit, payout.getEndDate(), results.getEndDate(), preMsg + " Payout:" + (String)payout.getId() + " end date validation error", postMsg);
        ExecutionUnitVerificationHelper.assertEquals(executionUnit, (Comparable)payout.getId(), (Comparable)results.getId(), preMsg + " Payout:" + (String)payout.getId() + " id validation error", postMsg);
        ExecutionUnitVerificationHelper.assertCalendarYYYYMMDDEquals(executionUnit, payout.getStartDate(), results.getStartDate(), preMsg + " Payout:" + (String)payout.getId() + " start date validation error", postMsg);
        BigDecimal d = payout.getTaxableAmount();
        if (d != null) {
            d = new BigDecimal(decimalFormat.format(d));
        }
        ExecutionUnitVerificationHelper.assertEquals(executionUnit, d, results.getTaxableAmount(), preMsg + " Payout:" + (String)payout.getId() + " taxable amount validation error", postMsg);
    }

    public static void assertEqual(IExecutionUnit executionUnit, IConfigData configData, IConfigData results, String preMsg, String postMsg) throws ExecutionUnitVerificationException {
        ExecutionUnitVerificationHelper.assertNullabilityAndClass(executionUnit, configData, results, preMsg, postMsg);
        if (results == null) {
            return;
        }
        ExecutionUnitVerificationHelper.assertNotNull(executionUnit, results.getLastUpdateDate(), preMsg + " ConfigData:" + (String)configData.getId() + " lastUpdateDate validation error", "results value is null.");
        ExecutionUnitVerificationHelper.assertEquals(executionUnit, (Comparable)configData.getId(), (Comparable)results.getId(), preMsg + " ConfigData:" + (String)configData.getId() + "  Id validation error", postMsg);
        ExecutionUnitVerificationHelper.assertEquals(executionUnit, (Comparable)((Object)configData.getConfigMap().toString()), (Comparable)((Object)results.getConfigMap().toString()), preMsg + " ConfigData:" + (String)configData.getId() + "  ConfigValue validation error", postMsg);
    }

    public static void assertEqual(IExecutionUnit executionUnit, IPolicy policy, IPolicy results, String preMsg, String postMsg) throws ExecutionUnitVerificationException {
        ExecutionUnitVerificationHelper.assertNullabilityAndClass(executionUnit, policy, results, preMsg, postMsg);
        if (results == null) {
            return;
        }
        ExecutionUnitVerificationHelper.assertNotNull(executionUnit, results.getLastUpdateDate(), preMsg + " Policy:" + (String)policy.getId() + " lastUpdateDate validation error", "results value is null.");
        ExecutionUnitVerificationHelper.assertEquals(executionUnit, (Comparable)policy.getId(), (Comparable)results.getId(), preMsg + " Policy:" + (String)policy.getId() + " id validation error", postMsg);
        ExecutionUnitVerificationHelper.assertEquals(executionUnit, (Comparable)((Object)policy.getAnnuityHolderId()), (Comparable)((Object)results.getAnnuityHolderId()), preMsg + " Policy:" + (String)policy.getId() + " Holder id validation error", postMsg);
        for (int i = 1; i <= policy.getFunds().size(); ++i) {
            ExecutionUnitVerificationHelper.assertEqual(executionUnit, policy.getFunds().get(new Integer(i)), results.getFunds().get(new Integer(i)), preMsg, postMsg);
        }
    }

    public static void assertEqual(IExecutionUnit executionUnit, IFund fund, IFund results, String preMsg, String postMsg) throws ExecutionUnitVerificationException {
        ExecutionUnitVerificationHelper.assertNullabilityAndClass(executionUnit, fund, results, preMsg, postMsg);
        if (results == null) {
            return;
        }
        ExecutionUnitVerificationHelper.assertEquals(executionUnit, (Comparable)((Object)fund.getFundName()), (Comparable)((Object)results.getFundName()), preMsg + " Fund name validation error", postMsg);
        ExecutionUnitVerificationHelper.assertEquals(executionUnit, fund.getIndexRate(), results.getIndexRate(), preMsg + " Fund Index rate validation error", postMsg);
        ExecutionUnitVerificationHelper.assertEqual(executionUnit, fund.getAddress(), results.getAddress(), preMsg + " Fund Address validation error", postMsg);
    }

    public static void assertEqual(IExecutionUnit executionUnit, IBeneficiary beneficiary, IBeneficiary results, String preMsg, String postMsg) throws ExecutionUnitVerificationException {
        if (results == null) {
            return;
        }
        ExecutionUnitVerificationHelper.assertNotNull(executionUnit, results.getLastUpdateDate(), preMsg + " Beneficiary:" + (String)beneficiary.getId() + " lastUpdateDate validation error", "results value is null.");
        ExecutionUnitVerificationHelper.assertEquals(executionUnit, (Comparable)beneficiary.getId(), (Comparable)results.getId(), preMsg + " Beneficiary:" + (String)beneficiary.getId() + " id validation error", postMsg);
        ExecutionUnitVerificationHelper.assertEquals(executionUnit, (Comparable)((Object)beneficiary.getFirstName()), (Comparable)((Object)results.getFirstName()), preMsg + " Beneficiary:" + (String)beneficiary.getId() + " first name validation error", postMsg);
        ExecutionUnitVerificationHelper.assertEquals(executionUnit, (Comparable)((Object)beneficiary.getLastName()), (Comparable)((Object)results.getLastName()), preMsg + " Beneficiary:" + (String)beneficiary.getId() + " last name validation error", postMsg);
        ExecutionUnitVerificationHelper.assertEquals(executionUnit, (Comparable)((Object)beneficiary.getRelationship()), (Comparable)((Object)results.getRelationship()), preMsg + " Beneficiary:" + (String)beneficiary.getId() + " relationship validation error", postMsg);
        ExecutionUnitVerificationHelper.assertEquals(executionUnit, (Comparable)((Object)beneficiary.getAnnuityHolderId()), (Comparable)((Object)results.getAnnuityHolderId()), preMsg + " Beneficiary:" + (String)beneficiary.getId() + " annuity holder id validation error", postMsg);
    }

    public static void assertEqual(IExecutionUnit executionUnit, IBeneContact beneContact, IBeneContact results, String preMsg, String postMsg) throws ExecutionUnitVerificationException {
        if (results == null) {
            return;
        }
        ExecutionUnitVerificationHelper.assertNotNull(executionUnit, results.getLastUpdateDate(), preMsg + " BeneContact:" + ((BeneContactId)beneContact.getId()).toString() + " lastUpdateDate validation error", "results value is null.");
        ExecutionUnitVerificationHelper.assertEquals(executionUnit, (Comparable)((Object)((BeneContactId)beneContact.getId()).getContactType()), (Comparable)((Object)((BeneContactId)results.getId()).getContactType()), preMsg + " BeneContact:" + ((BeneContactId)beneContact.getId()).toString() + " id-type validation error", postMsg);
        ExecutionUnitVerificationHelper.assertEquals(executionUnit, (Comparable)((Object)((BeneContactId)beneContact.getId()).getBeneficiaryPK()), (Comparable)((Object)((BeneContactId)results.getId()).getBeneficiaryPK()), preMsg + " BeneContact:" + ((BeneContactId)beneContact.getId()).toString() + " id-key validation error", postMsg);
        ExecutionUnitVerificationHelper.assertEquals(executionUnit, (Comparable)((Object)beneContact.getEmail()), (Comparable)((Object)results.getEmail()), preMsg + " BeneContact:" + ((BeneContactId)beneContact.getId()).toString() + " email validation error", postMsg);
        ExecutionUnitVerificationHelper.assertEquals(executionUnit, (Comparable)((Object)beneContact.getPhone()), (Comparable)((Object)results.getPhone()), preMsg + " BeneContact:" + ((BeneContactId)beneContact.getId()).toString() + " email validation error", postMsg);
    }

    private static void assertNullabilityAndClass(IExecutionUnit executionUnit, Object obj, Object results, String preMsg, String postMsg) throws ExecutionUnitVerificationException {
        if (obj == null && results == null) {
            return;
        }
        if (obj == null) {
            throw new ExecutionUnitVerificationException(ExecutionUnitVerificationHelper.formatMessage(executionUnit.getDescription(), preMsg, postMsg, "object is null which is not equal to results: " + results));
        }
        if (results == null) {
            throw new ExecutionUnitVerificationException(ExecutionUnitVerificationHelper.formatMessage(executionUnit.getDescription(), preMsg, postMsg, "results is null is not equal to object:" + obj));
        }
    }

    private static String formatMessage(String description, String preMsg, String postMsg, String localMsg) {
        StringBuffer sb = new StringBuffer();
        if (preMsg != null) {
            sb.append(preMsg);
            sb.append(".  ");
        }
        sb.append("Execution Unit Description: ");
        sb.append(description);
        sb.append(".  ");
        if (postMsg != null) {
            sb.append(postMsg);
            sb.append(".  ");
        }
        if (localMsg != null) {
            sb.append(localMsg);
            sb.append(".");
        }
        return sb.toString();
    }
}

