/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.AbastractAnnuityExecutionUnit;
import com.ibm.wssvt.acme.annuity.common.util.ServerExceptionMapper;
import com.ibm.wssvt.acme.annuity.common.util.ServerExceptionType;
import com.ibm.wssvt.acme.common.executionunit.ExecutionUnitVerificationException;
import com.ibm.wssvt.acme.common.executionunit.InvalidExecutionUnitParameterException;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.util.List;

public class MultipleUpdateAnnuityEU
extends AbastractAnnuityExecutionUnit {
    private static final long serialVersionUID = 5301722316503041271L;
    private int useId = -1;
    private int holderStartId;
    private int holderEndId;
    private int maximumThreshold;
    boolean enableVerify = true;
    private static final String ENABLE_VERIFY_KEY = "enableVerify";
    private static final String USE_ID_KEY = "useId";
    private static final String START_ID_KEY = "holderStartId";
    private static final String MAX_THRESHOLD_KEY = "maximumThreshold";
    private static final String END_ID_KEY = "holderEndId";
    AcmeLogger logger = null;

    public void execute() {
        int threshold = 0;
        try {
            this.setScenarioVariables();
            String holderId = this.useId == -1 ? "" + this.getRandomInteger(this.holderStartId, this.holderEndId) : "" + this.useId;
            IAnnuityHolder holder = this.getAnnuityBeansFactory().createAnnuityHolder();
            holder.setId(holderId);
            holder.setConfiguration(this.getConfiguration());
            holder = this.getServerAdapter().findHolderById(holder);
            if (this.enableVerify) {
                if (holder == null) {
                    throw new ExecutionUnitVerificationException("returned holder for id: " + holderId + " is null.");
                }
                if (!holderId.equals(holder.getId())) {
                    throw new ExecutionUnitVerificationException("returned holder for id: " + holderId + " returned different holder.  returned holder id is: " + (String)holder.getId());
                }
            }
            holder.setConfiguration(this.getConfiguration());
            List<IAnnuity> annList = this.getServerAdapter().findHolderAnnuities(holder);
            if (annList == null || annList.size() < 1) {
                throw new ExecutionUnitVerificationException("The holder has null or 0 annuities.  This test on this holder cannot be executed.");
            }
            IAnnuity annuity = annList.get(0);
            IAnnuity updateOneResult = null;
            String origActNumberValue = null;
            this.logger.fine("Annuity id to be modified: " + (String)annuity.getId());
            while (threshold <= this.maximumThreshold) {
                origActNumberValue = annuity.getAccountNumber();
                annuity.setAccountNumber("updated-1" + annuity.getAccountNumber());
                annuity.setConfiguration(this.getConfiguration());
                try {
                    updateOneResult = this.getServerAdapter().updateAnnuity(annuity);
                    break;
                }
                catch (Exception e) {
                    ServerExceptionType exType = ServerExceptionMapper.getExceptionType(e);
                    if (ServerExceptionType.OPTIMISTIC_LOCKING_EXCEPTION.equals((Object)exType)) {
                        this.logger.info("OPTIMISTIC LOCKING EXCEPTION encountered while updating annuity id: " + (String)annuity.getId() + ".  Trying again to a max of: " + this.maximumThreshold + " times. This is the: " + (threshold + 1) + " attempt.");
                        ++threshold;
                        try {
                            annuity.setConfiguration(this.getConfiguration());
                            annuity = this.getServerAdapter().findAnnuityById(annuity);
                            continue;
                        }
                        catch (Exception ex) {
                            this.logger.warning("Failed to re-read annuity after OPTIMISTIC LOCK. Error: " + ex);
                            this.getExecutionUnitEvent().addException(ex);
                            return;
                        }
                    }
                    this.logger.warning("Failed to update annuity with rider. Error: " + e);
                    this.getExecutionUnitEvent().addException(e);
                    return;
                }
            }
            threshold = 0;
            if (this.enableVerify) {
                if (updateOneResult == null) {
                    throw new ExecutionUnitVerificationException("Annuity update returned a null value.");
                }
                if (!updateOneResult.getAccountNumber().startsWith("updated-1")) {
                    throw new ExecutionUnitVerificationException("Annuity update returned invalid value for account number.");
                }
            }
            annuity.setAccountNumber("updated-2" + annuity.getAccountNumber());
            annuity.setConfiguration(this.getConfiguration());
            try {
                IAnnuity res = this.getServerAdapter().updateAnnuity(annuity);
                throw new ExecutionUnitVerificationException("Expected the update to throw an Optimistic Locking exception, but it did not.  AnnuityId: " + (String)annuity.getId() + " act# " + res.getAccountNumber());
            }
            catch (Exception e) {
                if (!ServerExceptionType.OPTIMISTIC_LOCKING_EXCEPTION.equals((Object)ServerExceptionMapper.getExceptionType(e))) {
                    throw new ExecutionUnitVerificationException("Expected the update to throw an Optimistic Locking exception, but it threw: " + e);
                }
                annuity.setConfiguration(this.getConfiguration());
                IAnnuity finalResult = null;
                while (threshold <= this.maximumThreshold) {
                    annuity = this.getServerAdapter().findAnnuityById(annuity);
                    annuity.setAccountNumber(origActNumberValue);
                    annuity.setConfiguration(this.getConfiguration());
                    try {
                        finalResult = this.getServerAdapter().updateAnnuity(annuity);
                        break;
                    }
                    catch (Exception e2) {
                        ServerExceptionType exType = ServerExceptionMapper.getExceptionType(e2);
                        if (ServerExceptionType.OPTIMISTIC_LOCKING_EXCEPTION.equals((Object)exType)) {
                            this.logger.info("OPTIMISTIC LOCKING EXCEPTION encountered while updating annuity id: " + (String)annuity.getId() + ".  Trying again to a max of: " + this.maximumThreshold + " times. This is the: " + (threshold + 1) + " attempt.");
                            ++threshold;
                            continue;
                        }
                        this.logger.warning("Failed to update annuity with rider. Error: " + e2);
                        this.getExecutionUnitEvent().addException(e2);
                        return;
                    }
                }
                threshold = 0;
                if (this.enableVerify) {
                    if (finalResult == null) {
                        throw new ExecutionUnitVerificationException("Annuity update returned a null value.");
                    }
                    if (!finalResult.getAccountNumber().equals(origActNumberValue)) {
                        throw new ExecutionUnitVerificationException("Annuity update returned invalid value for account number.");
                    }
                }
            }
        }
        catch (Exception e) {
            this.getExecutionUnitEvent().addException(e);
        }
    }

    private void setScenarioVariables() throws InvalidExecutionUnitParameterException {
        this.logger = this.getLogger(((Object)((Object)this)).getClass().getName());
        try {
            this.enableVerify = this.getParameterValueBoolean(ENABLE_VERIFY_KEY);
        }
        catch (InvalidExecutionUnitParameterException e1) {
            this.logger.warning("Missing or invalid value for: enableVerify parameter.  for scenario: " + this.getDescription() + ".  Defaulting to true.");
            this.enableVerify = true;
        }
        try {
            this.useId = this.getParameterValueInt(USE_ID_KEY);
        }
        catch (Exception e) {
            this.logger.info("useId parameter not in config file, use random");
            this.useId = -1;
        }
        try {
            this.maximumThreshold = this.getParameterValueInt(MAX_THRESHOLD_KEY);
        }
        catch (Exception e) {
            this.logger.warning("maximumThreshold parameter not specified, using default set to 2.");
            this.maximumThreshold = 2;
        }
        if (this.useId == -1) {
            try {
                this.holderStartId = this.getParameterValueInt(START_ID_KEY);
            }
            catch (Exception e) {
                throw new InvalidExecutionUnitParameterException("The parameter holderStartId is invalid.  it must be an integer");
            }
            try {
                this.holderEndId = this.getParameterValueInt(END_ID_KEY);
            }
            catch (Exception e) {
                throw new InvalidExecutionUnitParameterException("The parameter holderEndId is invalid.  it must be an integer");
            }
            if (this.holderStartId < 0 || this.holderEndId < 0) {
                throw new InvalidExecutionUnitParameterException("Either prameter: holderStartId or parameter: holderEndId is less than zero. Invalid values.");
            }
            if (this.holderStartId == this.holderEndId) {
                throw new InvalidExecutionUnitParameterException("The prameter: holderStartId has the same value as parameter : holderEndId. Invalid values.");
            }
            if (this.holderEndId < this.holderStartId) {
                throw new InvalidExecutionUnitParameterException("Either prameter: holderEndId is less than the parameter: holderStartId. Invalid values.");
            }
        }
    }
}

