/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.bean.Identifiable;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.AbastractAnnuityExecutionUnit;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.BasicExecutionUnitLibrarry;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.ExecutionUnitVerificationHelper;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.common.adapter.ServerAdapterCommunicationException;
import com.ibm.wssvt.acme.common.executionunit.IExecutionUnit;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;

public class ReadAnnuityFromHolderEU
extends AbastractAnnuityExecutionUnit {
    private static final long serialVersionUID = -5232684206187027962L;
    private String useId = null;
    private int maxId = 0;
    private int startId = 0;
    private static final String USE_ID = "useId";
    private static final String MAX_ID = "maxId";
    private static final String START_ID_KEY = "startId";
    AcmeLogger logger = null;

    public void execute() {
        String sHolderId = null;
        Identifiable annuityHolderReturn = null;
        String sAnnuityId = null;
        this.setScenarioVariables();
        if (this.useId == null && this.maxId == 0) {
            this.logger.severe("Scenario parameter error: Either useId or maxId must be set > 0 for scenario: " + this.getDescription() + ": failed to execute");
            InvalidArgumentException e = new InvalidArgumentException("Scenario parameter error: Either useId or maxId must be set > 0 for scenario");
            this.getExecutionUnitEvent().addException((Exception)((Object)e));
            return;
        }
        this.logger.fine("After getting parameters, Begin execution");
        int count = 0;
        while (annuityHolderReturn == null && count < 3) {
            sHolderId = this.useId != null ? this.useId : Integer.toString(this.getRandomInteger(this.startId, this.maxId));
            this.logger.fine("Looking up id: " + sHolderId);
            try {
                annuityHolderReturn = this.findAnnuityHolder(sHolderId);
            }
            catch (Exception e) {
                if (this.useId != null) {
                    this.logger.warning("failed to find Holder, Id = " + sHolderId + " Error: " + e);
                    this.getExecutionUnitEvent().addException(e);
                    return;
                }
                this.logger.warning("Exception while looking up Annuity, id: " + sAnnuityId + "Error: " + e);
                ++count;
            }
        }
        if (count >= 3) {
            this.logger.warning("failed to find Holder in " + count + " attempts, Id = " + sHolderId);
            EntityNotFoundException e = new EntityNotFoundException("failed to find Holder in " + count + " attempts, Id = " + sHolderId);
            this.getExecutionUnitEvent().addException((Exception)((Object)e));
            return;
        }
        this.logger.fine("Successful find of Holder, id = " + (String)annuityHolderReturn.getId() + "Call verify");
        try {
            ExecutionUnitVerificationHelper.assertEquals((IExecutionUnit)this, (Comparable)((Object)sHolderId), (Comparable)annuityHolderReturn.getId(), "Returned Annuity Holder id is not equal to requested id", "Mismatch was found.");
        }
        catch (Exception e) {
            this.logger.severe("Failed on verify find annuity holder. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        List<IAnnuity> annuityListResults = null;
        try {
            this.logger.fine("Looking up annuities for holder ID: " + (String)annuityHolderReturn.getId());
            annuityHolderReturn.setConfiguration(this.getConfiguration());
            annuityListResults = this.getServerAdapter().findHolderAnnuities((IAnnuityHolder)annuityHolderReturn);
            this.logger.fine("Looked up annuities for holder ID: " + (String)annuityHolderReturn.getId());
        }
        catch (Exception e) {
            this.logger.severe("Error Holder ID: " + (String)annuityHolderReturn.getId() + " failed finding annuities. Exception: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        if (annuityListResults != null) {
            this.logger.fine("HolderId: " + sHolderId + " has: " + annuityListResults.size() + " annuities");
            Iterator<IAnnuity> it = annuityListResults.iterator();
            while (it.hasNext()) {
                try {
                    IAnnuity ann = it.next();
                    this.logger.fine("HolderId: " + ann.getAnnuityHolderId() + " Annuity ID: " + (String)ann.getId());
                    ExecutionUnitVerificationHelper.assertIdContains((IExecutionUnit)this, ann.getAnnuityHolderId(), sHolderId, "ERROR: requested annuity id: " + ann.getAnnuityHolderId(), " does not contain holder id: " + sHolderId);
                }
                catch (Exception e) {
                    this.logger.severe("validating holder ID: " + sHolderId + " Failed for annuity: ");
                    this.getExecutionUnitEvent().addException(e);
                    return;
                }
            }
        } else {
            this.logger.warning("Holder ID: " + sHolderId + " has 0 annuities");
            EntityNotFoundException e = new EntityNotFoundException("Holder ID: " + sHolderId + " has 0 annuities");
            this.getExecutionUnitEvent().addException((Exception)((Object)e));
            return;
        }
    }

    private void setScenarioVariables() {
        this.logger = this.getLogger(((Object)((Object)this)).getClass().getName());
        try {
            this.useId = (String)this.getConfiguration().getParameterValue((Object)USE_ID);
        }
        catch (Exception e) {
            this.logger.warning("useId parameter not in config file, use random");
        }
        try {
            this.maxId = this.getParameterValueInt(MAX_ID);
        }
        catch (Exception e) {
            this.logger.warning("maxId parameter not in config file, use default max");
        }
        try {
            this.startId = this.getParameterValueInt(START_ID_KEY);
        }
        catch (Exception e) {
            this.logger.warning("the attribute:startId is missing for scenario: " + this.getDescription() + " .Setting the default to 1");
            this.startId = 1;
        }
    }

    private IAnnuityHolder findAnnuityHolder(String id) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IAnnuityHolder annuityHolder = null;
        annuityHolder = BasicExecutionUnitLibrarry.getAnnuityHolder(this.getAnnuityBeansFactory());
        annuityHolder.setId(id);
        annuityHolder.setConfiguration(this.getConfiguration());
        annuityHolder = this.getServerAdapter().findHolderById(annuityHolder);
        return annuityHolder;
    }
}

