/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.AbastractAnnuityExecutionUnit;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.BasicExecutionUnitLibrarry;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.ExecutionUnitVerificationHelper;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.common.adapter.ServerAdapterCommunicationException;
import com.ibm.wssvt.acme.common.executionunit.IExecutionUnit;
import com.ibm.wssvt.acme.common.executionunit.InvalidExecutionUnitParameterException;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.rmi.RemoteException;

public class ReadHolderEU
extends AbastractAnnuityExecutionUnit {
    private static final long serialVersionUID = -4362529230415268925L;
    private String useId = null;
    private int maxId = 0;
    private int startId = 0;
    boolean verbose = false;
    private static final String USE_ID = "useId";
    private static final String MAX_ID = "maxId";
    private static final String VERBOSE = "verbose";
    private static final String START_ID_KEY = "startId";
    AcmeLogger logger = null;

    public void execute() {
        String sHolderId = null;
        IAnnuityHolder annuityHolderReturn = null;
        this.setScenarioVariables();
        if (this.useId == null && this.maxId == 0) {
            this.logger.warning("Scenario parameter error: Either useId or maxId must be set > 0 for scenario: " + this.getDescription() + ": failed to execute");
            return;
        }
        sHolderId = this.useId != null ? this.useId : Integer.toString(this.getRandomInteger(this.startId, this.maxId));
        this.logger.fine("Looking up id: " + sHolderId);
        if (this.verbose) {
            System.out.println("Looking up id: " + sHolderId);
        }
        try {
            annuityHolderReturn = this.findAnnuityHolder(sHolderId);
        }
        catch (Exception e) {
            this.logger.warning("failed to find AnnuityHolder, Id = " + sHolderId + " Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        try {
            ExecutionUnitVerificationHelper.assertEquals((IExecutionUnit)this, (Comparable)((Object)sHolderId), (Comparable)annuityHolderReturn.getId(), "Returned Annuity Holder id is not equal to requested id", "Mismatch was found.");
        }
        catch (Exception e) {
            this.logger.warning("Failed on verify find annuity holder. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Successful find of Holder, id = " + (String)annuityHolderReturn.getId());
        if (this.verbose) {
            System.out.println("Successful find of Holder, id = " + (String)annuityHolderReturn.getId());
        }
    }

    private void setScenarioVariables() {
        this.logger = this.getLogger(((Object)((Object)this)).getClass().getName());
        try {
            this.verbose = this.getParameterValueBoolean(VERBOSE);
        }
        catch (InvalidExecutionUnitParameterException e1) {
            this.logger.fine("Missing or invalid value for: verbose parameter.  for scenario: " + this.getDescription() + "Defaulting to false.");
            this.verbose = false;
        }
        try {
            this.useId = (String)this.getConfiguration().getParameterValue((Object)USE_ID);
        }
        catch (Exception e) {
            this.logger.fine("useId parameter not in config file, use random");
        }
        try {
            this.maxId = this.getParameterValueInt(MAX_ID);
        }
        catch (Exception e) {
            this.logger.fine("maxId parameter not in config file, use default max");
        }
        try {
            this.startId = this.getParameterValueInt(START_ID_KEY);
        }
        catch (Exception e) {
            this.logger.warning("the attribute:startId is missing for scenario: " + this.getDescription() + " .Setting the default to 1");
            this.startId = 1;
        }
    }

    private IAnnuityHolder findAnnuityHolder(String id) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IAnnuityHolder annuityHolder = null;
        annuityHolder = BasicExecutionUnitLibrarry.getAnnuityHolder(this.getAnnuityBeansFactory());
        annuityHolder.setId(id);
        annuityHolder.setConfiguration(this.getConfiguration());
        annuityHolder = this.getServerAdapter().findHolderById(annuityHolder);
        return annuityHolder;
    }
}

