/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit;

import com.ibm.wssvt.acme.annuity.common.bean.IConfigData;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.AbstractSingletonExecutionUnit;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.BasicExecutionUnitLibrarry;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.ExecutionUnitVerificationHelper;
import com.ibm.wssvt.acme.annuity.common.exception.EntityAlreadyExistsException;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.common.adapter.ServerAdapterCommunicationException;
import com.ibm.wssvt.acme.common.executionunit.ExecutionUnitVerificationException;
import com.ibm.wssvt.acme.common.executionunit.IExecutionUnit;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.rmi.RemoteException;

public class SingletonConcurrencyEU
extends AbstractSingletonExecutionUnit {
    private static final long serialVersionUID = -4657309483111671699L;
    private AcmeLogger logger;

    public void execute() {
        this.setScenarioVariables();
        IConfigData configData = null;
        this.logger.fine("Retrieve Initial ConfigData");
        try {
            configData = this.retrieveConfigData();
        }
        catch (Exception e) {
            this.logger.warning("Failed to retrieve ConfigData. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Verifying retrieve ConfigData");
        try {
            this.verifyRetrieve(configData);
        }
        catch (Exception e) {
            this.logger.info("Retrieve ConfigData verification failed.  Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.fine("Verifying Singleton Container Managed Concurrency");
        try {
            configData.setConfiguration(this.getConfiguration());
            this.getServerAdapter().testReadConcurrency(configData);
            this.getServerAdapter().testWriteConcurrency(configData);
        }
        catch (Exception e) {
            this.logger.info("Singleton Container Managed Concurrency check faild!  Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
    }

    private void setScenarioVariables() {
        this.logger = this.getLogger(((Object)((Object)this)).getClass().getName());
    }

    private IConfigData retrieveConfigData() throws EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IConfigData configData = BasicExecutionUnitLibrarry.getConfigData(this.getAnnuityBeansFactory());
        configData.setConfiguration(this.getConfiguration());
        configData = this.getServerAdapter().getServerConfigData(configData);
        return configData;
    }

    private void verifyRetrieve(IConfigData configData) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        ExecutionUnitVerificationHelper.assertValidId((IExecutionUnit)this, configData, "ConfigData retrieved from server NOT valid", "ConfigData Retrieve mismatch.");
    }
}

