/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit.policy;

import com.ibm.wssvt.acme.annuity.common.bean.IBeneficiary;
import com.ibm.wssvt.acme.annuity.common.bean.jpa.JPABeansFactory;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.BasicExecutionUnitLibrarry;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.ExecutionUnitVerificationHelper;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.policy.AbastractPolicyExecutionUnit;
import com.ibm.wssvt.acme.annuity.common.exception.EntityAlreadyExistsException;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.common.adapter.ServerAdapterCommunicationException;
import com.ibm.wssvt.acme.common.executionunit.ExecutionUnitVerificationException;
import com.ibm.wssvt.acme.common.executionunit.IExecutionUnit;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.rmi.RemoteException;

public class CRUDBeneficiaryEU
extends AbastractPolicyExecutionUnit {
    private static final long serialVersionUID = 1516157826365359836L;
    private AcmeLogger logger;

    public void execute() {
        this.setScenarioVariables();
        this.logger.fine("Creating Beneficiary");
        IBeneficiary beneficiary = null;
        try {
            beneficiary = this.createBeneficiary();
        }
        catch (Exception e) {
            this.logger.warning("Failed to create Beneficiary. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Verifying Create Beneficiary");
        try {
            this.verifyCreate(beneficiary);
        }
        catch (Exception e) {
            this.logger.info("Create Beneficiary verification failed.  Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.fine("Updating Beneficiary");
        IBeneficiary updated = null;
        try {
            updated = this.updateBeneficiary(beneficiary);
        }
        catch (Exception e) {
            this.logger.warning("Failed to update Beneficiary. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Verifying Update Beneficiary");
        try {
            this.verifyUpdate(updated);
        }
        catch (Exception e) {
            this.logger.info("Update Beneficiary verification failed. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.fine("Deleting Beneficiary");
        try {
            this.deleteBeneficiary(updated);
        }
        catch (Exception e) {
            this.logger.info("Failed to delete Beneficiary. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Verifying Delete Beneficiary");
        try {
            this.verifyDelete(updated);
        }
        catch (Exception e) {
            this.logger.info("Delete Beneficiary verification failed.  Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
    }

    private IBeneficiary createBeneficiary() throws EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IBeneficiary beneficiary = BasicExecutionUnitLibrarry.getBeneficiary(this.getAnnuityBeansFactory());
        beneficiary.setConfiguration(this.getConfiguration());
        beneficiary = this.getServerAdapter().createBeneficiary(beneficiary);
        return beneficiary;
    }

    private IBeneficiary updateBeneficiary(IBeneficiary before) throws EntityNotFoundException, InvalidArgumentException, ServerInternalErrorException, ServerAdapterCommunicationException, RemoteException {
        IBeneficiary after = BasicExecutionUnitLibrarry.getBeneficiary(this.getAnnuityBeansFactory());
        after.setId(before.getId());
        after.setConfiguration(this.getConfiguration());
        after = this.getServerAdapter().findBeneficiaryById(after);
        after.setFirstName(after.getFirstName() + "-updated");
        after.setLastName(after.getLastName() + "-updated");
        after.setRelationship(after.getRelationship() + "-updated");
        after.setConfiguration(this.getConfiguration());
        after = this.getServerAdapter().updateBeneficiary(after);
        return after;
    }

    private void deleteBeneficiary(IBeneficiary beneficiary) throws InvalidArgumentException, EntityNotFoundException, ServerInternalErrorException, ServerAdapterCommunicationException, RemoteException {
        IBeneficiary removed = BasicExecutionUnitLibrarry.getBeneficiary(this.getAnnuityBeansFactory());
        removed.setId(beneficiary.getId());
        removed.setConfiguration(this.getConfiguration());
        this.getServerAdapter().deleteBeneficiary(removed);
    }

    private void verifyCreate(IBeneficiary beneficiary) throws EntityNotFoundException, InvalidArgumentException, ServerInternalErrorException, ServerAdapterCommunicationException, RemoteException, ExecutionUnitVerificationException {
        IBeneficiary results = ((JPABeansFactory)this.getAnnuityBeansFactory()).createBeneficiary();
        results.setId(beneficiary.getId());
        results.setConfiguration(this.getConfiguration());
        results = this.getServerAdapter().findBeneficiaryById(results);
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, beneficiary, results, "beneficiary from client is not equal to DB value", "beneficiary Create mismacth was found.");
    }

    private void verifyUpdate(IBeneficiary beneficiary) throws ExecutionUnitVerificationException, EntityNotFoundException, InvalidArgumentException, ServerInternalErrorException, ServerAdapterCommunicationException, RemoteException {
        IBeneficiary results = ((JPABeansFactory)this.getAnnuityBeansFactory()).createBeneficiary();
        results.setId(beneficiary.getId());
        results.setConfiguration(this.getConfiguration());
        results = this.getServerAdapter().findBeneficiaryById(results);
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, beneficiary, results, "beneficiary from client is not equal to DB value", "beneficiary Update mismacth was found.");
    }

    private void verifyDelete(IBeneficiary beneficiary) throws InvalidArgumentException, ServerInternalErrorException, ServerAdapterCommunicationException, RemoteException, ExecutionUnitVerificationException {
        IBeneficiary results = ((JPABeansFactory)this.getAnnuityBeansFactory()).createBeneficiary();
        results.setId(beneficiary.getId());
        results.setConfiguration(this.getConfiguration());
        try {
            results = this.getServerAdapter().findBeneficiaryById(results);
            if (results != null) {
                throw new ExecutionUnitVerificationException("Deletion of beneficiary with ID = " + (String)beneficiary.getId() + "was not successful! The object still exists in DB.");
            }
        }
        catch (EntityNotFoundException entityNotFoundException) {
            // empty catch block
        }
    }

    private void setScenarioVariables() {
        this.logger = this.getLogger(((Object)((Object)this)).getClass().getName());
    }
}

