/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit.policy;

import com.ibm.wssvt.acme.annuity.common.bean.ContactType;
import com.ibm.wssvt.acme.annuity.common.bean.IAddress;
import com.ibm.wssvt.acme.annuity.common.bean.IBeneContact;
import com.ibm.wssvt.acme.annuity.common.bean.IBeneficiary;
import com.ibm.wssvt.acme.annuity.common.bean.IFund;
import com.ibm.wssvt.acme.annuity.common.bean.IPolicy;
import com.ibm.wssvt.acme.annuity.common.bean.jpa.BeneContactId;
import com.ibm.wssvt.acme.annuity.common.bean.jpa.JPABeansFactory;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.BasicExecutionUnitLibrarry;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.ExecutionUnitVerificationHelper;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.policy.AbastractPolicyExecutionUnit;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.common.adapter.ServerAdapterCommunicationException;
import com.ibm.wssvt.acme.common.executionunit.ExecutionUnitVerificationException;
import com.ibm.wssvt.acme.common.executionunit.IExecutionUnit;
import com.ibm.wssvt.acme.common.executionunit.ISingleRunExecutionUnit;
import com.ibm.wssvt.acme.common.executionunit.ISingleThreadedExecutionUnit;
import com.ibm.wssvt.acme.common.executionunit.InvalidExecutionUnitParameterException;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class PopulatePolicyDatabaseEU
extends AbastractPolicyExecutionUnit
implements ISingleThreadedExecutionUnit,
ISingleRunExecutionUnit {
    private static final long serialVersionUID = -5421478878181609584L;
    private int startId;
    private boolean useCharPrefixID = true;
    private int numberOfHolderEntries;
    private int maxNumberOfPoliciesPerHolder;
    private int maxNumberOfFundsPerPolicy;
    private int maxNumberOfBeneficiariesPerHolder;
    private int maxNumberOfBeneContactsPerBeneficiary;
    boolean enableVerify = true;
    boolean randomizeSelection = true;
    private Random populateRandom = new Random();
    private AcmeLogger logger = null;

    public void execute() {
        this.logger = this.getLogger(((Object)((Object)this)).getClass().getName());
        try {
            this.setAndVerifyScenarioParams();
        }
        catch (Exception e) {
            this.logger.warning("Invalid scenario parameters for scenario description:" + this.getDescription() + "  Error is: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.info("Starting id=" + this.startId + " Count=" + this.numberOfHolderEntries);
        Long startTime = System.currentTimeMillis();
        for (int i = this.startId; i < this.startId + this.numberOfHolderEntries; ++i) {
            String hid;
            String id = hid = "" + i;
            if (i % 10 == 0 && i != this.startId) {
                this.logger.info("10 holders+children created in:" + (System.currentTimeMillis() - startTime) + " ms. " + 1000000L / (System.currentTimeMillis() - startTime) + " Holders/sec." + (i - this.startId) + " holders created.");
                startTime = System.currentTimeMillis();
            }
            int numberOfPoliciesForThisHolder = this.randomizeSelection ? this.getRandomInteger(1, this.maxNumberOfPoliciesPerHolder) : this.maxNumberOfPoliciesPerHolder;
            for (int j = 1; j <= numberOfPoliciesForThisHolder; ++j) {
                Map<Integer, IFund> fundsMap = new HashMap<Integer, IFund>();
                id = hid + "-" + j;
                IPolicy policy = this.getPolicy(id);
                policy.setAnnuityHolderId(hid);
                policy.setFunds(fundsMap);
                int numberOfFundsForThisPolicy = this.randomizeSelection ? this.getRandomInteger(1, this.maxNumberOfFundsPerPolicy) : this.maxNumberOfFundsPerPolicy;
                for (int k = 1; k <= numberOfFundsForThisPolicy; ++k) {
                    String fundId = hid + "-" + j + "-" + k;
                    IFund fund = this.getFund(fundId);
                    fundsMap = policy.getFunds();
                    fundsMap.put(new Integer(k), fund);
                    policy.setFunds(fundsMap);
                }
                try {
                    policy.setConfiguration(this.getConfiguration());
                    policy = this.getServerAdapter().createPolicy(policy);
                }
                catch (Exception e) {
                    this.logger.warning("Failed to create Policy. Error is: " + e);
                    this.getExecutionUnitEvent().addException(e);
                    return;
                }
                try {
                    if (!this.enableVerify) continue;
                    this.verifyPolicy(policy);
                    continue;
                }
                catch (Exception e) {
                    this.logger.warning("Failed to verify create policy. Error is: " + e);
                    this.getExecutionUnitEvent().addException(e);
                }
            }
            int numberOfBeneficiariesForThisHolder = this.randomizeSelection ? this.getRandomInteger(1, this.maxNumberOfBeneficiariesPerHolder) : this.maxNumberOfBeneficiariesPerHolder;
            for (int j = 1; j <= numberOfBeneficiariesForThisHolder; ++j) {
                id = hid + "-" + j;
                ArrayList<IBeneContact> beneContacts = new ArrayList<IBeneContact>();
                IBeneficiary beneficiary = this.getBeneficiary(id);
                beneficiary.setAnnuityHolderId(hid);
                beneficiary.setBeneContacts(beneContacts);
                try {
                    beneficiary.setConfiguration(this.getConfiguration());
                    beneficiary = this.getServerAdapter().createBeneficiary(beneficiary);
                }
                catch (Exception e) {
                    this.logger.warning("Failed to create Beneficiary. Error is: " + e);
                    this.getExecutionUnitEvent().addException(e);
                    return;
                }
                try {
                    if (this.enableVerify) {
                        this.verifyBeneficiary(beneficiary);
                    }
                }
                catch (Exception e) {
                    this.logger.warning("Failed to verify create beneficiary. Error is: " + e);
                    this.getExecutionUnitEvent().addException(e);
                }
                int numberOfBeneContactsForThisBeneficiary = this.randomizeSelection ? this.getRandomInteger(1, this.maxNumberOfBeneContactsPerBeneficiary) : this.maxNumberOfBeneContactsPerBeneficiary;
                for (int k = 0; k < numberOfBeneContactsForThisBeneficiary; ++k) {
                    BeneContactId bcid = new BeneContactId();
                    bcid.setBeneficiaryPK((String)beneficiary.getId());
                    bcid.setContactType(ContactType.values()[k]);
                    IBeneContact beneContact = this.getBeneContact(bcid);
                    try {
                        beneContact.setConfiguration(this.getConfiguration());
                        beneContact = this.getServerAdapter().createBeneContact(beneContact);
                    }
                    catch (Exception e) {
                        this.logger.warning("Failed to create Beneficiary contact. Error is: " + e);
                        this.getExecutionUnitEvent().addException(e);
                        return;
                    }
                    try {
                        if (!this.enableVerify) continue;
                        this.verifyBeneContact(beneContact);
                        continue;
                    }
                    catch (Exception e) {
                        this.logger.warning("Failed to verify create beneficiary contact. Error is: " + e);
                        this.getExecutionUnitEvent().addException(e);
                    }
                }
            }
        }
    }

    private void setAndVerifyScenarioParams() throws InvalidExecutionUnitParameterException {
        String START_ID_KEY = "startId";
        String NUMBER_OF_HOLDER_ENTRIES_KEY = "numberOfHolders";
        String MAX_NUMBER_OF_POLICIES_PER_HOLDER_KEY = "maxNumberOfPoliciesPerHolder";
        String MAX_NUMBER_OF_FUNDS_PER_POLICY_KEY = "maxNumberOfFundsPerPolicy";
        String MAX_NUMBER_OF_BENEFICIARIES_PER_HOLDER_KEY = "maxNumberOfBeneficiariesPerHolder";
        String MAX_NUMBER_OF_BENE_CONTACTS_PER_BENEFICIARY_KEY = "maxNumberOfBeneContactsPerBeneficiary";
        String ENABLE_VERIFY_KEY = "enableVerify";
        String RANDOMIZE_SELECTION_KEY = "randomizeSelection";
        String USE_ID_CHAR_PREFIX = "useIdCharPrefix";
        this.startId = this.getParameterValueInt("startId");
        this.numberOfHolderEntries = this.getParameterValueInt("numberOfHolders");
        this.maxNumberOfPoliciesPerHolder = this.getParameterValueInt("maxNumberOfPoliciesPerHolder");
        this.maxNumberOfFundsPerPolicy = this.getParameterValueInt("maxNumberOfFundsPerPolicy");
        this.maxNumberOfBeneficiariesPerHolder = this.getParameterValueInt("maxNumberOfBeneficiariesPerHolder");
        this.maxNumberOfBeneContactsPerBeneficiary = this.getParameterValueInt("maxNumberOfBeneContactsPerBeneficiary");
        if (this.startId <= 0) {
            throw new InvalidExecutionUnitParameterException("startId is less or equal to 0.  Invalid value for scenario with description: " + this.getDescription() + ".  Value must be one or more.");
        }
        if (this.numberOfHolderEntries <= 0) {
            throw new InvalidExecutionUnitParameterException("numberOfHolders is less or equal to 0.  Invalid value for scenario with description: " + this.getDescription() + ".  Value must be one or more.");
        }
        if (this.maxNumberOfPoliciesPerHolder < 1) {
            throw new InvalidExecutionUnitParameterException("maxNumberOfPoliciesPerHolder is less or equal to 0.  Invalid value for scenario with description: " + this.getDescription() + ".  Value must be one or more.");
        }
        if (this.maxNumberOfFundsPerPolicy < 1) {
            throw new InvalidExecutionUnitParameterException("maxNumberOfFundsPerPolicy is less or equal to 0.  Invalid value for scenario with description: " + this.getDescription() + ".  Value must be one or more.");
        }
        if (this.maxNumberOfBeneficiariesPerHolder < 1) {
            throw new InvalidExecutionUnitParameterException("maxNumberOfBeneficiariesPerHolder is less or equal to 0.  Invalid value for scenario with description: " + this.getDescription() + ".  Value must be one or more.");
        }
        if (this.maxNumberOfBeneContactsPerBeneficiary < 1) {
            throw new InvalidExecutionUnitParameterException("maxNumberOfBeneContactsPerBeneficiary is less or equal to 0.  Invalid value for scenario with description: " + this.getDescription() + ".  Value must be in range of 1-3.");
        }
        if (this.maxNumberOfBeneContactsPerBeneficiary > 3) {
            throw new InvalidExecutionUnitParameterException("maxNumberOfBeneContactsPerBeneficiary is greater than 3.  Invalid value for scenario with description: " + this.getDescription() + ".  Value must be in range of 1-3.");
        }
        try {
            this.useCharPrefixID = this.getParameterValueBoolean("useIdCharPrefix");
        }
        catch (InvalidExecutionUnitParameterException e) {
            this.logger.warning("the attribute: useIdCharPrefix is missing for scenario: " + this.getDescription() + ".  Setting the default to true.");
            this.useCharPrefixID = true;
        }
        try {
            this.enableVerify = this.getParameterValueBoolean("enableVerify");
        }
        catch (InvalidExecutionUnitParameterException e) {
            this.logger.warning("the attribute: enableVerify is missing for scenario: " + this.getDescription() + ".  Setting the default to true.");
            this.enableVerify = true;
        }
        try {
            this.randomizeSelection = this.getParameterValueBoolean("randomizeSelection");
        }
        catch (InvalidExecutionUnitParameterException e) {
            this.logger.warning("the attribute: randomizeSelection is missing for scenario: " + this.getDescription() + ".  Setting the default to true.");
            this.randomizeSelection = true;
        }
    }

    private void verifyPolicy(IPolicy policy) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        IPolicy results = ((JPABeansFactory)this.getAnnuityBeansFactory()).createPolicy();
        results.setId(policy.getId());
        results.setConfiguration(this.getConfiguration());
        results = this.getServerAdapter().findPolicyById(results);
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, policy, results, "policy from Client is not equal to DB value", "Mismacth was found.");
    }

    private void verifyBeneficiary(IBeneficiary beneficiary) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        IBeneficiary results = ((JPABeansFactory)this.getAnnuityBeansFactory()).createBeneficiary();
        results.setId(beneficiary.getId());
        results.setConfiguration(this.getConfiguration());
        results = this.getServerAdapter().findBeneficiaryById(results);
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, beneficiary, results, "beneficiary from Client is not equal to DB value", "Mismacth was found.");
    }

    private void verifyBeneContact(IBeneContact beneContact) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        IBeneContact results = ((JPABeansFactory)this.getAnnuityBeansFactory()).createBeneContact();
        results.setId(beneContact.getId());
        results.setConfiguration(this.getConfiguration());
        results = this.getServerAdapter().findBeneContactById(results);
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, beneContact, results, "beneficiary contact from Client is not equal to DB value", "Mismacth was found.");
    }

    private IPolicy getPolicy(String sPolicyId) {
        IPolicy policy = BasicExecutionUnitLibrarry.getPolicy(this.getAnnuityBeansFactory());
        if (this.useCharPrefixID) {
            policy.setId("P" + sPolicyId);
        } else {
            policy.setId(sPolicyId);
        }
        return policy;
    }

    private IFund getFund(String sFundId) {
        String[] states = new String[]{"TX", "CA", "NY", "MN", "NC", "IL", "VA"};
        IFund fund = BasicExecutionUnitLibrarry.getFund(this.getAnnuityBeansFactory());
        fund.setFundName(sFundId + " Company");
        Double rand = new Double(this.populateRandom.nextDouble() * 10000.0);
        Double randInt = new Double(rand.intValue());
        Double indexRate = new Double(randInt / 100.0);
        fund.setIndexRate(indexRate);
        IAddress faddress = fund.getAddress();
        faddress.setLine1(sFundId + "Main Street");
        faddress.setLine2("Apt # " + sFundId);
        Random r = new Random();
        faddress.setState(states[r.nextInt(states.length)]);
        fund.setAddress(faddress);
        return fund;
    }

    private IBeneficiary getBeneficiary(String sBeneficiaryId) {
        IBeneficiary beneficiary = BasicExecutionUnitLibrarry.getBeneficiary(this.getAnnuityBeansFactory());
        if (this.useCharPrefixID) {
            beneficiary.setId("B" + sBeneficiaryId);
        } else {
            beneficiary.setId(sBeneficiaryId);
        }
        return beneficiary;
    }

    private IBeneContact getBeneContact(BeneContactId id) {
        String[] domains = new String[]{"us.ibm.com", "ca.ibm.com", "uk.ibm.com", "in.ibm.com", "cn.ibm.com", "websphere.com", "apache.org"};
        IBeneContact beneContact = BasicExecutionUnitLibrarry.getBeneContact(this.getAnnuityBeansFactory(), id.getBeneficiaryPK());
        ((BeneContactId)beneContact.getId()).setContactType(id.getContactType());
        Random r = new Random();
        beneContact.setPhone(100 + r.nextInt(900) + "-" + (100 + r.nextInt(900)) + "-" + (1000 + r.nextInt(9000)));
        beneContact.setEmail("user" + r.nextInt() + "@" + domains[r.nextInt(domains.length)]);
        return beneContact;
    }
}

