/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit.stackunit;

import com.ibm.wssvt.acme.annuity.common.bean.IContact;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.AbstractAnnuityStackableExecutionUnit;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.BasicExecutionUnitLibrarry;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.ExecutionUnitVerificationHelper;
import com.ibm.wssvt.acme.common.executionunit.ExecutionUnitVerificationException;
import com.ibm.wssvt.acme.common.executionunit.IExecutionUnit;
import com.ibm.wssvt.acme.common.executionunit.InvalidExecutionUnitParameterException;
import com.ibm.wssvt.acme.common.log.AcmeLogger;

public class UpdateContactEU
extends AbstractAnnuityStackableExecutionUnit {
    private static final long serialVersionUID = 5751982103363852382L;
    boolean enableVerify = true;
    AcmeLogger logger;

    public void execute() {
        this.logger = this.getLogger(((Object)((Object)this)).getClass().getName());
        try {
            this.setEUParams();
            IContact contact = BasicExecutionUnitLibrarry.getContact(this.getAnnuityBeansFactory());
            contact.setConfiguration(this.getConfiguration());
            String contactId = (String)this.getStackMap().get("contactId");
            if (contactId == null || contactId.trim().length() == 0) {
                throw new InvalidExecutionUnitParameterException("This EU expects to find the attribute contactId in the stack but found null or empty.  found: " + contactId + ".  Make sure that you use this EU in a correct order.");
            }
            contact.setId(contactId);
            this.logger.fine("ready to find contact: " + contact);
            IContact readResult = this.getServerAdapter().findContactById(contact);
            this.logger.fine("found Contact: " + readResult);
            if (this.enableVerify && !((String)contact.getId()).equals(readResult.getId())) {
                throw new ExecutionUnitVerificationException("the client contact id: " + contactId + " did not match the server contactId: " + (String)readResult.getId());
            }
            long time = System.currentTimeMillis();
            readResult.setEmail("updated Email - " + time);
            readResult.setPhone("512-222-3333 - " + time);
            readResult.getAddress().setCity("updated City - " + time);
            readResult.setConfiguration(this.getConfiguration());
            this.logger.fine("ready to update contact: " + readResult);
            IContact updateResult = this.getServerAdapter().updateContact(readResult);
            this.logger.fine("updated contact: " + updateResult);
            if (this.enableVerify) {
                ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, readResult, updateResult, "Contact Client Value did not match Server Contact Value.", "Mismatch was found");
            }
        }
        catch (Exception e) {
            this.getExecutionUnitEvent().addException(e);
        }
    }

    private void setEUParams() {
        try {
            this.enableVerify = this.getParameterValueBoolean("enableVerify");
        }
        catch (InvalidExecutionUnitParameterException e) {
            this.enableVerify = true;
        }
    }
}

