/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.servicelookup.ejb2;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.bean.IContact;
import com.ibm.wssvt.acme.annuity.common.bean.IPayor;
import com.ibm.wssvt.acme.annuity.common.bean.IPayout;
import com.ibm.wssvt.acme.annuity.common.bean.IRider;
import com.ibm.wssvt.acme.annuity.common.business.IAnnuityService;
import com.ibm.wssvt.acme.annuity.common.business.ejb2x.AnnuityMgmtSvcEJB2x;
import com.ibm.wssvt.acme.annuity.common.exception.EntityAlreadyExistsException;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.common.exception.ExceptionFormatter;
import java.rmi.RemoteException;
import java.util.List;

public class AnnuityEJB2xRemoteServiceProxy
implements IAnnuityService {
    private AnnuityMgmtSvcEJB2x remote;

    public AnnuityEJB2xRemoteServiceProxy(AnnuityMgmtSvcEJB2x remote) {
        this.remote = remote;
    }

    @Override
    public IAnnuity findAnnuityById(IAnnuity annuity) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        try {
            return this.remote.findAnnuityById(annuity);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception was thrown. Error: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
    }

    @Override
    public IAnnuityHolder findAnnuityHolder(IAnnuity annuity) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        try {
            return this.remote.findAnnuityHolder(annuity);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception was thrown. Error: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
    }

    @Override
    public IContact findContactById(IContact contact) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        try {
            return this.remote.findContactById(contact);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception was thrown. Error: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
    }

    @Override
    public List<IAnnuity> findHolderAnnuities(IAnnuityHolder annuityHolder) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            return this.remote.findHolderAnnuities(annuityHolder);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception was thrown. Error: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
    }

    @Override
    public IAnnuityHolder findHolderById(IAnnuityHolder annuityHolder) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        try {
            return this.remote.findHolderById(annuityHolder);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception was thrown. Error: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
    }

    @Override
    public IPayor findPayorById(IPayor payor) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        try {
            return this.remote.findPayorById(payor);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception was thrown. Error: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
    }

    @Override
    public IPayout findPayoutById(IPayout payout) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        try {
            return this.remote.findPayoutById(payout);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception was thrown. Error: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
    }

    @Override
    public IRider findRiderById(IRider rider) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        try {
            return this.remote.findRiderById(rider);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception was thrown. Error: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
    }

    @Override
    public IAnnuity createAnnuity(IAnnuity ann) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        try {
            return this.remote.createAnnuity(ann);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception was thrown. Error: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
    }

    @Override
    public IAnnuityHolder createAnnuityHolder(IAnnuityHolder annHolder) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        try {
            return this.remote.createAnnuityHolder(annHolder);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception was thrown. Error: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
    }

    @Override
    public IContact createContact(IContact contact) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        try {
            return this.remote.createContact(contact);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception was thrown. Error: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
    }

    @Override
    public IPayor createPayor(IPayor payor) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        try {
            return this.remote.createPayor(payor);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception was thrown. Error: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
    }

    @Override
    public void deleteAnnuity(IAnnuity annuity) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            this.remote.deleteAnnuity(annuity);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception was thrown. Error: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
    }

    @Override
    public void deleteAnnuityHolder(IAnnuityHolder annHolder) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            this.remote.deleteAnnuityHolder(annHolder);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception was thrown. Error: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
    }

    @Override
    public void deleteContact(IContact contact) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            this.remote.deleteContact(contact);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception was thrown. Error: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
    }

    @Override
    public void deletePayor(IPayor payor) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            this.remote.deletePayor(payor);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception was thrown. Error: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
    }

    @Override
    public void deletePayout(IPayout payout) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            this.remote.deletePayout(payout);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception was thrown. Error: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
    }

    @Override
    public void deleteRider(IRider rider) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            this.remote.deleteRider(rider);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception was thrown. Error: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
    }

    @Override
    public IAnnuity updateAnnuity(IAnnuity ann) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            return this.remote.updateAnnuity(ann);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception was thrown. Error: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
    }

    @Override
    public IAnnuityHolder updateAnnuityHolder(IAnnuityHolder annHolder) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            return this.remote.updateAnnuityHolder(annHolder);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception was thrown. Error: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
    }

    @Override
    public IContact updateContact(IContact contact) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            return this.remote.updateContact(contact);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception was thrown. Error: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
    }

    @Override
    public IPayor updatePayor(IPayor payor) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            return this.remote.updatePayor(payor);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception was thrown. Error: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
    }

    @Override
    public List<IAnnuity> findPayorAnnuities(IPayor payor) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            return this.remote.findPayorAnnuities(payor);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception was thrown. Error: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
    }

    @Override
    public IPayout createPayout(IPayout payout) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        try {
            return this.remote.createPayout(payout);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception was thrown. Error: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
    }

    @Override
    public IPayout updatePayout(IPayout payout) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            return this.remote.updatePayout(payout);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception was thrown. Error: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
    }
}

