/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.servicelookup.ejb2;

import com.ibm.wssvt.acme.annuity.common.business.IAnnuityService;
import com.ibm.wssvt.acme.annuity.common.business.ejb2x.AnnuityMgmtSvcEJB2x;
import com.ibm.wssvt.acme.annuity.common.business.ejb2x.AnnuityMgmtSvcEJB2xHome;
import com.ibm.wssvt.acme.annuity.common.business.ejb2x.AnnuityMgmtSvcEJB2xLocal;
import com.ibm.wssvt.acme.annuity.common.business.ejb2x.AnnuityMgmtSvcEJB2xLocalHome;
import com.ibm.wssvt.acme.annuity.common.exception.AnnuitySecurityException;
import com.ibm.wssvt.acme.annuity.common.servicelookup.ejb2.AnnuityEJB2xLocalServiceProxy;
import com.ibm.wssvt.acme.annuity.common.servicelookup.ejb2.AnnuityEJB2xRemoteServiceProxy;
import com.ibm.wssvt.acme.annuity.common.util.AnnuityKerberosProperties;
import com.ibm.wssvt.acme.annuity.common.util.AnnuityKerberosSecurity;
import com.ibm.wssvt.acme.common.bean.Configrable;
import com.ibm.wssvt.acme.common.exception.ExceptionFormatter;
import com.ibm.wssvt.acme.common.exception.InvalidConfigurationException;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.rmi.RemoteException;
import java.util.Properties;
import java.util.logging.Level;
import javax.ejb.CreateException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

public class EJB2xServiceLookup {
    public static IAnnuityService getAnnuityEJB2xService(Configrable<String, String> configrable, AcmeLogger logger) throws InvalidConfigurationException, NamingException, CreateException, RemoteException, AnnuitySecurityException {
        String mode = (String)configrable.getConfiguration().getParameterValue((Object)"connectionMode");
        if ("local".equalsIgnoreCase(mode)) {
            return new AnnuityEJB2xLocalServiceProxy(EJB2xServiceLookup.getAnnuityEJB2xLocalService(configrable, logger));
        }
        if ("remote".equalsIgnoreCase(mode)) {
            return new AnnuityEJB2xRemoteServiceProxy(EJB2xServiceLookup.getAnnuityEJB2xRemoteService(configrable, logger));
        }
        logger.info("The connectionMode configuration is not valid.  Supplied value is: " + mode);
        throw new InvalidConfigurationException("The connectionMode configuration is not valid.  Supplied value is: " + mode + logger.getAllLogs());
    }

    public static AnnuityMgmtSvcEJB2x getAnnuityEJB2xRemoteService(Configrable<String, String> configrable, AcmeLogger logger) throws NamingException, RemoteException, CreateException, AnnuitySecurityException {
        try {
            if ("true".equalsIgnoreCase((String)configrable.getConfiguration().getParameterValue((Object)"useKerberosSecurity"))) {
                AnnuityKerberosProperties akp = new AnnuityKerberosProperties();
                akp.setKerbProperties(configrable, logger);
                AnnuityKerberosSecurity annuityKerberosSecurity = new AnnuityKerberosSecurity();
                if (AnnuityKerberosProperties.LOGIN_STYLE_NEW_TICKET.equalsIgnoreCase(akp.getLoginStyle())) {
                    annuityKerberosSecurity.login(akp, logger);
                } else if (AnnuityKerberosProperties.LOGIN_STYLE_NEW_OR_REFRESH_TICKET.equalsIgnoreCase(akp.getLoginStyle())) {
                    annuityKerberosSecurity.renewLogin(akp, logger);
                }
            }
            logger.fine("EJB2xServerAdapter - Using Remote");
            Properties p = new Properties();
            logger.finest("configrable values:" + configrable.getConfiguration().getParameters());
            p.put("java.naming.factory.initial", configrable.getConfiguration().getParameterValue((Object)"initialContextFactory"));
            p.put("java.naming.provider.url", configrable.getConfiguration().getParameterValue((Object)"iiopAddress"));
            InitialContext ic = new InitialContext(p);
            logger.fine("obtained initial context: " + ic);
            String homeJNDI = (String)configrable.getConfiguration().getParameterValue((Object)"ejb2xRemoteHomeJNDI");
            logger.fine("remote home jndi is: " + homeJNDI);
            Object h = ic.lookup(homeJNDI);
            AnnuityMgmtSvcEJB2xHome home = (AnnuityMgmtSvcEJB2xHome)PortableRemoteObject.narrow((Object)h, AnnuityMgmtSvcEJB2xHome.class);
            AnnuityMgmtSvcEJB2x remote = home.create();
            return remote;
        }
        catch (NamingException e) {
            String msg = "Failed to get the EJB2x Remote Server Interface.  Make sure that the Server is accessable.  Server Reported Error: " + ExceptionFormatter.deepFormatToString((Throwable)e) + logger.getAllLogs();
            logger.log(Level.WARNING, msg, (Throwable)e);
            NamingException ne = new NamingException(msg);
            ne.setRootCause(e);
            throw ne;
        }
        catch (RemoteException e) {
            String msg = "Failed to get the EJB2x Remote Server Interface.  with Remote Exception.  Server Reported Error: " + e.getMessage() + logger.getAllLogs();
            logger.log(Level.WARNING, msg, (Throwable)e);
            throw new RemoteException(msg, e);
        }
        catch (CreateException e) {
            throw e;
        }
    }

    public static AnnuityMgmtSvcEJB2xLocal getAnnuityEJB2xLocalService(Configrable<String, String> configrable, AcmeLogger logger) throws NamingException, CreateException {
        try {
            InitialContext ic = new InitialContext();
            logger.fine("obtained initial context: " + ic);
            String homeJNDI = (String)configrable.getConfiguration().getParameterValue((Object)"ejb2xLocalHomeJNDI");
            logger.fine("local home jndi is: " + homeJNDI);
            AnnuityMgmtSvcEJB2xLocalHome localHome = (AnnuityMgmtSvcEJB2xLocalHome)ic.lookup(homeJNDI);
            logger.fine("home was found.  Home: " + localHome);
            AnnuityMgmtSvcEJB2xLocal local = localHome.create();
            logger.finer("local interface was found value is: " + local);
            return local;
        }
        catch (NamingException e) {
            String msg = "Failed to get the EJB2x Remote Server Interface.  Make sure that the Server is accessable.  Server Reported Error: " + ExceptionFormatter.deepFormatToString((Throwable)e) + logger.getAllLogs();
            logger.log(Level.WARNING, msg, (Throwable)e);
            NamingException ne = new NamingException(msg);
            ne.setRootCause(e);
            throw ne;
        }
        catch (CreateException e) {
            throw e;
        }
    }
}

