/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.servicelookup.ejb2xjaxws;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.bean.IContact;
import com.ibm.wssvt.acme.annuity.common.bean.IPayor;
import com.ibm.wssvt.acme.annuity.common.bean.IPayout;
import com.ibm.wssvt.acme.annuity.common.bean.IRider;
import com.ibm.wssvt.acme.annuity.common.bean.jaxbjpa.AnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.bean.jaxbjpa.AnnuityValueObject;
import com.ibm.wssvt.acme.annuity.common.bean.jaxbjpa.Contact;
import com.ibm.wssvt.acme.annuity.common.bean.jaxbjpa.Payor;
import com.ibm.wssvt.acme.annuity.common.bean.jaxbjpa.PayoutValueObject;
import com.ibm.wssvt.acme.annuity.common.bean.jaxbjpa.Rider;
import com.ibm.wssvt.acme.annuity.common.business.IAnnuityService;
import com.ibm.wssvt.acme.annuity.common.business.ejbws.ejb2xjaxws.AnnuityMgmtSvcEJB2xJAXWS;
import com.ibm.wssvt.acme.annuity.common.exception.EntityAlreadyExistsException;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.common.exception.ExceptionFormatter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class AnnuityEJB2xJAXWSEJBRemoteServiceProxy
implements IAnnuityService {
    private AnnuityMgmtSvcEJB2xJAXWS remote;

    public AnnuityEJB2xJAXWSEJBRemoteServiceProxy(AnnuityMgmtSvcEJB2xJAXWS remote) {
        this.remote = remote;
    }

    @Override
    public IAnnuity createAnnuity(IAnnuity ann) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        AnnuityValueObject result = null;
        AnnuityValueObject annuityValueObject = new AnnuityValueObject();
        annuityValueObject.setAnnuity(ann);
        try {
            result = this.remote.createAnnuity(annuityValueObject);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception. Error is: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
        annuityValueObject.getAnnuity();
        return result == null ? null : result.getAnnuity();
    }

    @Override
    public IAnnuity findAnnuityById(IAnnuity annuity) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        AnnuityValueObject result = null;
        AnnuityValueObject annuityValueObject = new AnnuityValueObject();
        annuityValueObject.setAnnuity(annuity);
        try {
            result = this.remote.findAnnuityById(annuityValueObject);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception. Error is: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
        annuityValueObject.getAnnuity();
        return result == null ? null : result.getAnnuity();
    }

    @Override
    public IAnnuityHolder findAnnuityHolder(IAnnuity annuity) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        AnnuityHolder result = null;
        AnnuityValueObject annuityValueObject = new AnnuityValueObject();
        annuityValueObject.setAnnuity(annuity);
        try {
            result = this.remote.findAnnuityHolder(annuityValueObject);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception. Error is: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
        annuityValueObject.getAnnuity();
        return result;
    }

    @Override
    public IContact findContactById(IContact contact) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        Contact result = null;
        try {
            result = this.remote.findContactById((Contact)contact);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception. Error is: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
        return result;
    }

    @Override
    public List<IAnnuity> findHolderAnnuities(IAnnuityHolder annuityHolder) throws ServerInternalErrorException, InvalidArgumentException {
        ArrayList<IAnnuity> result = new ArrayList<IAnnuity>();
        List<Object> tempList = new ArrayList();
        try {
            tempList = this.remote.findHolderAnnuities((AnnuityHolder)annuityHolder);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception. Error is: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
        for (AnnuityValueObject annuityValueObject : tempList) {
            result.add(annuityValueObject.getAnnuity());
        }
        return result;
    }

    @Override
    public IAnnuityHolder findHolderById(IAnnuityHolder annuityHolder) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        AnnuityHolder result = null;
        try {
            result = this.remote.findHolderById((AnnuityHolder)annuityHolder);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception. Error is: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
        return result;
    }

    @Override
    public List<IAnnuity> findPayorAnnuities(IPayor payor) throws ServerInternalErrorException, InvalidArgumentException {
        ArrayList<IAnnuity> result = null;
        List<AnnuityValueObject> tempList = null;
        try {
            tempList = this.remote.findPayorAnnuities((Payor)payor);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception. Error is: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
        if (tempList != null) {
            result = new ArrayList<IAnnuity>();
            for (AnnuityValueObject object : tempList) {
                result.add(object.getAnnuity());
            }
        }
        return result;
    }

    @Override
    public IPayor findPayorById(IPayor payor) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        Payor result = null;
        try {
            result = this.remote.findPayorById((Payor)payor);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception. Error is: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
        return result;
    }

    @Override
    public IPayout findPayoutById(IPayout payout) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        PayoutValueObject result = null;
        PayoutValueObject in = new PayoutValueObject();
        in.setPayout(payout);
        try {
            result = this.remote.findPayoutById(in);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception. Error is: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
        in.getPayout();
        return result == null ? null : result.getPayout();
    }

    @Override
    public IRider findRiderById(IRider rider) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        Rider result = null;
        try {
            result = this.remote.findRiderById((Rider)rider);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception. Error is: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
        return result;
    }

    @Override
    public IAnnuityHolder createAnnuityHolder(IAnnuityHolder annHolder) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        AnnuityHolder result = null;
        try {
            result = this.remote.createAnnuityHolder((AnnuityHolder)annHolder);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception. Error is: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
        return result;
    }

    @Override
    public IContact createContact(IContact contact) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        Contact result = null;
        try {
            result = this.remote.createContact((Contact)contact);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception. Error is: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
        return result;
    }

    @Override
    public IPayor createPayor(IPayor payor) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        Payor result = null;
        try {
            result = this.remote.createPayor((Payor)payor);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception. Error is: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
        return result;
    }

    @Override
    public IPayout createPayout(IPayout payout) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        PayoutValueObject result = null;
        PayoutValueObject in = new PayoutValueObject();
        in.setPayout(payout);
        try {
            result = this.remote.createPayout(in);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception. Error is: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
        in.getPayout();
        return result == null ? null : result.getPayout();
    }

    @Override
    public void deleteAnnuity(IAnnuity annuity) throws ServerInternalErrorException, InvalidArgumentException {
        AnnuityValueObject annuityValueObject = new AnnuityValueObject();
        annuityValueObject.setAnnuity(annuity);
        try {
            this.remote.deleteAnnuity(annuityValueObject);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception. Error is: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
        annuityValueObject.getAnnuity();
    }

    @Override
    public void deleteAnnuityHolder(IAnnuityHolder annHolder) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            this.remote.deleteAnnuityHolder((AnnuityHolder)annHolder);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception. Error is: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
    }

    @Override
    public void deleteContact(IContact contact) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            this.remote.deleteContact((Contact)contact);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception. Error is: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
    }

    @Override
    public void deletePayor(IPayor payor) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            this.remote.deletePayor((Payor)payor);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception. Error is: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
    }

    @Override
    public void deletePayout(IPayout payout) throws ServerInternalErrorException, InvalidArgumentException {
        PayoutValueObject in = new PayoutValueObject();
        in.setPayout(payout);
        try {
            this.remote.deletePayout(in);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception. Error is: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
        in.getPayout();
    }

    @Override
    public void deleteRider(IRider rider) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            this.remote.deleteRider((Rider)rider);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception. Error is: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
    }

    @Override
    public IAnnuity updateAnnuity(IAnnuity annuity) throws ServerInternalErrorException, InvalidArgumentException {
        AnnuityValueObject result = null;
        AnnuityValueObject annuityValueObject = new AnnuityValueObject();
        annuityValueObject.setAnnuity(annuity);
        try {
            result = this.remote.updateAnnuity(annuityValueObject);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception. Error is: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
        annuityValueObject.getAnnuity();
        return result == null ? null : result.getAnnuity();
    }

    @Override
    public IAnnuityHolder updateAnnuityHolder(IAnnuityHolder annHolder) throws ServerInternalErrorException, InvalidArgumentException {
        AnnuityHolder result = null;
        try {
            result = this.remote.updateAnnuityHolder((AnnuityHolder)annHolder);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception. Error is: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
        return result;
    }

    @Override
    public IContact updateContact(IContact contact) throws ServerInternalErrorException, InvalidArgumentException {
        Contact result = null;
        try {
            result = this.remote.updateContact((Contact)contact);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception. Error is: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
        return result;
    }

    @Override
    public IPayor updatePayor(IPayor payor) throws ServerInternalErrorException, InvalidArgumentException {
        Payor result = null;
        try {
            result = this.remote.updatePayor((Payor)payor);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception. Error is: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
        return result;
    }

    @Override
    public IPayout updatePayout(IPayout payout) throws ServerInternalErrorException, InvalidArgumentException {
        PayoutValueObject result = null;
        PayoutValueObject in = new PayoutValueObject();
        in.setPayout(payout);
        try {
            result = this.remote.updatePayout(in);
        }
        catch (RemoteException e) {
            throw new ServerInternalErrorException("Remote Exception. Error is: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
        }
        in.getPayout();
        return result == null ? null : result.getPayout();
    }
}

