/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.servicelookup.ejb2xjaxws;

import com.ibm.wssvt.acme.annuity.common.business.IAnnuityService;
import com.ibm.wssvt.acme.annuity.common.business.ejbws.ejb2xjaxws.AnnuityMgmtSvcEJB2xJAXWS;
import com.ibm.wssvt.acme.annuity.common.business.ejbws.ejb2xjaxws.AnnuityMgmtSvcEJB2xJAXWSHome;
import com.ibm.wssvt.acme.annuity.common.business.ejbws.ejb2xjaxws.AnnuityMgmtSvcEJB2xJAXWSLocal;
import com.ibm.wssvt.acme.annuity.common.business.ejbws.ejb2xjaxws.AnnuityMgmtSvcEJB2xJAXWSLocalHome;
import com.ibm.wssvt.acme.annuity.common.servicelookup.ejb2xjaxws.AnnuityEJB2xJAXWSEJBLocalServiceProxy;
import com.ibm.wssvt.acme.annuity.common.servicelookup.ejb2xjaxws.AnnuityEJB2xJAXWSEJBRemoteServiceProxy;
import com.ibm.wssvt.acme.common.bean.Configrable;
import com.ibm.wssvt.acme.common.exception.ExceptionFormatter;
import com.ibm.wssvt.acme.common.exception.InvalidConfigurationException;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.rmi.RemoteException;
import java.util.Properties;
import java.util.logging.Level;
import javax.ejb.CreateException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

public class EJB2xJAXWSEJBServiceLookup {
    public static IAnnuityService getAnnuityEJB2xJAXWSEJBService(Configrable<String, String> configrable, AcmeLogger logger) throws InvalidConfigurationException, NamingException, CreateException, RemoteException {
        String mode = (String)configrable.getConfiguration().getParameterValue((Object)"connectionMode");
        if ("local".equalsIgnoreCase(mode)) {
            return new AnnuityEJB2xJAXWSEJBLocalServiceProxy(EJB2xJAXWSEJBServiceLookup.getAnnuityEJB2xJAXWSEJBLocalService(configrable, logger));
        }
        if ("remote".equalsIgnoreCase(mode)) {
            return new AnnuityEJB2xJAXWSEJBRemoteServiceProxy(EJB2xJAXWSEJBServiceLookup.getAnnuityEJB2xJAXWSEJBRemoteService(configrable, logger));
        }
        logger.info("The connectionMode configuration is not valid.  Supplied value is: " + mode);
        throw new InvalidConfigurationException("The connectionMode configuration is not valid.  Supplied value is: " + mode + logger.getAllLogs());
    }

    public static AnnuityMgmtSvcEJB2xJAXWS getAnnuityEJB2xJAXWSEJBRemoteService(Configrable<String, String> configrable, AcmeLogger logger) throws NamingException, RemoteException, CreateException {
        try {
            AnnuityMgmtSvcEJB2xJAXWS remote = null;
            logger.fine("EJB2xJAXWSServerAdapter - Using Remote");
            Properties p = new Properties();
            logger.finest("configrable values:" + configrable.getConfiguration().getParameters());
            p.put("java.naming.factory.initial", configrable.getConfiguration().getParameterValue((Object)"initialContextFactory"));
            p.put("java.naming.provider.url", configrable.getConfiguration().getParameterValue((Object)"iiopAddress"));
            InitialContext ic = new InitialContext(p);
            logger.fine("obtained initial context: " + ic);
            String homeJNDI = (String)configrable.getConfiguration().getParameterValue((Object)"ejb2xJAXWSEJBRemoteHomeJNDI");
            if (homeJNDI == null || "".equals(homeJNDI.trim())) {
                throw new NamingException("The JNDI Name for the parameter ejb2xJAXWSEJBRemoteHomeJNDI is null or blank.  Invalid value");
            }
            logger.fine("remote home jndi is: " + homeJNDI);
            Object h = ic.lookup(homeJNDI);
            AnnuityMgmtSvcEJB2xJAXWSHome home = (AnnuityMgmtSvcEJB2xJAXWSHome)PortableRemoteObject.narrow((Object)h, AnnuityMgmtSvcEJB2xJAXWSHome.class);
            remote = home.create();
            return remote;
        }
        catch (NamingException e) {
            String msg = "Failed to get the EJB2x JAX-WS Remote Server Interface.  Make sure that the Server is accessable.  Server Reported Error: " + ExceptionFormatter.deepFormatToString((Throwable)e) + logger.getAllLogs();
            logger.log(Level.WARNING, msg, (Throwable)e);
            NamingException ne = new NamingException(msg);
            ne.setRootCause(e);
            throw ne;
        }
        catch (RemoteException e) {
            String msg = "Failed to get the EJB2x JAX-WS Remote Server Interface.  with Remote Exception.  Server Reported Error: " + ExceptionFormatter.deepFormatToString((Throwable)e) + logger.getAllLogs();
            logger.log(Level.WARNING, msg, (Throwable)e);
            throw new RemoteException(msg, e);
        }
        catch (CreateException e) {
            throw e;
        }
    }

    public static AnnuityMgmtSvcEJB2xJAXWSLocal getAnnuityEJB2xJAXWSEJBLocalService(Configrable<String, String> configrable, AcmeLogger logger) throws NamingException, CreateException {
        AnnuityMgmtSvcEJB2xJAXWSLocal local = null;
        try {
            InitialContext ic = new InitialContext();
            logger.fine("obtained initial context: " + ic);
            String homeJNDI = (String)configrable.getConfiguration().getParameterValue((Object)"ejb2xJAXWSEJBLocalHomeJNDI");
            if (homeJNDI == null || "".equals(homeJNDI.trim())) {
                throw new NamingException("The JNDI Name for the parameter ejb2xJAXWSEJBLocalHomeJNDI is null or blank.  Invalid value");
            }
            logger.fine("local home jndi is: " + homeJNDI);
            AnnuityMgmtSvcEJB2xJAXWSLocalHome localHome = (AnnuityMgmtSvcEJB2xJAXWSLocalHome)ic.lookup(homeJNDI);
            logger.fine("home was found.  Home: " + localHome);
            local = localHome.create();
            logger.finer("local interface was found value is: " + local);
            return local;
        }
        catch (NamingException e) {
            String msg = "Failed to get the EJB2x JAX-WS Local Server Interface.  Make sure that the Server is accessable.  Server Reported Error: " + e.getMessage() + logger.getAllLogs();
            logger.log(Level.WARNING, msg, (Throwable)e);
            NamingException ne = new NamingException(msg);
            ne.setRootCause(e);
            throw ne;
        }
        catch (CreateException e) {
            throw e;
        }
    }
}

