/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.servicelookup.ejb3jaxrpc;

import com.ibm.wssvt.acme.annuity.common.business.IAnnuityService;
import com.ibm.wssvt.acme.annuity.common.business.ejbws.ejb3jaxrpc.AnnuityMgmtSvcEJB30JAXRPC;
import com.ibm.wssvt.acme.annuity.common.business.ejbws.ejb3jaxrpc.AnnuityMgmtSvcEJB30JAXRPCLocal;
import com.ibm.wssvt.acme.annuity.common.exception.AnnuitySecurityException;
import com.ibm.wssvt.acme.annuity.common.servicelookup.ejb3jaxrpc.AnnuityEJB3JAXRPCEJBLocalServiceProxy;
import com.ibm.wssvt.acme.annuity.common.servicelookup.ejb3jaxrpc.AnnuityEJB3JAXRPCEJBRemoteServiceProxy;
import com.ibm.wssvt.acme.annuity.common.util.AnnuityKerberosProperties;
import com.ibm.wssvt.acme.annuity.common.util.AnnuityKerberosSecurity;
import com.ibm.wssvt.acme.common.bean.Configrable;
import com.ibm.wssvt.acme.common.exception.ExceptionFormatter;
import com.ibm.wssvt.acme.common.exception.InvalidConfigurationException;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

public class EJB3JAXRPCEJBServiceLookup {
    public static IAnnuityService getAnnuityEJB3JAXRPCEJBService(Configrable<String, String> configrable, AcmeLogger logger) throws InvalidConfigurationException, NamingException, AnnuitySecurityException {
        String mode = (String)configrable.getConfiguration().getParameterValue((Object)"connectionMode");
        if ("local".equalsIgnoreCase(mode)) {
            return new AnnuityEJB3JAXRPCEJBLocalServiceProxy(EJB3JAXRPCEJBServiceLookup.getAnnuityEJB3JAXRPCEJBLocalService(configrable, logger));
        }
        if ("remote".equalsIgnoreCase(mode)) {
            return new AnnuityEJB3JAXRPCEJBRemoteServiceProxy(EJB3JAXRPCEJBServiceLookup.getAnnuityEJB3JAXRPCEJBRemoteService(configrable, logger));
        }
        logger.info("The connectionMode configuration is not valid.  Supplied value is: " + mode);
        throw new InvalidConfigurationException("The connectionMode configuration is not valid.  Supplied value is: " + mode + logger.getAllLogs());
    }

    public static AnnuityMgmtSvcEJB30JAXRPC getAnnuityEJB3JAXRPCEJBRemoteService(Configrable<String, String> configrable, AcmeLogger logger) throws NamingException, AnnuitySecurityException {
        AnnuityMgmtSvcEJB30JAXRPC svcRemote = null;
        try {
            if ("true".equalsIgnoreCase((String)configrable.getConfiguration().getParameterValue((Object)"useKerberosSecurity"))) {
                AnnuityKerberosProperties akp = new AnnuityKerberosProperties();
                akp.setKerbProperties(configrable, logger);
                AnnuityKerberosSecurity annuityKerberosSecurity = new AnnuityKerberosSecurity();
                if (AnnuityKerberosProperties.LOGIN_STYLE_NEW_TICKET.equalsIgnoreCase(akp.getLoginStyle())) {
                    annuityKerberosSecurity.login(akp, logger);
                } else if (AnnuityKerberosProperties.LOGIN_STYLE_NEW_OR_REFRESH_TICKET.equalsIgnoreCase(akp.getLoginStyle())) {
                    annuityKerberosSecurity.renewLogin(akp, logger);
                }
            }
            Properties p = new Properties();
            p.put("java.naming.factory.initial", configrable.getConfiguration().getParameterValue((Object)"initialContextFactory"));
            p.put("java.naming.provider.url", configrable.getConfiguration().getParameterValue((Object)"iiopAddress"));
            InitialContext ic = new InitialContext(p);
            logger.fine("obtained initial context: " + ic);
            String jndi = (String)configrable.getConfiguration().getParameterValue((Object)"ejb3JaxrpcRemoteJNDI");
            if (jndi == null || "".equals(jndi.trim())) {
                throw new NamingException("The JNDI Name for the parameter ejb3JaxrpcRemoteJNDI is null or blank.  Invalid value");
            }
            Object ref = ic.lookup(jndi);
            svcRemote = (AnnuityMgmtSvcEJB30JAXRPC)PortableRemoteObject.narrow((Object)ref, AnnuityMgmtSvcEJB30JAXRPC.class);
            logger.fine("svcRemote was found.  value is: " + svcRemote);
        }
        catch (NamingException e) {
            String msg = "Failed to get the EJB3 Remote Service Interface.  Make sure that the Server is accessable.  Server Reported Error: " + ExceptionFormatter.deepFormatToString((Throwable)e) + logger.getAllLogs();
            logger.warning(msg);
            NamingException ne = new NamingException(msg);
            ne.setRootCause(e);
            throw ne;
        }
        return svcRemote;
    }

    public static AnnuityMgmtSvcEJB30JAXRPCLocal getAnnuityEJB3JAXRPCEJBLocalService(Configrable<String, String> configrable, AcmeLogger logger) throws NamingException {
        AnnuityMgmtSvcEJB30JAXRPCLocal svc = null;
        try {
            InitialContext ic = new InitialContext();
            logger.fine("obtained initial context: " + ic);
            String jndi = (String)configrable.getConfiguration().getParameterValue((Object)"ejb3JaxrpcLocalJNDI");
            if (jndi == null || "".equals(jndi.trim())) {
                throw new NamingException("The JNDI Name for the parameter ejb3JaxrpcLocalJNDI is null or blank.  Invalid value");
            }
            Object ref = ic.lookup(jndi);
            svc = (AnnuityMgmtSvcEJB30JAXRPCLocal)ref;
            logger.fine("svcLocal was found.  value is: " + svc);
        }
        catch (NamingException e) {
            String msg = "Failed to get the EJB3 Local Service Interface.  Make sure that the Server is accessable.  Server Reported Error: " + ExceptionFormatter.deepFormatToString((Throwable)e) + logger.getAllLogs();
            logger.warning(msg);
            NamingException ne = new NamingException(msg);
            ne.setRootCause(e);
            throw ne;
        }
        return svc;
    }
}

