/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.servicelookup.ejb3mdb;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.bean.IContact;
import com.ibm.wssvt.acme.annuity.common.bean.IPayor;
import com.ibm.wssvt.acme.annuity.common.bean.IPayout;
import com.ibm.wssvt.acme.annuity.common.bean.IRider;
import com.ibm.wssvt.acme.annuity.common.business.IAnnuityService;
import com.ibm.wssvt.acme.annuity.common.exception.EntityAlreadyExistsException;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerBusinessModuleException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerPersistenceModuleException;
import com.ibm.wssvt.acme.annuity.common.util.AnnuityAction;
import com.ibm.wssvt.acme.annuity.common.util.AnnuityJMSMessage;
import com.ibm.wssvt.acme.common.bean.Configrable;
import com.ibm.wssvt.acme.common.exception.ExceptionFormatter;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TemporaryQueue;

public class AnnuityEJB3MDBServiceProxy
implements IAnnuityService {
    private ConnectionFactory connFactory = null;
    private Destination queueDest = null;
    private long replyConsumerTimeout = 10000L;
    private AcmeLogger logger = null;

    public AnnuityEJB3MDBServiceProxy(ConnectionFactory connectionFactory, Destination queueDestination, long replyConsumerTimeout, AcmeLogger logger) {
        this.connFactory = connectionFactory;
        this.queueDest = queueDestination;
        this.replyConsumerTimeout = replyConsumerTimeout;
        this.logger = logger;
    }

    private void processCommonExceptions(Exception e) throws InvalidArgumentException, ServerBusinessModuleException, ServerPersistenceModuleException {
        if (e instanceof InvalidArgumentException) {
            throw (InvalidArgumentException)((Object)e);
        }
        if (e instanceof ServerBusinessModuleException) {
            throw (ServerBusinessModuleException)((Object)e);
        }
        if (e instanceof ServerPersistenceModuleException) {
            throw (ServerPersistenceModuleException)((Object)e);
        }
        String msg = "The exception type is not known. Exception class is: " + e.getClass() + " error is: " + ExceptionFormatter.deepFormatToString((Throwable)e);
        this.logger.log(Level.INFO, msg);
        e.printStackTrace();
        throw new RuntimeException(msg, e);
    }

    private AnnuityJMSMessage jmsSendAndReceiveCall(Configrable<String, String> configrable, AnnuityAction annuityAction) throws JMSException {
        AnnuityJMSMessage annuityReply;
        block11: {
            Connection connection = null;
            MessageConsumer messageConsumer = null;
            annuityReply = null;
            try {
                connection = this.connFactory.createConnection();
                Session jmsSession = connection.createSession(false, 1);
                TemporaryQueue tempQueue = jmsSession.createTemporaryQueue();
                MessageProducer queueSender = jmsSession.createProducer(this.queueDest);
                ObjectMessage objectMessage = jmsSession.createObjectMessage();
                AnnuityJMSMessage annuityJMSMessage = new AnnuityJMSMessage();
                annuityJMSMessage.setAction(annuityAction);
                annuityJMSMessage.setInput(configrable);
                objectMessage.setObject((Serializable)annuityJMSMessage);
                objectMessage.setJMSDestination(this.queueDest);
                objectMessage.setJMSReplyTo((Destination)tempQueue);
                queueSender.setDeliveryMode(1);
                queueSender.send((Message)objectMessage);
                messageConsumer = jmsSession.createConsumer((Destination)tempQueue);
                connection.start();
                Message replyMessage = messageConsumer.receive(this.replyConsumerTimeout);
                if (replyMessage == null) {
                    throw new JMSException("The reply JMS Message is not valid. Its null.  Maybe the server did not respond in the allocated time of: " + this.replyConsumerTimeout);
                }
                ObjectMessage replyObject = null;
                if (!(replyMessage instanceof ObjectMessage)) {
                    throw new JMSException("The reply JMS Message is not instance of ObjectMesasge as expected.  Its class is: " + replyMessage.getClass() + " to String is: " + replyMessage);
                }
                replyObject = (ObjectMessage)replyMessage;
                this.logger.fine("reply" + replyObject);
                if (replyObject.getObject() instanceof AnnuityJMSMessage) {
                    annuityReply = (AnnuityJMSMessage)replyObject.getObject();
                    break block11;
                }
                throw new JMSException("The reply JMS Message internal object is not instance of AnnuityJMSMessage as expected.  Its class is: " + replyObject.getObject().getClass() + " toString is: " + replyObject.getObject());
            }
            catch (JMSException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JMSException("The JMS send/receive method: jmsSendAndReceiveCall() failed with this exception - " + e);
            }
            catch (Throwable t) {
                throw new JMSException("The JMS send/receive method: jmsSendAndReceiveCall() failed with this throwable - " + t.toString() + ".  Throwable's cause was: " + t.getCause());
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        return annuityReply;
    }

    @Override
    public IAnnuity findAnnuityById(IAnnuity annuity) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        try {
            AnnuityJMSMessage annuityJMSMessageReply = this.jmsSendAndReceiveCall(annuity, AnnuityAction.FIND_ANNUITY_BY_ID);
            if (annuityJMSMessageReply == null) {
                throw new ServerInternalErrorException("The JMS Call returned a null object.");
            }
            if (annuityJMSMessageReply.getOutput() == null) {
                throw new ServerInternalErrorException("The JMS call returned invalid data.  The reply message has a null output.");
            }
            IAnnuity retData = null;
            if (annuityJMSMessageReply.getOutput() instanceof IAnnuity) {
                retData = (IAnnuity)annuityJMSMessageReply.getOutput();
            } else if (annuityJMSMessageReply.getOutput() instanceof Exception) {
                if (annuityJMSMessageReply.getOutput() instanceof EntityNotFoundException) {
                    throw (EntityNotFoundException)((Object)annuityJMSMessageReply.getOutput());
                }
                this.processCommonExceptions((Exception)annuityJMSMessageReply.getOutput());
            } else {
                throw new ServerInternalErrorException("The result object is of an an expected type. Its type is: " + annuityJMSMessageReply.getOutput().getClass());
            }
            return retData;
        }
        catch (JMSException e) {
            String msg = "Failed to send/receive the JMS Message.  Received a JMSException.  Error is:" + (Object)((Object)e) + " returning a ServerInternalErrorException";
            this.logger.log(Level.INFO, msg, (Throwable)e);
            throw new ServerInternalErrorException(msg, e);
        }
    }

    @Override
    public IAnnuityHolder findAnnuityHolder(IAnnuity annuity) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        try {
            AnnuityJMSMessage annuityJMSMessageReply = this.jmsSendAndReceiveCall(annuity, AnnuityAction.FIND_ANNUITY_HOLDER);
            if (annuityJMSMessageReply == null) {
                throw new ServerInternalErrorException("The JMS Call returned a null object.");
            }
            if (annuityJMSMessageReply.getOutput() == null) {
                throw new ServerInternalErrorException("The JMS call returned invalid data.  The reply message has a null output.");
            }
            IAnnuityHolder retData = null;
            if (annuityJMSMessageReply.getOutput() instanceof IAnnuityHolder) {
                retData = (IAnnuityHolder)annuityJMSMessageReply.getOutput();
            } else if (annuityJMSMessageReply.getOutput() instanceof Exception) {
                if (annuityJMSMessageReply.getOutput() instanceof EntityNotFoundException) {
                    throw (EntityNotFoundException)((Object)annuityJMSMessageReply.getOutput());
                }
                this.processCommonExceptions((Exception)annuityJMSMessageReply.getOutput());
            } else {
                throw new ServerInternalErrorException("The result object is of an an expected type. Its type is: " + annuityJMSMessageReply.getOutput().getClass());
            }
            return retData;
        }
        catch (JMSException e) {
            String msg = "Failed to send/receive the JMS Message.  Received a JMSException.  Error is:" + (Object)((Object)e) + " returning a ServerInternalErrorException";
            this.logger.log(Level.INFO, msg, (Throwable)e);
            throw new ServerInternalErrorException(msg, e);
        }
    }

    @Override
    public IContact findContactById(IContact contact) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        try {
            AnnuityJMSMessage annuityJMSMessageReply = this.jmsSendAndReceiveCall(contact, AnnuityAction.FIND_CONTACT_BY_ID);
            if (annuityJMSMessageReply == null) {
                throw new ServerInternalErrorException("The JMS Call returned a null object.");
            }
            if (annuityJMSMessageReply.getOutput() == null) {
                throw new ServerInternalErrorException("The JMS call returned invalid data.  The reply message has a null output.");
            }
            IContact retData = null;
            if (annuityJMSMessageReply.getOutput() instanceof IContact) {
                retData = (IContact)annuityJMSMessageReply.getOutput();
            } else if (annuityJMSMessageReply.getOutput() instanceof Exception) {
                if (annuityJMSMessageReply.getOutput() instanceof EntityNotFoundException) {
                    throw (EntityNotFoundException)((Object)annuityJMSMessageReply.getOutput());
                }
                this.processCommonExceptions((Exception)annuityJMSMessageReply.getOutput());
            } else {
                throw new ServerInternalErrorException("The result object is of an an expected type. Its type is: " + annuityJMSMessageReply.getOutput().getClass());
            }
            return retData;
        }
        catch (JMSException e) {
            String msg = "Failed to send/receive the JMS Message.  Received a JMSException.  Error is:" + (Object)((Object)e) + " returning a ServerInternalErrorException";
            this.logger.log(Level.INFO, msg, (Throwable)e);
            throw new ServerInternalErrorException(msg, e);
        }
    }

    @Override
    public List<IAnnuity> findHolderAnnuities(IAnnuityHolder annuityHolder) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            AnnuityJMSMessage annuityJMSMessageReply = this.jmsSendAndReceiveCall(annuityHolder, AnnuityAction.FIND_HOLDER_ANNUITIES);
            if (annuityJMSMessageReply == null) {
                throw new ServerInternalErrorException("The JMS Call returned a null object.");
            }
            if (annuityJMSMessageReply.getOutput() == null) {
                throw new ServerInternalErrorException("The JMS call returned invalid data.  The reply message has a null output.");
            }
            List retData = null;
            if (annuityJMSMessageReply.getOutput() instanceof List) {
                retData = (List)annuityJMSMessageReply.getOutput();
            } else if (annuityJMSMessageReply.getOutput() instanceof Exception) {
                this.processCommonExceptions((Exception)annuityJMSMessageReply.getOutput());
            } else {
                throw new ServerInternalErrorException("The result object is of an an expected type. Its type is: " + annuityJMSMessageReply.getOutput().getClass());
            }
            return retData;
        }
        catch (JMSException e) {
            String msg = "Failed to send/receive the JMS Message.  Received a JMSException.  Error is:" + (Object)((Object)e) + " returning a ServerInternalErrorException";
            this.logger.log(Level.INFO, msg, (Throwable)e);
            throw new ServerInternalErrorException(msg, e);
        }
    }

    @Override
    public IAnnuityHolder findHolderById(IAnnuityHolder annuityHolder) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        try {
            AnnuityJMSMessage annuityJMSMessageReply = this.jmsSendAndReceiveCall(annuityHolder, AnnuityAction.FIND_HOLDER_BY_ID);
            if (annuityJMSMessageReply == null) {
                throw new ServerInternalErrorException("The JMS Call returned a null object.");
            }
            if (annuityJMSMessageReply.getOutput() == null) {
                throw new ServerInternalErrorException("The JMS call returned invalid data.  The reply message has a null output.");
            }
            IAnnuityHolder retData = null;
            if (annuityJMSMessageReply.getOutput() instanceof IAnnuityHolder) {
                retData = (IAnnuityHolder)annuityJMSMessageReply.getOutput();
            } else if (annuityJMSMessageReply.getOutput() instanceof Exception) {
                if (annuityJMSMessageReply.getOutput() instanceof EntityNotFoundException) {
                    throw (EntityNotFoundException)((Object)annuityJMSMessageReply.getOutput());
                }
                this.processCommonExceptions((Exception)annuityJMSMessageReply.getOutput());
            } else {
                throw new ServerInternalErrorException("The result object is of an an expected type. Its type is: " + annuityJMSMessageReply.getOutput().getClass());
            }
            return retData;
        }
        catch (JMSException e) {
            String msg = "Failed to send/receive the JMS Message.  Received a JMSException.  Error is:" + (Object)((Object)e) + " returning a ServerInternalErrorException";
            this.logger.log(Level.INFO, msg, (Throwable)e);
            throw new ServerInternalErrorException(msg, e);
        }
    }

    @Override
    public IPayor findPayorById(IPayor payor) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        try {
            AnnuityJMSMessage annuityJMSMessageReply = this.jmsSendAndReceiveCall(payor, AnnuityAction.FIND_PAYOR_BY_ID);
            if (annuityJMSMessageReply == null) {
                throw new ServerInternalErrorException("The JMS Call returned a null object.");
            }
            if (annuityJMSMessageReply.getOutput() == null) {
                throw new ServerInternalErrorException("The JMS call returned invalid data.  The reply message has a null output.");
            }
            IPayor retData = null;
            if (annuityJMSMessageReply.getOutput() instanceof IPayor) {
                retData = (IPayor)annuityJMSMessageReply.getOutput();
            } else if (annuityJMSMessageReply.getOutput() instanceof Exception) {
                if (annuityJMSMessageReply.getOutput() instanceof EntityNotFoundException) {
                    throw (EntityNotFoundException)((Object)annuityJMSMessageReply.getOutput());
                }
                this.processCommonExceptions((Exception)annuityJMSMessageReply.getOutput());
            } else {
                throw new ServerInternalErrorException("The result object is of an an expected type. Its type is: " + annuityJMSMessageReply.getOutput().getClass());
            }
            return retData;
        }
        catch (JMSException e) {
            String msg = "Failed to send/receive the JMS Message.  Received a JMSException.  Error is:" + (Object)((Object)e) + " returning a ServerInternalErrorException";
            this.logger.log(Level.INFO, msg, (Throwable)e);
            throw new ServerInternalErrorException(msg, e);
        }
    }

    @Override
    public IPayout findPayoutById(IPayout payout) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        try {
            AnnuityJMSMessage annuityJMSMessageReply = this.jmsSendAndReceiveCall(payout, AnnuityAction.FIND_PAYOUT_BY_ID);
            if (annuityJMSMessageReply == null) {
                throw new ServerInternalErrorException("The JMS Call returned a null object.");
            }
            if (annuityJMSMessageReply.getOutput() == null) {
                throw new ServerInternalErrorException("The JMS call returned invalid data.  The reply message has a null output.");
            }
            IPayout retData = null;
            if (annuityJMSMessageReply.getOutput() instanceof IPayout) {
                retData = (IPayout)annuityJMSMessageReply.getOutput();
            } else if (annuityJMSMessageReply.getOutput() instanceof Exception) {
                if (annuityJMSMessageReply.getOutput() instanceof EntityNotFoundException) {
                    throw (EntityNotFoundException)((Object)annuityJMSMessageReply.getOutput());
                }
                this.processCommonExceptions((Exception)annuityJMSMessageReply.getOutput());
            } else {
                throw new ServerInternalErrorException("The result object is of an an expected type. Its type is: " + annuityJMSMessageReply.getOutput().getClass());
            }
            return retData;
        }
        catch (JMSException e) {
            String msg = "Failed to send/receive the JMS Message.  Received a JMSException.  Error is:" + (Object)((Object)e) + " returning a ServerInternalErrorException";
            this.logger.log(Level.INFO, msg, (Throwable)e);
            throw new ServerInternalErrorException(msg, e);
        }
    }

    @Override
    public IRider findRiderById(IRider rider) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        try {
            AnnuityJMSMessage annuityJMSMessageReply = this.jmsSendAndReceiveCall(rider, AnnuityAction.FIND_RIDER_BY_ID);
            if (annuityJMSMessageReply == null) {
                throw new ServerInternalErrorException("The JMS Call returned a null object.");
            }
            if (annuityJMSMessageReply.getOutput() == null) {
                throw new ServerInternalErrorException("The JMS call returned invalid data.  The reply message has a null output.");
            }
            IRider retData = null;
            if (annuityJMSMessageReply.getOutput() instanceof IRider) {
                retData = (IRider)annuityJMSMessageReply.getOutput();
            } else if (annuityJMSMessageReply.getOutput() instanceof Exception) {
                if (annuityJMSMessageReply.getOutput() instanceof EntityNotFoundException) {
                    throw (EntityNotFoundException)((Object)annuityJMSMessageReply.getOutput());
                }
                this.processCommonExceptions((Exception)annuityJMSMessageReply.getOutput());
            } else {
                throw new ServerInternalErrorException("The result object is of an an expected type. Its type is: " + annuityJMSMessageReply.getOutput().getClass());
            }
            return retData;
        }
        catch (JMSException e) {
            String msg = "Failed to send/receive the JMS Message.  Received a JMSException.  Error is:" + (Object)((Object)e) + " returning a ServerInternalErrorException";
            this.logger.log(Level.INFO, msg, (Throwable)e);
            throw new ServerInternalErrorException(msg, e);
        }
    }

    @Override
    public IAnnuity createAnnuity(IAnnuity ann) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        try {
            AnnuityJMSMessage annuityJMSMessageReply = this.jmsSendAndReceiveCall(ann, AnnuityAction.CREATE_ANNUITY);
            if (annuityJMSMessageReply == null) {
                throw new ServerInternalErrorException("The JMS Call returned a null object.");
            }
            if (annuityJMSMessageReply.getOutput() == null) {
                throw new ServerInternalErrorException("The JMS call returned invalid data.  The reply message has a null output.");
            }
            IAnnuity retData = null;
            if (annuityJMSMessageReply.getOutput() instanceof IAnnuity) {
                retData = (IAnnuity)annuityJMSMessageReply.getOutput();
            } else if (annuityJMSMessageReply.getOutput() instanceof Exception) {
                if (annuityJMSMessageReply.getOutput() instanceof EntityAlreadyExistsException) {
                    throw (EntityAlreadyExistsException)((Object)annuityJMSMessageReply.getOutput());
                }
                this.processCommonExceptions((Exception)annuityJMSMessageReply.getOutput());
            } else {
                throw new ServerInternalErrorException("The result object is of an an expected type. Its type is: " + annuityJMSMessageReply.getOutput().getClass());
            }
            return retData;
        }
        catch (JMSException e) {
            String msg = "Failed to send/receive the JMS Message.  Received a JMSException.  Error is:" + (Object)((Object)e) + " returning a ServerInternalErrorException";
            this.logger.log(Level.INFO, msg, (Throwable)e);
            throw new ServerInternalErrorException(msg, e);
        }
    }

    @Override
    public IAnnuityHolder createAnnuityHolder(IAnnuityHolder annHolder) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        try {
            AnnuityJMSMessage annuityJMSMessageReply = this.jmsSendAndReceiveCall(annHolder, AnnuityAction.CREATE_ANNUITY_HOLDER);
            if (annuityJMSMessageReply == null) {
                throw new ServerInternalErrorException("The JMS Call returned a null object.");
            }
            if (annuityJMSMessageReply.getOutput() == null) {
                throw new ServerInternalErrorException("The JMS call returned invalid data.  The reply message has a null output.");
            }
            IAnnuityHolder retData = null;
            if (annuityJMSMessageReply.getOutput() instanceof IAnnuityHolder) {
                retData = (IAnnuityHolder)annuityJMSMessageReply.getOutput();
            } else if (annuityJMSMessageReply.getOutput() instanceof Exception) {
                if (annuityJMSMessageReply.getOutput() instanceof EntityAlreadyExistsException) {
                    throw (EntityAlreadyExistsException)((Object)annuityJMSMessageReply.getOutput());
                }
                this.processCommonExceptions((Exception)annuityJMSMessageReply.getOutput());
            } else {
                throw new ServerInternalErrorException("The result object is of an an expected type. Its type is: " + annuityJMSMessageReply.getOutput().getClass());
            }
            return retData;
        }
        catch (JMSException e) {
            String msg = "Failed to send/receive the JMS Message.  Received a JMSException.  Error is:" + (Object)((Object)e) + " returning a ServerInternalErrorException";
            this.logger.log(Level.INFO, msg, (Throwable)e);
            throw new ServerInternalErrorException(msg, e);
        }
    }

    @Override
    public IContact createContact(IContact contact) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        try {
            AnnuityJMSMessage annuityJMSMessageReply = this.jmsSendAndReceiveCall(contact, AnnuityAction.CREATE_CONTACT);
            if (annuityJMSMessageReply == null) {
                throw new ServerInternalErrorException("The JMS Call returned a null object.");
            }
            if (annuityJMSMessageReply.getOutput() == null) {
                throw new ServerInternalErrorException("The JMS call returned invalid data.  The reply message has a null output.");
            }
            IContact retData = null;
            if (annuityJMSMessageReply.getOutput() instanceof IContact) {
                retData = (IContact)annuityJMSMessageReply.getOutput();
            } else if (annuityJMSMessageReply.getOutput() instanceof Exception) {
                if (annuityJMSMessageReply.getOutput() instanceof EntityAlreadyExistsException) {
                    throw (EntityAlreadyExistsException)((Object)annuityJMSMessageReply.getOutput());
                }
                this.processCommonExceptions((Exception)annuityJMSMessageReply.getOutput());
            } else {
                throw new ServerInternalErrorException("The result object is of an an expected type. Its type is: " + annuityJMSMessageReply.getOutput().getClass());
            }
            return retData;
        }
        catch (JMSException e) {
            String msg = "Failed to send/receive the JMS Message.  Received a JMSException.  Error is:" + (Object)((Object)e) + " returning a ServerInternalErrorException";
            this.logger.log(Level.INFO, msg, (Throwable)e);
            throw new ServerInternalErrorException(msg, e);
        }
    }

    @Override
    public IPayor createPayor(IPayor payor) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        try {
            AnnuityJMSMessage annuityJMSMessageReply = this.jmsSendAndReceiveCall(payor, AnnuityAction.CREATE_PAYOR);
            if (annuityJMSMessageReply == null) {
                throw new ServerInternalErrorException("The JMS Call returned a null object.");
            }
            if (annuityJMSMessageReply.getOutput() == null) {
                throw new ServerInternalErrorException("The JMS call returned invalid data.  The reply message has a null output.");
            }
            IPayor retData = null;
            if (annuityJMSMessageReply.getOutput() instanceof IPayor) {
                retData = (IPayor)annuityJMSMessageReply.getOutput();
            } else if (annuityJMSMessageReply.getOutput() instanceof Exception) {
                if (annuityJMSMessageReply.getOutput() instanceof EntityAlreadyExistsException) {
                    throw (EntityAlreadyExistsException)((Object)annuityJMSMessageReply.getOutput());
                }
                this.processCommonExceptions((Exception)annuityJMSMessageReply.getOutput());
            } else {
                throw new ServerInternalErrorException("The result object is of an an expected type. Its type is: " + annuityJMSMessageReply.getOutput().getClass());
            }
            return retData;
        }
        catch (JMSException e) {
            String msg = "Failed to send/receive the JMS Message.  Received a JMSException.  Error is:" + (Object)((Object)e) + " returning a ServerInternalErrorException";
            this.logger.log(Level.INFO, msg, (Throwable)e);
            throw new ServerInternalErrorException(msg, e);
        }
    }

    @Override
    public void deleteAnnuity(IAnnuity annuity) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            AnnuityJMSMessage annuityJMSMessageReply = this.jmsSendAndReceiveCall(annuity, AnnuityAction.DELETE_ANNUITY);
            if (annuityJMSMessageReply == null) {
                throw new ServerInternalErrorException("The JMS Call returned a null object.");
            }
            if (annuityJMSMessageReply.getOutput() == null) {
                return;
            }
            if (!(annuityJMSMessageReply.getOutput() instanceof Exception)) {
                throw new ServerInternalErrorException("The result object is of an an expected type (expected value was null (for correct behavior) or exception. Its type is: " + annuityJMSMessageReply.getOutput().getClass());
            }
            this.processCommonExceptions((Exception)annuityJMSMessageReply.getOutput());
        }
        catch (JMSException e) {
            String msg = "Failed to send/receive the JMS Message.  Received a JMSException.  Error is:" + (Object)((Object)e) + " returning a ServerInternalErrorException";
            this.logger.log(Level.INFO, msg, (Throwable)e);
            throw new ServerInternalErrorException(msg, e);
        }
    }

    @Override
    public void deleteAnnuityHolder(IAnnuityHolder annHolder) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            AnnuityJMSMessage annuityJMSMessageReply = this.jmsSendAndReceiveCall(annHolder, AnnuityAction.DELETE_ANNUITY_HOLDER);
            if (annuityJMSMessageReply == null) {
                throw new ServerInternalErrorException("The JMS Call returned a null object.");
            }
            if (annuityJMSMessageReply.getOutput() == null) {
                return;
            }
            if (!(annuityJMSMessageReply.getOutput() instanceof Exception)) {
                throw new ServerInternalErrorException("The result object is of an an expected type (expected value was null (for correct behavior) or exception. Its type is: " + annuityJMSMessageReply.getOutput().getClass());
            }
            this.processCommonExceptions((Exception)annuityJMSMessageReply.getOutput());
        }
        catch (JMSException e) {
            String msg = "Failed to send/receive the JMS Message.  Received a JMSException.  Error is:" + (Object)((Object)e) + " returning a ServerInternalErrorException";
            this.logger.log(Level.INFO, msg, (Throwable)e);
            throw new ServerInternalErrorException(msg, e);
        }
    }

    @Override
    public void deleteContact(IContact contact) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            AnnuityJMSMessage annuityJMSMessageReply = this.jmsSendAndReceiveCall(contact, AnnuityAction.DELETE_CONTACT);
            if (annuityJMSMessageReply == null) {
                throw new ServerInternalErrorException("The JMS Call returned a null object.");
            }
            if (annuityJMSMessageReply.getOutput() == null) {
                return;
            }
            if (!(annuityJMSMessageReply.getOutput() instanceof Exception)) {
                throw new ServerInternalErrorException("The result object is of an an expected type (expected value was null (for correct behavior) or exception. Its type is: " + annuityJMSMessageReply.getOutput().getClass());
            }
            this.processCommonExceptions((Exception)annuityJMSMessageReply.getOutput());
        }
        catch (JMSException e) {
            String msg = "Failed to send/receive the JMS Message.  Received a JMSException.  Error is:" + (Object)((Object)e) + " returning a ServerInternalErrorException";
            this.logger.log(Level.INFO, msg, (Throwable)e);
            throw new ServerInternalErrorException(msg, e);
        }
    }

    @Override
    public void deletePayor(IPayor payor) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            AnnuityJMSMessage annuityJMSMessageReply = this.jmsSendAndReceiveCall(payor, AnnuityAction.DELETE_PAYOR);
            if (annuityJMSMessageReply == null) {
                throw new ServerInternalErrorException("The JMS Call returned a null object.");
            }
            if (annuityJMSMessageReply.getOutput() == null) {
                return;
            }
            if (!(annuityJMSMessageReply.getOutput() instanceof Exception)) {
                throw new ServerInternalErrorException("The result object is of an an expected type (expected value was null (for correct behavior) or exception. Its type is: " + annuityJMSMessageReply.getOutput().getClass());
            }
            this.processCommonExceptions((Exception)annuityJMSMessageReply.getOutput());
        }
        catch (JMSException e) {
            String msg = "Failed to send/receive the JMS Message.  Received a JMSException.  Error is:" + (Object)((Object)e) + " returning a ServerInternalErrorException";
            this.logger.log(Level.INFO, msg, (Throwable)e);
            throw new ServerInternalErrorException(msg, e);
        }
    }

    @Override
    public void deletePayout(IPayout payout) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            AnnuityJMSMessage annuityJMSMessageReply = this.jmsSendAndReceiveCall(payout, AnnuityAction.DELETE_PAYOUT);
            if (annuityJMSMessageReply == null) {
                throw new ServerInternalErrorException("The JMS Call returned a null object.");
            }
            if (annuityJMSMessageReply.getOutput() == null) {
                return;
            }
            if (!(annuityJMSMessageReply.getOutput() instanceof Exception)) {
                throw new ServerInternalErrorException("The result object is of an an expected type (expected value was null (for correct behavior) or exception. Its type is: " + annuityJMSMessageReply.getOutput().getClass());
            }
            this.processCommonExceptions((Exception)annuityJMSMessageReply.getOutput());
        }
        catch (JMSException e) {
            String msg = "Failed to send/receive the JMS Message.  Received a JMSException.  Error is:" + (Object)((Object)e) + " returning a ServerInternalErrorException";
            this.logger.log(Level.INFO, msg, (Throwable)e);
            throw new ServerInternalErrorException(msg, e);
        }
    }

    @Override
    public void deleteRider(IRider rider) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            AnnuityJMSMessage annuityJMSMessageReply = this.jmsSendAndReceiveCall(rider, AnnuityAction.DELETE_RIDER);
            if (annuityJMSMessageReply == null) {
                throw new ServerInternalErrorException("The JMS Call returned a null object.");
            }
            if (annuityJMSMessageReply.getOutput() == null) {
                return;
            }
            if (!(annuityJMSMessageReply.getOutput() instanceof Exception)) {
                throw new ServerInternalErrorException("The result object is of an an expected type (expected value was null (for correct behavior) or exception. Its type is: " + annuityJMSMessageReply.getOutput().getClass());
            }
            this.processCommonExceptions((Exception)annuityJMSMessageReply.getOutput());
        }
        catch (JMSException e) {
            String msg = "Failed to send/receive the JMS Message.  Received a JMSException.  Error is:" + (Object)((Object)e) + " returning a ServerInternalErrorException";
            this.logger.log(Level.INFO, msg, (Throwable)e);
            throw new ServerInternalErrorException(msg, e);
        }
    }

    @Override
    public IAnnuity updateAnnuity(IAnnuity ann) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            AnnuityJMSMessage annuityJMSMessageReply = this.jmsSendAndReceiveCall(ann, AnnuityAction.UPDATE_ANNUITY);
            if (annuityJMSMessageReply == null) {
                throw new ServerInternalErrorException("The JMS Call returned a null object.");
            }
            if (annuityJMSMessageReply.getOutput() == null) {
                throw new ServerInternalErrorException("The JMS call returned invalid data.  The reply message has a null output.");
            }
            IAnnuity retData = null;
            if (annuityJMSMessageReply.getOutput() instanceof IAnnuity) {
                retData = (IAnnuity)annuityJMSMessageReply.getOutput();
            } else if (annuityJMSMessageReply.getOutput() instanceof Exception) {
                this.processCommonExceptions((Exception)annuityJMSMessageReply.getOutput());
            } else {
                throw new ServerInternalErrorException("The result object is of an an expected type. Its type is: " + annuityJMSMessageReply.getOutput().getClass());
            }
            return retData;
        }
        catch (JMSException e) {
            String msg = "Failed to send/receive the JMS Message.  Received a JMSException.  Error is:" + (Object)((Object)e) + " returning a ServerInternalErrorException";
            this.logger.log(Level.INFO, msg, (Throwable)e);
            throw new ServerInternalErrorException(msg, e);
        }
    }

    @Override
    public IAnnuityHolder updateAnnuityHolder(IAnnuityHolder annHolder) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            AnnuityJMSMessage annuityJMSMessageReply = this.jmsSendAndReceiveCall(annHolder, AnnuityAction.UPDATE_ANNUITY_HOLDER);
            if (annuityJMSMessageReply == null) {
                throw new ServerInternalErrorException("The JMS Call returned a null object.");
            }
            if (annuityJMSMessageReply.getOutput() == null) {
                throw new ServerInternalErrorException("The JMS call returned invalid data.  The reply message has a null output.");
            }
            IAnnuityHolder retData = null;
            if (annuityJMSMessageReply.getOutput() instanceof IAnnuityHolder) {
                retData = (IAnnuityHolder)annuityJMSMessageReply.getOutput();
            } else if (annuityJMSMessageReply.getOutput() instanceof Exception) {
                this.processCommonExceptions((Exception)annuityJMSMessageReply.getOutput());
            } else {
                throw new ServerInternalErrorException("The result object is of an an expected type. Its type is: " + annuityJMSMessageReply.getOutput().getClass());
            }
            return retData;
        }
        catch (JMSException e) {
            String msg = "Failed to send/receive the JMS Message.  Received a JMSException.  Error is:" + (Object)((Object)e) + " returning a ServerInternalErrorException";
            this.logger.log(Level.INFO, msg, (Throwable)e);
            throw new ServerInternalErrorException(msg, e);
        }
    }

    @Override
    public IContact updateContact(IContact contact) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            AnnuityJMSMessage annuityJMSMessageReply = this.jmsSendAndReceiveCall(contact, AnnuityAction.UPDATE_CONTACT);
            if (annuityJMSMessageReply == null) {
                throw new ServerInternalErrorException("The JMS Call returned a null object.");
            }
            if (annuityJMSMessageReply.getOutput() == null) {
                throw new ServerInternalErrorException("The JMS call returned invalid data.  The reply message has a null output.");
            }
            IContact retData = null;
            if (annuityJMSMessageReply.getOutput() instanceof IContact) {
                retData = (IContact)annuityJMSMessageReply.getOutput();
            } else if (annuityJMSMessageReply.getOutput() instanceof Exception) {
                this.processCommonExceptions((Exception)annuityJMSMessageReply.getOutput());
            } else {
                throw new ServerInternalErrorException("The result object is of an an expected type. Its type is: " + annuityJMSMessageReply.getOutput().getClass());
            }
            return retData;
        }
        catch (JMSException e) {
            String msg = "Failed to send/receive the JMS Message.  Received a JMSException.  Error is:" + (Object)((Object)e) + " returning a ServerInternalErrorException";
            this.logger.log(Level.INFO, msg, (Throwable)e);
            throw new ServerInternalErrorException(msg, e);
        }
    }

    @Override
    public IPayor updatePayor(IPayor payor) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            AnnuityJMSMessage annuityJMSMessageReply = this.jmsSendAndReceiveCall(payor, AnnuityAction.UPDATE_PAYOR);
            if (annuityJMSMessageReply == null) {
                throw new ServerInternalErrorException("The JMS Call returned a null object.");
            }
            if (annuityJMSMessageReply.getOutput() == null) {
                throw new ServerInternalErrorException("The JMS call returned invalid data.  The reply message has a null output.");
            }
            IPayor retData = null;
            if (annuityJMSMessageReply.getOutput() instanceof IPayor) {
                retData = (IPayor)annuityJMSMessageReply.getOutput();
            } else if (annuityJMSMessageReply.getOutput() instanceof Exception) {
                this.processCommonExceptions((Exception)annuityJMSMessageReply.getOutput());
            } else {
                throw new ServerInternalErrorException("The result object is of an an expected type. Its type is: " + annuityJMSMessageReply.getOutput().getClass());
            }
            return retData;
        }
        catch (JMSException e) {
            String msg = "Failed to send/receive the JMS Message.  Received a JMSException.  Error is:" + (Object)((Object)e) + " returning a ServerInternalErrorException";
            this.logger.log(Level.INFO, msg, (Throwable)e);
            throw new ServerInternalErrorException(msg, e);
        }
    }

    @Override
    public List<IAnnuity> findPayorAnnuities(IPayor payor) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            AnnuityJMSMessage annuityJMSMessageReply = this.jmsSendAndReceiveCall(payor, AnnuityAction.FIND_PAYOR_ANNUITIES);
            if (annuityJMSMessageReply == null) {
                throw new ServerInternalErrorException("The JMS Call returned a null object.");
            }
            if (annuityJMSMessageReply.getOutput() == null) {
                throw new ServerInternalErrorException("The JMS call returned invalid data.  The reply message has a null output.");
            }
            List retData = null;
            if (annuityJMSMessageReply.getOutput() instanceof List) {
                retData = (List)annuityJMSMessageReply.getOutput();
            } else if (annuityJMSMessageReply.getOutput() instanceof Exception) {
                this.processCommonExceptions((Exception)annuityJMSMessageReply.getOutput());
            } else {
                throw new ServerInternalErrorException("The result object is of an an expected type. Its type is: " + annuityJMSMessageReply.getOutput().getClass());
            }
            return retData;
        }
        catch (JMSException e) {
            String msg = "Failed to send/receive the JMS Message.  Received a JMSException.  Error is:" + (Object)((Object)e) + " returning a ServerInternalErrorException";
            this.logger.log(Level.INFO, msg, (Throwable)e);
            throw new ServerInternalErrorException(msg, e);
        }
    }

    @Override
    public IPayout createPayout(IPayout payout) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        try {
            AnnuityJMSMessage annuityJMSMessageReply = this.jmsSendAndReceiveCall(payout, AnnuityAction.CREATE_PAYOUT);
            if (annuityJMSMessageReply == null) {
                throw new ServerInternalErrorException("The JMS Call returned a null object.");
            }
            if (annuityJMSMessageReply.getOutput() == null) {
                throw new ServerInternalErrorException("The JMS call returned invalid data.  The reply message has a null output.");
            }
            IPayout retData = null;
            if (annuityJMSMessageReply.getOutput() instanceof IPayout) {
                retData = (IPayout)annuityJMSMessageReply.getOutput();
            } else if (annuityJMSMessageReply.getOutput() instanceof Exception) {
                if (annuityJMSMessageReply.getOutput() instanceof EntityAlreadyExistsException) {
                    throw (EntityAlreadyExistsException)((Object)annuityJMSMessageReply.getOutput());
                }
                this.processCommonExceptions((Exception)annuityJMSMessageReply.getOutput());
            } else {
                throw new ServerInternalErrorException("The result object is of an an expected type. Its type is: " + annuityJMSMessageReply.getOutput().getClass());
            }
            return retData;
        }
        catch (JMSException e) {
            String msg = "Failed to send/receive the JMS Message.  Received a JMSException.  Error is:" + (Object)((Object)e) + " returning a ServerInternalErrorException";
            this.logger.log(Level.INFO, msg, (Throwable)e);
            throw new ServerInternalErrorException(msg, e);
        }
    }

    @Override
    public IPayout updatePayout(IPayout payout) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            AnnuityJMSMessage annuityJMSMessageReply = this.jmsSendAndReceiveCall(payout, AnnuityAction.UPDATE_PAYOUT);
            if (annuityJMSMessageReply == null) {
                throw new ServerInternalErrorException("The JMS Call returned a null object.");
            }
            if (annuityJMSMessageReply.getOutput() == null) {
                throw new ServerInternalErrorException("The JMS call returned invalid data.  The reply message has a null output.");
            }
            IPayout retData = null;
            if (annuityJMSMessageReply.getOutput() instanceof IPayout) {
                retData = (IPayout)annuityJMSMessageReply.getOutput();
            } else if (annuityJMSMessageReply.getOutput() instanceof Exception) {
                this.processCommonExceptions((Exception)annuityJMSMessageReply.getOutput());
            } else {
                throw new ServerInternalErrorException("The result object is of an an expected type. Its type is: " + annuityJMSMessageReply.getOutput().getClass());
            }
            return retData;
        }
        catch (JMSException e) {
            String msg = "Failed to send/receive the JMS Message.  Received a JMSException.  Error is:" + (Object)((Object)e) + " returning a ServerInternalErrorException";
            this.logger.log(Level.INFO, msg, (Throwable)e);
            throw new ServerInternalErrorException(msg, e);
        }
    }
}

