/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.servicelookup.jaxws2ejb3jaxrpc;

import com.ibm.wssvt.acme.annuity.common.business.IAnnuityService;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.AnnuityMgmtSvcEJB3JAXRPCImpl;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.jaxws2ejb3jaxrpc.AnnuityMgmtSvcEJB3JAXRPCSEI;
import com.ibm.wssvt.acme.annuity.common.exception.AnnuitySecurityException;
import com.ibm.wssvt.acme.annuity.common.servicelookup.jaxws2ejb3jaxrpc.AnnuityJAXWSToEjb3JAXRPCServiceProxy;
import com.ibm.wssvt.acme.annuity.common.servicelookup.jaxws2ejb3jaxrpc.AnnuityJAXWSToEjb3JAXRPCServiceProxyAsync;
import com.ibm.wssvt.acme.common.bean.Configrable;
import com.ibm.wssvt.acme.common.exception.ExceptionFormatter;
import com.ibm.wssvt.acme.common.exception.InvalidConfigurationException;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;

public class JAXWSToEjb3JAXRPCServiceLookup {
    private static final String JAXRPC_SERVICE_KEY = "JAXRPCServiceURL";
    private static final String USE_ASYNC_KEY = "useAsync";

    public static IAnnuityService getAnnuityJAXWSService(AnnuityMgmtSvcEJB3JAXRPCImpl injectedService, Configrable<String, String> configrable, AcmeLogger logger) throws InvalidConfigurationException, AnnuitySecurityException {
        String wsdlURL = "file:/META-INF/wsdl/AnnuityMgmtSvcEJB3JAXRPCImpl.wsdl";
        String jaxwsServiceURL = (String)configrable.getConfiguration().getParameterValue((Object)JAXRPC_SERVICE_KEY);
        try {
            AnnuityMgmtSvcEJB3JAXRPCSEI port;
            if (injectedService != null) {
                logger.fine("using injected service: " + (Object)((Object)injectedService));
                port = injectedService.getAnnuityMgmtSvcEJB3JAXRPCImplPort();
                ((BindingProvider)port).getRequestContext().put("javax.xml.ws.service.endpoint.address", jaxwsServiceURL);
                logger.fine("using injected service port: " + port);
            } else {
                URL url = new URL(wsdlURL);
                AnnuityMgmtSvcEJB3JAXRPCImpl service = new AnnuityMgmtSvcEJB3JAXRPCImpl(url, new QName("http://ejb3jaxrpc.ejbws.impl.business.annuity.acme.wssvt.ibm.com", "AnnuityMgmtSvcEJB3JAXRPCImpl"));
                port = service.getAnnuityMgmtSvcEJB3JAXRPCImplPort();
                ((BindingProvider)port).getRequestContext().put("javax.xml.ws.service.endpoint.address", jaxwsServiceURL);
                logger.fine("using injected service port: " + port);
                logger.fine("the ws port is: " + port);
            }
            String useAsuncFlag = (String)configrable.getConfiguration().getParameterValue((Object)USE_ASYNC_KEY);
            if (Boolean.parseBoolean(useAsuncFlag)) {
                return new AnnuityJAXWSToEjb3JAXRPCServiceProxyAsync(port, logger);
            }
            return new AnnuityJAXWSToEjb3JAXRPCServiceProxy(port);
        }
        catch (MalformedURLException e) {
            logger.warning("The url is invalid.  url value is: " + wsdlURL + " This url should refer to a local file that is bundled with this application logic." + " Most probably this is a defect in the Application.");
            throw new InvalidConfigurationException("The url is invalid.  url value is: " + wsdlURL + " Error: " + ExceptionFormatter.deepFormatToString((Throwable)e) + logger.getAllLogs());
        }
    }
}

