/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.util;

import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.wssvt.acme.annuity.common.util.AnnuityLoggerFactory;
import com.ibm.wssvt.acme.annuity.common.util.UsernameTokenPropagationVerification;
import com.ibm.wssvt.acme.common.bean.Configrable;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.ejb.EJBContext;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;

public class EJBLoggingInterceptor
implements Serializable {
    private static final long serialVersionUID = -813019909465130674L;
    UsernameTokenPropagationVerification untverify = new UsernameTokenPropagationVerification();
    @Resource
    EJBContext ejbContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object methodLogAndTime(InvocationContext ic) throws Exception {
        AcmeLogger logger = null;
        Object result = null;
        long startTime = 0L;
        try {
            Object[] params;
            Configrable configrable = null;
            for (Object param : params = ic.getParameters()) {
                if (!(param instanceof Configrable)) continue;
                configrable = (Configrable)param;
                break;
            }
            if (configrable == null) {
                Logger defLogger = Logger.getLogger(this.getClass().getName());
                defLogger.logp(Level.WARNING, this.getClass().getName(), "methodLogAndTime", "The method call did not conatin any configrable paramenter.Method is: " + ic.getMethod().getName() + ". Its is expected that EACH method must contain at least one argument of type Configrable." + ".  Using default logger: " + defLogger.getName());
            } else {
                logger = AnnuityLoggerFactory.getAcmeServerLogger(configrable, this.getClass().getName());
                if (logger.getLogger().isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, this.getClass().getName(), "methodLogAndTime", "entering: " + this.getClass().getName() + " for method: " + ic.getMethod().getName());
                    logger.logp(Level.FINE, this.getClass().getName(), "methodLogAndTime", "params: ");
                    for (Object param : params) {
                        logger.logp(Level.FINE, this.getClass().getName(), "methodLogAndTime", "param: " + param.toString());
                    }
                }
                startTime = System.currentTimeMillis();
                if (logger.getLogger().isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, this.getClass().getName(), "methodLogAndTime", "method: " + ic.getMethod().getName() + " in class: " + ic.getMethod().getDeclaringClass().getName() + " before invoke time: " + startTime);
                }
                this.logSecuirtyInfo((Configrable<String, String>)configrable);
                if (configrable.getConfiguration().getParameterValue((Object)"verifyEjbUNToken") != null && "true".equalsIgnoreCase((String)configrable.getConfiguration().getParameterValue((Object)"verifyEjbUNToken"))) {
                    this.untverify.verifyUsernameToken((Configrable<String, String>)configrable, "verifyEjbUNToken");
                }
            }
            Object object = result = ic.proceed();
            return object;
        }
        finally {
            long endTime = System.currentTimeMillis();
            if (logger != null && logger.getLogger().isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, this.getClass().getName(), "methodLogAndTime", "method: " + ic.getMethod().getName() + " in class: " + ic.getMethod().getDeclaringClass().getName() + " after invoke time: " + endTime + ". Total time in ms: " + (endTime - startTime));
                logger.logp(Level.FINE, this.getClass().getName(), "methodLogAndTime", "total time for method: " + ic.getMethod().getName() + " in class: " + ic.getMethod().getDeclaringClass().getName() + " in ms: " + (endTime - startTime));
            }
        }
    }

    private void logSecuirtyInfo(Configrable<String, String> configrable) {
        if ("true".equalsIgnoreCase((String)configrable.getConfiguration().getParameterValue((Object)"EJB3LogSecurityInfo"))) {
            AcmeLogger logger = AnnuityLoggerFactory.getAcmeServerLogger(configrable, this.getClass().getName());
            logger.info("ejbContext Info:");
            logger.info("ejbContext.getCallerPrincipal(): " + this.ejbContext.getCallerPrincipal());
            if (this.ejbContext.getCallerPrincipal() != null) {
                logger.info("ejbContext.getCallerPrincipal.getName(): " + this.ejbContext.getCallerPrincipal().getName());
            }
            logger.info("ejbContext.getCallerPrincipal.isCallerInRole(\"admins\"): " + this.ejbContext.isCallerInRole("admins"));
            logger.info("ejbContext.getCallerPrincipalisCallerInRole(\"users\"): " + this.ejbContext.isCallerInRole("admins"));
            logger.info("WSSubject Info:");
            try {
                logger.info("WSSubject.getCallerPrincipal(): " + WSSubject.getCallerPrincipal());
                logger.info("WSSubject.getCallerSubject(): " + WSSubject.getCallerSubject());
                if (WSSubject.getCallerSubject() != null) {
                    logger.info("WSSubject.getCallerSubject().getPublicCredentials(): " + WSSubject.getCallerSubject().getPublicCredentials());
                    logger.info("WSSubject.getCallerSubject().getgetPrivateCredentials(): " + WSSubject.getCallerSubject().getPrivateCredentials());
                }
            }
            catch (WSSecurityException e) {
                logger.log(Level.WARNING, "the call WSSubject.getCallerSubject() returned WSSecurityException.  No Action will be taken, but needs to investigate why we got this error.  Error: " + e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
            try {
                logger.info("WSSubject.getRunAsSubject(): " + WSSubject.getRunAsSubject());
                if (WSSubject.getRunAsSubject() != null) {
                    logger.info("WSSubject.getRunAsSubject().getPublicCredentials(): " + WSSubject.getRunAsSubject().getPublicCredentials());
                    logger.info("WSSubject.getRunAsSubject().getPrivateCredentials(): " + WSSubject.getRunAsSubject().getPrivateCredentials());
                }
            }
            catch (WSSecurityException e) {
                logger.log(Level.WARNING, "the call WSSubject.getRunAsSubject() returned WSSecurityException. No Action will be taken, but needs to investigate why we got this error.  Error: " + e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
        }
    }
}

