/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.common.client.ui.gui;

import com.ibm.wssvt.acme.common.client.ui.gui.AcmeGUI;
import com.ibm.wssvt.acme.common.client.ui.gui.GuiUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class StartupPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTextArea txtWelcomeMsg = null;
    private JButton btnLoadFromTemplate = null;
    private JButton btnLoadFromFileAsATemplate = null;
    private JButton btnLoadFromFileAndConfigure = null;
    private JLabel lblStartupMessage = null;

    public StartupPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setName("Startup");
        this.setSize(1076, 669);
        this.lblStartupMessage = new JLabel();
        this.lblStartupMessage.setBounds(new Rectangle(52, 505, 753, 16));
        this.lblStartupMessage.setText("");
        this.setLayout(null);
        this.add((Component)this.getTxtWelcomeMsg(), null);
        this.add((Component)this.getBtnLoadFromTemplate(), null);
        this.add((Component)this.getBtnLoadFromFileAsATemplate(), null);
        this.add((Component)this.getBtnLoadFromFileAndConfigure(), null);
        this.add((Component)this.lblStartupMessage, null);
    }

    private JTextArea getTxtWelcomeMsg() {
        if (this.txtWelcomeMsg == null) {
            this.txtWelcomeMsg = new JTextArea();
            this.txtWelcomeMsg.setBounds(new Rectangle(21, 14, 562, 71));
            this.txtWelcomeMsg.setEditable(false);
            this.txtWelcomeMsg.setText("Hi!\nThis tool can be used to generate the XML Configuration File.\nused by the Acme Annuity Application.\nUpdate each tab from the left to the right - and save your work at the end.");
        }
        return this.txtWelcomeMsg;
    }

    private JButton getBtnLoadFromTemplate() {
        if (this.btnLoadFromTemplate == null) {
            this.btnLoadFromTemplate = new JButton();
            this.btnLoadFromTemplate.setBounds(new Rectangle(47, 121, 238, 34));
            this.btnLoadFromTemplate.setText("Load From Template");
            this.btnLoadFromTemplate.setToolTipText("Load the default template and configure.");
            this.btnLoadFromTemplate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!AcmeGUI.loadTemplate()) {
                        StartupPanel.this.lblStartupMessage.setText("Failed to load!! Check the log");
                        return;
                    }
                    StartupPanel.this.lblStartupMessage.setText("Template loaded OK!");
                }
            });
        }
        return this.btnLoadFromTemplate;
    }

    private JButton getBtnLoadFromFileAsATemplate() {
        if (this.btnLoadFromFileAsATemplate == null) {
            this.btnLoadFromFileAsATemplate = new JButton();
            this.btnLoadFromFileAsATemplate.setBounds(new Rectangle(46, 168, 237, 33));
            this.btnLoadFromFileAsATemplate.setText("Load From My File As A Template");
            this.btnLoadFromFileAsATemplate.setToolTipText("Load an existing file and use as a custom template.");
            this.btnLoadFromFileAsATemplate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File file = GuiUtils.getOpenFile();
                    if (file == null) {
                        StartupPanel.this.lblStartupMessage.setText("User Cancel!");
                        StartupPanel.this.lblStartupMessage.setForeground(Color.BLUE);
                        return;
                    }
                    try {
                        URL u = new URL("file", "", file.getAbsolutePath());
                        System.out.println(u.toString());
                        if (!AcmeGUI.loadUserFile(u.toString(), false)) {
                            StartupPanel.this.lblStartupMessage.setText("Failed to load!! File is not valid");
                            StartupPanel.this.lblStartupMessage.setForeground(Color.RED);
                            return;
                        }
                    }
                    catch (MalformedURLException e1) {
                        StartupPanel.this.lblStartupMessage.setText("Error: " + e1);
                        StartupPanel.this.lblStartupMessage.setForeground(Color.RED);
                        e1.printStackTrace();
                    }
                    StartupPanel.this.lblStartupMessage.setText("file loaded OK!");
                    StartupPanel.this.lblStartupMessage.setForeground(Color.BLACK);
                }
            });
        }
        return this.btnLoadFromFileAsATemplate;
    }

    private JButton getBtnLoadFromFileAndConfigure() {
        if (this.btnLoadFromFileAndConfigure == null) {
            this.btnLoadFromFileAndConfigure = new JButton();
            this.btnLoadFromFileAndConfigure.setBounds(new Rectangle(44, 213, 237, 36));
            this.btnLoadFromFileAndConfigure.setText("Load From My File And Configure");
            this.btnLoadFromFileAndConfigure.setToolTipText("Load an existing file and configure.");
            this.btnLoadFromFileAndConfigure.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File file = GuiUtils.getOpenFile();
                    if (file == null) {
                        StartupPanel.this.lblStartupMessage.setText("User Cancel!");
                        StartupPanel.this.lblStartupMessage.setForeground(Color.BLUE);
                        return;
                    }
                    try {
                        URL u = new URL("file", "", file.getAbsolutePath());
                        if (!AcmeGUI.loadUserFile(u.toString(), true)) {
                            StartupPanel.this.lblStartupMessage.setText("Failed to load!! file is not valid");
                            StartupPanel.this.lblStartupMessage.setForeground(Color.RED);
                            return;
                        }
                    }
                    catch (MalformedURLException e1) {
                        e1.printStackTrace();
                        StartupPanel.this.lblStartupMessage.setText("Error: " + e1);
                        StartupPanel.this.lblStartupMessage.setForeground(Color.RED);
                    }
                    StartupPanel.this.lblStartupMessage.setText("File loaded & Configured OK!");
                    StartupPanel.this.lblStartupMessage.setForeground(Color.BLACK);
                }
            });
        }
        return this.btnLoadFromFileAndConfigure;
    }
}

