/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.bean.jaxbjpa;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IPayout;
import com.ibm.wssvt.acme.annuity.common.bean.jaxbjpa.Annuity;
import com.ibm.wssvt.acme.annuity.common.bean.jaxbjpa.EquityAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.jaxbjpa.FixedAnnuity;
import com.ibm.wssvt.acme.annuity.common.util.AnnuityType;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="AnnuityValueObject", namespace="http://bean.common.annuity.acme.wssvt.ibm.com/jaxbjpa/")
public class AnnuityValueObject
implements Serializable {
    private static final long serialVersionUID = -4402726312235247013L;
    @XmlElement
    private AnnuityType annuityType;
    @XmlElement
    private Annuity basic;
    @XmlElement
    private FixedAnnuity fixed;
    @XmlElement
    private EquityAnnuity equity;

    public void setAnnuity(IAnnuity annuity) {
        if (annuity instanceof FixedAnnuity) {
            this.annuityType = AnnuityType.FIXED;
            this.fixed = (FixedAnnuity)annuity;
        } else if (annuity instanceof EquityAnnuity) {
            this.annuityType = AnnuityType.EQUITY;
            this.equity = (EquityAnnuity)annuity;
        } else {
            this.annuityType = AnnuityType.BASIC;
            this.basic = (Annuity)annuity;
        }
        if (annuity != null && annuity.getPayouts() != null) {
            for (IPayout payout : annuity.getPayouts()) {
                payout.setAnnuity(null);
            }
        }
    }

    public IAnnuity getAnnuity() {
        Annuity result = null;
        if (this.annuityType == null) {
            return null;
        }
        result = AnnuityType.FIXED.equals((Object)this.annuityType) ? this.fixed : (AnnuityType.EQUITY.equals((Object)this.annuityType) ? this.equity : this.basic);
        for (IPayout payout : result.getPayouts()) {
            payout.setAnnuity(result);
        }
        return result;
    }
}

