/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.business.jaxrpc.bean;

import com.ibm.wssvt.acme.annuity.common.business.jaxrpc.bean.Annuity;
import com.ibm.wssvt.acme.annuity.common.business.jaxrpc.bean.AnnuityType;
import com.ibm.wssvt.acme.annuity.common.business.jaxrpc.bean.EquityAnnuity;
import com.ibm.wssvt.acme.annuity.common.business.jaxrpc.bean.FixedAnnuity;
import com.ibm.wssvt.acme.annuity.common.business.jaxrpc.bean.Payout;
import java.io.Serializable;

public class AnnuityValueObject
implements Serializable {
    private AnnuityType annuityType;
    private Annuity basic;
    private FixedAnnuity fixed;
    private EquityAnnuity equity;

    public void setAnnuity(Annuity annuity) {
        if (annuity == null) {
            this.annuityType = null;
            this.fixed = null;
            this.equity = null;
            this.basic = null;
            return;
        }
        if (annuity instanceof FixedAnnuity) {
            this.annuityType = AnnuityType.FIXED;
            this.fixed = (FixedAnnuity)annuity;
        } else if (annuity instanceof EquityAnnuity) {
            this.annuityType = AnnuityType.EQUITY;
            this.equity = (EquityAnnuity)annuity;
        } else {
            this.annuityType = AnnuityType.BASIC;
            this.basic = annuity;
        }
        if (annuity != null && annuity.getPayouts() != null) {
            for (Payout payout : annuity.getPayouts()) {
                payout.setAnnuity(null);
            }
        }
    }

    public Annuity getAnnuityData() {
        Annuity result = this.getAnnuity();
        if (result == null) {
            return null;
        }
        if (result.getPayouts() != null) {
            for (Payout payout : result.getPayouts()) {
                payout.setAnnuity(result);
            }
        }
        return result;
    }

    public Annuity getAnnuity() {
        Annuity result = null;
        if (this.annuityType == null) {
            return null;
        }
        result = AnnuityType.FIXED.toString().equals(this.annuityType.toString()) ? this.fixed : (AnnuityType.EQUITY.toString().equals(this.annuityType.toString()) ? this.equity : this.basic);
        return result;
    }

    public AnnuityType getAnnuityType() {
        return this.annuityType;
    }

    public void setAnnuityType(AnnuityType annuityType) {
        this.annuityType = annuityType;
    }

    public Annuity getBasic() {
        return this.basic;
    }

    public void setBasic(Annuity basic) {
        this.basic = basic;
    }

    public EquityAnnuity getEquity() {
        return this.equity;
    }

    public void setEquity(EquityAnnuity equity) {
        this.equity = equity;
    }

    public FixedAnnuity getFixed() {
        return this.fixed;
    }

    public void setFixed(FixedAnnuity fixed) {
        this.fixed = fixed;
    }
}

