/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit;

import com.ibm.wssvt.acme.annuity.common.bean.AnnuityHolderCategory;
import com.ibm.wssvt.acme.annuity.common.bean.ContactType;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.bean.IContact;
import com.ibm.wssvt.acme.annuity.common.bean.IEquityAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IFixedAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IPayor;
import com.ibm.wssvt.acme.annuity.common.bean.IPayout;
import com.ibm.wssvt.acme.annuity.common.bean.IRider;
import com.ibm.wssvt.acme.annuity.common.bean.RiderType;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.AbastractAnnuityExecutionUnit;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.BasicExecutionUnitLibrarry;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.ExecutionUnitVerificationHelper;
import com.ibm.wssvt.acme.annuity.common.exception.EntityAlreadyExistsException;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.annuity.common.util.AnnuityType;
import com.ibm.wssvt.acme.common.adapter.ServerAdapterCommunicationException;
import com.ibm.wssvt.acme.common.executionunit.ExecutionUnitVerificationException;
import com.ibm.wssvt.acme.common.executionunit.IExecutionUnit;
import com.ibm.wssvt.acme.common.executionunit.InvalidExecutionUnitParameterException;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.rmi.RemoteException;

public class CreateAllEntitiesEU
extends AbastractAnnuityExecutionUnit {
    private static final long serialVersionUID = -8986934038714550844L;
    private AcmeLogger logger;
    boolean enableVerify = true;
    private static final String ENABLE_VERIFY_KEY = "enableVerify";

    public void execute() {
        this.setScenarioVariables();
        this.logger.fine("creating contact");
        IContact contact = null;
        try {
            contact = this.createContact();
        }
        catch (Exception e) {
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        try {
            if (this.enableVerify) {
                this.verifyContactValues(contact);
            }
        }
        catch (Exception e) {
            this.logger.info("Create Contact verification failed.  Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.fine("crating annuity holder");
        IAnnuityHolder annuityHolder = null;
        try {
            annuityHolder = this.createAnnuityHolder(contact);
        }
        catch (Exception e) {
            this.logger.warning("failed to create Annuity Holder Successfully. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        try {
            if (this.enableVerify) {
                this.verifyAnnuityHolderValues(annuityHolder);
            }
        }
        catch (Exception e) {
            this.logger.info("failed to verify create annuity holder successfuly. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.fine("creating payor");
        IPayor payor = null;
        try {
            payor = this.createPayor();
        }
        catch (Exception e) {
            this.logger.warning("failed to create payor successfuly. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        try {
            if (this.enableVerify) {
                this.verifyPayorValues(payor);
            }
        }
        catch (Exception e) {
            this.logger.info("failed to verify create payor successfuly. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.fine("creating annuity");
        IAnnuity annuity = null;
        AnnuityType annuityType = this.getRandomEnum(AnnuityType.class);
        try {
            annuity = this.createAnnuityWithRider(annuityType);
        }
        catch (Exception e) {
            this.logger.warning("failed to create annuity successfuly. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        try {
            this.logger.info("verify annuity with rider");
            if (this.enableVerify) {
                this.verifyAnnuityValues(annuity, annuityType);
            }
        }
        catch (Exception e) {
            this.logger.info("failed to verify create annuity successfuly. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.fine("upating annuity");
        try {
            this.logger.info("create annuity with payout");
            annuity = this.createAnnuityPayout(annuity);
        }
        catch (Exception e) {
            this.logger.warning("failed to create annuity successfuly. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        try {
            if (this.enableVerify) {
                this.verifyAnnuityValues(annuity, annuityType);
            }
        }
        catch (Exception e) {
            this.logger.info("failed to verify create annuity successfuly. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.fine("upating annuity");
        try {
            annuity.getPayors().add(payor);
            annuity.setAnnuityHolderId((String)annuityHolder.getId());
            annuity.setConfiguration(this.getConfiguration());
            this.getServerAdapter().updateAnnuity(annuity);
        }
        catch (Exception e) {
            this.logger.warning("failed to update annuity successfuly. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        try {
            if (this.enableVerify) {
                this.verifyAnnuityValues(annuity, annuityType);
            }
        }
        catch (Exception e) {
            this.logger.info("failed to verify annuity update successfuly. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.fine("scenario: " + this.getDescription() + " completed.");
    }

    private IAnnuity createAnnuityPayout(IAnnuity annuity) throws EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IPayout payout = BasicExecutionUnitLibrarry.getPayout(this.getAnnuityBeansFactory());
        payout.setAnnuity(annuity);
        payout.setConfiguration(this.getConfiguration());
        payout = this.getServerAdapter().createPayout(payout);
        annuity.getPayouts().add(payout);
        return annuity;
    }

    private IAnnuity createAnnuityWithRider(AnnuityType annuityType) throws EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IAnnuity annuity = BasicExecutionUnitLibrarry.getAnnuity(this.getAnnuityBeansFactory(), annuityType);
        IRider rider1 = BasicExecutionUnitLibrarry.getRider(this.getAnnuityBeansFactory());
        IRider rider2 = BasicExecutionUnitLibrarry.getRider(this.getAnnuityBeansFactory());
        IRider rider3 = BasicExecutionUnitLibrarry.getRider(this.getAnnuityBeansFactory());
        rider3.setType(RiderType.REPLACE);
        annuity.getRiders().add(rider1);
        annuity.getRiders().add(rider2);
        annuity.getRiders().add(rider3);
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().createAnnuity(annuity);
        return annuity;
    }

    private void setScenarioVariables() {
        this.logger = this.getLogger(((Object)((Object)this)).getClass().getName());
        try {
            this.enableVerify = this.getParameterValueBoolean(ENABLE_VERIFY_KEY);
        }
        catch (InvalidExecutionUnitParameterException e1) {
            this.logger.warning("Missing or invalid value for: enableVerify parameter.  for scenario: " + this.getDescription() + "Defaulting to true." + " current value is: " + (String)this.getConfiguration().getParameterValue((Object)ENABLE_VERIFY_KEY));
            this.enableVerify = true;
        }
    }

    private void verifyAnnuityValues(IAnnuity annuity, AnnuityType annuityType) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        int i;
        IAnnuity results = null;
        if (AnnuityType.BASIC.equals((Object)annuityType)) {
            results = this.getAnnuityBeansFactory().createAnnuity();
        }
        if (AnnuityType.EQUITY.equals((Object)annuityType)) {
            results = this.getAnnuityBeansFactory().createAnnEquity();
        }
        if (AnnuityType.FIXED.equals((Object)annuityType)) {
            results = this.getAnnuityBeansFactory().createAnnFixed();
        }
        results.setId(annuity.getId());
        results.setConfiguration(this.getConfiguration());
        results = this.getServerAdapter().findAnnuityById(results);
        if (annuity instanceof IFixedAnnuity) {
            ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, (IFixedAnnuity)annuity, (IFixedAnnuity)results, "Fixed Annuity from Client is not equal to DB value", "Mismacth was found.");
        } else if (annuity instanceof IEquityAnnuity) {
            ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, (IEquityAnnuity)annuity, (IEquityAnnuity)results, "Equity Annuity from Client is not equal to DB value", "Mismacth was found.");
        } else {
            ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, annuity, results, "Basic Annuity from Client is not equal to DB value", "Mismacth was found.");
        }
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, annuity.getPayouts(), results.getPayouts(), "Annuity payouts from Client is not equal to DB value", "Mismacth was found in number of payouts");
        boolean found = false;
        if (annuity.getPayouts() != null) {
            IPayout clientPayout = null;
            for (i = 0; i < annuity.getPayouts().size(); ++i) {
                found = false;
                clientPayout = annuity.getPayouts().get(i);
                for (IPayout resultPayout : results.getPayouts()) {
                    if (!((String)clientPayout.getId()).equals(resultPayout.getId())) continue;
                    found = true;
                    ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, clientPayout, resultPayout, "Annuity Payout from Client is not equal to DB value at location: " + i, "Mismacth was found");
                }
                if (found || clientPayout == null) continue;
                throw new ExecutionUnitVerificationException("Annuity Payout from client is not equal to DB.  Found Payout with id: " + (String)clientPayout.getId() + " on the client side, but not in the database for annuity id:" + (String)annuity.getId());
            }
        }
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, annuity.getRiders(), results.getRiders(), "Annuity rider from Client is not equal to DB value", "Mismacth was found in number of rider");
        if (annuity.getRiders() != null) {
            IRider clientRider = null;
            for (i = 0; i < annuity.getRiders().size(); ++i) {
                found = false;
                clientRider = annuity.getRiders().get(i);
                for (IRider resultRider : results.getRiders()) {
                    if (!((String)clientRider.getId()).equals(resultRider.getId())) continue;
                    found = true;
                    ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, clientRider, resultRider, "Annuity rider from Client is not equal to DB value at location: " + i, "Mismacth was found");
                }
                if (found || clientRider == null) continue;
                throw new ExecutionUnitVerificationException("Annuity rider from client is not equal to DB.  Found rider with id: " + (String)clientRider.getId() + " on the client side, but not in the database for annuity id:" + (String)annuity.getId());
            }
        }
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, annuity.getPayors(), results.getPayors(), "Annuity Payor from Client is not equal to DB value", "Mismacth was found.");
        if (annuity.getPayors() != null) {
            IPayor clientPayor = null;
            for (i = 0; i < annuity.getPayors().size(); ++i) {
                found = false;
                clientPayor = annuity.getPayors().get(i);
                for (IPayor resultPayor : results.getPayors()) {
                    if (!((String)clientPayor.getId()).equals(resultPayor.getId())) continue;
                    found = true;
                    ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, annuity.getPayors().get(i), resultPayor, "Annuity payor from Client is not equal to DB value at location: " + i, "Mismacth was found");
                }
                if (found || clientPayor == null) continue;
                throw new ExecutionUnitVerificationException("Annuity payor from client is not equal to DB.  Found payor with id: " + (String)clientPayor.getId() + " on the client side, but not in the database for annuity id:" + (String)annuity.getId());
            }
        }
    }

    private void verifyPayorValues(IPayor payor) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        IPayor results = this.getAnnuityBeansFactory().createPayor();
        results.setId(payor.getId());
        results.setConfiguration(this.getConfiguration());
        results = this.getServerAdapter().findPayorById(payor);
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, payor, results, "Payor from Client is not equal to DB value", "Mismacth was found.");
    }

    private IPayor createPayor() throws EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IPayor payor = BasicExecutionUnitLibrarry.getPayor(this.getAnnuityBeansFactory());
        payor.setConfiguration(this.getConfiguration());
        payor = this.getServerAdapter().createPayor(payor);
        return payor;
    }

    private void verifyAnnuityHolderValues(IAnnuityHolder annuityHolder) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        IAnnuityHolder results = this.getAnnuityBeansFactory().createAnnuityHolder();
        results.setId(annuityHolder.getId());
        results.setConfiguration(this.getConfiguration());
        results = this.getServerAdapter().findHolderById(results);
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, annuityHolder, results, "Annuity Holder from Client is not equal to DB value", "Mismacth was found.");
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, annuityHolder.getContact(), results.getContact(), "Annuity Holder Contact from Client is not equal to DB value", "Mismacth was found.");
    }

    private IAnnuityHolder createAnnuityHolder(IContact contact) throws EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IAnnuityHolder annuityHolder = BasicExecutionUnitLibrarry.getAnnuityHolder(this.getAnnuityBeansFactory());
        annuityHolder.setCategory(this.getRandomEnum(AnnuityHolderCategory.class));
        annuityHolder.setContact(contact);
        annuityHolder.setConfiguration(this.getConfiguration());
        annuityHolder = this.getServerAdapter().createAnnuityHolder(annuityHolder);
        return annuityHolder;
    }

    private void verifyContactValues(IContact contact) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        IContact results = this.getAnnuityBeansFactory().createContact();
        results.setId(contact.getId());
        results.setConfiguration(this.getConfiguration());
        results = this.getServerAdapter().findContactById(results);
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, contact, results, "contact from Client is not equal to DB value", "Mismacth was found.");
    }

    private IContact createContact() throws EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IContact contact = BasicExecutionUnitLibrarry.getContact(this.getAnnuityBeansFactory());
        contact.setConfiguration(this.getConfiguration());
        contact.setContactType(this.getRandomEnum(ContactType.class));
        contact = this.getServerAdapter().createContact(contact);
        return contact;
    }
}

