/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuity;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.AbastractAnnuityExecutionUnit;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.BasicExecutionUnitLibrarry;
import com.ibm.wssvt.acme.annuity.common.exception.AnnuityException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerBusinessLogicException;
import com.ibm.wssvt.acme.common.adapter.ServerAdapterCommunicationException;
import com.ibm.wssvt.acme.common.exception.AcmeException;
import com.ibm.wssvt.acme.common.executionunit.ExecutionUnitVerificationException;
import com.ibm.wssvt.acme.common.executionunit.InvalidExecutionUnitParameterException;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.rmi.RemoteException;

public class CreateAndReadAnnuityEU
extends AbastractAnnuityExecutionUnit {
    private static final long serialVersionUID = 3868305156006203220L;
    private static String UPDATED_ACCOUNT_NUMBER = "updatedAccountNumber";

    public void execute() {
        try {
            AcmeLogger logger = this.getLogger(((Object)((Object)this)).getClass().getName());
            logger.fine("0100:Try CreateAnnuity->");
            IAnnuity annuity = this.createAnnuity();
            logger.fine("0200:Annuity Created? ID=" + (String)annuity.getId());
            this.verifyCreateSucess(annuity);
            String oldAccountNumber = annuity.getAccountNumber();
            String oldId = (String)annuity.getId();
            logger.fine("0300:Try Annuity Update");
            this.updateAnnuity(annuity);
            logger.fine("0500:annuity=" + annuity.toString());
            logger.fine("0600:Annuity Update");
            IAnnuity updatedAnnuity = this.findAnnuity((String)annuity.getId());
            this.verifyUpdateSuccess(oldAccountNumber, oldId, updatedAnnuity);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getExecutionUnitEvent().addException(e);
        }
    }

    private IAnnuity findAnnuity(String id) throws ServerAdapterCommunicationException, AnnuityException, RemoteException {
        IAnnuity annuity = this.getAnnuityBeansFactory().createAnnuity();
        annuity.setId(id);
        annuity.setConfiguration(this.getConfiguration());
        return this.getServerAdapter().findAnnuityById(annuity);
    }

    private void verifyUpdateSuccess(String oldAccountNumber, String oldId, IAnnuity updatedAnnuity) throws ExecutionUnitVerificationException {
        if (updatedAnnuity == null) {
            throw new ExecutionUnitVerificationException("Update  Annuity Failed.  Returned object is null");
        }
        if (updatedAnnuity.getId() == null) {
            throw new ExecutionUnitVerificationException("Update Annuity Failed. Returned object id == null");
        }
        if (!oldId.equals(updatedAnnuity.getId())) {
            throw new ExecutionUnitVerificationException("The updatde Annuity has different id that the created annuity! created id: " + oldId + " updated id: " + (String)updatedAnnuity.getId());
        }
        if (oldAccountNumber.equals(updatedAnnuity.getAccountNumber())) {
            throw new ExecutionUnitVerificationException("The updatde Annuity has same acct number as the created annuity! created id: " + oldId + " updated id: " + (String)updatedAnnuity.getId() + " created account number: " + oldAccountNumber + " updated account number: " + updatedAnnuity.getAccountNumber());
        }
    }

    private void verifyCreateSucess(IAnnuity annuity) throws AnnuityException, ExecutionUnitVerificationException {
        if (annuity == null) {
            throw new ExecutionUnitVerificationException("Create Annuity Failed.  Returned object is null");
        }
        if (annuity.getId() == null) {
            throw new ExecutionUnitVerificationException("Create Annuity Failed. Returned object id == null");
        }
    }

    private void updateAnnuity(IAnnuity annuity) throws ServerAdapterCommunicationException, ServerBusinessLogicException, AnnuityException, InvalidExecutionUnitParameterException, RemoteException {
        if (this.getConfiguration().getParameterValue((Object)UPDATED_ACCOUNT_NUMBER) == null) {
            throw new InvalidExecutionUnitParameterException("Configuratioin for scenario:" + ((Object)((Object)this)).getClass().getName() + " is incomplete.  Attribute: " + UPDATED_ACCOUNT_NUMBER + " is requiered");
        }
        annuity.setAccountNumber((String)this.getConfiguration().getParameterValue((Object)UPDATED_ACCOUNT_NUMBER));
        annuity.setConfiguration(this.getConfiguration());
        this.getServerAdapter().updateAnnuity(annuity);
    }

    private IAnnuity createAnnuity() throws AcmeException, RemoteException {
        IAnnuity annuity = BasicExecutionUnitLibrarry.getBasicAnnuity(this.getAnnuityBeansFactory());
        annuity.setId("20000");
        annuity.setConfiguration(this.getConfiguration());
        annuity.getConfiguration().addParameter((Object)"asynchTimeoutValue", (Object)"3");
        IAnnuity resAnnuity = this.getServerAdapter().createAnnuity(annuity);
        return resAnnuity;
    }
}

