/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.bean.IEquityAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IFixedAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IPayor;
import com.ibm.wssvt.acme.annuity.common.bean.IPayout;
import com.ibm.wssvt.acme.annuity.common.bean.IRider;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.AbastractAnnuityExecutionUnit;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.BasicExecutionUnitLibrarry;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.ExecutionUnitVerificationHelper;
import com.ibm.wssvt.acme.annuity.common.exception.EntityAlreadyExistsException;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.annuity.common.util.AnnuityType;
import com.ibm.wssvt.acme.annuity.common.util.ServerExceptionMapper;
import com.ibm.wssvt.acme.annuity.common.util.ServerExceptionType;
import com.ibm.wssvt.acme.common.adapter.ServerAdapterCommunicationException;
import com.ibm.wssvt.acme.common.executionunit.ExecutionUnitVerificationException;
import com.ibm.wssvt.acme.common.executionunit.IExecutionUnit;
import com.ibm.wssvt.acme.common.executionunit.InvalidExecutionUnitParameterException;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.StringTokenizer;

public class UpdateExistingAnnuityPayorPayoutRiderWithoutAddPayorEU
extends AbastractAnnuityExecutionUnit {
    private static final long serialVersionUID = -8978758038714550844L;
    private static final String START_HOLDER_ID = "startHolderId";
    private static final String END_HOLDER_ID = "endHolderId";
    private int startHolderId;
    private int endHolderId;
    private int holderRange;
    private AcmeLogger logger;
    private int overRideIdint = 0;
    private int maximumThreshold = 2;
    private int retryThinkTime = 5000;
    private boolean enableVerify = true;

    /*
     * WARNING - void declaration
     */
    public void execute() {
        int threshold = 0;
        try {
            this.setScenarioVariables();
        }
        catch (Exception e) {
            this.logger.severe("Invalid scenario parameters for scenario description:" + this.getDescription() + "  Error is: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        String randomHolderId = "" + (this.startHolderId + this.getRandomInteger(0, this.holderRange));
        this.logger.fine("Got the random holder ID --- " + randomHolderId);
        this.logger.fine("Find the holder from existing database");
        IAnnuityHolder holder = null;
        try {
            holder = this.getAnnuityBeansFactory().createAnnuityHolder();
            holder.setId(randomHolderId);
            holder.setConfiguration(this.getConfiguration());
            holder = this.getServerAdapter().findHolderById(holder);
        }
        catch (Exception e) {
            this.logger.severe("Failed to find holder. ID - " + randomHolderId + " Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        if (this.enableVerify) {
            this.logger.fine("Verifying annuity holder from db");
            try {
                this.verifyAnnuityHolderValue(holder);
            }
            catch (Exception e) {
                this.logger.severe("Find AnnuityHolder verification failed. Holder ID:" + (String)holder.getId() + " Error: " + e);
                this.getExecutionUnitEvent().addException(e);
                return;
            }
        }
        this.logger.fine("Getting list of Annuity from AnnuityHolder:" + (String)holder.getId());
        List<Object> annuities = new ArrayList();
        try {
            annuities = this.getAnnuities(holder);
            String annIds = "";
            for (IAnnuity iAnnuity : annuities) {
                annIds = annIds + (String)iAnnuity.getId() + " : ";
            }
            this.logger.fine("Got the the annuity IDs here --- " + annIds);
        }
        catch (Exception e) {
            this.logger.severe("Failed to get list of annuities. Holder ID:" + (String)holder.getId() + "  Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Annuity size is " + annuities.size());
        IAnnuity results = null;
        for (IAnnuity iAnnuity : annuities) {
            void var7_14;
            AnnuityType annuityType = this.getAnnuityType(iAnnuity);
            this.logger.fine("Updating Annuity with Rider:" + (String)iAnnuity.getId());
            threshold = 0;
            while (threshold <= this.maximumThreshold) {
                try {
                    var7_14.setConfiguration(this.getConfiguration());
                    results = this.updateAnnuityWithRider((IAnnuity)var7_14);
                    break;
                }
                catch (Exception e) {
                    threshold = this.recoverableExceptionCheck(e, threshold, (IAnnuity)var7_14);
                    if (threshold == 0) {
                        this.logger.severe("Failed to update annuity with rider. ID:" + (String)var7_14.getId() + " Error: " + e);
                        this.getExecutionUnitEvent().addException(e);
                        return;
                    }
                    IAnnuity iAnnuity2 = this.rereadAnnuity((IAnnuity)var7_14);
                    if (iAnnuity2 != null) continue;
                    return;
                }
            }
            if (this.enableVerify) {
                this.logger.fine("Verifying Annuity with Rider:" + (String)results.getId());
                try {
                    this.verifyAnnuityValues(results, annuityType);
                }
                catch (Exception e) {
                    this.logger.severe("Failed to verify update annuity with rider. ID:" + (String)var7_14.getId() + " Error: " + e);
                    this.getExecutionUnitEvent().addException(e);
                    return;
                }
            }
            this.logger.fine("Updating Annuity with Payout:" + (String)results.getId());
            threshold = 0;
            IAnnuity resultsA = null;
            while (threshold <= this.maximumThreshold) {
                try {
                    results.setConfiguration(this.getConfiguration());
                    resultsA = this.updateAnnuityWithPayout(results);
                    break;
                }
                catch (Exception e) {
                    threshold = this.recoverableExceptionCheck(e, threshold, results);
                    if (threshold == 0) {
                        this.logger.severe("Failed to update annuity with Payout. ID:" + (String)var7_14.getId() + "  Error: " + e);
                        this.getExecutionUnitEvent().addException(e);
                        return;
                    }
                    if ((results = this.rereadAnnuity(results)) != null) continue;
                    return;
                }
            }
            if (this.enableVerify) {
                this.logger.fine("Verifying Annuity with Payout:" + (String)resultsA.getId());
                try {
                    this.verifyAnnuityValues(resultsA, annuityType);
                }
                catch (Exception e) {
                    this.logger.severe("Failed to verify update annuity with Payout. ID:" + (String)var7_14.getId() + "  Error: " + e);
                    this.getExecutionUnitEvent().addException(e);
                    return;
                }
            }
            this.logger.fine("Updating Annuity with Payor:" + (String)var7_14.getId());
            threshold = 0;
            IAnnuity resultsB = null;
            while (threshold <= this.maximumThreshold) {
                try {
                    resultsA.setConfiguration(this.getConfiguration());
                    resultsB = this.updateAnnuityWithPayor(resultsA);
                    break;
                }
                catch (Exception e) {
                    threshold = this.recoverableExceptionCheck(e, threshold, resultsA);
                    if (threshold == 0) {
                        this.logger.severe("Failed to update annuity with Payor. ID:" + (String)var7_14.getId() + "  Error: " + e);
                        this.getExecutionUnitEvent().addException(e);
                        return;
                    }
                    if ((resultsA = this.rereadAnnuity(resultsA)) != null) continue;
                    return;
                }
            }
            if (this.enableVerify) {
                this.logger.fine("Verifying Annuity with Payor:" + (String)var7_14.getId());
                try {
                    this.verifyAnnuityValues(resultsB, annuityType);
                }
                catch (Exception e) {
                    this.logger.severe("Failed to verify update annuity with Payor. ID:" + (String)var7_14.getId() + "  Error: " + e);
                    this.getExecutionUnitEvent().addException(e);
                    return;
                }
            }
            this.logger.fine("Updating Annuity by itself:" + (String)resultsB.getId());
            threshold = 0;
            IAnnuity resultsC = null;
            while (threshold <= this.maximumThreshold) {
                try {
                    resultsB.setConfiguration(this.getConfiguration());
                    resultsC = this.updateAnnuityAlone(resultsB);
                    break;
                }
                catch (Exception e) {
                    threshold = this.recoverableExceptionCheck(e, threshold, resultsB);
                    if (threshold == 0) {
                        this.logger.severe("Failed to update annuity by itself: ID:" + (String)var7_14.getId() + "  " + e);
                        this.getExecutionUnitEvent().addException(e);
                        return;
                    }
                    if ((resultsB = this.rereadAnnuity(resultsB)) != null) continue;
                    return;
                }
            }
            if (!this.enableVerify) continue;
            this.logger.fine("Verifying Annuity by itself:" + (String)resultsC.getId());
            try {
                this.verifyAnnuityValues(resultsC, annuityType);
            }
            catch (Exception e) {
                this.logger.severe("Failed to verify update annuity by itself. ID:" + (String)var7_14.getId() + " Error: " + e);
                this.getExecutionUnitEvent().addException(e);
                return;
            }
        }
    }

    private int recoverableExceptionCheck(Exception e, int threshold, IAnnuity annuity) {
        boolean tryAgain = false;
        ServerExceptionType exType = ServerExceptionMapper.getExceptionType(e);
        if (ServerExceptionType.OPTIMISTIC_LOCKING_EXCEPTION.equals((Object)exType)) {
            this.logger.info("OPTIMISTIC LOCKING EXCEPTION encountered while updating annuity id: " + (String)annuity.getId() + ".  Trying again to a max of: " + this.maximumThreshold + " times. This is attempt: " + (threshold + 1));
            tryAgain = true;
        } else if (ServerExceptionType.DEADLOCK_EXCEPTION.equals((Object)exType)) {
            this.logger.info("DEADLOCK EXCEPTION encountered while updating annuity id: " + (String)annuity.getId() + ".  Trying again to a max of: " + this.maximumThreshold + " times. This is attempt: " + (threshold + 1));
            tryAgain = true;
        }
        if (tryAgain) {
            if (++threshold == this.maximumThreshold) {
                threshold = 0;
            }
            try {
                Thread.sleep(this.retryThinkTime);
            }
            catch (InterruptedException eSleep) {
                this.logger.severe("Thread Sleep has been interrupted" + eSleep.toString());
                this.getExecutionUnitEvent().addException((Exception)eSleep);
            }
        }
        return threshold;
    }

    private void setScenarioVariables() throws InvalidExecutionUnitParameterException {
        String OVERRIDE_ID_KEY = "overRideId";
        String MAX_THRESHOLD = "maximumThreshold";
        String ENABLE_VERIFY_KEY = "enableVerify";
        String RETRY_THINK_TIME = "retryThinkTime";
        this.logger = this.getLogger(((Object)((Object)this)).getClass().getName());
        this.startHolderId = this.getParameterValueInt(START_HOLDER_ID);
        this.endHolderId = this.getParameterValueInt(END_HOLDER_ID);
        try {
            this.retryThinkTime = this.getParameterValueInt("retryThinkTime");
        }
        catch (Exception e) {
            this.logger.warning("the attribute:retryThinkTime is missing for scenario: " + this.getDescription() + " .Setting the default to 5 seconds");
            this.retryThinkTime = 5000;
        }
        try {
            this.overRideIdint = this.getParameterValueInt("overRideId");
        }
        catch (Exception e) {
            this.logger.warning("the attribute:overRideId is missing for scenario: " + this.getDescription() + " .Setting the default to zero");
            this.overRideIdint = 0;
        }
        if (this.startHolderId <= 0) {
            throw new InvalidExecutionUnitParameterException("startHolderId is less or equal to 0.  Invalid value for scenario with description: " + this.getDescription() + ".  Value must be one or more.");
        }
        if (this.endHolderId <= 0) {
            throw new InvalidExecutionUnitParameterException("endHolderId is less or equal to 0.  Invalid value for scenario with description: " + this.getDescription() + ".  Value must be one or more.");
        }
        if (this.overRideIdint < 0) {
            throw new InvalidExecutionUnitParameterException("overRideId is less or equal to 0.  Invalid value for scenario with description: " + this.getDescription() + ".  Value must be one or more.");
        }
        try {
            this.maximumThreshold = this.getParameterValueInt("maximumThreshold");
        }
        catch (Exception e) {
            this.logger.fine("maximumThreshold parameter not specified, using default");
            this.maximumThreshold = 2;
        }
        try {
            this.enableVerify = this.getParameterValueBoolean("enableVerify");
        }
        catch (Exception e) {
            this.logger.warning("enableVerify parameter is not set, using default true.");
            this.enableVerify = true;
        }
        if (this.overRideIdint > 0) {
            this.startHolderId = this.overRideIdint;
            this.holderRange = 0;
        } else {
            this.holderRange = this.endHolderId - this.startHolderId;
        }
    }

    private IAnnuity rereadAnnuity(IAnnuity annuity) {
        IAnnuity results = null;
        try {
            annuity.setConfiguration(this.getConfiguration());
            results = this.getServerAdapter().findAnnuityById(annuity);
        }
        catch (Exception e) {
            this.logger.severe("Failed to re-read annuity ID:" + (String)annuity.getId() + "  Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        return results;
    }

    private void verifyAnnuityHolderValue(IAnnuityHolder annuityHolder) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        IAnnuityHolder results = this.getAnnuityBeansFactory().createAnnuityHolder();
        results.setId(annuityHolder.getId());
        results.setConfiguration(this.getConfiguration());
        results = this.getServerAdapter().findHolderById(results);
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, annuityHolder, results, "AnnuityHolder from Client is not equal to DB value", "Mismacth was found.");
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, annuityHolder.getContact(), results.getContact(), "AnnuityHolder Contact from Client is not equal to DB value", "Mismacth was found.");
    }

    private List<IAnnuity> getAnnuities(IAnnuityHolder holder) throws ServerAdapterCommunicationException, InvalidArgumentException, ServerInternalErrorException, RemoteException {
        holder.setConfiguration(this.getConfiguration());
        List<IAnnuity> annuities = this.getServerAdapter().findHolderAnnuities(holder);
        return annuities;
    }

    private IAnnuity updateAnnuityWithRider(IAnnuity annuity) throws EntityNotFoundException, EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IRider rider1 = BasicExecutionUnitLibrarry.getRider(this.getAnnuityBeansFactory());
        IRider rider2 = BasicExecutionUnitLibrarry.getRider(this.getAnnuityBeansFactory());
        annuity.getRiders().add(rider1);
        annuity.getRiders().add(rider2);
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().updateAnnuity(annuity);
        IRider removed = BasicExecutionUnitLibrarry.getRider(this.getAnnuityBeansFactory());
        removed.setId(rider1.getId());
        int removeIndex = 0;
        for (int i = 0; i < annuity.getRiders().size(); ++i) {
            if (!((String)removed.getId()).equals(annuity.getRiders().get(i).getId())) continue;
            removeIndex = i;
            break;
        }
        annuity.getRiders().remove(removeIndex);
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().updateAnnuity(annuity);
        removed.setConfiguration(this.getConfiguration());
        this.getServerAdapter().deleteRider(removed);
        rider2.setRule(this.getUpdatedString(rider2.getRule()));
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().findAnnuityById(annuity);
        for (IRider rider : annuity.getRiders()) {
            if (!((String)rider2.getId()).equals(rider.getId())) continue;
            rider.setRule(this.getUpdatedString(rider.getRule()));
            break;
        }
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().updateAnnuity(annuity);
        return annuity;
    }

    private IAnnuity updateAnnuityWithPayout(IAnnuity annuity) throws EntityNotFoundException, EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IPayout payout1 = BasicExecutionUnitLibrarry.getPayout(this.getAnnuityBeansFactory());
        payout1.setAnnuity(annuity);
        payout1.setTaxableAmount(new BigDecimal(this.getRandomInteger(100, 1000)));
        payout1.setConfiguration(this.getConfiguration());
        payout1 = this.getServerAdapter().createPayout(payout1);
        IPayout payout2 = BasicExecutionUnitLibrarry.getPayout(this.getAnnuityBeansFactory());
        payout2.setAnnuity(annuity);
        payout2.setTaxableAmount(new BigDecimal(this.getRandomInteger(100, 1000)));
        payout2.setConfiguration(this.getConfiguration());
        payout2 = this.getServerAdapter().createPayout(payout2);
        annuity.getPayouts().add(payout1);
        annuity.getPayouts().add(payout2);
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().updateAnnuity(annuity);
        IPayout removed = BasicExecutionUnitLibrarry.getPayout(this.getAnnuityBeansFactory());
        removed.setId(payout1.getId());
        int removeIndex = 0;
        for (int i = 0; i < annuity.getPayouts().size(); ++i) {
            if (!((String)removed.getId()).equals(annuity.getPayouts().get(i).getId())) continue;
            removeIndex = i;
            break;
        }
        annuity.getPayouts().remove(removeIndex);
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().updateAnnuity(annuity);
        removed.setConfiguration(this.getConfiguration());
        this.getServerAdapter().deletePayout(removed);
        GregorianCalendar newEndDate = new GregorianCalendar();
        ((Calendar)newEndDate).add(2, 11);
        for (IPayout payout : annuity.getPayouts()) {
            if (!((String)payout2.getId()).equals(payout.getId())) continue;
            payout.setEndDate(newEndDate);
            payout.setTaxableAmount(new BigDecimal(this.getRandomInteger(10000, 100000)));
            payout.setAnnuity(annuity);
            payout.setConfiguration(this.getConfiguration());
            payout = this.getServerAdapter().updatePayout(payout);
            break;
        }
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().updateAnnuity(annuity);
        return annuity;
    }

    private IAnnuity updateAnnuityWithPayor(IAnnuity annuity) throws EntityNotFoundException, EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        this.logger.fine("Annuity:" + (String)annuity.getId() + " Payor list size:" + annuity.getPayors().size());
        IPayor payor1 = BasicExecutionUnitLibrarry.getPayor(this.getAnnuityBeansFactory());
        payor1.setConfiguration(this.getConfiguration());
        payor1 = this.getServerAdapter().createPayor(payor1);
        IPayor payor2 = BasicExecutionUnitLibrarry.getPayor(this.getAnnuityBeansFactory());
        payor2.setConfiguration(this.getConfiguration());
        payor2 = this.getServerAdapter().createPayor(payor2);
        annuity.getPayors().add(payor1);
        annuity.getPayors().add(payor2);
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().updateAnnuity(annuity);
        this.logger.fine("2 payors added? Annuity:" + (String)annuity.getId() + " Payor list size:" + annuity.getPayors().size());
        IPayor removed = BasicExecutionUnitLibrarry.getPayor(this.getAnnuityBeansFactory());
        removed.setId(payor1.getId());
        int removeIndex = 0;
        boolean foundIt = false;
        for (int i = 0; i < annuity.getPayors().size(); ++i) {
            if (!((String)removed.getId()).equals(annuity.getPayors().get(i).getId())) continue;
            removeIndex = i;
            foundIt = true;
            break;
        }
        if (!foundIt) {
            throw new ExecutionUnitVerificationException("Updated Annuity Payor1 from client list was not found in DB.   annuity payor size:" + annuity.getPayors().size() + " Annuity:" + (String)annuity.getId() + " Payor id:" + (String)removed.getId());
        }
        annuity.getPayors().remove(removeIndex);
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().updateAnnuity(annuity);
        removed.setConfiguration(this.getConfiguration());
        this.getServerAdapter().deletePayor(removed);
        for (IPayor payor : annuity.getPayors()) {
            if (!((String)payor2.getId()).equals(payor.getId())) continue;
            payor.setName(this.getUpdatedString(payor2.getName()));
            payor.setConfiguration(this.getConfiguration());
            payor = this.getServerAdapter().updatePayor(payor);
            break;
        }
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().updateAnnuity(annuity);
        IPayor removed2 = BasicExecutionUnitLibrarry.getPayor(this.getAnnuityBeansFactory());
        removed2.setId(payor2.getId());
        int removeIndex2 = 0;
        boolean foundIt2 = false;
        for (int i = 0; i < annuity.getPayors().size(); ++i) {
            if (!((String)removed2.getId()).equals(annuity.getPayors().get(i).getId())) continue;
            removeIndex2 = i;
            foundIt2 = true;
            break;
        }
        if (!foundIt2) {
            throw new ExecutionUnitVerificationException("Updated Annuity Payor2 from client list was not found in DB.   annuity payor size:" + annuity.getPayors().size() + " Annuity:" + (String)annuity.getId() + " Payor id:" + (String)removed.getId());
        }
        annuity.getPayors().remove(removeIndex2);
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().updateAnnuity(annuity);
        removed2.setConfiguration(this.getConfiguration());
        this.getServerAdapter().deletePayor(removed2);
        return annuity;
    }

    private IAnnuity updateAnnuityAlone(IAnnuity annuity) throws EntityNotFoundException, EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        if (annuity instanceof IEquityAnnuity) {
            return this.updateEquityAnnuity((IEquityAnnuity)annuity);
        }
        if (annuity instanceof IFixedAnnuity) {
            return this.updateFixedAnnuity((IFixedAnnuity)annuity);
        }
        return this.updateBasicAnnuity(annuity);
    }

    private IAnnuity updateBasicAnnuity(IAnnuity annuity) throws EntityNotFoundException, EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        annuity.setAmount(new Double(111111.0));
        annuity.setLastPaidAmt(new Double(1111.0));
        annuity.setAccountNumber(this.getUpdatedString(annuity.getAccountNumber()));
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().updateAnnuity(annuity);
        return annuity;
    }

    private IEquityAnnuity updateEquityAnnuity(IEquityAnnuity annuity) throws EntityNotFoundException, EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        annuity.setAmount(new Double(111111.0));
        annuity.setLastPaidAmt(new Double(1111.0));
        annuity.setFundNames(this.getUpdatedString(annuity.getFundNames()));
        annuity.setAccountNumber(this.getUpdatedString(annuity.getAccountNumber()));
        annuity.setIndexRate(new Double(0.88));
        annuity.setConfiguration(this.getConfiguration());
        annuity = (IEquityAnnuity)this.getServerAdapter().updateAnnuity(annuity);
        return annuity;
    }

    private IFixedAnnuity updateFixedAnnuity(IFixedAnnuity annuity) throws EntityNotFoundException, EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        annuity.setAmount(new Double(111111.0));
        annuity.setLastPaidAmt(new Double(1111.0));
        annuity.setAccountNumber(this.getUpdatedString(annuity.getAccountNumber()));
        annuity.setRate(new Double(0.88));
        annuity.setConfiguration(this.getConfiguration());
        annuity = (IFixedAnnuity)this.getServerAdapter().updateAnnuity(annuity);
        return annuity;
    }

    private void verifyAnnuityValues(IAnnuity annuity, AnnuityType annuityType) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        int i;
        IAnnuity results = null;
        if (AnnuityType.BASIC.equals((Object)annuityType)) {
            results = this.getAnnuityBeansFactory().createAnnuity();
        }
        if (AnnuityType.EQUITY.equals((Object)annuityType)) {
            results = this.getAnnuityBeansFactory().createAnnEquity();
        }
        if (AnnuityType.FIXED.equals((Object)annuityType)) {
            results = this.getAnnuityBeansFactory().createAnnFixed();
        }
        results.setId(annuity.getId());
        results.setConfiguration(this.getConfiguration());
        results = this.getServerAdapter().findAnnuityById(results);
        if (annuity instanceof IFixedAnnuity) {
            ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, (IFixedAnnuity)annuity, (IFixedAnnuity)results, "Fixed Annuity from Client is not equal to DB value", "Mismacth was found.");
        } else if (annuity instanceof IEquityAnnuity) {
            ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, (IEquityAnnuity)annuity, (IEquityAnnuity)results, "Equity Annuity from Client is not equal to DB value", "Mismacth was found.");
        } else {
            ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, annuity, results, "Basic Annuity from Client is not equal to DB value", "Mismacth was found.");
        }
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, annuity.getPayouts(), results.getPayouts(), "Annuity payouts from Client is not equal to DB value", "Mismacth was found in number of payouts");
        boolean found = false;
        if (annuity.getPayouts() != null) {
            IPayout clientPayout = null;
            for (i = 0; i < annuity.getPayouts().size(); ++i) {
                found = false;
                clientPayout = annuity.getPayouts().get(i);
                for (IPayout resultPayout : results.getPayouts()) {
                    if (!((String)clientPayout.getId()).equals(resultPayout.getId())) continue;
                    found = true;
                    ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, clientPayout, resultPayout, "Annuity Payout from Client is not equal to DB value at location: " + i, "Mismacth was found");
                }
                if (found || clientPayout == null) continue;
                throw new ExecutionUnitVerificationException("Annuity Payout from client is not equal to DB.  Found Payout with id: " + (String)clientPayout.getId() + " on the client side, but not in the database for annuity id:" + (String)annuity.getId());
            }
        }
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, annuity.getRiders(), results.getRiders(), "Annuity rider from Client is not equal to DB value", "Mismacth was found in number of rider");
        if (annuity.getRiders() != null) {
            IRider clientRider = null;
            for (i = 0; i < annuity.getRiders().size(); ++i) {
                found = false;
                clientRider = annuity.getRiders().get(i);
                for (IRider resultRider : results.getRiders()) {
                    if (!((String)clientRider.getId()).equals(resultRider.getId())) continue;
                    found = true;
                    ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, clientRider, resultRider, "Annuity rider from Client is not equal to DB value at location: " + i, "Mismacth was found");
                }
                if (found || clientRider == null) continue;
                throw new ExecutionUnitVerificationException("Annuity rider from client is not equal to DB.  Found rider with id: " + (String)clientRider.getId() + " on the client side, but not in the database for annuity id:" + (String)annuity.getId());
            }
        }
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, annuity.getPayors(), results.getPayors(), "Annuity Payor from Client is not equal to DB value", "Mismacth was found.");
        if (annuity.getPayors() != null) {
            IPayor clientPayor = null;
            for (i = 0; i < annuity.getPayors().size(); ++i) {
                found = false;
                clientPayor = annuity.getPayors().get(i);
                for (IPayor resultPayor : results.getPayors()) {
                    if (!((String)clientPayor.getId()).equals(resultPayor.getId())) continue;
                    found = true;
                    ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, annuity.getPayors().get(i), resultPayor, "Annuity payor from Client is not equal to DB value at location: " + i, "Mismacth was found");
                }
                if (found || clientPayor == null) continue;
                throw new ExecutionUnitVerificationException("Annuity payor from client is not equal to DB.  Found payor with id: " + (String)clientPayor.getId() + " on the client side, but not in the database for annuity id:" + (String)annuity.getId());
            }
        }
    }

    private String getUpdatedString(String st) {
        String newName = "";
        String first = "";
        String last = "";
        if (st.indexOf("**") < 0) {
            newName = st + "**0";
        } else {
            StringTokenizer parser = new StringTokenizer(st, "**");
            first = parser.nextToken();
            last = parser.nextToken();
            newName = first + "**" + (Integer.valueOf(last) + 1);
        }
        return newName;
    }

    private AnnuityType getAnnuityType(IAnnuity annuity) {
        if (annuity instanceof IEquityAnnuity) {
            return AnnuityType.EQUITY;
        }
        if (annuity instanceof IFixedAnnuity) {
            return AnnuityType.FIXED;
        }
        return AnnuityType.BASIC;
    }
}

