/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit.policy;

import com.ibm.wssvt.acme.annuity.common.bean.IFund;
import com.ibm.wssvt.acme.annuity.common.bean.IPolicy;
import com.ibm.wssvt.acme.annuity.common.bean.jpa.JPABeansFactory;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.BasicExecutionUnitLibrarry;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.ExecutionUnitVerificationHelper;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.policy.AbastractPolicyExecutionUnit;
import com.ibm.wssvt.acme.annuity.common.exception.EntityAlreadyExistsException;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.common.adapter.ServerAdapterCommunicationException;
import com.ibm.wssvt.acme.common.executionunit.ExecutionUnitVerificationException;
import com.ibm.wssvt.acme.common.executionunit.IExecutionUnit;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.rmi.RemoteException;
import java.util.Map;

public class CRUDPolicyEU
extends AbastractPolicyExecutionUnit {
    private static final long serialVersionUID = -8980124038714550844L;
    private AcmeLogger logger;

    public void execute() {
        this.setScenarioVariables();
        this.logger.fine("Creating Policy");
        IPolicy policy = null;
        try {
            policy = this.createPolicy();
        }
        catch (Exception e) {
            this.logger.warning("Failed to create Policy. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Verifying Create Policy");
        try {
            this.verifyCreate(policy);
        }
        catch (Exception e) {
            this.logger.info("Create Policy verification failed.  Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.fine("Updating Policy");
        IPolicy updated = null;
        try {
            updated = this.updatePolicy(policy);
        }
        catch (Exception e) {
            this.logger.warning("Failed to update Policy. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Verifying Update Policy");
        try {
            this.verifyUpdate(updated);
        }
        catch (Exception e) {
            this.logger.info("Update policy verification failed. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.fine("Deleting Policy");
        try {
            this.deletePolicy(updated);
        }
        catch (Exception e) {
            this.logger.info("Failed to delete Policy. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Verifying Delete Policy");
        try {
            this.verifyDelete(updated);
        }
        catch (Exception e) {
            this.logger.info("Delete Policy verification failed.  Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
    }

    private void setScenarioVariables() {
        this.logger = this.getLogger(((Object)((Object)this)).getClass().getName());
    }

    private IPolicy createPolicy() throws EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IPolicy policy = BasicExecutionUnitLibrarry.getPolicy(this.getAnnuityBeansFactory());
        policy.setConfiguration(this.getConfiguration());
        policy = this.getServerAdapter().createPolicy(policy);
        return policy;
    }

    private IPolicy updatePolicy(IPolicy before) throws EntityNotFoundException, ServerAdapterCommunicationException, InvalidArgumentException, ServerInternalErrorException, RemoteException {
        IPolicy after = BasicExecutionUnitLibrarry.getPolicy(this.getAnnuityBeansFactory());
        after.setId(before.getId());
        after.setConfiguration(this.getConfiguration());
        after = this.getServerAdapter().findPolicyById(after);
        Map<Integer, IFund> fundMap = after.getFunds();
        IFund fund = BasicExecutionUnitLibrarry.getFund(this.getAnnuityBeansFactory());
        fund.setFundName("Oracle");
        fund.setIndexRate(new Double(3.0));
        fundMap.put(new Integer(3), fund);
        after.setFunds(fundMap);
        after.setConfiguration(this.getConfiguration());
        after = this.getServerAdapter().updatePolicy(after);
        return after;
    }

    private void deletePolicy(IPolicy policy) throws EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException, EntityNotFoundException {
        IPolicy removed = BasicExecutionUnitLibrarry.getPolicy(this.getAnnuityBeansFactory());
        removed.setId(policy.getId());
        removed.setConfiguration(this.getConfiguration());
        this.getServerAdapter().deletePolicy(removed);
    }

    private void verifyCreate(IPolicy policy) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        IPolicy results = ((JPABeansFactory)this.getAnnuityBeansFactory()).createPolicy();
        results.setId(policy.getId());
        results.setConfiguration(this.getConfiguration());
        results = this.getServerAdapter().findPolicyById(results);
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, policy, results, "policy from client is not equal to DB value", "policy Create mismacth was found.");
    }

    private void verifyUpdate(IPolicy policy) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        IPolicy results = ((JPABeansFactory)this.getAnnuityBeansFactory()).createPolicy();
        results.setId(policy.getId());
        results.setConfiguration(this.getConfiguration());
        results = this.getServerAdapter().findPolicyById(results);
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, policy, results, "policy from client is not equal to DB value", "policy Update mismacth was found.");
    }

    private void verifyDelete(IPolicy policy) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        IPolicy results = ((JPABeansFactory)this.getAnnuityBeansFactory()).createPolicy();
        results.setId(policy.getId());
        results.setConfiguration(this.getConfiguration());
        try {
            results = this.getServerAdapter().findPolicyById(results);
            if (results != null) {
                throw new ExecutionUnitVerificationException("Deletion of policy with ID = " + (String)policy.getId() + "was not successful! The object still exists in DB.");
            }
        }
        catch (EntityNotFoundException entityNotFoundException) {
            // empty catch block
        }
    }
}

