/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit.policy;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.bean.IFund;
import com.ibm.wssvt.acme.annuity.common.bean.IPolicy;
import com.ibm.wssvt.acme.annuity.common.bean.Identifiable;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.BasicExecutionUnitLibrarry;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.ExecutionUnitVerificationHelper;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.policy.AbastractPolicyExecutionUnit;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.common.adapter.ServerAdapterCommunicationException;
import com.ibm.wssvt.acme.common.executionunit.IExecutionUnit;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;

public class ReadPolicyFundFromFundNameAndHolderEU
extends AbastractPolicyExecutionUnit {
    private static final long serialVersionUID = -5232684206187027962L;
    private String useId = null;
    private int maxId = 0;
    private int startId = 0;
    private static final String USE_ID = "useId";
    private static final String MAX_ID = "maxId";
    private static final String START_ID_KEY = "startId";
    AcmeLogger logger = null;

    public void execute() {
        String sHolderId = null;
        Identifiable policyHolder = null;
        this.setScenarioVariables();
        if (this.useId == null && this.maxId == 0) {
            this.logger.severe("Scenario parameter error: Either useId or maxId must be set > 0 for scenario: " + this.getDescription() + ": failed to execute");
            InvalidArgumentException e = new InvalidArgumentException("Scenario parameter error: Either useId or maxId must be set > 0 for scenario");
            this.getExecutionUnitEvent().addException((Exception)((Object)e));
            return;
        }
        this.logger.fine("After getting parameters, Begin execution");
        sHolderId = this.useId != null ? this.useId : Integer.toString(this.getRandomInteger(this.startId, this.maxId));
        int count = 0;
        while (policyHolder == null && count < 3) {
            sHolderId = this.useId != null ? this.useId : Integer.toString(this.getRandomInteger(this.startId, this.maxId));
            this.logger.fine("Looking up id: " + sHolderId);
            try {
                policyHolder = this.findAnnuityHolder(sHolderId);
            }
            catch (Exception e) {
                if (this.useId != null) {
                    this.logger.warning("failed to find Holder, Id = " + sHolderId + " Error: " + e);
                    this.getExecutionUnitEvent().addException(e);
                    return;
                }
                this.logger.warning("Exception while looking up Holder with, id: " + sHolderId + "Error: " + e);
                ++count;
            }
        }
        if (count >= 3) {
            this.logger.warning("failed to find Holder in " + count + " attempts, Id = " + sHolderId);
            EntityNotFoundException e = new EntityNotFoundException("failed to find Holder in " + count + " attempts, Id = " + sHolderId);
            this.getExecutionUnitEvent().addException((Exception)((Object)e));
            return;
        }
        this.logger.fine("Successful find of Holder, id = " + (String)policyHolder.getId() + "Call verify ");
        try {
            ExecutionUnitVerificationHelper.assertEquals((IExecutionUnit)this, (Comparable)((Object)sHolderId), (Comparable)policyHolder.getId(), "Returned Annuity Holder id is not equal to requested id", "Mismatch was found.");
        }
        catch (Exception e) {
            this.logger.severe("Failed on verify find holder. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        List<IPolicy> policyListResults = null;
        try {
            this.logger.fine("Looking up policies for holder ID: " + (String)policyHolder.getId());
            policyHolder.setConfiguration(this.getConfiguration());
            policyListResults = this.getServerAdapter().findHolderPolicies((IAnnuityHolder)policyHolder);
            this.logger.fine("Looked up policies for holder ID: " + (String)policyHolder.getId());
        }
        catch (Exception e) {
            this.logger.severe("Error Holder ID: " + (String)policyHolder.getId() + " failed finding policies. Exception: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        if (policyListResults != null) {
            this.logger.fine("HolderId: " + sHolderId + " has: " + policyListResults.size() + " policies");
            Iterator<IPolicy> it = policyListResults.iterator();
            while (it.hasNext()) {
                IFund fundQuery1 = null;
                IFund fundQuery2 = null;
                IPolicy pol = it.next();
                try {
                    this.logger.fine("HolderId: " + pol.getAnnuityHolderId() + " Policy ID: " + (String)pol.getId());
                    ExecutionUnitVerificationHelper.assertIdContains((IExecutionUnit)this, (String)pol.getId(), sHolderId, "ERROR: requested policy id: " + (String)pol.getId(), " does not contain holder id: " + sHolderId);
                }
                catch (Exception e) {
                    this.logger.severe("validating holder ID: " + sHolderId + " Failed for policy: ");
                    this.getExecutionUnitEvent().addException(e);
                    return;
                }
                try {
                    fundQuery1 = pol.getFunds().get(new Integer(1));
                    String fundName = fundQuery1.getFundName();
                    if (fundName != null) {
                        this.logger.fine("Looking up Fund for holder ID: " + (String)policyHolder.getId() + " with FundName " + fundName);
                        fundQuery2 = this.getServerAdapter().findFundIndexRateFromFundName((IAnnuityHolder)policyHolder, fundName);
                        this.logger.fine("The IndexRate for Fund " + fundName + " is : " + fundQuery2.getIndexRate());
                    }
                }
                catch (Exception e) {
                    this.logger.severe("Exception while getting FundIndexRateFromFundName for holderId " + sHolderId);
                    this.getExecutionUnitEvent().addException(e);
                    return;
                }
                this.logger.fine("Comparing query results");
                try {
                    ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, fundQuery1, fundQuery2, "Results of queries do not match!", "GetIndexRate and GetPolicy queries returned different results.");
                }
                catch (Exception e) {
                    this.logger.severe("Validation of e-mail lists failed for holder: " + sHolderId);
                    this.getExecutionUnitEvent().addException(e);
                }
                this.logger.fine("Finished comparing results");
            }
        } else {
            this.logger.warning("Holder ID: " + sHolderId + " has 0 policies");
            EntityNotFoundException e = new EntityNotFoundException("Holder ID: " + sHolderId + " has 0 policies");
            this.getExecutionUnitEvent().addException((Exception)((Object)e));
            return;
        }
    }

    private void setScenarioVariables() {
        this.logger = this.getLogger(((Object)((Object)this)).getClass().getName());
        try {
            this.useId = (String)this.getConfiguration().getParameterValue((Object)USE_ID);
        }
        catch (Exception e) {
            this.logger.warning("useId parameter not in config file, use random");
        }
        try {
            this.maxId = this.getParameterValueInt(MAX_ID);
        }
        catch (Exception e) {
            this.logger.warning("maxId parameter not in config file, use default max");
        }
        try {
            this.startId = this.getParameterValueInt(START_ID_KEY);
        }
        catch (Exception e) {
            this.logger.warning("the attribute:startId is missing for scenario: " + this.getDescription() + " .Setting the default to 1");
            this.startId = 1;
        }
    }

    private IAnnuityHolder findAnnuityHolder(String id) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IAnnuityHolder annuityHolder = null;
        annuityHolder = BasicExecutionUnitLibrarry.getAnnuityHolder(this.getAnnuityBeansFactory());
        annuityHolder.setId(id);
        annuityHolder.setConfiguration(this.getConfiguration());
        annuityHolder = this.getServerAdapter().findHolderById(annuityHolder);
        return annuityHolder;
    }
}

