/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.jaxrpc.bean.jaxrpc2ejb3jaxws;

import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.bean.jaxrpc2ejb3jaxws.Annuity;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.bean.jaxrpc2ejb3jaxws.EquityAnnuity;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.bean.jaxrpc2ejb3jaxws.FixedAnnuity;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.bean.jaxrpc2ejb3jaxws.Payout;
import com.ibm.wssvt.acme.annuity.common.client.jaxrpc.jaxrpc2ejb3jaxwsimpl.AnnuityType;

public class AnnuityValueObject {
    private AnnuityType annuityType;
    private Annuity basic;
    private FixedAnnuity fixed;
    private EquityAnnuity equity;

    public AnnuityType getAnnuityType() {
        return this.annuityType;
    }

    public void setAnnuityType(AnnuityType annuityType) {
        this.annuityType = annuityType;
    }

    public Annuity getBasic() {
        return this.basic;
    }

    public void setBasic(Annuity basic) {
        this.basic = basic;
    }

    public FixedAnnuity getFixed() {
        return this.fixed;
    }

    public void setFixed(FixedAnnuity fixed) {
        this.fixed = fixed;
    }

    public EquityAnnuity getEquity() {
        return this.equity;
    }

    public void setEquity(EquityAnnuity equity) {
        this.equity = equity;
    }

    public void setAnnuity(Annuity annuity) {
        if (annuity == null) {
            this.annuityType = null;
            this.fixed = null;
            this.equity = null;
            this.basic = null;
            return;
        }
        if (annuity instanceof FixedAnnuity) {
            this.annuityType = AnnuityType.FIXED;
            this.fixed = (FixedAnnuity)annuity;
        } else if (annuity instanceof EquityAnnuity) {
            this.annuityType = AnnuityType.EQUITY;
            this.equity = (EquityAnnuity)annuity;
        } else {
            this.annuityType = AnnuityType.BASIC;
            this.basic = annuity;
        }
        if (annuity != null && annuity.getPayouts() != null) {
            for (Payout payout : annuity.getPayouts()) {
                payout.setAnnuity(null);
            }
        }
    }

    public Annuity getAnnuityData() {
        Annuity result = this.getAnnuity();
        if (result == null) {
            return null;
        }
        if (result.getPayouts() != null) {
            for (Payout payout : result.getPayouts()) {
                payout.setAnnuity(result);
            }
        }
        return result;
    }

    public Annuity getAnnuity() {
        Annuity result = null;
        if (this.annuityType == null) {
            return null;
        }
        result = AnnuityType.FIXED.equals(this.annuityType) ? this.fixed : (AnnuityType.EQUITY.equals(this.annuityType) ? this.equity : this.basic);
        return result;
    }
}

