/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.persistence.impl.jpasa;

import com.ibm.wssvt.acme.annuity.common.bean.IPersisteble;
import com.ibm.wssvt.acme.annuity.common.exception.EntityAlreadyExistsException;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerPersistenceModuleException;
import com.ibm.wssvt.acme.annuity.common.persistence.BasicPersistence;
import com.ibm.wssvt.acme.annuity.common.persistence.JPAPersistenceUnitName;
import com.ibm.wssvt.acme.annuity.common.persistence.PersistenceUnitNameHelper;
import com.ibm.wssvt.acme.common.bean.Configrable;
import com.ibm.wssvt.acme.common.exception.ExceptionFormatter;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.util.Map;
import java.util.logging.Level;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;
import javax.persistence.PersistenceException;
import javax.persistence.TransactionRequiredException;

public abstract class BasicPersistenceJPASAImpl<T>
implements BasicPersistence<IPersisteble<T>, String, String> {
    private AcmeLogger logger;
    private static EntityManagerFactory cachedFactory = null;

    public BasicPersistenceJPASAImpl(AcmeLogger logger) {
        this.logger = logger;
    }

    @Override
    public IPersisteble<T> createObject(IPersisteble<T> persistebleObject) throws ServerPersistenceModuleException, EntityAlreadyExistsException, InvalidArgumentException {
        EntityManager em = null;
        try {
            this.logger.fine("Entering the create Object - jpa-SA -getting factory");
            this.logger.fine("Create Object's id is " + persistebleObject.getId());
            cachedFactory = this.getEntityManagerFactory(persistebleObject);
            this.logger.fine("- jpa-SA -getting em");
            em = cachedFactory.createEntityManager();
            this.logger.fine("- begin tx");
            em.getTransaction().begin();
            this.logger.fine("- persist");
            em.persist(persistebleObject);
            this.logger.fine("- commit");
            em.getTransaction().commit();
            IPersisteble<T> iPersisteble = persistebleObject;
            return iPersisteble;
        }
        catch (EntityExistsException e) {
            this.rollBackTransaction(em);
            String msg = "Entity already exists.  Error: " + ExceptionFormatter.deepFormatToString((Throwable)e) + this.logger.getAllLogs();
            this.logger.info(msg);
            throw new EntityAlreadyExistsException("Attempt to save an object with same primary key. " + msg);
        }
        catch (IllegalStateException e) {
            this.rollBackTransaction(em);
            String msg = "Illegal State Exception.  Check the code logic.  Error: " + ExceptionFormatter.deepFormatToString((Throwable)e) + this.logger.getAllLogs();
            this.logger.log(Level.SEVERE, msg, (Throwable)e);
            throw new ServerPersistenceModuleException("Illegal State Exception. Check Business Logic." + msg);
        }
        catch (IllegalArgumentException e) {
            this.rollBackTransaction(em);
            String msg = "Object is not a JPA Object.  Error: " + ExceptionFormatter.deepFormatToString((Throwable)e) + this.logger.getAllLogs();
            this.logger.log(Level.SEVERE, msg, (Throwable)e);
            throw new InvalidArgumentException("Object is not a JPA Object. Check Code Logic. Error: " + msg);
        }
        catch (TransactionRequiredException e) {
            this.rollBackTransaction(em);
            String msg = "Business Logic was expecting a transaction.  Error: " + ExceptionFormatter.deepFormatToString((Throwable)e) + this.logger.getAllLogs();
            this.logger.log(Level.SEVERE, msg, (Throwable)e);
            throw new ServerPersistenceModuleException("Business Logic was expecting a transaction. Check Business Logic..  Error: " + msg);
        }
        catch (PersistenceException e) {
            this.rollBackTransaction(em);
            String msg = "Persistence Module returned an error - see error message for details. Error: " + ExceptionFormatter.deepFormatToString((Throwable)e) + this.logger.getAllLogs();
            this.logger.log(Level.WARNING, msg, (Throwable)e);
            throw new ServerPersistenceModuleException(msg);
        }
        catch (Throwable t) {
            this.rollBackTransaction(em);
            String msg = "Non-decleraed exeception.  Error: " + ExceptionFormatter.deepFormatToString((Throwable)t) + this.logger.getAllLogs();
            this.logger.log(Level.SEVERE, msg, t);
            throw new ServerPersistenceModuleException(msg);
        }
        finally {
            this.logger.fine("- close em");
            if (em != null) {
                em.close();
            }
        }
    }

    @Override
    public <C> void deleteObject(Class<C> object, Object id, Configrable<String, String> configrable) throws ServerPersistenceModuleException, InvalidArgumentException {
        EntityManager em = null;
        try {
            this.logger.fine("Entering the delete Object - jpa-SA -getting factory");
            cachedFactory = this.getEntityManagerFactory(configrable);
            this.logger.fine("- jpa-SA -getting em");
            em = cachedFactory.createEntityManager();
            this.logger.fine("- begin tx");
            em.getTransaction().begin();
            this.logger.fine("- find ");
            Object obj = em.find(object, id);
            this.logger.fine("- delete ");
            em.remove(obj);
            this.logger.fine("- commit");
            em.getTransaction().commit();
        }
        catch (IllegalStateException e) {
            this.rollBackTransaction(em);
            String msg = "Illegal State Exception.  Check the code logic.  Error: " + ExceptionFormatter.deepFormatToString((Throwable)e) + this.logger.getAllLogs();
            this.logger.log(Level.SEVERE, msg, (Throwable)e);
            throw new ServerPersistenceModuleException("Illegal State Exception. Check Business Logic." + msg);
        }
        catch (IllegalArgumentException e) {
            this.rollBackTransaction(em);
            String msg = "Object is not a JPA Object.  Error: " + ExceptionFormatter.deepFormatToString((Throwable)e) + this.logger.getAllLogs();
            this.logger.log(Level.SEVERE, msg, (Throwable)e);
            throw new InvalidArgumentException("Object is not a JPA Object. Check Code Logic. Error: " + msg);
        }
        catch (TransactionRequiredException e) {
            this.rollBackTransaction(em);
            String msg = "Business Logic was expecting a transaction.  Error: " + ExceptionFormatter.deepFormatToString((Throwable)e) + this.logger.getAllLogs();
            this.logger.log(Level.SEVERE, msg, (Throwable)e);
            throw new ServerPersistenceModuleException("Business Logic was expecting a transaction. Check Business Logic..  Error: " + msg);
        }
        catch (PersistenceException e) {
            this.rollBackTransaction(em);
            String msg = "Persistence Module returned an error - see error message for details. Error: " + ExceptionFormatter.deepFormatToString((Throwable)e) + this.logger.getAllLogs();
            this.logger.log(Level.WARNING, msg, (Throwable)e);
            throw new ServerPersistenceModuleException(msg);
        }
        catch (Throwable t) {
            this.rollBackTransaction(em);
            String msg = "Non-decleraed exeception.  Error: " + ExceptionFormatter.deepFormatToString((Throwable)t) + this.logger.getAllLogs();
            this.logger.log(Level.SEVERE, msg, t);
            throw new ServerPersistenceModuleException(msg);
        }
        finally {
            this.logger.fine("- close em");
            if (em != null) {
                em.close();
            }
        }
    }

    @Override
    public <C> C readObject(Class<C> entClass, Object entId, Configrable<String, String> configrable) throws EntityNotFoundException, ServerPersistenceModuleException, InvalidArgumentException {
        EntityManager em = null;
        Object persistable = null;
        try {
            this.logger.fine("Entering the read Object - jpa-SA -getting factory");
            cachedFactory = this.getEntityManagerFactory(configrable);
            this.logger.fine("- jpa-SA -getting em");
            em = cachedFactory.createEntityManager();
            persistable = em.find(entClass, entId);
            if (persistable == null) {
                this.logger.fine("read object returned null.  the object does not exist.  Class: " + entClass + " id: " + entId + " returning an EntityNotFoundException");
                throw new EntityNotFoundException("Failed to find the object with " + entClass + " with id:" + entId + this.logger.getAllLogs());
            }
        }
        catch (IllegalStateException e) {
            String msg = "Illegal State Closed.  Error: " + ExceptionFormatter.deepFormatToString((Throwable)e) + this.logger.getAllLogs();
            this.logger.log(Level.SEVERE, msg, (Throwable)e);
            throw new ServerPersistenceModuleException(msg);
        }
        catch (IllegalArgumentException e) {
            String msg = "Object is not a JPA Object.  Check the code logic. Error: " + ExceptionFormatter.deepFormatToString((Throwable)e) + this.logger.getAllLogs();
            this.logger.log(Level.SEVERE, msg, (Throwable)e);
            throw new InvalidArgumentException(msg);
        }
        catch (EntityNotFoundException e) {
            throw e;
        }
        catch (PersistenceException e) {
            String msg = "Persistence Module returned an error - see error message for details. Error: " + ExceptionFormatter.deepFormatToString((Throwable)e) + this.logger.getAllLogs();
            this.logger.log(Level.WARNING, msg, (Throwable)e);
            throw new ServerPersistenceModuleException(msg);
        }
        catch (Throwable t) {
            String msg = "Encountered a non-declered exception. Error: " + ExceptionFormatter.deepFormatToString((Throwable)t) + this.logger.getAllLogs();
            this.logger.log(Level.SEVERE, msg, t);
            throw new ServerPersistenceModuleException(msg);
        }
        finally {
            this.logger.fine("- close em");
            if (em != null) {
                em.close();
            }
        }
        return (C)persistable;
    }

    @Override
    public IPersisteble<T> updateObject(IPersisteble<T> persisteble) throws ServerPersistenceModuleException, InvalidArgumentException {
        EntityManager em = null;
        try {
            this.logger.fine("Entering the update Object - jpa-SA -getting factory - new");
            cachedFactory = this.getEntityManagerFactory(persisteble);
            this.logger.fine("- jpa-SA -getting em");
            em = cachedFactory.createEntityManager();
            this.logger.fine("- begin tx");
            em.getTransaction().begin();
            this.logger.fine("- delete ");
            persisteble = (IPersisteble)em.merge(persisteble);
            this.logger.fine("- commit");
            em.getTransaction().commit();
            IPersisteble iPersisteble = persisteble;
            return iPersisteble;
        }
        catch (IllegalStateException e) {
            this.rollBackTransaction(em);
            String msg = "Illegal State Exception.  Check the code logic.  Error: " + ExceptionFormatter.deepFormatToString((Throwable)e) + this.logger.getAllLogs();
            this.logger.log(Level.SEVERE, msg, (Throwable)e);
            throw new ServerPersistenceModuleException("Illegal State Exception. Check Business Logic." + msg);
        }
        catch (IllegalArgumentException e) {
            this.rollBackTransaction(em);
            String msg = "Object is not a JPA Object.  Error: " + ExceptionFormatter.deepFormatToString((Throwable)e) + this.logger.getAllLogs();
            this.logger.log(Level.SEVERE, msg, (Throwable)e);
            throw new InvalidArgumentException("Object is not a JPA Object. Check Code Logic. Error: " + msg);
        }
        catch (TransactionRequiredException e) {
            this.rollBackTransaction(em);
            String msg = "Business Logic was expecting a transaction.  Error: " + ExceptionFormatter.deepFormatToString((Throwable)e) + this.logger.getAllLogs();
            this.logger.log(Level.SEVERE, msg, (Throwable)e);
            throw new ServerPersistenceModuleException("Business Logic was expecting a transaction. Check Business Logic..  Error: " + msg);
        }
        catch (PersistenceException e) {
            this.rollBackTransaction(em);
            String msg = "Persistence Module returned an error - see error message for details. Error: " + ExceptionFormatter.deepFormatToString((Throwable)e) + this.logger.getAllLogs();
            this.logger.log(Level.WARNING, msg, (Throwable)e);
            throw new ServerPersistenceModuleException(msg);
        }
        catch (Throwable t) {
            this.rollBackTransaction(em);
            String msg = "Non-decleraed exeception.  Error: " + ExceptionFormatter.deepFormatToString((Throwable)t) + this.logger.getAllLogs();
            this.logger.log(Level.SEVERE, msg, t);
            throw new ServerPersistenceModuleException(msg);
        }
        finally {
            this.logger.fine("- close em");
            if (em != null) {
                em.close();
            }
        }
    }

    protected synchronized EntityManagerFactory getEntityManagerFactory(Configrable<String, String> configrable) throws InvalidArgumentException {
        String refreshEmf = (String)configrable.getConfiguration().getParameterValue((Object)"refreshJPAEMF");
        this.logger.fine("refreshJPAEMF value is:" + refreshEmf + " null means false");
        this.logger.fine("cachedFactory is: " + cachedFactory);
        if (cachedFactory == null || "true".equalsIgnoreCase(refreshEmf) || !cachedFactory.isOpen()) {
            if (cachedFactory != null && cachedFactory.isOpen()) {
                this.logger.fine("cachedFactory is not null, we need to close it first.  Issuing close()");
                cachedFactory.close();
            }
            PersistenceUnitNameHelper.setPersistenceUnitName(configrable, null);
            String persistenceUnitName = (String)configrable.getConfiguration().getParameterValue((Object)"persistenceUnitName");
            this.logger.fine("persistenceUnitName: " + persistenceUnitName);
            if (JPAPersistenceUnitName.AnnuitySAJAXBJPA.toString().equals(persistenceUnitName)) {
                this.logger.fine("using AnnuitySAJAXBJPA factory");
                cachedFactory = Persistence.createEntityManagerFactory((String)"AnnuitySAJAXBJPA", (Map)configrable.getConfiguration().getParameters());
            } else if (JPAPersistenceUnitName.AnnuitySAJPAOnly.toString().equals(persistenceUnitName)) {
                this.logger.fine("using AnnuitySAJPAOnly factory");
                cachedFactory = Persistence.createEntityManagerFactory((String)"AnnuitySAJPAOnly", (Map)configrable.getConfiguration().getParameters());
            } else if (JPAPersistenceUnitName.PolicySAJPAOnly.toString().equals(persistenceUnitName)) {
                this.logger.fine("using PolicySAJPAOnly factory");
                cachedFactory = Persistence.createEntityManagerFactory((String)"PolicySAJPAOnly", (Map)configrable.getConfiguration().getParameters());
            } else {
                throw new InvalidArgumentException("The parameter persistenceUnitName was not set.  Please provide a valid value! " + this.logger.getAllLogs());
            }
        }
        return cachedFactory;
    }

    private void rollBackTransaction(EntityManager em) {
        if (em == null) {
            return;
        }
        EntityTransaction toRollBack = em.getTransaction();
        if (toRollBack != null && toRollBack.isActive()) {
            try {
                toRollBack.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

