/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.servicelookup.ejb31;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.bean.IContact;
import com.ibm.wssvt.acme.annuity.common.bean.IPayor;
import com.ibm.wssvt.acme.annuity.common.bean.IPayout;
import com.ibm.wssvt.acme.annuity.common.bean.IRider;
import com.ibm.wssvt.acme.annuity.common.business.IAnnuityService;
import com.ibm.wssvt.acme.annuity.common.business.ejb31.AnnuityMgmtAsynchSvcEJB31;
import com.ibm.wssvt.acme.annuity.common.exception.EntityAlreadyExistsException;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.common.bean.Configrable;
import com.ibm.wssvt.acme.common.exception.InvalidConfigurationException;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import com.ibm.wssvt.acme.common.util.StringUtils;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class AnnuityEJB31AsynchRemoteServiceProxy
implements IAnnuityService {
    AnnuityMgmtAsynchSvcEJB31 remote;
    private AcmeLogger logger;
    private final long DEFAULT_FIRE_FORGET_WAIT = 2000L;
    private final long DEFAULT_ASYNCH_METHOD_WAIT_COUNT = 100L;
    private final long DEFAULT_ASYNCH_WAIT_VALUE = 1L;
    private static final String FIRE_FORGET_VERIFY_ENABLED_KEY = "fireAndForgetVerify";
    private static final String FIRE_FORGET_VERIFY_WAIT_KEY = "fireAndForgetWait";
    private static final String ASYNCH_METHOD_WAIT = "asynchMethodWait";
    private static final String ASYNCH_METHOD_WAIT_COUNT = "asynchMethodWaitCount";
    private static final String ASYNCH_TIMEOUT_VALUE = "remoteAsynchTimeoutValue";
    int remoteAsynchTimeout = 10;

    public AnnuityEJB31AsynchRemoteServiceProxy(AnnuityMgmtAsynchSvcEJB31 remote, AcmeLogger logger) {
        this.remote = remote;
        this.logger = logger;
    }

    @Override
    public IAnnuity findAnnuityById(IAnnuity annuity) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        Future<IAnnuity> future = this.remote.findAnnuityById(annuity);
        this.getAsyncTimout(annuity);
        try {
            return future.get(this.remoteAsynchTimeout, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof EntityNotFoundException) {
                throw (EntityNotFoundException)((Object)e.getCause());
            }
            throw new ServerInternalErrorException(e);
        }
        catch (InterruptedException e) {
            throw new ServerInternalErrorException(e);
        }
        catch (TimeoutException e) {
            throw new ServerInternalErrorException(e);
        }
    }

    @Override
    public IAnnuityHolder findAnnuityHolder(IAnnuity annuity) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        Future<IAnnuityHolder> future = this.remote.findAnnuityHolder(annuity);
        this.getAsyncTimout(annuity);
        try {
            return future.get(this.remoteAsynchTimeout, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof EntityNotFoundException) {
                throw (EntityNotFoundException)((Object)e.getCause());
            }
            throw new ServerInternalErrorException(e);
        }
        catch (InterruptedException e) {
            throw new ServerInternalErrorException(e);
        }
        catch (TimeoutException e) {
            throw new ServerInternalErrorException(e);
        }
    }

    @Override
    public IContact findContactById(IContact contact) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        Future<IContact> future = this.remote.findContactById(contact);
        this.getAsyncTimout(contact);
        try {
            return future.get(this.remoteAsynchTimeout, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof EntityNotFoundException) {
                throw (EntityNotFoundException)((Object)e.getCause());
            }
            throw new ServerInternalErrorException(e);
        }
        catch (InterruptedException e) {
            throw new ServerInternalErrorException(e);
        }
        catch (TimeoutException e) {
            throw new ServerInternalErrorException(e);
        }
    }

    @Override
    public List<IAnnuity> findHolderAnnuities(IAnnuityHolder annuityHolder) throws ServerInternalErrorException, InvalidArgumentException {
        Future<List<IAnnuity>> future = this.remote.findHolderAnnuities(annuityHolder);
        this.getAsyncTimout(annuityHolder);
        try {
            return future.get(this.remoteAsynchTimeout, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            throw new ServerInternalErrorException(e);
        }
        catch (InterruptedException e) {
            throw new ServerInternalErrorException(e);
        }
        catch (TimeoutException e) {
            throw new ServerInternalErrorException(e);
        }
    }

    @Override
    public IAnnuityHolder findHolderById(IAnnuityHolder annuityHolder) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        Future<IAnnuityHolder> future = this.remote.findHolderById(annuityHolder);
        this.getAsyncTimout(annuityHolder);
        try {
            return future.get(this.remoteAsynchTimeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new ServerInternalErrorException(e);
        }
        catch (TimeoutException e) {
            throw new ServerInternalErrorException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof EntityNotFoundException) {
                throw (EntityNotFoundException)((Object)e.getCause());
            }
            throw new ServerInternalErrorException(e);
        }
    }

    @Override
    public IPayor findPayorById(IPayor payor) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        Future<IPayor> future = this.remote.findPayorById(payor);
        try {
            this.waitAndCheckForValidResponse(future, payor);
            return future.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof EntityNotFoundException) {
                throw (EntityNotFoundException)((Object)e.getCause());
            }
            throw new ServerInternalErrorException(e);
        }
        catch (InterruptedException e) {
            throw new ServerInternalErrorException(e);
        }
    }

    @Override
    public IPayout findPayoutById(IPayout payout) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        Future<IPayout> future = this.remote.findPayoutById(payout);
        try {
            this.waitAndCheckForValidResponse(future, payout);
            return future.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof EntityNotFoundException) {
                throw (EntityNotFoundException)((Object)e.getCause());
            }
            throw new ServerInternalErrorException(e);
        }
        catch (InterruptedException e) {
            throw new ServerInternalErrorException(e);
        }
    }

    @Override
    public IRider findRiderById(IRider rider) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        Future<IRider> future = this.remote.findRiderById(rider);
        try {
            this.waitAndCheckForValidResponse(future, rider);
            return future.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof EntityNotFoundException) {
                throw (EntityNotFoundException)((Object)e.getCause());
            }
            throw new ServerInternalErrorException(e);
        }
        catch (InterruptedException e) {
            throw new ServerInternalErrorException(e);
        }
    }

    @Override
    public IAnnuity createAnnuity(IAnnuity ann) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        Future<IAnnuity> future = this.remote.createAnnuity(ann);
        try {
            this.waitAndCheckForValidResponse(future, ann);
            return future.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof EntityAlreadyExistsException) {
                throw (EntityAlreadyExistsException)((Object)e.getCause());
            }
            throw new ServerInternalErrorException(e);
        }
        catch (InterruptedException e) {
            throw new ServerInternalErrorException(e);
        }
    }

    @Override
    public IAnnuityHolder createAnnuityHolder(IAnnuityHolder annHolder) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        Future<IAnnuityHolder> future = this.remote.createAnnuityHolder(annHolder);
        try {
            this.waitAndCheckForValidResponse(future, annHolder);
            return future.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof EntityAlreadyExistsException) {
                throw (EntityAlreadyExistsException)((Object)e.getCause());
            }
            throw new ServerInternalErrorException(e);
        }
        catch (InterruptedException e) {
            throw new ServerInternalErrorException(e);
        }
    }

    @Override
    public IContact createContact(IContact contact) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        Future<IContact> future = this.remote.createContact(contact);
        try {
            this.waitAndCheckForValidResponse(future, contact);
            return future.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof EntityAlreadyExistsException) {
                throw (EntityAlreadyExistsException)((Object)e.getCause());
            }
            throw new ServerInternalErrorException(e);
        }
        catch (InterruptedException e) {
            throw new ServerInternalErrorException(e);
        }
    }

    @Override
    public IPayor createPayor(IPayor payor) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        Future<IPayor> future = this.remote.createPayor(payor);
        try {
            this.waitAndCheckForValidResponse(future, payor);
            return future.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof EntityAlreadyExistsException) {
                throw (EntityAlreadyExistsException)((Object)e.getCause());
            }
            throw new ServerInternalErrorException(e);
        }
        catch (InterruptedException e) {
            throw new ServerInternalErrorException(e);
        }
    }

    @Override
    public void deleteAnnuity(IAnnuity annuity) throws ServerInternalErrorException, InvalidArgumentException {
        this.remote.deleteAnnuity(annuity);
        this.waitForDelete(annuity);
    }

    @Override
    public void deleteAnnuityHolder(IAnnuityHolder annHolder) throws ServerInternalErrorException, InvalidArgumentException {
        this.remote.deleteAnnuityHolder(annHolder);
        this.waitForDelete(annHolder);
    }

    @Override
    public void deleteContact(IContact contact) throws ServerInternalErrorException, InvalidArgumentException {
        this.remote.deleteContact(contact);
        this.waitForDelete(contact);
    }

    @Override
    public void deletePayor(IPayor payor) throws ServerInternalErrorException, InvalidArgumentException {
        this.remote.deletePayor(payor);
        this.waitForDelete(payor);
    }

    @Override
    public void deletePayout(IPayout payout) throws ServerInternalErrorException, InvalidArgumentException {
        this.remote.deletePayout(payout);
        this.waitForDelete(payout);
    }

    @Override
    public void deleteRider(IRider rider) throws ServerInternalErrorException, InvalidArgumentException {
        this.remote.deleteRider(rider);
        this.waitForDelete(rider);
    }

    @Override
    public IAnnuity updateAnnuity(IAnnuity ann) throws ServerInternalErrorException, InvalidArgumentException {
        Future<IAnnuity> future = this.remote.updateAnnuity(ann);
        try {
            this.waitAndCheckForValidResponse(future, ann);
            return future.get();
        }
        catch (ExecutionException e) {
            throw new ServerInternalErrorException(e);
        }
        catch (InterruptedException e) {
            throw new ServerInternalErrorException(e);
        }
    }

    @Override
    public IAnnuityHolder updateAnnuityHolder(IAnnuityHolder annHolder) throws ServerInternalErrorException, InvalidArgumentException {
        Future<IAnnuityHolder> future = this.remote.updateAnnuityHolder(annHolder);
        try {
            this.waitAndCheckForValidResponse(future, annHolder);
            return future.get();
        }
        catch (ExecutionException e) {
            throw new ServerInternalErrorException(e);
        }
        catch (InterruptedException e) {
            throw new ServerInternalErrorException(e);
        }
    }

    @Override
    public IContact updateContact(IContact contact) throws ServerInternalErrorException, InvalidArgumentException {
        Future<IContact> future = this.remote.updateContact(contact);
        try {
            this.waitAndCheckForValidResponse(future, contact);
            return future.get();
        }
        catch (ExecutionException e) {
            throw new ServerInternalErrorException(e);
        }
        catch (InterruptedException e) {
            throw new ServerInternalErrorException(e);
        }
    }

    @Override
    public IPayor updatePayor(IPayor payor) throws ServerInternalErrorException, InvalidArgumentException {
        Future<IPayor> future = this.remote.updatePayor(payor);
        try {
            this.waitAndCheckForValidResponse(future, payor);
            return future.get();
        }
        catch (ExecutionException e) {
            throw new ServerInternalErrorException(e);
        }
        catch (InterruptedException e) {
            throw new ServerInternalErrorException(e);
        }
    }

    @Override
    public List<IAnnuity> findPayorAnnuities(IPayor payor) throws ServerInternalErrorException, InvalidArgumentException {
        Future<List<IAnnuity>> future = this.remote.findPayorAnnuities(payor);
        try {
            this.waitAndCheckForValidResponse(future, payor);
            return future.get();
        }
        catch (ExecutionException e) {
            throw new ServerInternalErrorException(e);
        }
        catch (InterruptedException e) {
            throw new ServerInternalErrorException(e);
        }
    }

    @Override
    public IPayout createPayout(IPayout payout) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        Future<IPayout> future = this.remote.createPayout(payout);
        try {
            this.waitAndCheckForValidResponse(future, payout);
            return future.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof EntityAlreadyExistsException) {
                throw (EntityAlreadyExistsException)((Object)e.getCause());
            }
            throw new ServerInternalErrorException(e);
        }
        catch (InterruptedException e) {
            throw new ServerInternalErrorException(e);
        }
    }

    @Override
    public IPayout updatePayout(IPayout payout) throws ServerInternalErrorException, InvalidArgumentException {
        Future<IPayout> future = this.remote.updatePayout(payout);
        try {
            this.waitAndCheckForValidResponse(future, payout);
            return future.get();
        }
        catch (ExecutionException e) {
            throw new ServerInternalErrorException(e);
        }
        catch (InterruptedException e) {
            throw new ServerInternalErrorException(e);
        }
    }

    private void waitForDelete(Configrable<String, String> configrable) throws ServerInternalErrorException {
        if (this.isFireForgetVerificationEnabled(configrable)) {
            long waitTime = this.getFireForgetWaitTime(configrable);
            try {
                Thread.sleep(waitTime);
                this.logger.fine("Waiting for Fire and Forget delete...");
            }
            catch (InterruptedException e) {
                throw new ServerInternalErrorException(e);
            }
        }
    }

    private long getFireForgetWaitTime(Configrable<String, String> configrable) {
        long waitTime;
        try {
            if (configrable.getConfiguration().getParameterValue((Object)FIRE_FORGET_VERIFY_WAIT_KEY) == null) {
                throw new InvalidArgumentException();
            }
            if (Long.parseLong((String)configrable.getConfiguration().getParameterValue((Object)FIRE_FORGET_VERIFY_WAIT_KEY)) < 0L) {
                throw new InvalidArgumentException();
            }
            waitTime = Long.parseLong((String)configrable.getConfiguration().getParameterValue((Object)FIRE_FORGET_VERIFY_WAIT_KEY));
        }
        catch (Exception e) {
            this.logger.info("Invalid Configuration. The parameter fireAndForgetWait is not a valid value or not specified.");
            this.logger.info("Will be using the default value forfireAndForgetWait: 2000");
            waitTime = 2000L;
        }
        return waitTime;
    }

    private boolean isFireForgetVerificationEnabled(Configrable<String, String> configrable) {
        try {
            if (configrable.getConfiguration().getParameterValue((Object)FIRE_FORGET_VERIFY_ENABLED_KEY) == null) {
                throw new InvalidArgumentException();
            }
            return Boolean.parseBoolean((String)configrable.getConfiguration().getParameterValue((Object)FIRE_FORGET_VERIFY_ENABLED_KEY));
        }
        catch (Exception ex) {
            this.logger.info("Invalid Configuration.  The parameter fireAndForgetVerify is not a valid value or not specified.");
            this.logger.info("Will be using the default value forfireAndForgetVerifytrue");
            return true;
        }
    }

    private void waitForResponse(Future<?> future, Configrable<String, String> configrable) throws ServerInternalErrorException, InterruptedException {
        long cntr = 0L;
        Long waitTime = 1L;
        Long waitCount = 100L;
        if (configrable != null && configrable.getConfiguration() != null) {
            try {
                if (configrable.getConfiguration().getParameterValue((Object)ASYNCH_METHOD_WAIT) != null && (waitTime = Long.valueOf(Long.parseLong((String)configrable.getConfiguration().getParameterValue((Object)ASYNCH_METHOD_WAIT)))) <= 0L) {
                    waitTime = 100L;
                    throw new InvalidConfigurationException();
                }
                if (configrable.getConfiguration().getParameterValue((Object)ASYNCH_METHOD_WAIT_COUNT) != null && (waitCount = Long.valueOf(Long.parseLong((String)configrable.getConfiguration().getParameterValue((Object)ASYNCH_METHOD_WAIT_COUNT)))) <= 0L) {
                    waitCount = 100L;
                    throw new InvalidConfigurationException();
                }
            }
            catch (Exception e) {
                this.logger.fine("Invalid Configuration.  asynchMethodWait or asynchMethodWaitCount are not valid values.current values are: asynchMethodWait: " + (String)configrable.getConfiguration().getParameterValue((Object)ASYNCH_METHOD_WAIT) + ASYNCH_METHOD_WAIT_COUNT + ": " + (String)configrable.getConfiguration().getParameterValue((Object)ASYNCH_METHOD_WAIT_COUNT));
            }
            while (cntr <= waitCount) {
                if (future.isDone()) {
                    return;
                }
                this.logger.fine("waiting for Asynchronous work ... wait count: " + cntr);
                ++cntr;
                Thread.sleep(waitTime);
            }
        } else {
            this.logger.info("Object: " + configrable + " or it's configration is null!");
        }
    }

    private void waitAndCheckForValidResponse(Future<?> future, Configrable<String, String> configrable) throws ServerInternalErrorException, InterruptedException, ExecutionException {
        this.waitForResponse(future, configrable);
        if (future.isDone()) {
            if (future.get() == null) {
                throw new ServerInternalErrorException("The server responded with a null object.  Expected either an error or a non-null object.");
            }
        } else {
            throw new ServerInternalErrorException("The server did not respond in in the expected time.wait values are:asynchMethodWait:" + (String)configrable.getConfiguration().getParameterValue((Object)ASYNCH_METHOD_WAIT) + " and " + ASYNCH_METHOD_WAIT_COUNT + ": " + (String)configrable.getConfiguration().getParameterValue((Object)ASYNCH_METHOD_WAIT_COUNT) + " was waiting for Future object: " + future.getClass().getName());
        }
    }

    private void getAsyncTimout(Configrable<String, String> configrable) {
        String asynchTimeoutStringValue = (String)configrable.getConfiguration().getParameterValue((Object)ASYNCH_TIMEOUT_VALUE);
        if (asynchTimeoutStringValue != null && asynchTimeoutStringValue.trim().length() > 0) {
            this.remoteAsynchTimeout = StringUtils.toInt((String)asynchTimeoutStringValue);
            this.logger.fine("Setting remoteAsynchTimeout = " + this.remoteAsynchTimeout);
        }
    }
}

