/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ifix.installer;

import com.ibm.ws.ifix.installer.IFixContentRepository;
import com.ibm.ws.ifix.installer.IFixFeatureDefinitionImpl;
import com.ibm.ws.ifix.installer.IFixManifestProcessor;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.feature.provisioning.FeatureResource;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.provisioning.BundleRepositoryRegistry;
import com.ibm.ws.kernel.provisioning.ContentBasedLocalBundleRepository;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;
import wlp.lib.extract.ExtractProgress;
import wlp.lib.extract.LicenseProvider;
import wlp.lib.extract.ReturnCode;
import wlp.lib.extract.SelfExtract;
import wlp.lib.extract.SelfExtractUtils;
import wlp.lib.extract.SelfExtractor;

public class IFixExtractor
extends SelfExtractor {
    private PrintWriter log;
    boolean writtenContent = false;
    String fixID = "";

    public IFixExtractor(JarFile jar, LicenseProvider licenseProvider, Attributes attributes) {
        super(jar, licenseProvider, attributes);
    }

    private boolean isIFixContent(ZipEntry ze, IFixManifestProcessor mfp) {
        String name = ze.getName();
        return !ze.isDirectory() && !name.equals("META-INF/MANIFEST.MF") && !name.startsWith("com/") && !name.startsWith("wlp/") && !name.startsWith("org/") && !mfp.isIfixManifestRelatedFile(name);
    }

    private boolean isSatisfied(ProvisioningFeatureDefinition test, Set<ProvisioningFeatureDefinition> testSet, String installRoot, IFixContentRepository ifixRepo) {
        BundleRepositoryRegistry.BundleRepositoryHolder brh = BundleRepositoryRegistry.getRepositoryHolder(test.getBundleRepositoryType());
        ContentBasedLocalBundleRepository br = brh.getBundleRepository();
        Collection<FeatureResource> resources = test.getConstituents(null);
        boolean good = true;
        block5: for (FeatureResource fr : resources) {
            switch (fr.getType()) {
                case FEATURE_TYPE: {
                    boolean found = false;
                    for (ProvisioningFeatureDefinition fd : testSet) {
                        if (fd.getSymbolicName().equals(fr.getSymbolicName()) && fr.getVersionRange().includes(fd.getVersion())) continue;
                        found = true;
                        break;
                    }
                    if (found) break;
                    good = false;
                    break;
                }
                case BUNDLE_TYPE: 
                case JAR_TYPE: 
                case BOOT_JAR_TYPE: {
                    fr.getBundleRepositoryType();
                    File b = br.selectBundle(fr.getLocation(), fr.getSymbolicName(), fr.getVersionRange());
                    File bb = br.selectBaseBundle(fr.getLocation(), fr.getSymbolicName(), fr.getVersionRange());
                    if (b != null || bb != null) continue block5;
                    ifixRepo.containsBundle(fr.getLocation(), fr.getSymbolicName(), fr.getVersionRange());
                    break;
                }
                case FILE_TYPE: {
                    String loc;
                    String locString = fr.getLocation();
                    if (locString == null) break;
                    String[] locs = locString.contains(",") ? locString.split(",") : new String[]{locString};
                    boolean found = false;
                    String[] stringArray = locs;
                    int n = locs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        loc = stringArray[n2];
                        File testFile = new File(loc);
                        if (!testFile.isAbsolute()) {
                            testFile = new File(installRoot, loc);
                        }
                        if (testFile.exists()) {
                            found = true;
                            break;
                        }
                        ++n2;
                    }
                    if (!found) {
                        stringArray = locs;
                        n = locs.length;
                        n2 = 0;
                        while (n2 < n) {
                            loc = stringArray[n2];
                            if (this.jarFile.getEntry(loc) != null) {
                                found = true;
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (found) break;
                    good = false;
                }
            }
        }
        return good;
    }

    private ReturnCode writeOut(File installRoot, ZipEntry ze, ExtractProgress ep) {
        return this.writeOut(installRoot, ze, ep, true);
    }

    private ReturnCode writeOut(File installRoot, ZipEntry ze, ExtractProgress ep, boolean isNotMetadata) {
        File file = null;
        file = new File(installRoot, ze.getName());
        File parent = file.getParentFile();
        if (!parent.mkdirs() && !parent.exists()) {
            this.log("Unable to write " + file.getAbsolutePath() + " as parent directory did not exist and could not be created successfully");
            return new ReturnCode(4, "extractFileError", new FileNotFoundException(parent.getAbsolutePath()).getMessage());
        }
        byte[] buf = new byte[4096];
        BufferedOutputStream os = null;
        InputStream is = null;
        try {
            try {
                int read;
                os = new BufferedOutputStream(new FileOutputStream(file, false));
                is = this.jarFile.getInputStream(ze);
                while ((read = is.read(buf)) != -1) {
                    ((OutputStream)os).write(buf, 0, read);
                }
            }
            catch (IOException ioe) {
                this.log("IOException occurred while writing " + file.getAbsolutePath() + " " + ioe.getMessage());
                SelfExtractUtils.tryToClose(os);
                SelfExtractUtils.tryToClose(is);
                System.err.println(SelfExtract.format("patchFailed"));
                System.err.println(SelfExtract.format("restoreBackupsNeeded"));
                ReturnCode returnCode = new ReturnCode(4, "extractFileError", ioe.getMessage());
                SelfExtractUtils.tryToClose(os);
                SelfExtractUtils.tryToClose(is);
                return returnCode;
            }
        }
        catch (Throwable throwable) {
            SelfExtractUtils.tryToClose(os);
            SelfExtractUtils.tryToClose(is);
            throw throwable;
        }
        SelfExtractUtils.tryToClose(os);
        SelfExtractUtils.tryToClose(is);
        if (ep != null && isNotMetadata) {
            ep.extractedFile(ze.getName());
        }
        if (isNotMetadata) {
            this.writtenContent = true;
        }
        return null;
    }

    private ReturnCode processContent(File installRoot, ZipEntry ze, Set<ProvisioningFeatureDefinition> testSet, Set<IFixFeatureDefinitionImpl> ifixSet, IFixContentRepository ifixRepo, ExtractProgress ep) {
        String name = ze.getName();
        if (name.startsWith("lib/fixes") || name.startsWith("lib/versions")) {
            this.log("Ifix Metadata auto approved for delivery to runtime : " + name);
            ReturnCode rc = this.writeOut(installRoot, ze, ep, false);
            return rc;
        }
        if (ifixRepo.isStaticContent(name)) {
            File test = new File(installRoot, name);
            if (test.exists()) {
                this.log("Pre-existing static content being replaced : " + name);
                return this.writeOut(installRoot, ze, ep);
            }
            boolean found = false;
            for (ProvisioningFeatureDefinition fd : testSet) {
                Collection<FeatureResource> resources = fd.getConstituents(null);
                for (FeatureResource fr : resources) {
                    block0 : switch (fr.getType()) {
                        case JAR_TYPE: 
                        case FILE_TYPE: 
                        case BOOT_JAR_TYPE: {
                            String locString = fr.getLocation();
                            if (locString == null) break;
                            String[] locs = locString.contains(",") ? locString.split(",") : new String[]{locString};
                            found = false;
                            String[] stringArray = locs;
                            int n = locs.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String loc = stringArray[n2];
                                File loctest = new File(installRoot, loc);
                                if (loc.equals(name) || (loctest.exists() && loctest.isDirectory() || !loctest.exists()) && name.startsWith(loc)) {
                                    this.log("Static content " + name + " found owned by ifix feature " + fd);
                                    found = true;
                                    break block0;
                                }
                                ++n2;
                            }
                            break;
                        }
                    }
                    if (found) break;
                }
                if (found) break;
            }
            if (found) {
                return this.writeOut(installRoot, ze, ep);
            }
            this.log("Static content " + name + " skipped as not pre-existing, and no features claimed ownership");
        } else {
            int idx = name.lastIndexOf(47);
            String location = idx == -1 ? "" : name.substring(0, idx);
            if (!location.endsWith("/")) {
                location = String.valueOf(location) + "/";
            }
            String symbolicName = ifixRepo.getSymbolicName(name);
            String version = ifixRepo.getVersion(name);
            boolean found = false;
            for (BundleRepositoryRegistry.BundleRepositoryHolder brh : BundleRepositoryRegistry.holders()) {
                ContentBasedLocalBundleRepository cblbr = brh.getBundleRepository();
                Version trimmedVersion = Version.parseVersion(version);
                String trimmedVersionString = new Version(trimmedVersion.getMajor(), trimmedVersion.getMinor(), trimmedVersion.getMicro()).toString();
                String trimmedVersionUpperString = new Version(trimmedVersion.getMajor(), trimmedVersion.getMinor(), trimmedVersion.getMicro() + 1).toString();
                VersionRange vr = new VersionRange("[" + trimmedVersionString + "," + trimmedVersionUpperString + ")");
                File f = cblbr.selectBaseBundle(location, symbolicName, vr);
                if (f == null) continue;
                this.log("IFix Bundle content " + name + " found to have valid base content in runtime " + f.getAbsolutePath());
                found = true;
                break;
            }
            if (!found && ifixRepo.containsBaseBundle(location, symbolicName, version)) {
                for (ProvisioningFeatureDefinition fd : testSet) {
                    Collection<FeatureResource> resources = fd.getConstituents(null);
                    for (FeatureResource fr : resources) {
                        switch (fr.getType()) {
                            case BUNDLE_TYPE: 
                            case JAR_TYPE: 
                            case BOOT_JAR_TYPE: {
                                if (fr.getSymbolicName() == null || fr.getVersionRange() == null || !symbolicName.equals(fr.getSymbolicName()) || !fr.getVersionRange().includes(Version.parseVersion(version))) break;
                                this.log("IFix Bundle content " + name + " found to have valid base content in ifix");
                                found = true;
                            }
                        }
                        if (found) break;
                    }
                    if (found) break;
                }
            }
            if (found) {
                return this.writeOut(installRoot, ze, ep);
            }
            this.log("Content was skipped as not owned by any runtime/ifix feature " + name);
        }
        return null;
    }

    private ReturnCode processIfixManifestsAndRelatedFiles(File installRoot, Set<IFixFeatureDefinitionImpl> ifixSet, ExtractProgress ep) {
        String name;
        HashSet<String> allowedFeatureManifestsAndCheckSumFiles = new HashSet<String>();
        HashSet<String> allowedFeatureLocalizationResourcePrefixes = new HashSet<String>();
        for (IFixFeatureDefinitionImpl ifixFeature : ifixSet) {
            name = ifixFeature.getName();
            allowedFeatureManifestsAndCheckSumFiles.add(name.toLowerCase());
            String cs = String.valueOf(name.substring(0, name.length() - IFixManifestProcessor.CS_EXTENSION.length())) + IFixManifestProcessor.CS_EXTENSION;
            allowedFeatureManifestsAndCheckSumFiles.add(cs.toLowerCase());
            String fprefix = "lib/features/l10n/" + ifixFeature.getSymbolicName();
            String pprefix = "lib/platform/l10n/" + ifixFeature.getSymbolicName();
            allowedFeatureLocalizationResourcePrefixes.add(fprefix);
            allowedFeatureLocalizationResourcePrefixes.add(pprefix);
        }
        Enumeration<? extends ZipEntry> entries = this.jarFile.entries();
        while (entries.hasMoreElements()) {
            ReturnCode rc;
            ZipEntry ze = entries.nextElement();
            name = ze.getName();
            boolean write = false;
            if (allowedFeatureManifestsAndCheckSumFiles.contains(name.toLowerCase())) {
                this.log("Writing allowed Feature Manifest/Checksum File : " + name);
                write = true;
            } else {
                for (String prefix : allowedFeatureLocalizationResourcePrefixes) {
                    if (!name.startsWith(prefix)) continue;
                    this.log("Writing allowed Feature Localization Resource " + name);
                    write = true;
                    break;
                }
            }
            if (!write || (rc = this.writeOut(installRoot, ze, ep)) == null) continue;
            return rc;
        }
        return null;
    }

    @Override
    public ReturnCode extract(File wlpInstallDir, ExtractProgress ep) {
        boolean bl;
        IFixContentRepository cr;
        if (ep != null) {
            System.out.println(SelfExtract.format("patchingStarted", wlpInstallDir));
        }
        HashSet<ProvisioningFeatureDefinition> theSet = new HashSet<ProvisioningFeatureDefinition>();
        HashSet<IFixFeatureDefinitionImpl> ifixSet = new HashSet<IFixFeatureDefinitionImpl>();
        HashSet<ProvisioningFeatureDefinition> temporarySet = new HashSet<ProvisioningFeatureDefinition>();
        try {
            Field idf = Utils.class.getDeclaredField("installDir");
            idf.setAccessible(true);
            idf.set(null, wlpInstallDir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BundleRepositoryRegistry.initializeDefaults(null, false);
        IFixManifestProcessor mfp = new IFixManifestProcessor();
        try {
            cr = new IFixContentRepository(this.jarFile);
        }
        catch (Exception e1) {
            return new ReturnCode(2, "fileProcessingException", new Object[]{"lib/fixes/*lpmf", e1.getMessage()});
        }
        this.fixID = cr.getIfixIdentifier();
        File logFile = new File(wlpInstallDir, "lib/fixes/fixinstall.log");
        File parent = logFile.getParentFile();
        if (!parent.mkdirs() && !parent.exists()) {
            this.log("Unable to write " + logFile.getAbsolutePath() + " as parent directory did not exist and could not be created successfully");
            return new ReturnCode(4, "extractFileError", new FileNotFoundException(parent.getAbsolutePath()).getMessage());
        }
        try {
            this.log = new PrintWriter(new FileWriter(logFile, true));
            this.log("--------------- Ifix Install start.");
        }
        catch (IOException io) {
            return new ReturnCode(2, "fileProcessingException", new Object[]{logFile.getAbsolutePath(), io.getMessage()});
        }
        Map<String, ProvisioningFeatureDefinition> allFeatures = mfp.getFeatureDefinitions();
        theSet.addAll(allFeatures.values());
        Enumeration<? extends ZipEntry> entries = this.jarFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry ze = entries.nextElement();
            if (!mfp.isIfixManifestFileName(ze.getName())) continue;
            try {
                IFixFeatureDefinitionImpl iFixFeatureDefinitionImpl = mfp.getFeatureDefinitionForManifest(this.jarFile.getInputStream(ze), ze.getName());
                if (iFixFeatureDefinitionImpl == null) continue;
                ifixSet.add(iFixFeatureDefinitionImpl);
            }
            catch (IOException iOException) {
                return new ReturnCode(2, "fileProcessingException", new Object[]{String.valueOf(this.jarFile.getName()) + ":" + ze.getName(), iOException.getMessage()});
            }
        }
        this.log("Known Features : " + theSet);
        this.log("Features known to IFix : " + ifixSet);
        HashSet<ProvisioningFeatureDefinition> toRemove = new HashSet<ProvisioningFeatureDefinition>();
        for (ProvisioningFeatureDefinition provisioningFeatureDefinition : ifixSet) {
            boolean found = false;
            for (ProvisioningFeatureDefinition runtimeFd : theSet) {
                if (!runtimeFd.getSymbolicName().equals(provisioningFeatureDefinition.getSymbolicName()) || !runtimeFd.getVersion().equals(provisioningFeatureDefinition.getVersion())) continue;
                found = true;
                break;
            }
            if (found) continue;
            toRemove.add(provisioningFeatureDefinition);
        }
        this.log("Features in IFix removed as not found in runtime : " + toRemove);
        ifixSet.removeAll(toRemove);
        toRemove.clear();
        this.log("Features considered relevant in IFix : " + ifixSet);
        boolean bl2 = false;
        while (!bl && !ifixSet.isEmpty()) {
            bl = true;
            temporarySet = new HashSet();
            temporarySet.addAll(theSet);
            temporarySet.addAll(ifixSet);
            toRemove.clear();
            for (ProvisioningFeatureDefinition provisioningFeatureDefinition : ifixSet) {
                if (this.isSatisfied(provisioningFeatureDefinition, temporarySet, wlpInstallDir.getAbsolutePath(), cr)) continue;
                toRemove.add(provisioningFeatureDefinition);
                bl = false;
            }
            ifixSet.removeAll(toRemove);
        }
        this.log("Features in IFix considered satisfied : " + ifixSet);
        toRemove.clear();
        for (ProvisioningFeatureDefinition provisioningFeatureDefinition : theSet) {
            boolean found = false;
            for (ProvisioningFeatureDefinition provisioningFeatureDefinition2 : ifixSet) {
                if (!provisioningFeatureDefinition.getSymbolicName().equals(provisioningFeatureDefinition2.getSymbolicName()) || !provisioningFeatureDefinition.getVersion().equals(provisioningFeatureDefinition2.getVersion())) continue;
                found = true;
                break;
            }
            if (!found) continue;
            toRemove.add(provisioningFeatureDefinition);
        }
        theSet.removeAll(toRemove);
        this.log("Features relevant in runtime after removal of satisifed ifix features : " + theSet);
        temporarySet.clear();
        temporarySet.addAll(theSet);
        temporarySet.addAll(ifixSet);
        this.log("Satisfied Features in runtime and IFix : " + temporarySet);
        entries = this.jarFile.entries();
        while (entries.hasMoreElements()) {
            ReturnCode rc;
            ZipEntry zipEntry = entries.nextElement();
            if (!this.isIFixContent(zipEntry, mfp) || (rc = this.processContent(wlpInstallDir, zipEntry, temporarySet, ifixSet, cr, ep)) == null) continue;
            return rc;
        }
        this.log("Installing ifix feature manifests and related files : " + ifixSet);
        ReturnCode returnCode = this.processIfixManifestsAndRelatedFiles(wlpInstallDir, ifixSet, ep);
        if (returnCode != null) {
            this.log("Error writing feature manifests & related files.");
            return returnCode;
        }
        ReturnCode rc2 = this.fixScriptPermissions(ep, wlpInstallDir, this.jarFile);
        if (rc2 != null) {
            this.log("Error changing permissions of scripts from the ifix jar.");
            return rc2;
        }
        if (!this.writtenContent) {
            this.log("No Ifix Content was written to the runtime.");
            System.out.println(SelfExtract.format("patchingNotApplicableWithFix", new Object[]{wlpInstallDir, this.fixID}));
        }
        try {
            File f = new File(wlpInstallDir, "lib/versions/service.fingerprint");
            FileWriter fileWriter = new FileWriter(f, false);
            String data = "" + System.nanoTime();
            fileWriter.append(data);
            fileWriter.close();
            this.log("Updated service.fingerprint to " + data);
        }
        catch (IOException io) {
            this.log("Error updating fingerprint");
            return new ReturnCode(4, "fileProcessingException", new Object[]{new File(wlpInstallDir, "lib/versions/service.fingerprint").getAbsolutePath(), io.getMessage()});
        }
        if (ep != null) {
            System.out.println(SelfExtract.format("patchingSuccessful"));
        }
        this.log("--------------- Ifix Install end.");
        return ReturnCode.OK;
    }

    @Override
    public void parseArguments(String[] args, boolean archiveHasLicense) {
        SelfExtract.setVerbose(true);
        int i = 0;
        while (i < args.length) {
            String arg = args[i].trim().toLowerCase(Locale.ENGLISH);
            if (arg.startsWith("-")) {
                if (IFixExtractor.argIsOption(arg, "-installLocation")) {
                    if (i + 1 < args.length) {
                        SelfExtract.setTargetString(args[i + 1]);
                    }
                } else if (IFixExtractor.argIsOption(arg, "-help")) {
                    IFixExtractor.displayCommandLineHelp(this);
                    System.exit(0);
                } else if (IFixExtractor.argIsOption(arg, "-suppressInfo")) {
                    SelfExtract.setVerbose(false);
                } else {
                    System.out.println("\n" + SelfExtract.format("invalidOption", arg));
                    IFixExtractor.displayCommandLineHelp(this);
                    System.exit(0);
                }
            } else {
                SelfExtract.setTargetString(args[i]);
            }
            ++i;
        }
    }

    private static void displayCommandLineHelp(SelfExtractor extractor) {
        String jarName = System.getProperty("sun.java.command", "ifix.jar");
        String[] s = jarName.split(" ");
        jarName = s[0];
        System.out.println("\n" + SelfExtract.format("helpMakeBackups") + "\n");
        System.out.println("\n" + SelfExtract.format("usage"));
        System.out.println("\njava -jar " + jarName + " [" + SelfExtract.format("options") + "] \n");
        System.out.println(SelfExtract.format("options"));
        System.out.println("    --installLocation ");
        System.out.println("        " + SelfExtract.format("helpInstallLocation"));
        System.out.println("    --suppressInfo");
        System.out.println("        " + SelfExtract.format("helpSupressInfo"));
    }

    public static DateFormat getDateFormat() {
        DateFormat formatter = DateFormat.getDateTimeInstance(3, 2);
        if (formatter instanceof SimpleDateFormat) {
            SimpleDateFormat sdFormatter = (SimpleDateFormat)formatter;
            String pattern = sdFormatter.toPattern();
            int patternLength = pattern.length();
            int endOfSecsIndex = pattern.lastIndexOf(115) + 1;
            String newPattern = String.valueOf(pattern.substring(0, endOfSecsIndex)) + ":SSS z";
            if (endOfSecsIndex < patternLength) {
                newPattern = String.valueOf(newPattern) + pattern.substring(endOfSecsIndex, patternLength);
            }
            newPattern = newPattern.replace('h', 'H');
            newPattern = newPattern.replace('K', 'H');
            newPattern = newPattern.replace('k', 'H');
            newPattern = newPattern.replace('a', ' ');
            newPattern = newPattern.trim();
            sdFormatter.applyPattern(newPattern);
            formatter = sdFormatter;
        } else {
            formatter = new SimpleDateFormat("yy.MM.dd HH:mm:ss:SSS z");
        }
        return formatter;
    }

    private void log(String message) {
        Date d = new Date();
        String dateString = IFixExtractor.getDateFormat().format(d);
        this.log.println("[" + dateString + "] " + this.fixID + " " + message);
        this.log.flush();
    }
}

