/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.cmdline;

import com.ibm.ws.kernel.boot.cmdline.UtilityMain;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.zip.ZipFile;

public class Utils {
    private static File installDir;
    private static File userDir;
    private static File outputDir;
    private static ResourceBundle cmdlineResourceBundle;

    public static File getInstallDir() {
        URL url;
        if (installDir == null && (url = UtilityMain.class.getProtectionDomain().getCodeSource().getLocation()).getProtocol().equals("file")) {
            try {
                File f = new File(url.toURI());
                installDir = f.getParentFile().getParentFile();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return installDir;
    }

    public static File getUserDir() {
        if (userDir == null) {
            String userDirLoc = System.getenv("WLP_USER_DIR");
            if (userDirLoc != null) {
                userDir = new File(userDirLoc);
            } else {
                File installDir = Utils.getInstallDir();
                if (installDir != null) {
                    userDir = new File(installDir, "usr");
                }
            }
        }
        return userDir;
    }

    public static File getOutputDir() {
        if (outputDir == null) {
            String outputDirLoc = System.getenv("WLP_OUTPUT_DIR");
            if (outputDirLoc != null) {
                outputDir = new File(outputDirLoc);
            } else {
                File userDir = Utils.getUserDir();
                if (userDir != null) {
                    outputDir = new File(userDir, "servers");
                }
            }
        }
        return outputDir;
    }

    public static File getServerOutputDir(String serverName) {
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName can not be 'null'");
        }
        File outputDir = Utils.getOutputDir();
        if (outputDir != null) {
            return new File(outputDir, serverName);
        }
        return Utils.getServerConfigDir(serverName);
    }

    public static File getServerConfigDir(String serverName) {
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName can not be 'null'");
        }
        File userDir = Utils.getUserDir();
        if (userDir != null) {
            return new File(new File(userDir, "servers"), serverName);
        }
        return null;
    }

    public static File getJavaTools() throws MalformedURLException {
        File javaHomeFile;
        File javaToolsFile = null;
        String javaHome = System.getProperty("java.home");
        if (javaHome != null && !javaHome.isEmpty() && (javaToolsFile = Utils.buildJavaToolsFile(javaHomeFile = new File(javaHome))) == null) {
            javaToolsFile = Utils.buildJavaToolsFile(javaHomeFile.getParentFile());
        }
        return javaToolsFile;
    }

    private static File buildJavaToolsFile(File javaHomeFile) {
        File javaLibFile = new File(javaHomeFile, "lib");
        File javaToolsFile = new File(javaLibFile, "tools.jar");
        return javaToolsFile.exists() && javaToolsFile.isFile() ? javaToolsFile : null;
    }

    public static boolean hasToolsByDefault() {
        try {
            Class.forName("com.sun.mirror.apt.AnnotationProcessorFactory");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static ResourceBundle getResourceBundle() {
        if (cmdlineResourceBundle == null) {
            cmdlineResourceBundle = ResourceBundle.getBundle("com.ibm.ws.kernel.boot.cmdline.resources.CommandLineMessages");
        }
        return cmdlineResourceBundle;
    }

    static String getResourceBundleString(String key) {
        ResourceBundle bundle = Utils.getResourceBundle();
        return bundle == null ? null : bundle.getString(key);
    }

    public static boolean tryToClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean tryToClose(ZipFile zipFile) {
        if (zipFile != null) {
            try {
                zipFile.close();
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }
}

