/*******************************************************************************
 * Copyright (c) 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.ibm.ejs.container;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;

import org.junit.Test;

public class BeanOSerializationTest
{
    /**
     * Ensure that CMStatelessBeanO can be deserialized.
     */
    @Test
    public void testCMStatelessBeanOSerialization()
                    throws Exception
    {
        // Serialized form of CMStatelessBeanO.  Created by executing the
        // following class using a 7.0 install:
        //         import java.io.FileOutputStream;
        //         import java.io.ObjectOutputStream;
        //         import com.ibm.ejs.container.CMStatelessBeanO;
        //         public class a {
        //           public static void main(String[] args) throws Exception {
        //             ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream("a.ser"));
        //             oos.writeObject(new CMStatelessBeanO(null, null, null));
        //           }
        //         }
        int[] byteInts = new int[] {
                                    0xac, 0xed, 0x00, 0x05, 0x73, 0x72, 0x00, 0x26, 0x63, 0x6f, 0x6d, 0x2e, 0x69, 0x62, 0x6d, 0x2e,
                                    0x65, 0x6a, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x43, 0x4d,
                                    0x53, 0x74, 0x61, 0x74, 0x65, 0x6c, 0x65, 0x73, 0x73, 0x42, 0x65, 0x61, 0x6e, 0x4f, 0x5a, 0xf2,
                                    0x6e, 0x17, 0x5a, 0x40, 0xc7, 0x66, 0x02, 0x00, 0x00, 0x78, 0x72, 0x00, 0x24, 0x63, 0x6f, 0x6d,
                                    0x2e, 0x69, 0x62, 0x6d, 0x2e, 0x65, 0x6a, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
                                    0x65, 0x72, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6c, 0x65, 0x73, 0x73, 0x42, 0x65, 0x61, 0x6e,
                                    0x4f, 0xdd, 0x6b, 0x66, 0x8a, 0x09, 0x36, 0xa1, 0x47, 0x02, 0x00, 0x04, 0x5a, 0x00, 0x11, 0x61,
                                    0x6c, 0x6c, 0x6f, 0x77, 0x52, 0x6f, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x4f, 0x6e, 0x6c, 0x79,
                                    0x5a, 0x00, 0x09, 0x64, 0x69, 0x73, 0x63, 0x61, 0x72, 0x64, 0x65, 0x64, 0x5a, 0x00, 0x0c, 0x70,
                                    0x72, 0x65, 0x49, 0x6e, 0x76, 0x6f, 0x6b, 0x65, 0x64, 0x48, 0x43, 0x5a, 0x00, 0x09, 0x72, 0x65,
                                    0x65, 0x6e, 0x74, 0x72, 0x61, 0x6e, 0x74, 0x78, 0x72, 0x00, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x69,
                                    0x62, 0x6d, 0x2e, 0x65, 0x6a, 0x73, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
                                    0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x65, 0x61, 0x6e, 0x4f, 0xd6, 0x79, 0xc9,
                                    0xe8, 0x07, 0xa6, 0x4a, 0x73, 0x02, 0x00, 0x05, 0x49, 0x00, 0x15, 0x63, 0x75, 0x72, 0x72, 0x65,
                                    0x6e, 0x74, 0x49, 0x73, 0x6f, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x65, 0x76, 0x65, 0x6c,
                                    0x4c, 0x00, 0x0e, 0x69, 0x76, 0x43, 0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x4b, 0x69, 0x6e,
                                    0x64, 0x74, 0x00, 0x26, 0x4c, 0x63, 0x6f, 0x6d, 0x2f, 0x69, 0x62, 0x6d, 0x2f, 0x77, 0x73, 0x2f,
                                    0x65, 0x6a, 0x62, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2f, 0x43, 0x61, 0x6c,
                                    0x6c, 0x62, 0x61, 0x63, 0x6b, 0x4b, 0x69, 0x6e, 0x64, 0x3b, 0x4c, 0x00, 0x0d, 0x69, 0x76, 0x45,
                                    0x6a, 0x62, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x74, 0x00, 0x12, 0x4c, 0x6a, 0x61,
                                    0x76, 0x61, 0x2f, 0x6c, 0x61, 0x6e, 0x67, 0x2f, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x3b, 0x5b,
                                    0x00, 0x0e, 0x69, 0x76, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x63, 0x65, 0x70, 0x74, 0x6f, 0x72, 0x73,
                                    0x74, 0x00, 0x13, 0x5b, 0x4c, 0x6a, 0x61, 0x76, 0x61, 0x2f, 0x6c, 0x61, 0x6e, 0x67, 0x2f, 0x4f,
                                    0x62, 0x6a, 0x65, 0x63, 0x74, 0x3b, 0x4c, 0x00, 0x0b, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
                                    0x42, 0x65, 0x61, 0x6e, 0x74, 0x00, 0x17, 0x4c, 0x6a, 0x61, 0x76, 0x61, 0x78, 0x2f, 0x65, 0x6a,
                                    0x62, 0x2f, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x65, 0x61, 0x6e, 0x3b, 0x78, 0x72,
                                    0x00, 0x1b, 0x63, 0x6f, 0x6d, 0x2e, 0x69, 0x62, 0x6d, 0x2e, 0x65, 0x6a, 0x73, 0x2e, 0x63, 0x6f,
                                    0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x42, 0x65, 0x61, 0x6e, 0x4f, 0xda, 0x40, 0x5c,
                                    0xf7, 0x07, 0xeb, 0xb7, 0x9e, 0x02, 0x00, 0x02, 0x49, 0x00, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
                                    0x4c, 0x00, 0x06, 0x62, 0x65, 0x61, 0x6e, 0x49, 0x64, 0x74, 0x00, 0x1e, 0x4c, 0x63, 0x6f, 0x6d,
                                    0x2f, 0x69, 0x62, 0x6d, 0x2f, 0x65, 0x6a, 0x73, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
                                    0x65, 0x72, 0x2f, 0x42, 0x65, 0x61, 0x6e, 0x49, 0x64, 0x3b, 0x78, 0x70, 0x00, 0x00, 0x00, 0x00,
                                    0x70, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x72, 0x00, 0x24, 0x63, 0x6f, 0x6d, 0x2e, 0x69, 0x62, 0x6d,
                                    0x2e, 0x77, 0x73, 0x2e, 0x65, 0x6a, 0x62, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
                                    0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x4b, 0x69, 0x6e, 0x64, 0x00, 0x00, 0x00,
                                    0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x78, 0x72, 0x00, 0x0e, 0x6a, 0x61, 0x76, 0x61,
                                    0x2e, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x45, 0x6e, 0x75, 0x6d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                    0x00, 0x00, 0x12, 0x00, 0x00, 0x78, 0x70, 0x74, 0x00, 0x04, 0x4e, 0x6f, 0x6e, 0x65, 0x70, 0x70,
                                    0x70, 0x00, 0x00, 0x00, 0x00,
        };
        byte[] bytes = new byte[byteInts.length];
        for (int i = 0; i < byteInts.length; i++)
        {
            bytes[i] = (byte) byteInts[i];
        }

        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = new ObjectInputStream(bais);
        ois.readObject();
    }
}
