/*******************************************************************************
 * Copyright (c) 2017 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
/* Generated By:JavaCC: Do not edit this line. WIMXPathInterpreterTokenManager.java */
package com.ibm.ws.security.wim.xpath;

import com.ibm.websphere.ras.annotation.Trivial;

@Trivial
public class WIMXPathInterpreterTokenManager implements
        WIMXPathInterpreterConstants {
    public java.io.PrintStream debugStream = System.out;

    public void setDebugStream(java.io.PrintStream ds) {
        debugStream = ds;
    }

    private final int jjStopStringLiteralDfa_0(int pos, long active0) {
        switch (pos) {
        case 0:
            if ((active0 & 0x1000L) != 0L) {
                jjmatchedKind = 14;
                return 32;
            }
            if ((active0 & 0x42L) != 0L) {
                jjmatchedKind = 14;
                return 64;
            }
            return -1;
        case 1:
            if ((active0 & 0x40L) != 0L)
                return 64;
            if ((active0 & 0x2L) != 0L) {
                jjmatchedKind = 14;
                jjmatchedPos = 1;
                return 64;
            }
            if ((active0 & 0x1000L) != 0L) {
                jjmatchedKind = 14;
                jjmatchedPos = 1;
                return 31;
            }
            return -1;
        case 2:
            if ((active0 & 0x2L) != 0L)
                return 64;
            if ((active0 & 0x1000L) != 0L) {
                jjmatchedKind = 14;
                jjmatchedPos = 2;
                return 64;
            }
            return -1;
        case 3:
            if ((active0 & 0x1000L) != 0L) {
                jjmatchedKind = 14;
                jjmatchedPos = 3;
                return 64;
            }
            return -1;
        case 4:
            if ((active0 & 0x1000L) != 0L) {
                jjmatchedKind = 14;
                jjmatchedPos = 4;
                return 64;
            }
            return -1;
        case 5:
            if ((active0 & 0x1000L) != 0L) {
                jjmatchedKind = 14;
                jjmatchedPos = 5;
                return 64;
            }
            return -1;
        case 6:
            if ((active0 & 0x1000L) != 0L) {
                jjmatchedKind = 14;
                jjmatchedPos = 6;
                return 64;
            }
            return -1;
        case 7:
            if ((active0 & 0x1000L) != 0L)
                return 64;
            return -1;
        default:
            return -1;
        }
    }

    private final int jjStartNfa_0(int pos, long active0) {
        return jjMoveNfa_0(jjStopStringLiteralDfa_0(pos, active0), pos + 1);
    }

    private final int jjStopAtPos(int pos, int kind) {
        jjmatchedKind = kind;
        jjmatchedPos = pos;
        return pos + 1;
    }

    private final int jjStartNfaWithStates_0(int pos, int kind, int state) {
        jjmatchedKind = kind;
        jjmatchedPos = pos;
        try {
            curChar = input_stream.readChar();
        } catch (java.io.IOException e) {
            return pos + 1;
        }
        return jjMoveNfa_0(state, pos + 1);
    }

    private final int jjMoveStringLiteralDfa0_0() {
        switch (curChar) {
        case 40:
            return jjStopAtPos(0, 2);
        case 41:
            return jjStopAtPos(0, 3);
        case 47:
            jjmatchedKind = 30;
            return jjMoveStringLiteralDfa1_0(0x80000000L);
        case 64:
            jjmatchedKind = 21;
            return jjMoveStringLiteralDfa1_0(0x80L);
        case 91:
            return jjStopAtPos(0, 4);
        case 93:
            return jjStopAtPos(0, 5);
        case 97:
            return jjMoveStringLiteralDfa1_0(0x2L);
        case 101:
            return jjMoveStringLiteralDfa1_0(0x1000L);
        case 111:
            return jjMoveStringLiteralDfa1_0(0x40L);
        default:
            return jjMoveNfa_0(9, 0);
        }
    }

    private final int jjMoveStringLiteralDfa1_0(long active0) {
        try {
            curChar = input_stream.readChar();
        } catch (java.io.IOException e) {
            jjStopStringLiteralDfa_0(0, active0);
            return 1;
        }
        switch (curChar) {
        case 47:
            if ((active0 & 0x80000000L) != 0L)
                return jjStopAtPos(1, 31);
            break;
        case 110:
            return jjMoveStringLiteralDfa2_0(active0, 0x1002L);
        case 114:
            if ((active0 & 0x40L) != 0L)
                return jjStartNfaWithStates_0(1, 6, 64);
            break;
        case 120:
            return jjMoveStringLiteralDfa2_0(active0, 0x80L);
        default:
            break;
        }
        return jjStartNfa_0(0, active0);
    }

    private final int jjMoveStringLiteralDfa2_0(long old0, long active0) {
        if (((active0 &= old0)) == 0L)
            return jjStartNfa_0(0, old0);
        try {
            curChar = input_stream.readChar();
        } catch (java.io.IOException e) {
            jjStopStringLiteralDfa_0(1, active0);
            return 2;
        }
        switch (curChar) {
        case 100:
            if ((active0 & 0x2L) != 0L)
                return jjStartNfaWithStates_0(2, 1, 64);
            break;
        case 115:
            return jjMoveStringLiteralDfa3_0(active0, 0x80L);
        case 116:
            return jjMoveStringLiteralDfa3_0(active0, 0x1000L);
        default:
            break;
        }
        return jjStartNfa_0(1, active0);
    }

    private final int jjMoveStringLiteralDfa3_0(long old0, long active0) {
        if (((active0 &= old0)) == 0L)
            return jjStartNfa_0(1, old0);
        try {
            curChar = input_stream.readChar();
        } catch (java.io.IOException e) {
            jjStopStringLiteralDfa_0(2, active0);
            return 3;
        }
        switch (curChar) {
        case 105:
            return jjMoveStringLiteralDfa4_0(active0, 0x1080L);
        default:
            break;
        }
        return jjStartNfa_0(2, active0);
    }

    private final int jjMoveStringLiteralDfa4_0(long old0, long active0) {
        if (((active0 &= old0)) == 0L)
            return jjStartNfa_0(2, old0);
        try {
            curChar = input_stream.readChar();
        } catch (java.io.IOException e) {
            jjStopStringLiteralDfa_0(3, active0);
            return 4;
        }
        switch (curChar) {
        case 58:
            return jjMoveStringLiteralDfa5_0(active0, 0x80L);
        case 116:
            return jjMoveStringLiteralDfa5_0(active0, 0x1000L);
        default:
            break;
        }
        return jjStartNfa_0(3, active0);
    }

    private final int jjMoveStringLiteralDfa5_0(long old0, long active0) {
        if (((active0 &= old0)) == 0L)
            return jjStartNfa_0(3, old0);
        try {
            curChar = input_stream.readChar();
        } catch (java.io.IOException e) {
            jjStopStringLiteralDfa_0(4, active0);
            return 5;
        }
        switch (curChar) {
        case 105:
            return jjMoveStringLiteralDfa6_0(active0, 0x1000L);
        case 116:
            return jjMoveStringLiteralDfa6_0(active0, 0x80L);
        default:
            break;
        }
        return jjStartNfa_0(4, active0);
    }

    private final int jjMoveStringLiteralDfa6_0(long old0, long active0) {
        if (((active0 &= old0)) == 0L)
            return jjStartNfa_0(4, old0);
        try {
            curChar = input_stream.readChar();
        } catch (java.io.IOException e) {
            jjStopStringLiteralDfa_0(5, active0);
            return 6;
        }
        switch (curChar) {
        case 101:
            return jjMoveStringLiteralDfa7_0(active0, 0x1000L);
        case 121:
            return jjMoveStringLiteralDfa7_0(active0, 0x80L);
        default:
            break;
        }
        return jjStartNfa_0(5, active0);
    }

    private final int jjMoveStringLiteralDfa7_0(long old0, long active0) {
        if (((active0 &= old0)) == 0L)
            return jjStartNfa_0(5, old0);
        try {
            curChar = input_stream.readChar();
        } catch (java.io.IOException e) {
            jjStopStringLiteralDfa_0(6, active0);
            return 7;
        }
        switch (curChar) {
        case 112:
            return jjMoveStringLiteralDfa8_0(active0, 0x80L);
        case 115:
            if ((active0 & 0x1000L) != 0L)
                return jjStartNfaWithStates_0(7, 12, 64);
            break;
        default:
            break;
        }
        return jjStartNfa_0(6, active0);
    }

    private final int jjMoveStringLiteralDfa8_0(long old0, long active0) {
        if (((active0 &= old0)) == 0L)
            return jjStartNfa_0(6, old0);
        try {
            curChar = input_stream.readChar();
        } catch (java.io.IOException e) {
            jjStopStringLiteralDfa_0(7, active0);
            return 8;
        }
        switch (curChar) {
        case 101:
            if ((active0 & 0x80L) != 0L)
                return jjStopAtPos(8, 7);
            break;
        default:
            break;
        }
        return jjStartNfa_0(7, active0);
    }

    private final void jjCheckNAdd(int state) {
        if (jjrounds[state] != jjround) {
            jjstateSet[jjnewStateCnt++] = state;
            jjrounds[state] = jjround;
        }
    }

    private final void jjAddStates(int start, int end) {
        do {
            jjstateSet[jjnewStateCnt++] = jjnextStates[start];
        } while (start++ != end);
    }

    private final void jjCheckNAddTwoStates(int state1, int state2) {
        jjCheckNAdd(state1);
        jjCheckNAdd(state2);
    }

    private final void jjCheckNAddStates(int start, int end) {
        do {
            jjCheckNAdd(jjnextStates[start]);
        } while (start++ != end);
    }

/*    private final void jjCheckNAddStates(int start) {
        jjCheckNAdd(jjnextStates[start]);
        jjCheckNAdd(jjnextStates[start + 1]);
    }*/

    static final long[] jjbitVec0 = { 0xfffffffffffffffeL, 0xffffffffffffffffL,
            0xffffffffffffffffL, 0xffffffffffffffffL };
    static final long[] jjbitVec2 = { 0x0L, 0x0L, 0xffffffffffffffffL,
            0xffffffffffffffffL };
    static final long[] jjbitVec3 = { 0x0L, 0xffffffffffffc000L,
            0xfffff0007fffffffL, 0x7fffffL };
    static final long[] jjbitVec4 = { 0x0L, 0x0L, 0x80000000000000L,
            0xff7fffffff7fffffL };
    static final long[] jjbitVec5 = { 0x7ff3ffffffffffffL, 0x7ffffffffffffdfeL,
            0xffffffffffffffffL, 0xfc31ffffffffe00fL };
    static final long[] jjbitVec6 = { 0xffffffL, 0xffffffffffff0000L,
            0xf80001ffffffffffL, 0x30003L };
    static final long[] jjbitVec7 = { 0xffffffffffffffffL, 0x30000003fL,
            0xfffffffbffffd7c0L, 0xffffd547f7fffL };
    static final long[] jjbitVec8 = { 0xffffffffffffdffeL, 0xffffffffdffeffffL,
            0xffffffffffff007bL, 0x33fcfffffff199fL };
    static final long[] jjbitVec9 = { 0xfffe000000000000L, 0xfffffffe027fffffL,
            0xbbfffffbfffe007fL, 0x707ffffff0016L };
    static final long[] jjbitVec10 = { 0x7fffffe00000000L, 0xffff03ff0007ffffL,
            0x7cffffffffffffffL, 0x3ff3dffffef7fffL };
    static final long[] jjbitVec11 = { 0xf3ffffffffffffeeL, 0xffcfff1e3fffL,
            0xd3c5fdfffff99feeL, 0x3ffcfb080399fL };
    static final long[] jjbitVec12 = { 0xd36dfdfffff987e4L, 0x1fffc05e003987L,
            0xf3edfdfffffbafeeL, 0xffc100003bbfL };
    static final long[] jjbitVec13 = { 0xf3cdfdfffff99feeL, 0xffc3b0c0398fL,
            0xc3bfc718d63dc7ecL, 0xff8000803dc7L };
    static final long[] jjbitVec14 = { 0xc3effdfffffddfeeL, 0xffc300603ddfL,
            0xc3effdfffffddfecL, 0xffc340603ddfL };
    static final long[] jjbitVec15 = { 0xc3fffdfffffddfecL, 0xffc300803dcfL,
            0x0L, 0x0L };
    static final long[] jjbitVec16 = { 0x7ff7ffffffffffeL, 0x3ff7fffL,
            0x3bff6caefef02596L, 0x3ff3f5fL };
    static final long[] jjbitVec17 = { 0xc2a003ff03000000L,
            0xfffe03fffffffeffL, 0x2fe3ffffebf0fdfL, 0x0L };
    static final long[] jjbitVec18 = { 0x0L, 0x0L, 0xffffffff00000000L,
            0x7fffffffff003fL };
    static final long[] jjbitVec19 = { 0x500000000007daedL, 0x2c62ab82315001L,
            0xf580c90040000000L, 0x201080000000007L };
    static final long[] jjbitVec20 = { 0xffffffffffffffffL,
            0xffffffffffffffffL, 0xffffffff0fffffffL, 0x3ffffffffffffffL };
    static final long[] jjbitVec21 = { 0xffffffff3f3fffffL,
            0x3fffffffaaff3f3fL, 0x5fdfffffffffffffL, 0x1fdc1fff0fcf1fdcL };
    static final long[] jjbitVec22 = { 0x0L, 0x0L, 0x0L, 0x21fff0000L };
    static final long[] jjbitVec23 = { 0x4c4000000000L, 0x0L, 0x7L, 0x0L };
    static final long[] jjbitVec24 = { 0x3efffe000000a0L, 0xfffffffffffffffeL,
            0xfffffffe661fffffL, 0x77ffffffffffffffL };
    static final long[] jjbitVec25 = { 0x1fffffffffe0L, 0x0L, 0x0L, 0x0L };
    static final long[] jjbitVec26 = { 0xffffffffffffffffL,
            0xffffffffffffffffL, 0x3fffffffffL, 0x0L };
    static final long[] jjbitVec27 = { 0xffffffffffffffffL,
            0xffffffffffffffffL, 0xfffffffffL, 0x0L };

    private final int jjMoveNfa_0(int startState, int curPos) {
        int[] nextStates;
        int startsAt = 0;
        jjnewStateCnt = 64;
        int i = 1;
        jjstateSet[0] = startState;
        int j, kind = 0x7fffffff;
        for (;;) {
            if (++jjround == 0x7fffffff)
                reInitRounds();
            if (curChar < 64) {
                long l = 1L << curChar;
                MatchLoop: do {
                    switch (jjstateSet[--i]) {
                    case 9:
                        if ((0x3ff600000000000L & l) != 0L) {
                            if (kind > 34)
                                kind = 34;
                            jjCheckNAdd(47);
                        } else if ((0x7000000000000000L & l) != 0L) {
                            if (kind > 22)
                                kind = 22;
                        } else if (curChar == 39)
                            jjCheckNAddTwoStates(43, 44);
                        else if (curChar == 34)
                            jjCheckNAddTwoStates(40, 41);
                        else if (curChar == 33)
                            jjCheckNAdd(35);
                        if ((0x3ff000000000000L & l) != 0L) {
                            if (kind > 24)
                                kind = 24;
                            jjCheckNAddStates(0, 2);
                        } else if (curChar == 46)
                            jjCheckNAdd(46);
                        else if (curChar == 62)
                            jjCheckNAdd(35);
                        else if (curChar == 60)
                            jjCheckNAdd(35);
                        break;
                    case 32:
                        if ((0x3ff600000000000L & l) != 0L) {
                            if (kind > 34)
                                kind = 34;
                            jjCheckNAdd(47);
                        } else if (curChar == 58)
                            jjstateSet[jjnewStateCnt++] = 55;
                        else if (curChar == 47)
                            jjstateSet[jjnewStateCnt++] = 51;
                        if ((0x3ff600000000000L & l) != 0L) {
                            if (kind > 16)
                                kind = 16;
                            jjCheckNAdd(58);
                        }
                        if ((0x3ff600000000000L & l) != 0L) {
                            if (kind > 15)
                                kind = 15;
                            jjCheckNAdd(57);
                        }
                        if ((0x3ff600000000000L & l) != 0L) {
                            if (kind > 14)
                                kind = 14;
                            jjCheckNAdd(56);
                        }
                        if ((0x3ff600000000000L & l) != 0L)
                            jjCheckNAddTwoStates(53, 54);
                        if ((0x3ff600000000000L & l) != 0L)
                            jjCheckNAddTwoStates(49, 50);
                        break;
                    case 31:
                        if ((0x3ff600000000000L & l) != 0L) {
                            if (kind > 34)
                                kind = 34;
                            jjCheckNAdd(47);
                        } else if (curChar == 58)
                            jjstateSet[jjnewStateCnt++] = 55;
                        else if (curChar == 47)
                            jjstateSet[jjnewStateCnt++] = 51;
                        if ((0x3ff600000000000L & l) != 0L) {
                            if (kind > 16)
                                kind = 16;
                            jjCheckNAdd(58);
                        }
                        if ((0x3ff600000000000L & l) != 0L) {
                            if (kind > 15)
                                kind = 15;
                            jjCheckNAdd(57);
                        }
                        if ((0x3ff600000000000L & l) != 0L) {
                            if (kind > 14)
                                kind = 14;
                            jjCheckNAdd(56);
                        }
                        if ((0x3ff600000000000L & l) != 0L)
                            jjCheckNAddTwoStates(53, 54);
                        if ((0x3ff600000000000L & l) != 0L)
                            jjCheckNAddTwoStates(49, 50);
                        break;
                    case 64:
                        if ((0x3ff600000000000L & l) != 0L) {
                            if (kind > 34)
                                kind = 34;
                            jjCheckNAdd(47);
                        } else if (curChar == 58)
                            jjstateSet[jjnewStateCnt++] = 55;
                        else if (curChar == 47)
                            jjstateSet[jjnewStateCnt++] = 51;
                        if ((0x3ff600000000000L & l) != 0L) {
                            if (kind > 16)
                                kind = 16;
                            jjCheckNAdd(58);
                        }
                        if ((0x3ff600000000000L & l) != 0L) {
                            if (kind > 15)
                                kind = 15;
                            jjCheckNAdd(57);
                        }
                        if ((0x3ff600000000000L & l) != 0L) {
                            if (kind > 14)
                                kind = 14;
                            jjCheckNAdd(56);
                        }
                        if ((0x3ff600000000000L & l) != 0L)
                            jjCheckNAddTwoStates(53, 54);
                        if ((0x3ff600000000000L & l) != 0L)
                            jjCheckNAddTwoStates(49, 50);
                        break;
                    case 1:
                        if ((0x100000200L & l) != 0L)
                            jjAddStates(3, 4);
                        break;
                    case 2:
                        if (curChar == 40 && kind > 18)
                            kind = 18;
                        break;
                    case 11:
                        if ((0x100000200L & l) != 0L)
                            jjAddStates(5, 6);
                        break;
                    case 12:
                        if (curChar == 40 && kind > 19)
                            kind = 19;
                        break;
                    case 16:
                        if (curChar == 45)
                            jjstateSet[jjnewStateCnt++] = 15;
                        break;
                    case 24:
                        if ((0x100000200L & l) != 0L)
                            jjAddStates(7, 8);
                        break;
                    case 25:
                        if (curChar == 40 && kind > 20)
                            kind = 20;
                        break;
                    case 29:
                        if (curChar == 45)
                            jjstateSet[jjnewStateCnt++] = 28;
                        break;
                    case 34:
                        if ((0x7000000000000000L & l) != 0L && kind > 22)
                            kind = 22;
                        break;
                    case 35:
                        if (curChar == 61 && kind > 22)
                            kind = 22;
                        break;
                    case 36:
                        if (curChar == 60)
                            jjCheckNAdd(35);
                        break;
                    case 37:
                        if (curChar == 62)
                            jjCheckNAdd(35);
                        break;
                    case 38:
                        if (curChar == 33)
                            jjCheckNAdd(35);
                        break;
                    case 39:
                        if (curChar == 34)
                            jjCheckNAddTwoStates(40, 41);
                        break;
                    case 40:
                        if ((0xfffffffbffffffffL & l) != 0L)
                            jjCheckNAddTwoStates(40, 41);
                        break;
                    case 41:
                        if (curChar != 34)
                            break;
                        if (kind > 23)
                            kind = 23;
                        jjstateSet[jjnewStateCnt++] = 39;
                        break;
                    case 42:
                        if (curChar == 39)
                            jjCheckNAddTwoStates(43, 44);
                        break;
                    case 43:
                        if ((0xffffff7fffffffffL & l) != 0L)
                            jjCheckNAddTwoStates(43, 44);
                        break;
                    case 44:
                        if (curChar != 39)
                            break;
                        if (kind > 23)
                            kind = 23;
                        jjstateSet[jjnewStateCnt++] = 42;
                        break;
                    case 45:
                        if (curChar == 46)
                            jjCheckNAdd(46);
                        break;
                    case 46:
                        if ((0x3ff000000000000L & l) == 0L)
                            break;
                        if (kind > 25)
                            kind = 25;
                        jjCheckNAdd(46);
                        break;
                    case 47:
                        if ((0x3ff600000000000L & l) == 0L)
                            break;
                        if (kind > 34)
                            kind = 34;
                        jjCheckNAdd(47);
                        break;
                    case 49:
                        if ((0x3ff600000000000L & l) != 0L)
                            jjCheckNAddTwoStates(49, 50);
                        break;
                    case 50:
                        if (curChar == 47)
                            jjstateSet[jjnewStateCnt++] = 51;
                        break;
                    case 52:
                        if ((0x3ff600000000000L & l) == 0L)
                            break;
                        if (kind > 13)
                            kind = 13;
                        jjstateSet[jjnewStateCnt++] = 52;
                        break;
                    case 53:
                        if ((0x3ff600000000000L & l) != 0L)
                            jjCheckNAddTwoStates(53, 54);
                        break;
                    case 54:
                        if (curChar == 58)
                            jjstateSet[jjnewStateCnt++] = 55;
                        break;
                    case 56:
                        if ((0x3ff600000000000L & l) == 0L)
                            break;
                        if (kind > 14)
                            kind = 14;
                        jjCheckNAdd(56);
                        break;
                    case 57:
                        if ((0x3ff600000000000L & l) == 0L)
                            break;
                        if (kind > 15)
                            kind = 15;
                        jjCheckNAdd(57);
                        break;
                    case 58:
                        if ((0x3ff600000000000L & l) == 0L)
                            break;
                        if (kind > 16)
                            kind = 16;
                        jjCheckNAdd(58);
                        break;
                    case 59:
                        if ((0x3ff000000000000L & l) == 0L)
                            break;
                        if (kind > 24)
                            kind = 24;
                        jjCheckNAddStates(0, 2);
                        break;
                    case 60:
                        if ((0x3ff000000000000L & l) == 0L)
                            break;
                        if (kind > 24)
                            kind = 24;
                        jjCheckNAdd(60);
                        break;
                    case 61:
                        if ((0x3ff000000000000L & l) == 0L)
                            break;
                        if (kind > 25)
                            kind = 25;
                        jjCheckNAddTwoStates(61, 62);
                        break;
                    case 62:
                        if (curChar != 46)
                            break;
                        if (kind > 25)
                            kind = 25;
                        jjCheckNAdd(63);
                        break;
                    case 63:
                        if ((0x3ff000000000000L & l) == 0L)
                            break;
                        if (kind > 25)
                            kind = 25;
                        jjCheckNAdd(63);
                        break;
                    default:
                        break;
                    }
                } while (i != startsAt);
            } else if (curChar < 128) {
                long l = 1L << (curChar & 077);
                MatchLoop: do {
                    switch (jjstateSet[--i]) {
                    case 9:
                        if ((0x7fffffe87fffffeL & l) != 0L) {
                            if (kind > 14)
                                kind = 14;
                            jjCheckNAddStates(9, 15);
                        }
                        if ((0x7fffffe87fffffeL & l) != 0L) {
                            if (kind > 34)
                                kind = 34;
                            jjCheckNAdd(47);
                        }
                        if (curChar == 101)
                            jjstateSet[jjnewStateCnt++] = 32;
                        else if (curChar == 115)
                            jjstateSet[jjnewStateCnt++] = 21;
                        else if (curChar == 99)
                            jjstateSet[jjnewStateCnt++] = 8;
                        break;
                    case 32:
                        if ((0x7fffffe87fffffeL & l) != 0L) {
                            if (kind > 34)
                                kind = 34;
                            jjCheckNAdd(47);
                        }
                        if ((0x7fffffe87fffffeL & l) != 0L) {
                            if (kind > 16)
                                kind = 16;
                            jjCheckNAdd(58);
                        }
                        if ((0x7fffffe87fffffeL & l) != 0L) {
                            if (kind > 15)
                                kind = 15;
                            jjCheckNAdd(57);
                        }
                        if ((0x7fffffe87fffffeL & l) != 0L) {
                            if (kind > 14)
                                kind = 14;
                            jjCheckNAdd(56);
                        }
                        if ((0x7fffffe87fffffeL & l) != 0L)
                            jjCheckNAddTwoStates(53, 54);
                        if ((0x7fffffe87fffffeL & l) != 0L)
                            jjCheckNAddTwoStates(49, 50);
                        if (curChar == 110)
                            jjstateSet[jjnewStateCnt++] = 31;
                        break;
                    case 31:
                        if ((0x7fffffe87fffffeL & l) != 0L) {
                            if (kind > 34)
                                kind = 34;
                            jjCheckNAdd(47);
                        }
                        if ((0x7fffffe87fffffeL & l) != 0L) {
                            if (kind > 16)
                                kind = 16;
                            jjCheckNAdd(58);
                        }
                        if ((0x7fffffe87fffffeL & l) != 0L) {
                            if (kind > 15)
                                kind = 15;
                            jjCheckNAdd(57);
                        }
                        if ((0x7fffffe87fffffeL & l) != 0L) {
                            if (kind > 14)
                                kind = 14;
                            jjCheckNAdd(56);
                        }
                        if ((0x7fffffe87fffffeL & l) != 0L)
                            jjCheckNAddTwoStates(53, 54);
                        if ((0x7fffffe87fffffeL & l) != 0L)
                            jjCheckNAddTwoStates(49, 50);
                        if (curChar == 100)
                            jjstateSet[jjnewStateCnt++] = 30;
                        break;
                    case 64:
                        if ((0x7fffffe87fffffeL & l) != 0L) {
                            if (kind > 34)
                                kind = 34;
                            jjCheckNAdd(47);
                        }
                        if ((0x7fffffe87fffffeL & l) != 0L) {
                            if (kind > 16)
                                kind = 16;
                            jjCheckNAdd(58);
                        }
                        if ((0x7fffffe87fffffeL & l) != 0L) {
                            if (kind > 15)
                                kind = 15;
                            jjCheckNAdd(57);
                        }
                        if ((0x7fffffe87fffffeL & l) != 0L) {
                            if (kind > 14)
                                kind = 14;
                            jjCheckNAdd(56);
                        }
                        if ((0x7fffffe87fffffeL & l) != 0L)
                            jjCheckNAddTwoStates(53, 54);
                        if ((0x7fffffe87fffffeL & l) != 0L)
                            jjCheckNAddTwoStates(49, 50);
                        break;
                    case 0:
                        if (curChar == 115)
                            jjAddStates(3, 4);
                        break;
                    case 3:
                        if (curChar == 110)
                            jjstateSet[jjnewStateCnt++] = 0;
                        break;
                    case 4:
                        if (curChar == 105)
                            jjstateSet[jjnewStateCnt++] = 3;
                        break;
                    case 5:
                        if (curChar == 97)
                            jjstateSet[jjnewStateCnt++] = 4;
                        break;
                    case 6:
                        if (curChar == 116)
                            jjstateSet[jjnewStateCnt++] = 5;
                        break;
                    case 7:
                        if (curChar == 110)
                            jjstateSet[jjnewStateCnt++] = 6;
                        break;
                    case 8:
                        if (curChar == 111)
                            jjstateSet[jjnewStateCnt++] = 7;
                        break;
                    case 10:
                        if (curChar == 104)
                            jjAddStates(5, 6);
                        break;
                    case 13:
                        if (curChar == 116)
                            jjstateSet[jjnewStateCnt++] = 10;
                        break;
                    case 14:
                        if (curChar == 105)
                            jjstateSet[jjnewStateCnt++] = 13;
                        break;
                    case 15:
                        if (curChar == 119)
                            jjstateSet[jjnewStateCnt++] = 14;
                        break;
                    case 17:
                        if (curChar == 115)
                            jjstateSet[jjnewStateCnt++] = 16;
                        break;
                    case 18:
                        if (curChar == 116)
                            jjstateSet[jjnewStateCnt++] = 17;
                        break;
                    case 19:
                        if (curChar == 114)
                            jjstateSet[jjnewStateCnt++] = 18;
                        break;
                    case 20:
                        if (curChar == 97)
                            jjstateSet[jjnewStateCnt++] = 19;
                        break;
                    case 21:
                        if (curChar == 116)
                            jjstateSet[jjnewStateCnt++] = 20;
                        break;
                    case 22:
                        if (curChar == 115)
                            jjstateSet[jjnewStateCnt++] = 21;
                        break;
                    case 23:
                        if (curChar == 104)
                            jjAddStates(7, 8);
                        break;
                    case 26:
                        if (curChar == 116)
                            jjstateSet[jjnewStateCnt++] = 23;
                        break;
                    case 27:
                        if (curChar == 105)
                            jjstateSet[jjnewStateCnt++] = 26;
                        break;
                    case 28:
                        if (curChar == 119)
                            jjstateSet[jjnewStateCnt++] = 27;
                        break;
                    case 30:
                        if (curChar == 115)
                            jjstateSet[jjnewStateCnt++] = 29;
                        break;
                    case 33:
                        if (curChar == 101)
                            jjstateSet[jjnewStateCnt++] = 32;
                        break;
                    case 40:
                        jjAddStates(16, 17);
                        break;
                    case 43:
                        jjAddStates(18, 19);
                        break;
                    case 47:
                        if ((0x7fffffe87fffffeL & l) == 0L)
                            break;
                        if (kind > 34)
                            kind = 34;
                        jjCheckNAdd(47);
                        break;
                    case 48:
                        if ((0x7fffffe87fffffeL & l) == 0L)
                            break;
                        if (kind > 14)
                            kind = 14;
                        jjCheckNAddStates(9, 15);
                        break;
                    case 49:
                        if ((0x7fffffe87fffffeL & l) != 0L)
                            jjCheckNAddTwoStates(49, 50);
                        break;
                    case 51:
                    case 52:
                        if ((0x7fffffe87fffffeL & l) == 0L)
                            break;
                        if (kind > 13)
                            kind = 13;
                        jjCheckNAdd(52);
                        break;
                    case 53:
                        if ((0x7fffffe87fffffeL & l) != 0L)
                            jjCheckNAddTwoStates(53, 54);
                        break;
                    case 55:
                        if ((0x7fffffe87fffffeL & l) == 0L)
                            break;
                        if (kind > 14)
                            kind = 14;
                        jjCheckNAdd(56);
                        break;
                    case 56:
                        if ((0x7fffffe87fffffeL & l) == 0L)
                            break;
                        if (kind > 14)
                            kind = 14;
                        jjCheckNAdd(56);
                        break;
                    case 57:
                        if ((0x7fffffe87fffffeL & l) == 0L)
                            break;
                        if (kind > 15)
                            kind = 15;
                        jjCheckNAdd(57);
                        break;
                    case 58:
                        if ((0x7fffffe87fffffeL & l) == 0L)
                            break;
                        if (kind > 16)
                            kind = 16;
                        jjCheckNAdd(58);
                        break;
                    default:
                        break;
                    }
                } while (i != startsAt);
            } else {
                int hiByte = (int) (curChar >> 8);
                int i1 = hiByte >> 6;
                long l1 = 1L << (hiByte & 077);
                int i2 = (curChar & 0xff) >> 6;
                long l2 = 1L << (curChar & 077);
                MatchLoop: do {
                    switch (jjstateSet[--i]) {
                    case 9:
                    case 47:
                        if (!jjCanMove_1(hiByte, i1, i2, l1, l2))
                            break;
                        if (kind > 34)
                            kind = 34;
                        jjCheckNAdd(47);
                        break;
                    case 32:
                        if (jjCanMove_1(hiByte, i1, i2, l1, l2))
                            jjCheckNAddTwoStates(49, 50);
                        if (jjCanMove_1(hiByte, i1, i2, l1, l2))
                            jjCheckNAddTwoStates(53, 54);
                        if (jjCanMove_1(hiByte, i1, i2, l1, l2)) {
                            if (kind > 14)
                                kind = 14;
                            jjCheckNAdd(56);
                        }
                        if (jjCanMove_1(hiByte, i1, i2, l1, l2)) {
                            if (kind > 15)
                                kind = 15;
                            jjCheckNAdd(57);
                        }
                        if (jjCanMove_1(hiByte, i1, i2, l1, l2)) {
                            if (kind > 16)
                                kind = 16;
                            jjCheckNAdd(58);
                        }
                        if (jjCanMove_1(hiByte, i1, i2, l1, l2)) {
                            if (kind > 34)
                                kind = 34;
                            jjCheckNAdd(47);
                        }
                        break;
                    case 31:
                        if (jjCanMove_1(hiByte, i1, i2, l1, l2))
                            jjCheckNAddTwoStates(49, 50);
                        if (jjCanMove_1(hiByte, i1, i2, l1, l2))
                            jjCheckNAddTwoStates(53, 54);
                        if (jjCanMove_1(hiByte, i1, i2, l1, l2)) {
                            if (kind > 14)
                                kind = 14;
                            jjCheckNAdd(56);
                        }
                        if (jjCanMove_1(hiByte, i1, i2, l1, l2)) {
                            if (kind > 15)
                                kind = 15;
                            jjCheckNAdd(57);
                        }
                        if (jjCanMove_1(hiByte, i1, i2, l1, l2)) {
                            if (kind > 16)
                                kind = 16;
                            jjCheckNAdd(58);
                        }
                        if (jjCanMove_1(hiByte, i1, i2, l1, l2)) {
                            if (kind > 34)
                                kind = 34;
                            jjCheckNAdd(47);
                        }
                        break;
                    case 64:
                        if (jjCanMove_1(hiByte, i1, i2, l1, l2))
                            jjCheckNAddTwoStates(49, 50);
                        if (jjCanMove_1(hiByte, i1, i2, l1, l2))
                            jjCheckNAddTwoStates(53, 54);
                        if (jjCanMove_1(hiByte, i1, i2, l1, l2)) {
                            if (kind > 14)
                                kind = 14;
                            jjCheckNAdd(56);
                        }
                        if (jjCanMove_1(hiByte, i1, i2, l1, l2)) {
                            if (kind > 15)
                                kind = 15;
                            jjCheckNAdd(57);
                        }
                        if (jjCanMove_1(hiByte, i1, i2, l1, l2)) {
                            if (kind > 16)
                                kind = 16;
                            jjCheckNAdd(58);
                        }
                        if (jjCanMove_1(hiByte, i1, i2, l1, l2)) {
                            if (kind > 34)
                                kind = 34;
                            jjCheckNAdd(47);
                        }
                        break;
                    case 40:
                        if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                            jjAddStates(16, 17);
                        break;
                    case 43:
                        if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                            jjAddStates(18, 19);
                        break;
                    case 49:
                        if (jjCanMove_1(hiByte, i1, i2, l1, l2))
                            jjCheckNAddTwoStates(49, 50);
                        break;
                    case 52:
                        if (!jjCanMove_1(hiByte, i1, i2, l1, l2))
                            break;
                        if (kind > 13)
                            kind = 13;
                        jjstateSet[jjnewStateCnt++] = 52;
                        break;
                    case 53:
                        if (jjCanMove_1(hiByte, i1, i2, l1, l2))
                            jjCheckNAddTwoStates(53, 54);
                        break;
                    case 56:
                        if (!jjCanMove_1(hiByte, i1, i2, l1, l2))
                            break;
                        if (kind > 14)
                            kind = 14;
                        jjCheckNAdd(56);
                        break;
                    case 57:
                        if (!jjCanMove_1(hiByte, i1, i2, l1, l2))
                            break;
                        if (kind > 15)
                            kind = 15;
                        jjCheckNAdd(57);
                        break;
                    case 58:
                        if (!jjCanMove_1(hiByte, i1, i2, l1, l2))
                            break;
                        if (kind > 16)
                            kind = 16;
                        jjCheckNAdd(58);
                        break;
                    default:
                        break;
                    }
                } while (i != startsAt);
            }
            if (kind != 0x7fffffff) {
                jjmatchedKind = kind;
                jjmatchedPos = curPos;
                kind = 0x7fffffff;
            }
            ++curPos;
            if ((i = jjnewStateCnt) == (startsAt = 64 - (jjnewStateCnt = startsAt)))
                return curPos;
            try {
                curChar = input_stream.readChar();
            } catch (java.io.IOException e) {
                return curPos;
            }
        }
    }

    static final int[] jjnextStates = { 60, 61, 62, 1, 2, 11, 12, 24, 25, 49,
            50, 53, 54, 56, 57, 58, 40, 41, 43, 44, };

    private static final boolean jjCanMove_0(int hiByte, int i1, int i2,
            long l1, long l2) {
        switch (hiByte) {
        case 0:
            return ((jjbitVec2[i2] & l2) != 0L);
        default:
            if ((jjbitVec0[i1] & l1) != 0L)
                return true;
            return false;
        }
    }

    private static final boolean jjCanMove_1(int hiByte, int i1, int i2,
            long l1, long l2) {
        switch (hiByte) {
        case 0:
            return ((jjbitVec4[i2] & l2) != 0L);
        case 1:
            return ((jjbitVec5[i2] & l2) != 0L);
        case 2:
            return ((jjbitVec6[i2] & l2) != 0L);
        case 3:
            return ((jjbitVec7[i2] & l2) != 0L);
        case 4:
            return ((jjbitVec8[i2] & l2) != 0L);
        case 5:
            return ((jjbitVec9[i2] & l2) != 0L);
        case 6:
            return ((jjbitVec10[i2] & l2) != 0L);
        case 9:
            return ((jjbitVec11[i2] & l2) != 0L);
        case 10:
            return ((jjbitVec12[i2] & l2) != 0L);
        case 11:
            return ((jjbitVec13[i2] & l2) != 0L);
        case 12:
            return ((jjbitVec14[i2] & l2) != 0L);
        case 13:
            return ((jjbitVec15[i2] & l2) != 0L);
        case 14:
            return ((jjbitVec16[i2] & l2) != 0L);
        case 15:
            return ((jjbitVec17[i2] & l2) != 0L);
        case 16:
            return ((jjbitVec18[i2] & l2) != 0L);
        case 17:
            return ((jjbitVec19[i2] & l2) != 0L);
        case 30:
            return ((jjbitVec20[i2] & l2) != 0L);
        case 31:
            return ((jjbitVec21[i2] & l2) != 0L);
        case 32:
            return ((jjbitVec22[i2] & l2) != 0L);
        case 33:
            return ((jjbitVec23[i2] & l2) != 0L);
        case 48:
            return ((jjbitVec24[i2] & l2) != 0L);
        case 49:
            return ((jjbitVec25[i2] & l2) != 0L);
        case 159:
            return ((jjbitVec26[i2] & l2) != 0L);
        case 215:
            return ((jjbitVec27[i2] & l2) != 0L);
        default:
            if ((jjbitVec3[i1] & l1) != 0L)
                return true;
            return false;
        }
    }

    static final String[] jjstrLiteralImages = { "", "\141\156\144",
            "\50", "\51", "\133", "\135", "\157\162",
            "\100\170\163\151\72\164\171\160\145", null, null, null, null,
            "\145\156\164\151\164\151\145\163", null, null, null, null, null,
            null, null, null, "\100", null, null, null, null, null, null, null,
            null, "\57", "\57\57", null, null, null, null, null, null, null,
            null, };
    public static final String[] lexStateNames = { "DEFAULT", };
    static final long[] jjtoToken = { 0x4c3fdf0ffL, };
    static final long[] jjtoSkip = { 0xf00L, };
    protected SimpleCharStream input_stream;
    private final int[] jjrounds = new int[64];
    private final int[] jjstateSet = new int[128];
    protected char curChar;

    public WIMXPathInterpreterTokenManager(SimpleCharStream stream) {
        if (SimpleCharStream.staticFlag)
            throw new Error(
                    "ERROR: Cannot use a static CharStream class with a non-static lexical analyzer.");
        input_stream = stream;
    }

    public WIMXPathInterpreterTokenManager(SimpleCharStream stream, int lexState) {
        this(stream);
        switchTo(lexState);
    }

    public void reInit(SimpleCharStream stream) {
        jjmatchedPos = jjnewStateCnt = 0;
        curLexState = defaultLexState;
        input_stream = stream;
        reInitRounds();
    }

    private final void reInitRounds() {
        int i;
        jjround = 0x80000001;
        for (i = 64; i-- > 0;)
            jjrounds[i] = 0x80000000;
    }

    public void reInit(SimpleCharStream stream, int lexState) {
        reInit(stream);
        switchTo(lexState);
    }

    public void switchTo(int lexState) {
        if (lexState >= 1 || lexState < 0)
            throw new TokenMgrError("Error: Ignoring invalid lexical state : "
                    + lexState + ". State unchanged.",
                    TokenMgrError.INVALID_LEXICAL_STATE);
        else
            curLexState = lexState;
    }

    protected Token jjFillToken() {
        Token t = Token.newToken(jjmatchedKind);
        t.kind = jjmatchedKind;
        String im = jjstrLiteralImages[jjmatchedKind];
        t.image = (im == null) ? input_stream.GetImage() : im;
        t.beginLine = input_stream.getBeginLine();
        t.beginColumn = input_stream.getBeginColumn();
        t.endLine = input_stream.getEndLine();
        t.endColumn = input_stream.getEndColumn();
        return t;
    }

    int curLexState = 0;
    int defaultLexState = 0;
    int jjnewStateCnt;
    int jjround;
    int jjmatchedPos;
    int jjmatchedKind;

    public Token getNextToken() {
        int kind;
        Token specialToken = null;
        Token matchedToken;
        int curPos = 0;

        EOFLoop: for (;;) {
            try {
                curChar = input_stream.BeginToken();
            } catch (java.io.IOException e) {
                jjmatchedKind = 0;
                matchedToken = jjFillToken();
                return matchedToken;
            }

            try {
                input_stream.backup(0);
                while (curChar <= 32 && (0x100002600L & (1L << curChar)) != 0L)
                    curChar = input_stream.BeginToken();
            } catch (java.io.IOException e1) {
                continue EOFLoop;
            }
            jjmatchedKind = 0x7fffffff;
            jjmatchedPos = 0;
            curPos = jjMoveStringLiteralDfa0_0();
            if (jjmatchedKind != 0x7fffffff) {
                if (jjmatchedPos + 1 < curPos)
                    input_stream.backup(curPos - jjmatchedPos - 1);
                if ((jjtoToken[jjmatchedKind >> 6] & (1L << (jjmatchedKind & 077))) != 0L) {
                    matchedToken = jjFillToken();
                    return matchedToken;
                } else {
                    continue EOFLoop;
                }
            }
            int error_line = input_stream.getEndLine();
            int error_column = input_stream.getEndColumn();
            String error_after = null;
            boolean EOFSeen = false;
            try {
                input_stream.readChar();
                input_stream.backup(1);
            } catch (java.io.IOException e1) {
                EOFSeen = true;
                error_after = curPos <= 1 ? "" : input_stream.GetImage();
                if (curChar == '\n' || curChar == '\r') {
                    error_line++;
                    error_column = 0;
                } else
                    error_column++;
            }
            if (!EOFSeen) {
                input_stream.backup(1);
                error_after = curPos <= 1 ? "" : input_stream.GetImage();
            }
            throw new TokenMgrError(EOFSeen, curLexState, error_line,
                    error_column, error_after, curChar,
                    TokenMgrError.LEXICAL_ERROR);
        }
    }
}
