/*
 * Decompiled with CFR 0.152.
 */
package wlp.lib.extract;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import wlp.lib.extract.LicenseProvider;
import wlp.lib.extract.ReturnCode;
import wlp.lib.extract.SelfExtractUtils;

public class ZipLicenseProvider
implements LicenseProvider {
    private final ZipFile zipFile;
    private final ZipEntry laZipEntry;
    private final ZipEntry liZipEntry;
    private final String pName;
    private final String lName;
    private static LicenseProvider instance;
    private static final String PROGRAM_NAME = "Program Name:";

    private ZipLicenseProvider(ZipFile zipFile, ZipEntry laZipEntry, ZipEntry liZipEntry, String pName, String lName) {
        this.zipFile = zipFile;
        this.laZipEntry = laZipEntry;
        this.liZipEntry = liZipEntry;
        this.pName = pName;
        this.lName = lName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static ReturnCode buildInstance(ZipFile zipFile, String laPrefix, String liPrefix) {
        String lName;
        String pName;
        String line;
        BufferedReader r;
        ZipEntry liEnglishZipEntry;
        ZipEntry liZipEntry;
        ZipEntry laZipEntry;
        block14: {
            laZipEntry = null;
            liZipEntry = null;
            liEnglishZipEntry = null;
            try {
                laZipEntry = SelfExtractUtils.getLicenseFile(zipFile, laPrefix);
                liZipEntry = SelfExtractUtils.getLicenseFile(zipFile, liPrefix);
                liEnglishZipEntry = zipFile.getEntry(liPrefix + (liPrefix.endsWith("_") ? "" : "_") + "en");
            }
            catch (Exception e) {
                return new ReturnCode(1, "licenseNotFound", new Object[0]);
            }
            if (zipFile == null || laZipEntry == null || liZipEntry == null || liEnglishZipEntry == null) {
                return new ReturnCode(1, "licenseNotFound", new Object[0]);
            }
            r = null;
            line = null;
            pName = null;
            lName = null;
            try {
                r = new BufferedReader(new InputStreamReader(zipFile.getInputStream(laZipEntry), "UTF-16"));
                line = r.readLine();
                if (line == null) break block14;
                lName = line;
            }
            catch (IOException e) {
                SelfExtractUtils.tryToClose(r);
                catch (Throwable throwable) {
                    SelfExtractUtils.tryToClose(r);
                    throw throwable;
                }
            }
        }
        SelfExtractUtils.tryToClose(r);
        try {
            int i = 0;
            r = new BufferedReader(new InputStreamReader(zipFile.getInputStream(liEnglishZipEntry), "UTF-16"));
            do {
                if ((line = r.readLine()) == null || !line.startsWith(PROGRAM_NAME)) continue;
                pName = line.substring(PROGRAM_NAME.length() + 1);
            } while (line != null && pName == null && i++ < 6);
        }
        catch (IOException e) {
        }
        finally {
            SelfExtractUtils.tryToClose(r);
        }
        if (pName == null || lName == null) {
            return new ReturnCode(2, "licenseNotFound", new Object[0]);
        }
        instance = new ZipLicenseProvider(zipFile, laZipEntry, liZipEntry, pName, lName);
        return ReturnCode.OK;
    }

    public static LicenseProvider getInstance() {
        return instance;
    }

    public InputStream getLicenseAgreement() {
        try {
            return this.zipFile.getInputStream(this.laZipEntry);
        }
        catch (IOException e) {
            return null;
        }
    }

    public InputStream getLicenseInformation() {
        try {
            return this.zipFile.getInputStream(this.liZipEntry);
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getProgramName() {
        return this.pName;
    }

    public String getLicenseName() {
        return this.lName;
    }
}

