/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal.subsystem;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.feature.AppForceRestart;
import com.ibm.ws.kernel.feature.Visibility;
import com.ibm.ws.kernel.feature.internal.subsystem.FeatureDefinitionUtils;
import com.ibm.ws.kernel.feature.provisioning.FeatureResource;
import com.ibm.ws.kernel.feature.provisioning.HeaderElementDefinition;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.feature.provisioning.SubsystemContentType;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.osgi.framework.Filter;
import org.osgi.framework.Version;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions(traceGroups={"featureManager"}, traceGroup="", messageBundle="com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages", traceExceptionThrow=false, traceExceptionHandling=false)
public class SubsystemFeatureDefinitionImpl
implements ProvisioningFeatureDefinition {
    private static final TraceComponent tc = Tr.register(SubsystemFeatureDefinitionImpl.class);
    private final FeatureDefinitionUtils.ImmutableAttributes iAttr;
    private volatile FeatureDefinitionUtils.ProvisioningDetails mfDetails;
    private final String apiServiceElements;
    static final long serialVersionUID = -5390946999669015207L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    SubsystemFeatureDefinitionImpl(FeatureDefinitionUtils.ImmutableAttributes attr, FeatureDefinitionUtils.ProvisioningDetails details) {
        this.mfDetails = details;
        this.iAttr = attr;
        this.apiServiceElements = this.iAttr.hasApiServices ? this.mfDetails.getCachedRawHeader("IBM-API-Service") : null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    public SubsystemFeatureDefinitionImpl(String repoType, InputStream inputStream) throws IOException {
        this.mfDetails = new FeatureDefinitionUtils.ProvisioningDetails(null, inputStream);
        this.iAttr = FeatureDefinitionUtils.loadAttributes(repoType, null, this.mfDetails);
        this.apiServiceElements = this.iAttr.hasApiServices ? this.mfDetails.getCachedRawHeader("IBM-API-Service") : null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    public SubsystemFeatureDefinitionImpl(String repoType, File file) throws IOException {
        this.mfDetails = new FeatureDefinitionUtils.ProvisioningDetails(file, null);
        this.iAttr = FeatureDefinitionUtils.loadAttributes(repoType, file, this.mfDetails);
        this.apiServiceElements = this.iAttr.hasApiServices ? this.mfDetails.getCachedRawHeader("IBM-API-Service") : null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    FeatureDefinitionUtils.ImmutableAttributes getImmutableAttributes() {
        return this.iAttr;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    FeatureDefinitionUtils.ProvisioningDetails getProvisioningDetails() {
        return this.mfDetails;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    void setProvisioningDetails(FeatureDefinitionUtils.ProvisioningDetails details) {
        this.mfDetails = details;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    public File getFeatureDefinitionFile() {
        return this.iAttr.featureFile;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    public File getFeatureChecksumFile() {
        return this.iAttr.checksumFile;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    public String getFeatureName() {
        return this.iAttr.featureName;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    public String getSymbolicName() {
        return this.iAttr.symbolicName;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    public String getIbmShortName() {
        return this.iAttr.shortName;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    public int getIbmFeatureVersion() {
        return this.iAttr.featureVersion;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    public Version getVersion() {
        return this.iAttr.version;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    public AppForceRestart getAppForceRestart() {
        return this.iAttr.appRestart;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    public Visibility getVisibility() {
        return this.iAttr.visibility;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    public String getBundleRepositoryType() {
        return this.iAttr.bundleRepositoryType;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    public boolean isSupportedFeatureVersion() {
        return this.iAttr.isSupportedFeatureVersion();
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    public boolean isAutoFeature() {
        return this.iAttr.isAutoFeature;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    public String getApiServices() {
        return this.apiServiceElements;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    public Collection<File> getLocalizationFiles() {
        File dir = this.iAttr.getLocalizationDirectory();
        File[] files = null;
        if (dir != null && dir.isDirectory()) {
            files = dir.listFiles(new FilenameFilter(){
                static final long serialVersionUID = -6764374062422547304L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
                public boolean accept(File dir, String name) {
                    return name.startsWith(((SubsystemFeatureDefinitionImpl)SubsystemFeatureDefinitionImpl.this).iAttr.symbolicName) && name.endsWith(".properties");
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter", "com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
        }
        if (files == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(files);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    private ResourceBundle getResourceBundle(Locale locale) {
        File[] files;
        File dir = this.iAttr.getLocalizationDirectory();
        File[] fileArray = files = new File[]{new File(dir, String.valueOf(this.iAttr.symbolicName) + "_" + locale.toString() + ".properties"), new File(dir, String.valueOf(this.iAttr.symbolicName) + "_" + locale.getLanguage() + ".properties"), new File(dir, String.valueOf(this.iAttr.symbolicName) + ".properties")};
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.exists()) {
                try {
                    return new PropertyResourceBundle(new FileReader(file));
                }
                catch (IOException iOException) {
                    FFDCFilter.processException(iOException, "com.ibm.ws.kernel.feature.internal.subsystem.SubsystemFeatureDefinitionImpl", "242", this, new Object[]{locale});
                    IOException iOException2 = iOException;
                }
            }
            ++n2;
        }
        return null;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    public Collection<FeatureResource> getConstituents(SubsystemContentType type) {
        if (this.mfDetails == null) {
            throw new IllegalStateException("Method called outside of provisioining operation");
        }
        return this.mfDetails.getConstituents(type);
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    public String getHeader(String header) {
        if (this.mfDetails == null) {
            throw new IllegalStateException("Method called outside of provisioining operation");
        }
        try {
            return this.mfDetails.getMainAttributeValue(header);
        }
        catch (IOException iOException) {
            FFDCFilter.processException(iOException, "com.ibm.ws.kernel.feature.internal.subsystem.SubsystemFeatureDefinitionImpl", "266", this, new Object[]{header});
            IOException e = iOException;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "IOException reading manifest attribute from {0}: {1}", this.iAttr.featureFile, e);
            }
            return null;
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    public String getHeader(String header, Locale locale) {
        ResourceBundle rb;
        String value = this.getHeader(header);
        if (value == null || value.isEmpty() || locale == null) {
            return value;
        }
        if (value.charAt(0) == '%' && FeatureDefinitionUtils.LOCALIZABLE_HEADERS.contains(header) && (rb = this.getResourceBundle(locale)) != null) {
            value = rb.getString(value.substring(1));
        }
        return value;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    public Collection<HeaderElementDefinition> getHeaderElements(String header) {
        if (this.mfDetails == null) {
            throw new IllegalStateException("Method called outside of provisioining operation");
        }
        return this.mfDetails.getRawHeaderElements(header);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    void setHeader(String header, String value) {
        if (this.mfDetails == null) {
            throw new IllegalStateException("Method called outside of provisioining operation");
        }
        this.mfDetails.setHeaderValue(header, value);
    }

    public int hashCode() {
        return this.iAttr.hashCode();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubsystemFeatureDefinitionImpl other = (SubsystemFeatureDefinitionImpl)obj;
        return this.iAttr.equals(other.iAttr);
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    public boolean isSuperseded() {
        if (this.mfDetails == null) {
            throw new IllegalStateException("Method called outside of provisioining operation");
        }
        return this.mfDetails.isSuperseded();
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    public String getSupersededBy() {
        if (this.mfDetails == null) {
            throw new IllegalStateException("Method called outside of provisioining operation");
        }
        return this.mfDetails.getSupersededBy();
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    public boolean isCapabilitySatisfied(Collection<ProvisioningFeatureDefinition> featureDefinitionsToCheck) {
        if (!this.iAttr.isAutoFeature) {
            return true;
        }
        if (this.mfDetails == null) {
            throw new IllegalStateException("Method called outside of provisioining operation");
        }
        boolean isCapabilitySatisfied = true;
        Iterator<Filter> iter = this.mfDetails.getCapabilityFilters().iterator();
        HashSet<ProvisioningFeatureDefinition> satisfiedFeatureDefs = new HashSet<ProvisioningFeatureDefinition>();
        while (iter.hasNext() && isCapabilitySatisfied) {
            Filter checkFilter = iter.next();
            Iterator<ProvisioningFeatureDefinition> featureDefIter = featureDefinitionsToCheck.iterator();
            boolean featureMatch = false;
            while (featureDefIter.hasNext() && !featureMatch) {
                ProvisioningFeatureDefinition featureDef = featureDefIter.next();
                if (satisfiedFeatureDefs.contains(featureDef)) continue;
                HashMap<String, String> filterProps = new HashMap<String, String>();
                filterProps.put("osgi.identity", featureDef.getSymbolicName());
                try {
                    filterProps.put("type", this.mfDetails.getMainAttributeValue("Subsystem-Type"));
                }
                catch (IOException iOException) {
                    FFDCFilter.processException(iOException, "com.ibm.ws.kernel.feature.internal.subsystem.SubsystemFeatureDefinitionImpl", "393", this, new Object[]{featureDefinitionsToCheck});
                    IOException e = iOException;
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "IOException reading manifest attribute from {0}: {1}", this.iAttr.featureFile, e);
                    continue;
                }
                if (!checkFilter.matches(filterProps)) continue;
                satisfiedFeatureDefs.add(featureDef);
                featureMatch = true;
            }
            isCapabilitySatisfied = featureMatch;
        }
        return isCapabilitySatisfied;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    public boolean isKernel() {
        return false;
    }

    public String toString() {
        if (this.mfDetails == null) {
            return this.iAttr.toString();
        }
        return this.mfDetails.toString();
    }
}

