/*******************************************************************************
 * Copyright (c) 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.ibm.ws.javaee.dd.webext;

import com.ibm.ws.javaee.ddmetadata.annotation.DDAttribute;
import com.ibm.ws.javaee.ddmetadata.annotation.DDAttributeType;
import com.ibm.ws.javaee.ddmetadata.annotation.LibertyNotInUse;

/**
 * Represents &lt;cache-variable>.
 */
@LibertyNotInUse
public interface CacheVariable {
    enum TypeEnum {
        REQUEST_PARAMETER,
        REQUEST_ATTRIBUTE,
        SESSION_PARAMETER,
        COOKIE
    }

    boolean isSetType();

    @DDAttribute(name = "type", type = DDAttributeType.Enum)
    TypeEnum getType();

    @DDAttribute(name = "identifier", type = DDAttributeType.String)
    String getIdentifier();

    @DDAttribute(name = "method", type = DDAttributeType.String)
    String getMethod();

    boolean isSetRequired();

    @DDAttribute(name = "required", type = DDAttributeType.Boolean)
    boolean isRequired();

    @DDAttribute(name = "data-id", type = DDAttributeType.String)
    String getDataId();

    @DDAttribute(name = "invalidate", type = DDAttributeType.String)
    String getInvalidate();
}
