/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.secfvt.ejb;

import com.ibm.websphere.crypto.KeyException;
import com.ibm.websphere.crypto.KeyPair;
import com.ibm.websphere.crypto.KeySetHelper;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.WSSecurityHelper;
import com.ibm.websphere.security.auth.IdentityPrincipal;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLConfigChangeEvent;
import com.ibm.websphere.ssl.SSLConfigChangeListener;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import com.ibm.ws.ssl.config.DefaultSSLConfigChangeListener;
import java.security.cert.Certificate;
import java.util.Map;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;

public class APITestsBean
implements SessionBean {
    private SessionContext mySessionCtx;

    public Map getKeysForKeySetGroup(String keySetGroup) throws KeyException {
        Map keySets = null;
        KeySetHelper myHelper = KeySetHelper.getInstance();
        keySets = myHelper.getAllKeysForKeySetGroup(keySetGroup);
        return keySets;
    }

    public Certificate getCertificate(KeyPair keyPair) {
        return keyPair.getCertificate();
    }

    public Map getKeysForKeySet(String keySet) throws KeyException {
        Map keySets = null;
        KeySetHelper myHelper = KeySetHelper.getInstance();
        keySets = myHelper.getAllKeysForKeySet(keySet);
        return keySets;
    }

    public Object getLatestKeyForSet(String keySet) throws KeyException {
        Object key = null;
        KeySetHelper myHelper = KeySetHelper.getInstance();
        key = myHelper.getLatestKeyForKeySet(keySet);
        return key;
    }

    public Map getLatestKeysForGroup(String keySetGroup) throws KeyException {
        Map keyMap = null;
        KeySetHelper myHelper = KeySetHelper.getInstance();
        keyMap = myHelper.getLatestKeysForKeySetGroup(keySetGroup);
        return keyMap;
    }

    public String firstCallerAccessor() {
        return WSSecurityHelper.getFirstCaller();
    }

    public String firstServerAccessor() {
        return WSSecurityHelper.getFirstServer();
    }

    public String[] callerListAccessor() {
        return WSSecurityHelper.getCallerList();
    }

    public String[] serverListAccessor() {
        return WSSecurityHelper.getServerList();
    }

    public String[] addPropAttribute(String key, String value) throws WSSecurityException {
        return WSSecurityHelper.addPropagationAttribute((String)key, (String)value);
    }

    public String[] getPropAttribute(String key) throws WSSecurityException {
        return WSSecurityHelper.getPropagationAttributes((String)key);
    }

    public byte[] convertCookieToBytes(String cookie) {
        return WSSecurityHelper.convertCookieStringToBytes((String)cookie);
    }

    public boolean onlyManagerCanCall() {
        return true;
    }

    public String getCallerPrincipal() {
        return WSSubject.getCallerPrincipal();
    }

    public Subject getCallerSubject() throws WSSecurityException {
        return WSSubject.getCallerSubject();
    }

    public Properties getSSLProperties(String alias) throws SSLException {
        if (alias != null && JSSEHelper.getInstance().doesSSLConfigExist(alias)) {
            return JSSEHelper.getInstance().getProperties(alias);
        }
        return null;
    }

    public boolean testSSLPropertiesOnThread(String validAlias) throws SSLException {
        JSSEHelper.getInstance().setSSLPropertiesOnThread(JSSEHelper.getInstance().getProperties(validAlias));
        return validAlias != null && JSSEHelper.getInstance().doesSSLConfigExist(validAlias) && JSSEHelper.getInstance().getProperties(validAlias).equals(JSSEHelper.getInstance().getSSLPropertiesOnThread());
    }

    public Map getInboundConnectionInfo() {
        return JSSEHelper.getInstance().getInboundConnectionInfo();
    }

    public String testRegisterSSLListener(String alias, Map connectionInfo) {
        DefaultSSLConfigChangeListener mySSLListener = new DefaultSSLConfigChangeListener();
        try {
            JSSEHelper.getInstance().registerSSLConfigChangeListener(alias, connectionInfo, (SSLConfigChangeListener)mySSLListener);
            JSSEHelper.getInstance().registerSSLConfigChangeListener(null, connectionInfo, (SSLConfigChangeListener)mySSLListener);
            JSSEHelper.getInstance().registerSSLConfigChangeListener(alias, null, (SSLConfigChangeListener)mySSLListener);
            JSSEHelper.getInstance().registerSSLConfigChangeListener(alias, connectionInfo, null);
            JSSEHelper.getInstance().registerSSLConfigChangeListener(null, null, (SSLConfigChangeListener)mySSLListener);
            JSSEHelper.getInstance().registerSSLConfigChangeListener(alias, null, null);
            JSSEHelper.getInstance().registerSSLConfigChangeListener(null, connectionInfo, null);
            JSSEHelper.getInstance().registerSSLConfigChangeListener(null, null, null);
        }
        catch (SSLException e) {
            System.err.println("Unexpected Exception caught in APITestBean");
            return "Unexpected exception caught: " + e.getMessage();
        }
        return null;
    }

    public String testGetSSLProperties(String alias, Map connInfo) {
        DefaultSSLConfigChangeListener listener = new DefaultSSLConfigChangeListener();
        try {
            JSSEHelper.getInstance().registerSSLConfigChangeListener(null, connInfo, (SSLConfigChangeListener)listener);
            JSSEHelper.getInstance().registerSSLConfigChangeListener(alias, null, (SSLConfigChangeListener)listener);
            JSSEHelper.getInstance().registerSSLConfigChangeListener(alias, connInfo, null);
            JSSEHelper.getInstance().registerSSLConfigChangeListener(null, null, (SSLConfigChangeListener)listener);
            JSSEHelper.getInstance().registerSSLConfigChangeListener(alias, null, null);
            JSSEHelper.getInstance().registerSSLConfigChangeListener(null, connInfo, null);
            JSSEHelper.getInstance().registerSSLConfigChangeListener(null, null, null);
            JSSEHelper.getInstance().registerSSLConfigChangeListener(alias, connInfo, (SSLConfigChangeListener)listener);
            JSSEHelper.getInstance().getProperties(alias, connInfo, (SSLConfigChangeListener)listener);
            JSSEHelper.getInstance().getProperties(null, connInfo, (SSLConfigChangeListener)listener);
            JSSEHelper.getInstance().getProperties(alias, null, (SSLConfigChangeListener)listener);
            JSSEHelper.getInstance().getProperties(alias, connInfo, null);
            JSSEHelper.getInstance().getProperties(null, connInfo, null);
            JSSEHelper.getInstance().getProperties(null, null, (SSLConfigChangeListener)listener);
            JSSEHelper.getInstance().getProperties(alias, null, null);
            JSSEHelper.getInstance().getProperties(null, null, null);
            JSSEHelper.getInstance().deregisterSSLConfigChangeListener((SSLConfigChangeListener)listener);
            JSSEHelper.getInstance().deregisterSSLConfigChangeListener(null);
        }
        catch (SSLException e) {
            System.err.println("Unexpected Exception caught in APITestBean");
            return "Unexpected exception caught: " + e.getMessage();
        }
        return null;
    }

    public String testSSLProperties(String alias, Map connInfo, String propsURL) {
        JSSEHelper.getInstance().loadClientSSLPropertiesFromURL(propsURL, false);
        JSSEHelper.getInstance().loadClientSSLPropertiesFromURL(propsURL, true);
        try {
            JSSEHelper.getInstance().loadClientSSLPropertiesFromURL(null, true);
            return "Expected IllegalArgumentException for null SSLPropertiesURL not thrown";
        }
        catch (IllegalArgumentException e) {
            JSSEHelper.getInstance().reinitializeClientDefaultSSLProperties();
            Properties invalidProperties = new Properties();
            invalidProperties.put("key1", "value1");
            invalidProperties.put("key2", "value2");
            Properties realProperties = JSSEHelper.getInstance().getSSLPropertiesOnThread();
            try {
                JSSEHelper.getInstance().validateSSLProperties(invalidProperties);
                JSSEHelper.getInstance().validateSSLProperties(realProperties);
                JSSEHelper.getInstance().validateSSLProperties(null);
                JSSEHelper.getInstance().reinitializeClientDefaultSSLProperties();
            }
            catch (SSLException e2) {
                System.err.println("Unexpected Exception caught in APITestsBean");
                return "Caught Unexpected Exception: " + e2.getMessage();
            }
            return null;
        }
    }

    public void setSSLInboundConnectionInfo(Map connInfo) {
        JSSEHelper.getInstance().setInboundConnectionInfo(connInfo);
    }

    public Map getSSLInboundConnectionInfo() {
        return JSSEHelper.getInstance().getInboundConnectionInfo();
    }

    public String testSSLContext(String alias, Map connInfo, Properties props) {
        DefaultSSLConfigChangeListener listener = new DefaultSSLConfigChangeListener();
        try {
            JSSEHelper.getInstance().getSSLContext(connInfo, props);
            JSSEHelper.getInstance().getSSLContext(null, props);
        }
        catch (SSLException e) {
            System.err.println("Caught unexpected exception in APITestBean");
            return "Caught unexpected exception: " + e.getMessage();
        }
        try {
            JSSEHelper.getInstance().getSSLContext(connInfo, null);
            return "Expected exception in APITestsBean was not caught in function testSSLContext()";
        }
        catch (SSLException e) {
            try {
                JSSEHelper.getInstance().getSSLContext(null, null);
                return "Expected exception in APITestsBean was not caught in function testSSLContext()";
            }
            catch (SSLException e2) {
                try {
                    JSSEHelper.getInstance().getSSLContext(null, null, null);
                    JSSEHelper.getInstance().getSSLContext(alias, connInfo, null);
                    JSSEHelper.getInstance().getSSLContext(alias, null, (SSLConfigChangeListener)listener);
                    JSSEHelper.getInstance().getSSLContext(alias, null, null);
                    JSSEHelper.getInstance().getSSLContext(null, connInfo, (SSLConfigChangeListener)listener);
                    JSSEHelper.getInstance().getSSLContext(null, connInfo, null);
                    JSSEHelper.getInstance().getSSLContext(null, null, (SSLConfigChangeListener)listener);
                    JSSEHelper.getInstance().getSSLContext(alias, connInfo, (SSLConfigChangeListener)listener);
                }
                catch (SSLException e3) {
                    return "Caught unexpected exception: " + e3.getMessage() + " " + e3.getStackTrace();
                }
                return null;
            }
        }
    }

    public String testGetURLStreamHandler(String alias, Map connInfo, Properties props) {
        DefaultSSLConfigChangeListener listener = new DefaultSSLConfigChangeListener();
        try {
            JSSEHelper.getInstance().getURLStreamHandler(props);
            JSSEHelper.getInstance().getURLStreamHandler(null);
            JSSEHelper.getInstance().getURLStreamHandler(null, null, null);
            JSSEHelper.getInstance().getURLStreamHandler(null, null, (SSLConfigChangeListener)listener);
            JSSEHelper.getInstance().getURLStreamHandler(null, connInfo, null);
            JSSEHelper.getInstance().getURLStreamHandler(null, connInfo, (SSLConfigChangeListener)listener);
            JSSEHelper.getInstance().getURLStreamHandler(alias, null, null);
            JSSEHelper.getInstance().getURLStreamHandler(alias, null, (SSLConfigChangeListener)listener);
            JSSEHelper.getInstance().getURLStreamHandler(alias, connInfo, null);
            JSSEHelper.getInstance().getURLStreamHandler(alias, connInfo, (SSLConfigChangeListener)listener);
        }
        catch (SSLException e) {
            return "Caugh unexpected exception: " + e.getMessage() + " " + e.getStackTrace();
        }
        return null;
    }

    public String testGetSSLSocketFactory(String alias, Map connInfo, Properties props) {
        DefaultSSLConfigChangeListener listener = new DefaultSSLConfigChangeListener();
        try {
            JSSEHelper.getInstance().getSSLSocketFactory(connInfo, props);
            JSSEHelper.getInstance().getSSLSocketFactory(null, props);
        }
        catch (SSLException e) {
            return "Unexpected exception caught in APITestsBean: " + e.getMessage() + " " + e.getStackTrace();
        }
        try {
            JSSEHelper.getInstance().getSSLSocketFactory(connInfo, null);
            return "Expected exception was not thrown in APITestsBean in function testGetSSLSocketFactory";
        }
        catch (SSLException e) {
            try {
                JSSEHelper.getInstance().getSSLSocketFactory(null, null);
                return "Expected exception was not thrown in ApiTestsBean in function testGetSSLSocketFactory";
            }
            catch (SSLException e2) {
                try {
                    JSSEHelper.getInstance().getSSLSocketFactory(null, null, null);
                    JSSEHelper.getInstance().getSSLSocketFactory(null, null, (SSLConfigChangeListener)listener);
                    JSSEHelper.getInstance().getSSLSocketFactory(null, connInfo, null);
                    JSSEHelper.getInstance().getSSLSocketFactory(null, connInfo, (SSLConfigChangeListener)listener);
                    JSSEHelper.getInstance().getSSLSocketFactory(alias, null, null);
                    JSSEHelper.getInstance().getSSLSocketFactory(alias, null, (SSLConfigChangeListener)listener);
                    JSSEHelper.getInstance().getSSLSocketFactory(alias, connInfo, null);
                    JSSEHelper.getInstance().getSSLSocketFactory(alias, connInfo, (SSLConfigChangeListener)listener);
                }
                catch (SSLException e3) {
                    return "Unexpected exception caught in APITestsBean: " + e3.getMessage() + e3.getStackTrace();
                }
                return null;
            }
        }
    }

    public String testGetSSLServerSocketFactory(String alias, Map connInfo, Properties props) {
        DefaultSSLConfigChangeListener listener = new DefaultSSLConfigChangeListener();
        try {
            JSSEHelper.getInstance().getSSLServerSocketFactory(props);
        }
        catch (SSLException e) {
            return "Unexpected exception caught in APITestsBean: " + e.getMessage() + " " + e.getStackTrace();
        }
        try {
            JSSEHelper.getInstance().getSSLServerSocketFactory(null);
            return "Expected exception was not thrown in APITestsBean in function testGetSSLServerSocketFactory";
        }
        catch (SSLException e) {
            try {
                JSSEHelper.getInstance().getSSLServerSocketFactory(null, null, null);
                JSSEHelper.getInstance().getSSLServerSocketFactory(null, null, (SSLConfigChangeListener)listener);
                JSSEHelper.getInstance().getSSLServerSocketFactory(null, connInfo, null);
                JSSEHelper.getInstance().getSSLServerSocketFactory(null, connInfo, (SSLConfigChangeListener)listener);
                JSSEHelper.getInstance().getSSLServerSocketFactory(alias, null, null);
                JSSEHelper.getInstance().getSSLServerSocketFactory(alias, null, (SSLConfigChangeListener)listener);
                JSSEHelper.getInstance().getSSLServerSocketFactory(alias, connInfo, null);
                JSSEHelper.getInstance().getSSLServerSocketFactory(alias, connInfo, (SSLConfigChangeListener)listener);
            }
            catch (SSLException e2) {
                return "Unexpected exception caught in APITestsBean: " + e2.getMessage() + e2.getStackTrace();
            }
            return null;
        }
    }

    public String testSSLConfigChangeEvent(String alias, Properties props, Map connInfo) {
        SSLConfigChangeEvent event = new SSLConfigChangeEvent(alias, props, "dynamic", connInfo);
        return null;
    }

    public WSCredential getWSCredential(WSPrincipal prin) {
        return prin.getCredential();
    }

    public ManagedConnectionFactory getManagedConnectionFactory(String username, String realm, String origUser, byte[] token) {
        IdentityPrincipal myPrin = new IdentityPrincipal(username, realm, origUser, token);
        WSManagedConnectionFactoryImpl myFactory = new WSManagedConnectionFactoryImpl();
        myPrin.setManagedConnectionFactory((ManagedConnectionFactory)myFactory);
        return myPrin.getManagedConnectionFactory();
    }

    public SessionContext getSessionContext() {
        return this.mySessionCtx;
    }

    public void setSessionContext(SessionContext ctx) {
        this.mySessionCtx = ctx;
    }

    public void ejbCreate() throws CreateException {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void ejbRemove() {
    }
}

