/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.github.tomakehurst.wiremock.recording.SnapshotRecordResult;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import wiremock.com.fasterxml.jackson.core.JsonParseException;
import wiremock.com.fasterxml.jackson.core.JsonParser;
import wiremock.com.fasterxml.jackson.core.JsonProcessingException;
import wiremock.com.fasterxml.jackson.core.type.TypeReference;
import wiremock.com.fasterxml.jackson.databind.DeserializationContext;
import wiremock.com.fasterxml.jackson.databind.JavaType;
import wiremock.com.fasterxml.jackson.databind.deser.std.StdDeserializer;

public class SnapshotRecordResultDeserialiser
extends StdDeserializer<SnapshotRecordResult> {
    protected SnapshotRecordResultDeserialiser() {
        super(SnapshotRecordResult.class);
    }

    @Override
    public SnapshotRecordResult deserialize(JsonParser parser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        String name = parser.nextFieldName();
        parser.nextToken();
        if (name.equals("mappings")) {
            JavaType listType = deserializationContext.getTypeFactory().constructType(new TypeReference<List<StubMapping>>(){});
            List mappings = (List)deserializationContext.readValue(parser, listType);
            return SnapshotRecordResult.full(mappings);
        }
        if (name.equals("ids")) {
            JavaType listType = deserializationContext.getTypeFactory().constructType(new TypeReference<List<UUID>>(){});
            List ids = (List)deserializationContext.readValue(parser, listType);
            return SnapshotRecordResult.ids(ids);
        }
        throw new JsonParseException(parser, "Snapshot result must contain either mappings or ids element");
    }
}

