/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.provisioning;

import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.provisioning.ProductExtension;
import com.ibm.ws.kernel.provisioning.ProductExtensionInfo;
import com.ibm.ws.kernel.provisioning.ServiceFingerprint;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class ProductExtension {
    public static final String PRODUCT_EXTENSION_DIR = "etc/extensions";
    public static final String PRODUCT_EXTENSIONS_FILE_EXTENSION = ".properties";
    public static final String PRODUCT_EXTENSIONS_INSTALL = "com.ibm.websphere.productInstall";
    public static final String PRODUCT_EXTENSIONS_ID = "com.ibm.websphere.productId";
    private static FileFilter PROPERTIESFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.getName().endsWith(ProductExtension.PRODUCT_EXTENSIONS_FILE_EXTENSION);
        }
    };

    private static File getExtensionDir(File installDir) {
        return new File(installDir, PRODUCT_EXTENSION_DIR);
    }

    public static List<ProductExtensionInfo> getProductExtensions() {
        return ProductExtension.getProductExtensions(Utils.getInstallDir());
    }

    public static List<ProductExtensionInfo> getProductExtensions(File installDir) {
        ArrayList<ProductExtensionInfo> productList = new ArrayList<ProductExtensionInfo>();
        File productExtensionsDir = ProductExtension.getExtensionDir(installDir);
        if (productExtensionsDir.exists()) {
            File[] productPropertiesFiles;
            File[] fileArray = productPropertiesFiles = productExtensionsDir.listFiles(PROPERTIESFilter);
            int n = productPropertiesFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String fileName = file.getName();
                String productName = fileName.substring(0, fileName.indexOf(PRODUCT_EXTENSIONS_FILE_EXTENSION));
                if (productName.length() != 0 && !"usr".equalsIgnoreCase(productName)) {
                    try {
                        ProductExtensionInfo prodInfo = ProductExtension.loadExtensionInfo(productName, file);
                        if (prodInfo != null) {
                            productList.add(prodInfo);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
        }
        return productList;
    }

    public static ProductExtensionInfo getProductExtension(String extensionName) throws IOException {
        File extensionFile = new File(ProductExtension.getExtensionDir(Utils.getInstallDir()), String.valueOf(extensionName) + PRODUCT_EXTENSIONS_FILE_EXTENSION);
        return ProductExtension.loadExtensionInfo(extensionName, extensionFile);
    }

    private static ProductExtensionInfo loadExtensionInfo(String productName, File extensionFile) throws IOException {
        if (extensionFile.isFile()) {
            ProductExtensionInfoImpl productExtensionInfoImpl;
            Properties featureProperties = new Properties();
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(extensionFile);
                featureProperties.load(fileInputStream);
                String installLocation = featureProperties.getProperty(PRODUCT_EXTENSIONS_INSTALL);
                String productId = featureProperties.getProperty(PRODUCT_EXTENSIONS_ID);
                ServiceFingerprint.put((File)extensionFile);
                productExtensionInfoImpl = new ProductExtensionInfoImpl(productName, productId, installLocation);
            }
            catch (Throwable throwable) {
                Utils.tryToClose(fileInputStream);
                throw throwable;
            }
            Utils.tryToClose(fileInputStream);
            return productExtensionInfoImpl;
        }
        return null;
    }
}

