/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.util.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.aries.util.filesystem.IFile;
import org.apache.aries.util.internal.MessageUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream in, OutputStream out) throws IOException {
        try {
            IOUtils.copyAndDoNotCloseInputStream(in, out);
        }
        finally {
            IOUtils.close(in);
        }
    }

    public static void copyAndDoNotCloseInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] b = new byte[1024];
        while ((len = in.read(b)) != -1) {
            out.write(b, 0, len);
        }
    }

    public static void close(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (IOException e) {
            c = null;
        }
    }

    public static void close(ZipFile file) throws IOException {
        if (file != null) {
            file.close();
        }
    }

    public static OutputStream getOutputStream(File outputDir, String relativePath) throws IOException {
        File outputDirectory;
        int lastSeparatorIndex = relativePath.replace(File.separatorChar, '/').lastIndexOf("/");
        String dirName = null;
        String fileName = null;
        if (lastSeparatorIndex != -1) {
            dirName = relativePath.substring(0, lastSeparatorIndex);
            fileName = relativePath.substring(lastSeparatorIndex + 1);
            outputDirectory = new File(outputDir, dirName);
            if (!outputDirectory.exists() && !outputDirectory.mkdirs()) {
                throw new IOException(MessageUtil.getMessage((String)"UTIL0015E", (Object[])new Object[]{relativePath}));
            }
        } else {
            outputDirectory = outputDir;
            fileName = relativePath;
        }
        File outputFile = new File(outputDirectory, fileName);
        return new FileOutputStream(outputFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeOut(File outputDir, String relativePath, InputStream content) throws IOException {
        OutputStream out = null;
        try {
            out = IOUtils.getOutputStream(outputDir, relativePath);
            IOUtils.copy(content, out);
        }
        finally {
            IOUtils.close(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeOutAndDontCloseInputStream(File outputDir, String relativePath, InputStream content) throws IOException {
        OutputStream out = null;
        try {
            out = IOUtils.getOutputStream(outputDir, relativePath);
            IOUtils.copyAndDoNotCloseInputStream(content, out);
        }
        finally {
            IOUtils.close(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipUp(File rootDir, OutputStream targetStream) throws IOException {
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream(targetStream);
            IOUtils.zipUpRecursive(out, "", rootDir, Collections.EMPTY_SET);
        }
        catch (Throwable throwable) {
            IOUtils.close(out);
            throw throwable;
        }
        IOUtils.close(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipUp(File rootDir, File targetFile) throws IOException {
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream(new FileOutputStream(targetFile));
            IOUtils.zipUpRecursive(out, "", rootDir, Collections.EMPTY_SET);
        }
        catch (Throwable throwable) {
            IOUtils.close(out);
            throw throwable;
        }
        IOUtils.close(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void jarUp(File rootDir, File targetFile, Manifest manifest) throws IOException {
        JarOutputStream out = null;
        try {
            out = new JarOutputStream((OutputStream)new FileOutputStream(targetFile), manifest);
            IOUtils.zipUpRecursive(out, "", rootDir, new HashSet<String>(Arrays.asList("META-INF/MANIFEST.MF")));
        }
        catch (Throwable throwable) {
            IOUtils.close(out);
            throw throwable;
        }
        IOUtils.close(out);
    }

    private static void zipUpRecursive(ZipOutputStream out, String prefix, File directory, Set<String> filesToExclude) throws IOException {
        File[] files = directory.listFiles();
        if (files != null) {
            for (File f : files) {
                String fileName = f.isDirectory() ? prefix + f.getName() + "/" : prefix + f.getName();
                if (filesToExclude.contains(fileName)) continue;
                ZipEntry ze = new ZipEntry(fileName);
                ze.setSize(f.length());
                ze.setTime(f.lastModified());
                out.putNextEntry(ze);
                if (f.isDirectory()) {
                    IOUtils.zipUpRecursive(out, fileName, f, filesToExclude);
                    continue;
                }
                IOUtils.copy(new FileInputStream(f), out);
            }
        }
    }

    public static boolean deleteRecursive(File root) {
        if (!root.exists()) {
            return false;
        }
        if (root.isFile()) {
            return root.delete();
        }
        boolean result = true;
        for (File f : root.listFiles()) {
            result = IOUtils.deleteRecursive(f) && result;
        }
        return root.delete() && result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unpackZip(IFile zip, File outputDir) throws IOException {
        ZipInputStream zis;
        boolean success;
        block8: {
            success = true;
            zis = null;
            try {
                boolean isZip = false;
                ZipEntry zipEntry = null;
                try {
                    zis = new ZipInputStream(zip.open());
                    zipEntry = zis.getNextEntry();
                    isZip = zipEntry != null;
                }
                catch (ZipException e) {
                    isZip = false;
                }
                catch (UnsupportedOperationException e) {
                    isZip = false;
                }
                if (isZip) {
                    do {
                        if (!zipEntry.isDirectory()) {
                            IOUtils.writeOutAndDontCloseInputStream(outputDir, zipEntry.getName(), zis);
                        }
                        zis.closeEntry();
                    } while ((zipEntry = zis.getNextEntry()) != null);
                    break block8;
                }
                success = false;
            }
            catch (Throwable throwable) {
                IOUtils.close(zis);
                throw throwable;
            }
        }
        IOUtils.close(zis);
        return success;
    }
}

