CREATE TABLE CUSTOMER (
		CUSTID VARCHAR(250) NOT NULL,
		CUSTPWD VARCHAR(250),
		CUSTNAME VARCHAR(250),
		NUMINVOICESCREATED INTEGER NOT NULL,
		NUMINVOICESCOMPLETED INTEGER NOT NULL
	)
	AUDIT NONE
	DATA CAPTURE NONE 
	CCSID EBCDIC;

CREATE TABLE CUSTOMERINFO (
		CUSTID VARCHAR(250) NOT NULL,
		ADDRESS1 VARCHAR(250),
		ADDRESS2 VARCHAR(250),
		PHONE VARCHAR(250),
		EMAIL VARCHAR(250),
		CCNUM VARCHAR(250)
	)
	AUDIT NONE
	DATA CAPTURE NONE 
	CCSID EBCDIC;

CREATE TABLE CATEGORY (
		CATEGORYNAME VARCHAR(250) NOT NULL,
		NUMITEMSINCATEGORY INTEGER NOT NULL,
		CATEGORYDESCRIPTION VARCHAR(250)
	)
	AUDIT NONE
	DATA CAPTURE NONE 
	CCSID EBCDIC;

CREATE TABLE INVENTORY (
		CATEGORYNAME VARCHAR(250),
		ITEMID VARCHAR(250) NOT NULL,
		MFGNAME VARCHAR(250),
		UNITPRICE REAL NOT NULL,
		INVENTORYSOLD INTEGER NOT NULL,
		DESCRIPTION VARCHAR(250),
		PIC VARCHAR (1000) FOR BIT DATA
	)
	AUDIT NONE
	DATA CAPTURE NONE 
	CCSID EBCDIC;

CREATE TABLE MFGCATEGORY (
		MFGNAME VARCHAR(250) NOT NULL,
		CATEGORY_CATEGORYNAME VARCHAR(250) NOT NULL
	)
	AUDIT NONE
	DATA CAPTURE NONE 
	CCSID EBCDIC;

CREATE TABLE STORECREDIT (
		AMOUNT REAL NOT NULL,
		CUSTID VARCHAR(250) NOT NULL,
		TIME1 TIMESTAMP NOT NULL
	)
	AUDIT NONE
	DATA CAPTURE NONE 
	CCSID EBCDIC;

CREATE TABLE SETTINGS (
		ID INTEGER NOT NULL,
		NUMSUBACCOUNTS INTEGER NOT NULL,
		NUMCATEGORIES INTEGER NOT NULL,
		NUMMFGCATEGORIES INTEGER NOT NULL,
		NUMITEMSPERMFG INTEGER NOT NULL,
		NUMCUSTOMERS INTEGER NOT NULL,
		WSATENABLED SMALLINT NOT NULL,
		WSNENABLED SMALLINT NOT NULL,
		SDOENABLED SMALLINT NOT NULL,
		WSNVARIABLES VARCHAR(250)
	)
	AUDIT NONE
	DATA CAPTURE NONE 
	CCSID EBCDIC;

CREATE UNIQUE INDEX PK_CUSTOMER ON CUSTOMER (CUSTID);

CREATE UNIQUE INDEX PK_CUSTOMERINFO ON CUSTOMERINFO (CUSTID);

CREATE UNIQUE INDEX PK_CATEGORY ON CATEGORY (CATEGORYNAME);

CREATE UNIQUE INDEX PK_INVENTORY ON INVENTORY (ITEMID);

CREATE UNIQUE INDEX PK_MFGCATEGORY ON MFGCATEGORY (MFGNAME, CATEGORY_CATEGORYNAME);

CREATE UNIQUE INDEX PK_STORECREDIT ON STORECREDIT (CUSTID, TIME1);

CREATE UNIQUE INDEX PK_SETTINGS ON SETTINGS (ID);

ALTER TABLE CUSTOMER ADD CONSTRAINT PK_CUSTOMER PRIMARY KEY (CUSTID);

ALTER TABLE CUSTOMERINFO ADD CONSTRAINT PK_CUSTOMERINFO PRIMARY KEY (CUSTID);

ALTER TABLE CATEGORY ADD CONSTRAINT PK_CATEGORY PRIMARY KEY (CATEGORYNAME);

ALTER TABLE INVENTORY ADD CONSTRAINT PK_INVENTORY PRIMARY KEY (ITEMID);

ALTER TABLE MFGCATEGORY ADD CONSTRAINT PK_MFGCATEGORY PRIMARY KEY (MFGNAME, CATEGORY_CATEGORYNAME);

ALTER TABLE STORECREDIT ADD CONSTRAINT PK_STORECREDIT PRIMARY KEY (CUSTID, TIME1);

ALTER TABLE SETTINGS ADD CONSTRAINT PK_SETTINGS PRIMARY KEY (ID);

