/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.RuleSetBase;

public class ClusterRuleSetFactory {
    public static Log log = LogFactory.getLog(ClusterRuleSetFactory.class);

    public static RuleSetBase getClusterRuleSet(String prefix) {
        try {
            return ClusterRuleSetFactory.loadRuleSet(prefix, "org.apache.catalina.ha.ClusterRuleSet", ClusterRuleSetFactory.class.getClassLoader());
        }
        catch (Exception x) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Unable to load HA ClusterRuleSet (org.apache.catalina.ha.ClusterRuleSet)");
            }
            return new DefaultClusterRuleSet(prefix);
        }
    }

    protected static RuleSetBase loadRuleSet(String prefix, String className, ClassLoader cl) throws ClassNotFoundException, InstantiationException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = Class.forName(className, true, cl);
        Constructor<?> cons = clazz.getConstructor(String.class);
        return (RuleSetBase)cons.newInstance(prefix);
    }

    public static class DefaultClusterRuleSet
    extends RuleSetBase {
        protected String prefix = null;

        public DefaultClusterRuleSet() {
            this("");
        }

        public DefaultClusterRuleSet(String prefix) {
            this.namespaceURI = null;
            this.prefix = prefix;
        }

        public void addRuleInstances(Digester digester) {
            digester.addObjectCreate(this.prefix + "Membership", null, "className");
            digester.addSetProperties(this.prefix + "Membership");
            digester.addSetNext(this.prefix + "Membership", "setMembershipService", "org.apache.catalina.cluster.MembershipService");
            digester.addObjectCreate(this.prefix + "Sender", null, "className");
            digester.addSetProperties(this.prefix + "Sender");
            digester.addSetNext(this.prefix + "Sender", "setClusterSender", "org.apache.catalina.cluster.ClusterSender");
            digester.addObjectCreate(this.prefix + "Receiver", null, "className");
            digester.addSetProperties(this.prefix + "Receiver");
            digester.addSetNext(this.prefix + "Receiver", "setClusterReceiver", "org.apache.catalina.cluster.ClusterReceiver");
            digester.addObjectCreate(this.prefix + "Valve", null, "className");
            digester.addSetProperties(this.prefix + "Valve");
            digester.addSetNext(this.prefix + "Valve", "addValve", "org.apache.catalina.Valve");
            digester.addObjectCreate(this.prefix + "Deployer", null, "className");
            digester.addSetProperties(this.prefix + "Deployer");
            digester.addSetNext(this.prefix + "Deployer", "setClusterDeployer", "org.apache.catalina.cluster.ClusterDeployer");
            digester.addObjectCreate(this.prefix + "Listener", null, "className");
            digester.addSetProperties(this.prefix + "Listener");
            digester.addSetNext(this.prefix + "Listener", "addLifecycleListener", "org.apache.catalina.LifecycleListener");
            digester.addObjectCreate(this.prefix + "ClusterListener", null, "className");
            digester.addSetProperties(this.prefix + "ClusterListener");
            digester.addSetNext(this.prefix + "ClusterListener", "addClusterListener", "org.apache.catalina.cluster.MessageListener");
        }
    }
}

