/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.cts.ejb;

import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.NoSuchObjectLocalException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.logging.Logger;
import org.jboss.test.cts.interfaces.ClientCallback;
import org.jboss.test.cts.interfaces.StatefulSessionLocal;
import org.jboss.test.cts.interfaces.StatefulSessionLocalHome;
import org.jboss.test.cts.interfaces.StatelessSession;
import org.jboss.test.cts.interfaces.StatelessSessionHome;
import org.jboss.test.cts.interfaces.StatelessSessionLocal;
import org.jboss.test.cts.interfaces.StatelessSessionLocalHome;
import org.jboss.test.util.ejb.SessionSupport;

public class StatelessSessionBean
extends SessionSupport {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(StatelessSessionBean.class);
    private static boolean breakCreate = false;

    public void ejbCreate() throws CreateException {
        if (breakCreate) {
            throw new CreateException("broken create");
        }
    }

    public String method1(String msg) {
        return msg;
    }

    public void breakCreate() {
        breakCreate = true;
    }

    public void loopbackTest() throws RemoteException {
        try {
            StatelessSession sessionBean;
            InitialContext ctx = new InitialContext();
            StatelessSessionHome home = (StatelessSessionHome)ctx.lookup("ejbcts/StatelessSessionBean");
            try {
                sessionBean = home.create();
            }
            catch (CreateException ex) {
                log.debug((Object)("Loopback CreateException: " + (Object)((Object)ex)));
                throw new EJBException((Exception)((Object)ex));
            }
            sessionBean.loopbackTest(this.sessionCtx.getEJBObject());
        }
        catch (NamingException nex) {
            log.debug((Object)"Could not locate bean instance");
        }
    }

    public void loopbackTest(EJBObject obj) throws RemoteException {
        StatelessSession bean = (StatelessSession)obj;
        bean.method1("Hello");
    }

    public void callbackTest(ClientCallback callback, String data) throws RemoteException {
        callback.callback(data);
    }

    public void npeError() {
        Object obj = null;
        obj.toString();
    }

    public void testLocalHome() throws InvocationTargetException {
        StatelessSessionLocalHome home = (StatelessSessionLocalHome)this.sessionCtx.getEJBLocalHome();
        log.debug((Object)"Obtained StatelessSessionLocalHome from ctx");
        try {
            StatelessSessionLocal local = home.create();
            log.debug((Object)"Created StatelessSessionLocal#1");
            StatelessSessionLocalHome home2 = (StatelessSessionLocalHome)local.getEJBLocalHome();
            log.debug((Object)"Obtained StatelessSessionLocalHome from StatelessSessionLocal");
            local = home2.create();
            log.debug((Object)"Created StatelessSessionLocal#2");
            local.remove();
        }
        catch (Exception e) {
            log.debug((Object)"testLocalHome failed", (Throwable)e);
            throw new InvocationTargetException(e, "testLocalHome failed");
        }
    }

    public void testPassivationByTimeLocal() {
        StatefulSessionLocal sessionBean1 = null;
        Handle handle = null;
        try {
            InitialContext ctx = new InitialContext();
            log.debug((Object)"+++ testPassivationByTime");
            StatefulSessionLocalHome sessionHome = (StatefulSessionLocalHome)ctx.lookup("ejbcts/StatefulSessionLocalBean");
            sessionBean1 = sessionHome.create("testPassivationByTimeLocal");
            sessionBean1.ping();
            handle = sessionBean1.getHandle();
            log.debug((Object)"Waiting 41 seconds for passivation...");
            Thread.sleep(41000L);
            boolean passivated = sessionBean1.getWasPassivated();
            if (!passivated) {
                throw new EJBException("sessionBean1 WasPassivated");
            }
            boolean activated = sessionBean1.getWasActivated();
            if (!activated) {
                throw new EJBException("sessionBean1 WasActivated");
            }
            log.debug((Object)"Waiting 90 seconds for removal due to age...");
            Thread.sleep(90000L);
        }
        catch (CreateException e) {
            throw new EJBException(e.toString());
        }
        catch (NamingException e) {
            throw new EJBException(e.toString());
        }
        catch (InterruptedException e) {
            throw new EJBException(e.toString());
        }
        try {
            sessionBean1.ping();
            throw new EJBException("Was able to ping for a removed session");
        }
        catch (NoSuchObjectLocalException expected) {
            log.debug((Object)"Session access failed as expected", (Throwable)expected);
            try {
                handle.getEJBObject();
                throw new EJBException("Was able to getEJBObject for a removed session");
            }
            catch (RemoteException expected2) {
                log.debug((Object)"Session access failed as expected", (Throwable)expected2);
                return;
            }
        }
    }
}

