/*
 * Decompiled with CFR 0.152.
 */
package net.sf.log4jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import net.sf.log4jdbc.ConnectionSpy;
import net.sf.log4jdbc.OracleRdbmsSpecifics;
import net.sf.log4jdbc.RdbmsSpecifics;
import net.sf.log4jdbc.SpyLogDelegator;
import net.sf.log4jdbc.SpyLogFactory;
import net.sf.log4jdbc.SqlServerRdbmsSpecifics;

public class DriverSpy
implements Driver {
    private Driver lastUnderlyingDriverRequested;
    private static Map rdbmsSpecifics;
    static final SpyLogDelegator log;
    static String DebugStackPrefix;
    static boolean TraceFromApplication;
    static boolean SqlTimingWarnThresholdEnabled;
    static long SqlTimingWarnThresholdMsec;
    static boolean SqlTimingErrorThresholdEnabled;
    static long SqlTimingErrorThresholdMsec;
    static boolean DumpBooleanAsTrueFalse;
    static int DumpSqlMaxLineLength;
    static boolean StatementUsageWarn;
    static boolean DumpSqlSelect;
    static boolean DumpSqlInsert;
    static boolean DumpSqlUpdate;
    static boolean DumpSqlDelete;
    static boolean DumpSqlCreate;
    static boolean DumpSqlFilteringOn;
    static boolean DumpSqlAddSemicolon;
    static boolean DumpFullDebugStackTrace;
    static boolean AutoLoadPopularDrivers;
    static boolean TrimSql;
    static boolean SuppressGetGeneratedKeysException;
    static RdbmsSpecifics defaultRdbmsSpecifics;

    private static Long getLongOption(Properties props, String propName) {
        String propValue = props.getProperty(propName);
        Long longPropValue = null;
        if (propValue == null) {
            log.debug("x " + propName + " is not defined");
        } else {
            try {
                longPropValue = new Long(Long.parseLong(propValue));
                log.debug("  " + propName + " = " + longPropValue);
            }
            catch (NumberFormatException n) {
                log.debug("x " + propName + " \"" + propValue + "\" is not a valid number");
            }
        }
        return longPropValue;
    }

    private static Long getLongOption(Properties props, String propName, long defaultValue) {
        Long longPropValue;
        String propValue = props.getProperty(propName);
        if (propValue == null) {
            log.debug("x " + propName + " is not defined (using default of " + defaultValue + ")");
            longPropValue = new Long(defaultValue);
        } else {
            try {
                longPropValue = new Long(Long.parseLong(propValue));
                log.debug("  " + propName + " = " + longPropValue);
            }
            catch (NumberFormatException n) {
                log.debug("x " + propName + " \"" + propValue + "\" is not a valid number (using default of " + defaultValue + ")");
                longPropValue = new Long(defaultValue);
            }
        }
        return longPropValue;
    }

    private static String getStringOption(Properties props, String propName) {
        String propValue = props.getProperty(propName);
        if (propValue == null || propValue.length() == 0) {
            log.debug("x " + propName + " is not defined");
            propValue = null;
        } else {
            log.debug("  " + propName + " = " + propValue);
        }
        return propValue;
    }

    private static boolean getBooleanOption(Properties props, String propName, boolean defaultValue) {
        String propValue = props.getProperty(propName);
        if (propValue == null) {
            log.debug("x " + propName + " is not defined (using default value " + defaultValue + ")");
            return defaultValue;
        }
        boolean val = (propValue = propValue.trim().toLowerCase()).length() == 0 ? defaultValue : "true".equals(propValue) || "yes".equals(propValue) || "on".equals(propValue);
        log.debug("  " + propName + " = " + val);
        return val;
    }

    static RdbmsSpecifics getRdbmsSpecifics(Connection conn) {
        String driverName = "";
        try {
            DatabaseMetaData dbm = conn.getMetaData();
            driverName = dbm.getDriverName();
        }
        catch (SQLException s) {
            // empty catch block
        }
        log.debug("driver name is " + driverName);
        RdbmsSpecifics r = (RdbmsSpecifics)rdbmsSpecifics.get(driverName);
        if (r == null) {
            return defaultRdbmsSpecifics;
        }
        return r;
    }

    @Override
    public int getMajorVersion() {
        if (this.lastUnderlyingDriverRequested == null) {
            return 1;
        }
        return this.lastUnderlyingDriverRequested.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        if (this.lastUnderlyingDriverRequested == null) {
            return 0;
        }
        return this.lastUnderlyingDriverRequested.getMinorVersion();
    }

    @Override
    public boolean jdbcCompliant() {
        return this.lastUnderlyingDriverRequested != null && this.lastUnderlyingDriverRequested.jdbcCompliant();
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        Driver d = this.getUnderlyingDriver(url);
        if (d != null) {
            this.lastUnderlyingDriverRequested = d;
            return true;
        }
        return false;
    }

    private Driver getUnderlyingDriver(String url) throws SQLException {
        if (url.startsWith("jdbc:log4")) {
            url = url.substring(9);
            Enumeration<Driver> e = DriverManager.getDrivers();
            while (e.hasMoreElements()) {
                Driver d = e.nextElement();
                if (!d.acceptsURL(url)) continue;
                return d;
            }
        }
        return null;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        Driver d = this.getUnderlyingDriver(url);
        if (d == null) {
            return null;
        }
        url = url.substring(9);
        this.lastUnderlyingDriverRequested = d;
        Connection c = d.connect(url, info);
        if (c == null) {
            throw new SQLException("invalid or unknown driver url: " + url);
        }
        if (log.isJdbcLoggingEnabled()) {
            ConnectionSpy cspy = new ConnectionSpy(c);
            RdbmsSpecifics r = null;
            String dclass = d.getClass().getName();
            if (dclass != null && dclass.length() > 0) {
                r = (RdbmsSpecifics)rdbmsSpecifics.get(dclass);
            }
            if (r == null) {
                r = defaultRdbmsSpecifics;
            }
            cspy.setRdbmsSpecifics(r);
            return cspy;
        }
        return c;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        Driver d = this.getUnderlyingDriver(url);
        if (d == null) {
            return new DriverPropertyInfo[0];
        }
        this.lastUnderlyingDriverRequested = d;
        return d.getPropertyInfo(url, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String moreDrivers;
        log = SpyLogFactory.getSpyLogDelegator();
        log.debug("... log4jdbc initializing ...");
        InputStream propStream = DriverSpy.class.getResourceAsStream("/log4jdbc.properties");
        Properties props = new Properties(System.getProperties());
        if (propStream != null) {
            try {
                props.load(propStream);
            }
            catch (IOException e) {
                log.debug("ERROR!  io exception loading log4jdbc.properties from classpath: " + e.getMessage());
            }
            finally {
                try {
                    propStream.close();
                }
                catch (IOException e) {
                    log.debug("ERROR!  io exception closing property file stream: " + e.getMessage());
                }
            }
            log.debug("  log4jdbc.properties loaded from classpath");
        } else {
            log.debug("  log4jdbc.properties not found on classpath");
        }
        DebugStackPrefix = DriverSpy.getStringOption(props, "log4jdbc.debug.stack.prefix");
        TraceFromApplication = DebugStackPrefix != null;
        Long thresh = DriverSpy.getLongOption(props, "log4jdbc.sqltiming.warn.threshold");
        boolean bl = SqlTimingWarnThresholdEnabled = thresh != null;
        if (SqlTimingWarnThresholdEnabled) {
            SqlTimingWarnThresholdMsec = thresh;
        }
        boolean bl2 = SqlTimingErrorThresholdEnabled = (thresh = DriverSpy.getLongOption(props, "log4jdbc.sqltiming.error.threshold")) != null;
        if (SqlTimingErrorThresholdEnabled) {
            SqlTimingErrorThresholdMsec = thresh;
        }
        DumpBooleanAsTrueFalse = DriverSpy.getBooleanOption(props, "log4jdbc.dump.booleanastruefalse", false);
        DumpSqlMaxLineLength = DriverSpy.getLongOption(props, "log4jdbc.dump.sql.maxlinelength", 90L).intValue();
        DumpFullDebugStackTrace = DriverSpy.getBooleanOption(props, "log4jdbc.dump.fulldebugstacktrace", false);
        StatementUsageWarn = DriverSpy.getBooleanOption(props, "log4jdbc.statement.warn", false);
        DumpSqlSelect = DriverSpy.getBooleanOption(props, "log4jdbc.dump.sql.select", true);
        DumpSqlInsert = DriverSpy.getBooleanOption(props, "log4jdbc.dump.sql.insert", true);
        DumpSqlUpdate = DriverSpy.getBooleanOption(props, "log4jdbc.dump.sql.update", true);
        DumpSqlDelete = DriverSpy.getBooleanOption(props, "log4jdbc.dump.sql.delete", true);
        DumpSqlCreate = DriverSpy.getBooleanOption(props, "log4jdbc.dump.sql.create", true);
        DumpSqlFilteringOn = !DumpSqlSelect || !DumpSqlInsert || !DumpSqlUpdate || !DumpSqlDelete || !DumpSqlCreate;
        DumpSqlAddSemicolon = DriverSpy.getBooleanOption(props, "log4jdbc.dump.sql.addsemicolon", false);
        AutoLoadPopularDrivers = DriverSpy.getBooleanOption(props, "log4jdbc.auto.load.popular.drivers", true);
        TrimSql = DriverSpy.getBooleanOption(props, "log4jdbc.trim.sql", true);
        SuppressGetGeneratedKeysException = DriverSpy.getBooleanOption(props, "log4jdbc.suppress.generated.keys.exception", false);
        TreeSet<String> subDrivers = new TreeSet<String>();
        if (AutoLoadPopularDrivers) {
            subDrivers.add("oracle.jdbc.driver.OracleDriver");
            subDrivers.add("oracle.jdbc.OracleDriver");
            subDrivers.add("com.sybase.jdbc2.jdbc.SybDriver");
            subDrivers.add("net.sourceforge.jtds.jdbc.Driver");
            subDrivers.add("com.microsoft.jdbc.sqlserver.SQLServerDriver");
            subDrivers.add("com.microsoft.sqlserver.jdbc.SQLServerDriver");
            subDrivers.add("weblogic.jdbc.sqlserver.SQLServerDriver");
            subDrivers.add("com.informix.jdbc.IfxDriver");
            subDrivers.add("org.apache.derby.jdbc.ClientDriver");
            subDrivers.add("org.apache.derby.jdbc.EmbeddedDriver");
            subDrivers.add("com.mysql.jdbc.Driver");
            subDrivers.add("org.postgresql.Driver");
            subDrivers.add("org.hsqldb.jdbcDriver");
            subDrivers.add("org.h2.Driver");
        }
        if ((moreDrivers = DriverSpy.getStringOption(props, "log4jdbc.drivers")) != null) {
            String[] moreDriversArr = moreDrivers.split(",");
            for (int i = 0; i < moreDriversArr.length; ++i) {
                subDrivers.add(moreDriversArr[i]);
                log.debug("    will look for specific driver " + moreDriversArr[i]);
            }
        }
        try {
            DriverManager.registerDriver(new DriverSpy());
        }
        catch (SQLException s) {
            throw (RuntimeException)new RuntimeException("could not register log4jdbc driver!").initCause(s);
        }
        Iterator i = subDrivers.iterator();
        while (i.hasNext()) {
            String driverClass = (String)i.next();
            try {
                Class.forName(driverClass);
                log.debug("  FOUND DRIVER " + driverClass);
            }
            catch (Throwable c) {
                i.remove();
            }
        }
        if (subDrivers.size() == 0) {
            log.debug("WARNING!  log4jdbc couldn't find any underlying jdbc drivers.");
        }
        SqlServerRdbmsSpecifics sqlServer = new SqlServerRdbmsSpecifics();
        OracleRdbmsSpecifics oracle = new OracleRdbmsSpecifics();
        rdbmsSpecifics = new HashMap();
        rdbmsSpecifics.put("oracle.jdbc.driver.OracleDriver", oracle);
        rdbmsSpecifics.put("oracle.jdbc.OracleDriver", oracle);
        rdbmsSpecifics.put("net.sourceforge.jtds.jdbc.Driver", sqlServer);
        rdbmsSpecifics.put("com.microsoft.jdbc.sqlserver.SQLServerDriver", sqlServer);
        rdbmsSpecifics.put("weblogic.jdbc.sqlserver.SQLServerDriver", sqlServer);
        log.debug("... log4jdbc initialized! ...");
        defaultRdbmsSpecifics = new RdbmsSpecifics();
    }
}

