/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.auth;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.jboss.security.Util;

public class TemporarySessionPasswordGenerator {
    private static final char SESSION_PASSWORD_SEPARATOR = '$';
    private static final String SESSION_PASSWORD_PREFIX = "_x|=~";
    private final Map<Integer, Long> m_sessionPasswordCreationDates = new HashMap<Integer, Long>();
    private final Map<Integer, String> m_sessionPasswordMD5Strings = new HashMap<Integer, String>();
    private final int m_timeoutMillis;

    public TemporarySessionPasswordGenerator() {
        this(3600000);
    }

    public TemporarySessionPasswordGenerator(int timeoutMillis) {
        this.m_timeoutMillis = timeoutMillis;
    }

    public String generateSessionPassword(int sessionId) {
        StringBuffer pwBuf = new StringBuffer(SESSION_PASSWORD_PREFIX);
        pwBuf.append(sessionId);
        pwBuf.append('$');
        pwBuf.append(this.generateRandomPassword());
        String pw = pwBuf.toString();
        this.storeSessionPassword(new Integer(sessionId), pw);
        return pw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer authenticateSessionPassword(String password) throws IllegalStateException {
        String sessionMD5;
        Integer sessionId;
        int separator;
        int n = separator = password != null ? password.indexOf(36) : -1;
        if (separator == -1 || !password.startsWith(SESSION_PASSWORD_PREFIX)) {
            return null;
        }
        String sessionStr = password.substring(SESSION_PASSWORD_PREFIX.length(), separator);
        try {
            sessionId = new Integer(sessionStr);
        }
        catch (NumberFormatException e) {
            return null;
        }
        String passwordMD5 = this.generateMD5(password);
        TemporarySessionPasswordGenerator temporarySessionPasswordGenerator = this;
        synchronized (temporarySessionPasswordGenerator) {
            this.purgeOldSessionPasswords();
            sessionMD5 = this.m_sessionPasswordMD5Strings.remove(sessionId);
            this.m_sessionPasswordCreationDates.remove(sessionId);
        }
        if (sessionMD5 == null) {
            return null;
        }
        if (!sessionMD5.equals(passwordMD5)) {
            throw new IllegalStateException("WARNING! A session was attempted to be reattached but the login password was invalid");
        }
        return sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeSessionPassword(Integer sessionId, String pw) {
        TemporarySessionPasswordGenerator temporarySessionPasswordGenerator = this;
        synchronized (temporarySessionPasswordGenerator) {
            this.purgeOldSessionPasswords();
            this.m_sessionPasswordCreationDates.put(sessionId, new Long(System.currentTimeMillis()));
            this.m_sessionPasswordMD5Strings.put(sessionId, this.generateMD5(pw));
        }
    }

    private void purgeOldSessionPasswords() {
        long earliestAllowed = System.currentTimeMillis() - (long)this.m_timeoutMillis;
        ArrayList<Integer> doomedSessions = new ArrayList<Integer>();
        for (Map.Entry<Integer, Long> entry : this.m_sessionPasswordCreationDates.entrySet()) {
            Long creationTime = entry.getValue();
            if (creationTime >= earliestAllowed) continue;
            doomedSessions.add(entry.getKey());
        }
        for (Integer doomedSession : doomedSessions) {
            this.m_sessionPasswordCreationDates.remove(doomedSession);
            this.m_sessionPasswordMD5Strings.remove(doomedSession);
        }
    }

    private String generateRandomPassword() {
        StringBuffer password = new StringBuffer();
        String chars = "0a3X1bWd-2VeU*fTgH7sGtF6YS^KpJqI4rh7RiQj_5P.kOZlNm|0Mn~Lou!9EvD4wACxB8yz";
        Random random = new Random(System.currentTimeMillis());
        int passwordLength = 0;
        while (passwordLength < 64) {
            passwordLength = random.nextInt(129);
        }
        random = new Random(System.currentTimeMillis() + (long)passwordLength);
        for (int i = 0; i < passwordLength; ++i) {
            password.append(chars.charAt(random.nextInt(chars.length())));
        }
        return password.toString();
    }

    private String generateMD5(String password) {
        return Util.createPasswordHash((String)"MD5", (String)"base64", null, null, (String)password);
    }
}

