/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.scheduler;

import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.ejb.Stateless;
import javax.management.MBeanServerInvocationHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.mx.util.MBeanServerLocator;
import org.quartz.Calendar;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobListener;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.SchedulerMetaData;
import org.quartz.Trigger;
import org.quartz.TriggerListener;
import org.quartz.UnableToInterruptJobException;
import org.quartz.spi.JobFactory;
import org.rhq.enterprise.server.scheduler.EnhancedSchedulerImpl;
import org.rhq.enterprise.server.scheduler.SchedulerLocal;
import org.rhq.enterprise.server.scheduler.SchedulerServiceMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
public class SchedulerBean
implements SchedulerLocal {
    private static final long serialVersionUID = 1L;
    private final Log log = LogFactory.getLog((String)SchedulerBean.class.getName());

    private SchedulerServiceMBean getSchedulerService() throws SchedulerException {
        try {
            return MBeanServerInvocationHandler.newProxyInstance(MBeanServerLocator.locateJBoss(), SCHEDULER_MBEAN_NAME, SchedulerServiceMBean.class, false);
        }
        catch (Exception e) {
            throw new SchedulerException("Failed to get a proxy to the scheduler service MBean", (Throwable)e);
        }
    }

    @Override
    public void scheduleRepeatingJob(String name, String groupName, JobDataMap jobData, Class<? extends Job> jobClass, boolean rescheduleIfExists, boolean isVolatile, long initialDelay, long interval) throws SchedulerException {
        new EnhancedSchedulerImpl(this.getSchedulerService()).scheduleRepeatingJob(name, groupName, jobData, jobClass, rescheduleIfExists, isVolatile, initialDelay, interval);
    }

    @Override
    public void scheduleCronJob(String name, String groupName, JobDataMap jobData, Class<? extends Job> jobClass, boolean rescheduleIfExists, boolean isVolatile, String cronString) throws SchedulerException {
        new EnhancedSchedulerImpl(this.getSchedulerService()).scheduleCronJob(name, groupName, jobData, jobClass, rescheduleIfExists, isVolatile, cronString);
    }

    @Override
    public void scheduleSimpleRepeatingJob(Class<? extends Job> jobClass, boolean rescheduleIfExists, boolean isVolatile, long initialDelay, long interval) throws SchedulerException {
        new EnhancedSchedulerImpl(this.getSchedulerService()).scheduleSimpleRepeatingJob(jobClass, rescheduleIfExists, isVolatile, initialDelay, interval);
    }

    @Override
    public void scheduleSimpleCronJob(Class<? extends Job> jobClass, boolean rescheduleIfExists, boolean isVolatile, String cronString) throws SchedulerException {
        new EnhancedSchedulerImpl(this.getSchedulerService()).scheduleSimpleCronJob(jobClass, rescheduleIfExists, isVolatile, cronString);
    }

    @Override
    public Properties getQuartzProperties() {
        try {
            return this.getSchedulerService().getQuartzProperties();
        }
        catch (SchedulerException e) {
            this.log.error((Object)"Failed to get the Quartz properties", (Throwable)e);
            return null;
        }
    }

    @Override
    public void setQuartzProperties(Properties quartzProps) throws SchedulerException {
        this.getSchedulerService().setQuartzProperties(quartzProps);
    }

    @Override
    public Integer getDefaultOperationTimeout() {
        try {
            return this.getSchedulerService().getDefaultOperationTimeout();
        }
        catch (SchedulerException e) {
            this.log.error((Object)"Failed to get the default operation timeout", (Throwable)e);
            return null;
        }
    }

    @Override
    public void initQuartzScheduler() throws SchedulerException {
        this.getSchedulerService().initQuartzScheduler();
    }

    @Override
    public void startQuartzScheduler() throws SchedulerException {
        this.getSchedulerService().startQuartzScheduler();
    }

    @Override
    public String getSchedulerName() throws SchedulerException {
        return this.getSchedulerService().getSchedulerName();
    }

    @Override
    public String getSchedulerInstanceId() throws SchedulerException {
        return this.getSchedulerService().getSchedulerInstanceId();
    }

    @Override
    public SchedulerContext getContext() throws SchedulerException {
        return this.getSchedulerService().getContext();
    }

    @Override
    public SchedulerMetaData getMetaData() throws SchedulerException {
        return this.getSchedulerService().getMetaData();
    }

    @Override
    public void start() throws SchedulerException {
        this.getSchedulerService().start();
    }

    @Override
    public void pause() throws SchedulerException {
        this.getSchedulerService().pause();
    }

    @Override
    public boolean isPaused() throws SchedulerException {
        return this.getSchedulerService().isPaused();
    }

    @Override
    public void shutdown() throws SchedulerException {
        this.getSchedulerService().shutdown();
    }

    @Override
    public void shutdown(boolean waitForJobsToComplete) throws SchedulerException {
        this.getSchedulerService().shutdown(waitForJobsToComplete);
    }

    @Override
    public boolean isShutdown() throws SchedulerException {
        return this.getSchedulerService().isShutdown();
    }

    @Override
    public List getCurrentlyExecutingJobs() throws SchedulerException {
        return this.getSchedulerService().getCurrentlyExecutingJobs();
    }

    @Override
    public Date scheduleJob(JobDetail jobDetail, Trigger trigger) throws SchedulerException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Job details: " + jobDetail));
        }
        return this.getSchedulerService().scheduleJob(jobDetail, trigger);
    }

    @Override
    public Date scheduleJob(Trigger trigger) throws SchedulerException {
        return this.getSchedulerService().scheduleJob(trigger);
    }

    @Override
    public void addJob(JobDetail jobDetail, boolean replace) throws SchedulerException {
        this.getSchedulerService().addJob(jobDetail, replace);
    }

    @Override
    public boolean deleteJob(String jobName, String groupName) throws SchedulerException {
        return this.getSchedulerService().deleteJob(jobName, groupName);
    }

    @Override
    public boolean unscheduleJob(String triggerName, String groupName) throws SchedulerException {
        return this.getSchedulerService().unscheduleJob(triggerName, groupName);
    }

    @Override
    public void triggerJob(String jobName, String groupName) throws SchedulerException {
        this.getSchedulerService().triggerJob(jobName, groupName);
    }

    @Override
    public void triggerJobWithVolatileTrigger(String jobName, String groupName) throws SchedulerException {
        this.getSchedulerService().triggerJobWithVolatileTrigger(jobName, groupName);
    }

    @Override
    public void pauseTrigger(String triggerName, String groupName) throws SchedulerException {
        this.getSchedulerService().pauseTrigger(triggerName, groupName);
    }

    @Override
    public void pauseTriggerGroup(String groupName) throws SchedulerException {
        this.getSchedulerService().pauseTriggerGroup(groupName);
    }

    @Override
    public void pauseJob(String jobName, String groupName) throws SchedulerException {
        this.getSchedulerService().pauseJob(jobName, groupName);
    }

    @Override
    public void pauseJobGroup(String groupName) throws SchedulerException {
        this.getSchedulerService().pauseJobGroup(groupName);
    }

    @Override
    public void resumeTrigger(String triggerName, String groupName) throws SchedulerException {
        this.getSchedulerService().resumeTrigger(triggerName, groupName);
    }

    @Override
    public void resumeTriggerGroup(String groupName) throws SchedulerException {
        this.getSchedulerService().resumeTriggerGroup(groupName);
    }

    @Override
    public void resumeJob(String jobName, String groupName) throws SchedulerException {
        this.getSchedulerService().resumeJob(jobName, groupName);
    }

    @Override
    public void resumeJobGroup(String groupName) throws SchedulerException {
        this.getSchedulerService().resumeJobGroup(groupName);
    }

    @Override
    public String[] getJobGroupNames() throws SchedulerException {
        return this.getSchedulerService().getJobGroupNames();
    }

    @Override
    public String[] getJobNames(String groupName) throws SchedulerException {
        return this.getSchedulerService().getJobNames(groupName);
    }

    @Override
    public Trigger[] getTriggersOfJob(String jobName, String groupName) throws SchedulerException {
        return this.getSchedulerService().getTriggersOfJob(jobName, groupName);
    }

    @Override
    public String[] getTriggerGroupNames() throws SchedulerException {
        return this.getSchedulerService().getTriggerGroupNames();
    }

    @Override
    public String[] getTriggerNames(String groupName) throws SchedulerException {
        return this.getSchedulerService().getTriggerNames(groupName);
    }

    @Override
    public JobDetail getJobDetail(String jobName, String jobGroup) throws SchedulerException {
        return this.getSchedulerService().getJobDetail(jobName, jobGroup);
    }

    @Override
    public Trigger getTrigger(String triggerName, String triggerGroup) throws SchedulerException {
        return this.getSchedulerService().getTrigger(triggerName, triggerGroup);
    }

    @Override
    public boolean deleteCalendar(String calName) throws SchedulerException {
        return this.getSchedulerService().deleteCalendar(calName);
    }

    @Override
    public Calendar getCalendar(String calName) throws SchedulerException {
        return this.getSchedulerService().getCalendar(calName);
    }

    @Override
    public String[] getCalendarNames() throws SchedulerException {
        return this.getSchedulerService().getCalendarNames();
    }

    @Override
    public void addGlobalJobListener(JobListener jobListener) throws SchedulerException {
        this.getSchedulerService().addGlobalJobListener(jobListener);
    }

    @Override
    public void addJobListener(JobListener jobListener) throws SchedulerException {
        this.getSchedulerService().addJobListener(jobListener);
    }

    @Override
    public boolean removeGlobalJobListener(JobListener jobListener) throws SchedulerException {
        return this.getSchedulerService().removeGlobalJobListener(jobListener);
    }

    @Override
    public boolean removeJobListener(String name) throws SchedulerException {
        return this.getSchedulerService().removeJobListener(name);
    }

    @Override
    public List getGlobalJobListeners() throws SchedulerException {
        return this.getSchedulerService().getGlobalJobListeners();
    }

    @Override
    public Set getJobListenerNames() throws SchedulerException {
        return this.getSchedulerService().getJobListenerNames();
    }

    @Override
    public JobListener getJobListener(String name) throws SchedulerException {
        return this.getSchedulerService().getJobListener(name);
    }

    @Override
    public void addGlobalTriggerListener(TriggerListener triggerListener) throws SchedulerException {
        this.getSchedulerService().addGlobalTriggerListener(triggerListener);
    }

    @Override
    public void addTriggerListener(TriggerListener triggerListener) throws SchedulerException {
        this.getSchedulerService().addTriggerListener(triggerListener);
    }

    @Override
    public boolean removeGlobalTriggerListener(TriggerListener triggerListener) throws SchedulerException {
        return this.getSchedulerService().removeGlobalTriggerListener(triggerListener);
    }

    @Override
    public boolean removeTriggerListener(String name) throws SchedulerException {
        return this.getSchedulerService().removeTriggerListener(name);
    }

    @Override
    public List getGlobalTriggerListeners() throws SchedulerException {
        return this.getSchedulerService().getGlobalTriggerListeners();
    }

    @Override
    public Set getTriggerListenerNames() throws SchedulerException {
        return this.getSchedulerService().getTriggerListenerNames();
    }

    @Override
    public TriggerListener getTriggerListener(String name) throws SchedulerException {
        return this.getSchedulerService().getTriggerListener(name);
    }

    @Override
    public void addSchedulerListener(SchedulerListener schedulerListener) throws SchedulerException {
        this.getSchedulerService().addSchedulerListener(schedulerListener);
    }

    @Override
    public boolean removeSchedulerListener(SchedulerListener schedulerListener) throws SchedulerException {
        return this.getSchedulerService().removeSchedulerListener(schedulerListener);
    }

    @Override
    public List getSchedulerListeners() throws SchedulerException {
        return this.getSchedulerService().getSchedulerListeners();
    }

    @Override
    public void addCalendar(String calName, Calendar calendar, boolean replace, boolean updateTriggers) throws SchedulerException {
        this.getSchedulerService().addCalendar(calName, calendar, replace, updateTriggers);
    }

    @Override
    public Set getPausedTriggerGroups() throws SchedulerException {
        return this.getSchedulerService().getPausedTriggerGroups();
    }

    @Override
    public int getTriggerState(String triggerName, String triggerGroup) throws SchedulerException {
        return this.getSchedulerService().getTriggerState(triggerName, triggerGroup);
    }

    @Override
    public boolean interrupt(String jobName, String groupName) throws UnableToInterruptJobException {
        try {
            return this.getSchedulerService().interrupt(jobName, groupName);
        }
        catch (SchedulerException e) {
            throw new UnableToInterruptJobException((Throwable)e);
        }
    }

    @Override
    public boolean isInStandbyMode() throws SchedulerException {
        return this.getSchedulerService().isInStandbyMode();
    }

    @Override
    public void pauseAll() throws SchedulerException {
        this.getSchedulerService().pauseAll();
    }

    @Override
    public Date rescheduleJob(String triggerName, String groupName, Trigger newTrigger) throws SchedulerException {
        return this.getSchedulerService().rescheduleJob(triggerName, groupName, newTrigger);
    }

    @Override
    public void resumeAll() throws SchedulerException {
        this.getSchedulerService().resumeAll();
    }

    @Override
    public void setJobFactory(JobFactory factory) throws SchedulerException {
        this.getSchedulerService().setJobFactory(factory);
    }

    @Override
    public void standby() throws SchedulerException {
        this.getSchedulerService().standby();
    }

    @Override
    public void triggerJob(String jobName, String groupName, JobDataMap data) throws SchedulerException {
        this.getSchedulerService().triggerJob(jobName, groupName, data);
    }

    @Override
    public void triggerJobWithVolatileTrigger(String jobName, String groupName, JobDataMap data) throws SchedulerException {
        this.getSchedulerService().triggerJob(jobName, groupName, data);
    }

    public JobListener getGlobalJobListener(String jobName) throws SchedulerException {
        return this.getSchedulerService().getGlobalJobListener(jobName);
    }

    public TriggerListener getGlobalTriggerListener(String triggerName) throws SchedulerException {
        return this.getSchedulerService().getGlobalTriggerListener(triggerName);
    }

    public boolean isStarted() throws SchedulerException {
        return this.getSchedulerService().isStarted();
    }

    public boolean removeGlobalJobListener(String jobName) throws SchedulerException {
        return this.getSchedulerService().removeGlobalJobListener(jobName);
    }

    public boolean removeGlobalTriggerListener(String triggerName) throws SchedulerException {
        return this.getSchedulerService().removeGlobalTriggerListener(triggerName);
    }

    public void startDelayed(int delay) throws SchedulerException {
        this.getSchedulerService().startDelayed(delay);
    }
}

