/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.cluster;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.ResourceGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterKey {
    static final String DELIM = ":";
    static final String DELIM_NODE = "::";
    private int clusterGroupId = 0;
    private List<Node> hierarchy;
    private String key = null;
    private String namedKey = null;

    public ClusterKey(int clusterResourceGroupId) {
        this.clusterGroupId = clusterResourceGroupId;
        this.hierarchy = new ArrayList<Node>();
    }

    public ClusterKey(int clusterResourceGroupId, int resourceTypeId, String resourceKey) {
        this.clusterGroupId = clusterResourceGroupId;
        this.hierarchy = new ArrayList<Node>();
        this.hierarchy.add(new Node(resourceTypeId, resourceKey));
    }

    public ClusterKey(ClusterKey parentKey, int childResourceTypeId, String childResourceKey) {
        List<Node> rootClusterNodes = parentKey.getHierarchy();
        this.clusterGroupId = parentKey.getClusterGroupId();
        this.hierarchy = new ArrayList<Node>(rootClusterNodes);
        this.hierarchy.add(new Node(childResourceTypeId, childResourceKey));
    }

    public int getClusterGroupId() {
        return this.clusterGroupId;
    }

    public List<Node> getHierarchy() {
        return this.hierarchy;
    }

    public List<Node> addChildToHierarchy(int childResourceTypeId, String childResourceKey) {
        this.hierarchy.add(new Node(childResourceTypeId, childResourceKey));
        return this.hierarchy;
    }

    public int getDepth() {
        return this.hierarchy.size();
    }

    public void setDepth(int newDepth) {
        while (newDepth > 0 && this.hierarchy.size() > newDepth) {
            this.hierarchy.remove(this.hierarchy.size() - 1);
        }
    }

    public String getKey() {
        if (null == this.key) {
            StringBuilder b = new StringBuilder();
            b.append(this.clusterGroupId);
            for (Node node : this.hierarchy) {
                b.append(DELIM_NODE);
                b.append(node.toString());
            }
            this.key = b.toString();
        }
        return this.key;
    }

    public String toString() {
        return this.getKey();
    }

    public String toNamedString(EntityManager em) {
        if (null == this.namedKey) {
            ResourceGroup clusterResourceGroup = (ResourceGroup)em.find(ResourceGroup.class, (Object)this.clusterGroupId);
            StringBuilder b = new StringBuilder();
            b.append(null == clusterResourceGroup ? Integer.valueOf(this.clusterGroupId) : clusterResourceGroup.getName());
            for (Node node : this.hierarchy) {
                b.append(DELIM_NODE);
                b.append(node.toNamedString(em));
            }
            this.namedKey = b.toString();
        }
        return this.namedKey;
    }

    public static ClusterKey valueOf(String clusterKey) {
        ClusterKey result = null;
        try {
            String[] nodes = clusterKey.split(DELIM_NODE);
            int groupId = Integer.valueOf(nodes[0]);
            result = new ClusterKey(groupId);
            for (int i = 1; i < nodes.length; ++i) {
                String[] nodeInfo = nodes[i].split(DELIM);
                if (nodeInfo.length != 2 || "".equals(nodeInfo[0].trim()) || "".equals(nodeInfo[1].trim())) {
                    throw new IllegalArgumentException("Invalid cluster key node: " + nodeInfo);
                }
                result.addChildToHierarchy(Integer.valueOf(nodeInfo[0]), nodeInfo[1]);
            }
        }
        catch (Exception e) {
            LogFactory.getLog(ClusterKey.class).error((Object)("Invalid clusterKey |" + clusterKey + "| encountered: " + e));
            result = null;
        }
        return result;
    }

    public static int getResourceType(ClusterKey clusterKey) {
        List<Node> nodes = clusterKey.getHierarchy();
        return nodes.get(nodes.size() - 1).getResourceTypeId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClusterKey)) {
            return false;
        }
        ClusterKey that = (ClusterKey)o;
        return this.getKey().equals(that.getKey());
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public static class Node {
        int resourceTypeId;
        String resourceKey;

        public Node(int resourceTypeId, String resourceKey) {
            this.resourceTypeId = resourceTypeId;
            this.resourceKey = this.encode(resourceKey);
        }

        public int getResourceTypeId() {
            return this.resourceTypeId;
        }

        public String getResourceKey() {
            return this.decode(this.resourceKey);
        }

        public String toString() {
            return this.resourceTypeId + ClusterKey.DELIM + this.resourceKey;
        }

        public String toNamedString(EntityManager em) {
            ResourceType resourceType = (ResourceType)em.find(ResourceType.class, (Object)this.resourceTypeId);
            String resourceTypePart = null;
            resourceTypePart = null == resourceType ? this.resourceTypeId + ClusterKey.DELIM + this.resourceTypeId : resourceType.getPlugin() + ClusterKey.DELIM + resourceType.getName();
            return resourceTypePart + ClusterKey.DELIM + this.resourceKey;
        }

        private String encode(String info) {
            return info.replace(ClusterKey.DELIM, "%3a");
        }

        private String decode(String code) {
            return code.replace("%3a", ClusterKey.DELIM);
        }
    }
}

