/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.cts.ejb;

import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.logging.Logger;
import org.jboss.test.cts.ejb.StatelessSessionBean;

public class StrictlyPooledSessionBean
implements SessionBean {
    private static Logger log = Logger.getLogger(StatelessSessionBean.class);
    private static int maxActiveCount = 5;
    private static int activeCount;
    private SessionContext ctx;

    private static synchronized int incActiveCount() {
        return activeCount++;
    }

    private static synchronized int decActiveCount() {
        return activeCount--;
    }

    public void ejbCreate() {
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void ejbRemove() {
    }

    public void setSessionContext(SessionContext ctx) {
        this.ctx = ctx;
        try {
            InitialContext iniCtx = new InitialContext();
            Integer i = (Integer)iniCtx.lookup("java:comp/env/maxActiveCount");
            maxActiveCount = i;
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void methodA() {
        int count = StrictlyPooledSessionBean.incActiveCount();
        log.debug((Object)("Begin methodA, activeCount=" + count + ", ctx=" + this.ctx));
        try {
            try {
                if (count > maxActiveCount) {
                    String msg = "IllegalState, activeCount > maxActiveCount, " + count + " > " + maxActiveCount;
                    throw new EJBException(msg);
                }
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                Object var4_5 = null;
                count = StrictlyPooledSessionBean.decActiveCount();
                log.debug((Object)("End methodA, activeCount=" + count + ", ctx=" + this.ctx));
                return;
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            count = StrictlyPooledSessionBean.decActiveCount();
            log.debug((Object)("End methodA, activeCount=" + count + ", ctx=" + this.ctx));
            throw throwable;
        }
        count = StrictlyPooledSessionBean.decActiveCount();
        log.debug((Object)("End methodA, activeCount=" + count + ", ctx=" + this.ctx));
    }
}

