/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.ldap.aci;

import com.iplanet.services.ldap.aci.ACIComposeException;
import com.iplanet.services.ldap.aci.ACIException;
import com.iplanet.services.ldap.aci.ACIParseException;
import com.iplanet.services.ldap.aci.ACIParser;
import com.iplanet.services.ldap.aci.ACR;
import com.iplanet.services.ldap.aci.BindRule;
import com.iplanet.services.ldap.aci.QualifiedCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class ACI {
    public static final String ACI = "aci";
    static final String[] SUPPORTED_ATTR_RULES = new String[]{"userdnattr", "groupdnattr", "userattr"};
    static final Collection SUPPORTED_ATTR_RULES_COLLECTION = Arrays.asList(SUPPORTED_ATTR_RULES);
    static final String TARGET = "target";
    static final String TARGETFILTER = "targetfilter";
    static final String TARGETATTR = "targetattr";
    static final String TARGETATTRFILTERS = "targetattrfilters";
    static final String VERSION = "version";
    static final String ACL = "acl";
    static final String ALLOW = "allow";
    static final String DENY = "deny";
    static final String USERDN = "userdn";
    static final String GROUPDN = "groupdn";
    static final String ROLEDN = "roledn";
    static final String USERDNATTR = "userdnattr";
    static final String GROUPDNATTR = "groupdnattr";
    static final String USERATTR = "userattr";
    static final String AUTHMETHOD = "authmethod";
    static final String IP = "ip";
    static final String DNS = "dns";
    static final String TIMEOFDAY = "timeofday";
    static final String DAYOFWEEK = "dayofweek";
    static final String PRINCIPAL_SET = "principal";
    static final String AUTHMETHOD_SET = "authmethod";
    static final String IP_SET = "IP";
    static final String TOD_SET = "tod";
    static final String DOW_SET = "dow";
    static final String KEYWORD = "keyword";
    static final String OPERATOR = "operator";
    static final String VALUE = "value";
    static final String OPENPARENTH = "(";
    static final String CLOSEPARENTH = ")";
    static final String EXPRESSIONCONNECTOR = "expressionconnector";
    static final String EQ = "=";
    static final String NE = "!=";
    static final String GE = ">=";
    static final String LE = "<=";
    static final String GT = ">";
    static final String LT = "<";
    static final String AND = "and";
    static final String OR = "or";
    static final String OR_PIPE = "||";
    static final String SPACE = " ";
    static final String QUOTE = "\"";
    static final String NEWLINE = "\n";
    static final String SEMICOLON = ";";
    static final String COMMA = ",";
    static final String LDAP_PREFIX = "ldap:///";
    private String _target;
    private String _targetFilter;
    private String _targetAttrFilters;
    private QualifiedCollection _targetAttributes;
    private String _name = "Unnamed";
    private String _version = "3.0";
    private QualifiedCollection _permissions;
    private Collection _users;
    private Collection _groups;
    private Collection _roles;
    private Collection _clientIP;
    private Collection _clientHostNames;
    private Collection _timesOfDay;
    private Collection _daysOfWeek;
    private Collection _authMethods;
    private Collection _userDNAttrs;
    private Collection _groupDNAttrs;
    private Collection _userAttrs;
    private String _aciText = "";

    public ACI() {
    }

    public ACI(String name) {
        this._name = name;
    }

    public ACI(String name, String target, String targetFilter, QualifiedCollection targetAttributes, Collection users, QualifiedCollection permissions) {
        this.setName(name);
        this.setTarget(target);
        this.setTargetFilter(targetFilter);
        this.setTargetAttributes(targetAttributes);
        this.setUsers(users);
        this.setPermissions(permissions);
    }

    public boolean equals(Object object) {
        ACI castObject;
        boolean objectsEqual = false;
        if (this == object) {
            objectsEqual = true;
        } else if (object != null && object.getClass().equals(this.getClass()) && (castObject = (ACI)object).getName().equals(this.getName()) && castObject.getTarget().equals(this.getTarget()) && castObject.getTargetFilter().equals(this.getTargetFilter()) && castObject.getTargetAttributes().equals(this.getTargetAttributes()) && castObject.getPermissions().equals(this.getPermissions()) && ((Object)castObject.getUsers()).equals(this.getUsers()) && ((Object)castObject.getGroups()).equals(this.getGroups()) && ((Object)castObject.getRoles()).equals(this.getRoles()) && ((Object)castObject.getClientHostNames()).equals(this.getClientHostNames()) && ((Object)castObject.getTimesOfDay()).equals(this.getTimesOfDay()) && ((Object)castObject.getDaysOfWeek()).equals(this.getDaysOfWeek()) && ((Object)castObject.getAuthMethods()).equals(this.getAuthMethods())) {
            objectsEqual = true;
        }
        return objectsEqual;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setTarget(String target) {
        this._target = target;
    }

    public String getTarget() {
        return this._target;
    }

    public void setTargetFilter(String targetFilter) {
        this._targetFilter = targetFilter;
    }

    public String getTargetFilter() {
        return this._targetFilter;
    }

    public void removeTargetFilter() {
        this._targetFilter = null;
    }

    public void setTargetAttributes(QualifiedCollection targetAttributes) {
        this._targetAttributes = targetAttributes;
    }

    public QualifiedCollection getTargetAttributes() {
        return this._targetAttributes;
    }

    public void removeTargetAttributes() {
        this._targetAttributes = null;
    }

    public void setPermissions(QualifiedCollection permissions) {
        this._permissions = permissions;
    }

    public QualifiedCollection getPermissions() {
        return this._permissions;
    }

    public void setUsers(Collection users) {
        this._users = users;
    }

    public Collection getUsers() {
        return this._users;
    }

    public void setGroups(Collection groups) {
        this._groups = groups;
    }

    public Collection getGroups() {
        return this._groups;
    }

    public void setRoles(Collection roles) {
        this._roles = roles;
    }

    public Collection getRoles() {
        return this._roles;
    }

    public void setClientIP(Collection clientIP) {
        this._clientIP = clientIP;
    }

    public Collection getClientIP() {
        return this._clientIP;
    }

    public void setClientHostNames(Collection clientHostNames) {
        this._clientHostNames = clientHostNames;
    }

    public Collection getClientHostNames() {
        return this._clientHostNames;
    }

    public void setTimesOfDay(Collection timesOfDay) {
        this._timesOfDay = timesOfDay;
    }

    public Collection getTimesOfDay() {
        return this._timesOfDay;
    }

    public void setDaysOfWeek(Collection daysOfWeek) {
        this._daysOfWeek = daysOfWeek;
    }

    public Collection getDaysOfWeek() {
        return this._daysOfWeek;
    }

    public void setAuthMethods(Collection authMethods) {
        this._authMethods = authMethods;
    }

    public Collection getAuthMethods() {
        return this._authMethods;
    }

    public void setAttrRuleValue(String attrName, Collection values) throws ACIComposeException {
        if ((attrName = attrName.toLowerCase()).equals(USERDNATTR)) {
            this.setUserDNAttrs(values);
        } else if (attrName.equals(GROUPDNATTR)) {
            this.setGroupDNAttrs(values);
        } else if (attrName.equals(USERATTR)) {
            this.setUserAttrs(values);
        } else {
            throw new ACIComposeException("Unsupported attr rule name : " + attrName);
        }
    }

    public Collection getAttrRuleValue(String attrName) throws ACIException {
        Collection values = null;
        if (attrName.equals(USERDNATTR)) {
            values = this.getUserDNAttrs();
        } else if (attrName.equals(GROUPDNATTR)) {
            values = this.getGroupDNAttrs();
        } else if (attrName.equals(USERATTR)) {
            values = this.getUserAttrs();
        } else {
            throw new ACIException("Unsupported attr rule name : " + attrName);
        }
        return values;
    }

    public Collection getSupportedAttrRules() {
        return SUPPORTED_ATTR_RULES_COLLECTION;
    }

    public void setTargetAttrFilters(String targetAttrFilters) {
        this._targetAttrFilters = targetAttrFilters;
    }

    public String getTargetAttrFilters() {
        return this._targetAttrFilters;
    }

    public String toString() {
        boolean exclusive;
        StringBuffer aci = new StringBuffer();
        StringBuffer bindRule = new StringBuffer();
        StringBuffer tempBuffer = new StringBuffer();
        String value = null;
        value = this.getTarget();
        if (value != null && value.length() != 0) {
            aci.append(SPACE).append(OPENPARENTH).append(TARGET).append(SPACE).append(EQ).append(SPACE).append(QUOTE).append(value).append(QUOTE).append(CLOSEPARENTH).append(NEWLINE);
        }
        QualifiedCollection qc = null;
        Iterator iter = null;
        qc = this.getTargetAttributes();
        if (qc != null && qc.getCollection() != null && qc.getCollection().size() != 0) {
            exclusive = qc.isExclusive();
            String operator = exclusive ? NE : EQ;
            aci.append(SPACE).append(OPENPARENTH).append(TARGETATTR).append(SPACE).append(operator).append(SPACE);
            iter = qc.getCollection().iterator();
            if (iter.hasNext()) {
                value = (String)iter.next();
                aci.append(QUOTE).append(value);
            }
            while (iter.hasNext()) {
                value = (String)iter.next();
                aci.append(OR_PIPE).append(value);
            }
            aci.append(QUOTE).append(CLOSEPARENTH).append(NEWLINE);
        }
        if ((value = this.getTargetFilter()) != null && value.length() != 0) {
            aci.append(SPACE).append(OPENPARENTH).append(TARGETFILTER).append(SPACE).append(EQ).append(SPACE).append(QUOTE).append(value).append(QUOTE).append(CLOSEPARENTH).append(NEWLINE);
        }
        if ((value = this.getTargetAttrFilters()) != null && value.length() != 0) {
            aci.append(SPACE).append(OPENPARENTH).append(TARGETATTRFILTERS).append(SPACE).append(EQ).append(SPACE).append(QUOTE).append(value).append(QUOTE).append(CLOSEPARENTH).append(NEWLINE);
        }
        aci.append(SPACE).append(OPENPARENTH).append(VERSION).append(SPACE).append(this.getVersion()).append(SEMICOLON);
        aci.append(ACL).append(SPACE).append(QUOTE).append(this.getName()).append(QUOTE).append(SEMICOLON);
        qc = this.getPermissions();
        if (qc != null && qc.getCollection() != null && qc.getCollection().size() != 0) {
            exclusive = qc.isExclusive();
            String permissionType = exclusive ? DENY : ALLOW;
            aci.append(permissionType).append(OPENPARENTH);
            iter = qc.getCollection().iterator();
            if (iter.hasNext()) {
                value = (String)iter.next();
                aci.append(value);
            }
            while (iter.hasNext()) {
                value = (String)iter.next();
                aci.append(COMMA).append(SPACE).append(value);
            }
            aci.append(CLOSEPARENTH).append(NEWLINE);
        }
        Collection collection = null;
        collection = this.getUsers();
        if (collection != null && collection.size() != 0) {
            iter = collection.iterator();
            if (iter.hasNext()) {
                value = (String)iter.next();
                tempBuffer.append(USERDN).append(EQ).append(QUOTE).append(LDAP_PREFIX).append(value);
            }
            while (iter.hasNext()) {
                value = (String)iter.next();
                tempBuffer.append(SPACE).append(OR_PIPE).append(SPACE).append(LDAP_PREFIX).append(value);
            }
            tempBuffer.append(QUOTE).append(SPACE);
        }
        if (tempBuffer.length() != 0) {
            bindRule.append(tempBuffer);
        }
        tempBuffer.setLength(0);
        collection = this.getGroups();
        if (collection != null && collection.size() != 0) {
            iter = collection.iterator();
            if (iter.hasNext()) {
                value = (String)iter.next();
                tempBuffer.append(GROUPDN).append(EQ).append(QUOTE).append(LDAP_PREFIX).append(value);
            }
            while (iter.hasNext()) {
                value = (String)iter.next();
                tempBuffer.append(SPACE).append(OR_PIPE).append(SPACE).append(LDAP_PREFIX).append(value);
            }
            tempBuffer.append(QUOTE).append(SPACE);
        }
        if (tempBuffer.length() != 0) {
            if (bindRule.length() > 0) {
                bindRule.append(SPACE).append(OR).append(SPACE);
            }
            bindRule.append(tempBuffer);
        }
        tempBuffer.setLength(0);
        collection = this.getRoles();
        if (collection != null && collection.size() != 0) {
            iter = collection.iterator();
            if (iter.hasNext()) {
                value = (String)iter.next();
                tempBuffer.append(ROLEDN).append(EQ).append(QUOTE).append(LDAP_PREFIX).append(value);
            }
            while (iter.hasNext()) {
                value = (String)iter.next();
                tempBuffer.append(SPACE).append(OR_PIPE).append(SPACE).append(LDAP_PREFIX).append(value);
            }
            tempBuffer.append(QUOTE).append(SPACE);
        }
        if (tempBuffer.length() != 0) {
            if (bindRule.length() > 0) {
                bindRule.append(" or ");
            }
            bindRule.append(tempBuffer);
        }
        tempBuffer.setLength(0);
        collection = this.getUserDNAttrs();
        if (collection != null && collection.size() != 0) {
            iter = collection.iterator();
            if (iter.hasNext()) {
                value = (String)iter.next();
                tempBuffer.append(USERDNATTR).append(EQ).append(QUOTE).append(value).append(QUOTE);
            }
            while (iter.hasNext()) {
                value = (String)iter.next();
                tempBuffer.append(SPACE).append(OR).append(SPACE);
                tempBuffer.append(USERDNATTR).append(EQ).append(QUOTE).append(value).append(QUOTE);
            }
        }
        if (tempBuffer.length() != 0) {
            if (bindRule.length() > 0) {
                bindRule.append(SPACE).append(OR).append(SPACE);
            }
            bindRule.append(tempBuffer);
        }
        tempBuffer.setLength(0);
        collection = this.getGroupDNAttrs();
        if (collection != null && collection.size() != 0) {
            iter = collection.iterator();
            if (iter.hasNext()) {
                value = (String)iter.next();
                tempBuffer.append(GROUPDNATTR).append(EQ).append(QUOTE).append(value).append(QUOTE);
            }
            while (iter.hasNext()) {
                value = (String)iter.next();
                tempBuffer.append(SPACE).append(OR).append(SPACE);
                tempBuffer.append(GROUPDNATTR).append(EQ).append(QUOTE).append(value).append(QUOTE);
            }
        }
        if (tempBuffer.length() != 0) {
            if (bindRule.length() > 0) {
                bindRule.append(SPACE).append(OR).append(SPACE);
            }
            bindRule.append(tempBuffer);
        }
        tempBuffer.setLength(0);
        collection = this.getUserAttrs();
        if (collection != null && collection.size() != 0) {
            iter = collection.iterator();
            if (iter.hasNext()) {
                value = (String)iter.next();
                tempBuffer.append(USERATTR).append(EQ).append(QUOTE).append(value).append(QUOTE);
            }
            while (iter.hasNext()) {
                value = (String)iter.next();
                tempBuffer.append(SPACE).append(OR).append(SPACE);
                tempBuffer.append(USERATTR).append(EQ).append(QUOTE).append(value).append(QUOTE);
            }
        }
        if (tempBuffer.length() != 0) {
            if (bindRule.length() > 0) {
                bindRule.append(SPACE).append(OR).append(SPACE);
            }
            bindRule.append(tempBuffer);
        }
        if (bindRule.length() > 0) {
            bindRule.insert(0, SPACE);
            bindRule.insert(1, OPENPARENTH);
            bindRule.append(CLOSEPARENTH).append(NEWLINE);
        }
        tempBuffer.setLength(0);
        collection = this.getAuthMethods();
        if (collection != null && collection.size() != 0) {
            iter = collection.iterator();
            if (iter.hasNext()) {
                value = (String)iter.next();
                tempBuffer.append("authmethod").append(EQ).append(QUOTE).append(value).append(QUOTE);
            }
            while (iter.hasNext()) {
                value = (String)iter.next();
                tempBuffer.append(SPACE).append(OR).append(SPACE);
                tempBuffer.append("authmethod").append(EQ).append(QUOTE).append(value).append(QUOTE);
            }
        }
        if (tempBuffer.length() != 0) {
            if (bindRule.length() > 0) {
                bindRule.append(SPACE).append(AND).append(SPACE);
            }
            bindRule.append(OPENPARENTH).append(tempBuffer).append(CLOSEPARENTH);
        }
        StringBuffer ipBuffer = new StringBuffer();
        collection = this.getClientIP();
        if (collection != null && collection.size() != 0) {
            iter = collection.iterator();
            if (iter.hasNext()) {
                value = (String)iter.next();
                ipBuffer.append(IP).append(EQ).append(QUOTE).append(value).append(QUOTE);
            }
            while (iter.hasNext()) {
                value = (String)iter.next();
                ipBuffer.append(SPACE).append(OR).append(SPACE);
                ipBuffer.append(IP).append(EQ).append(QUOTE).append(value).append(QUOTE);
            }
        }
        tempBuffer.setLength(0);
        collection = this.getClientHostNames();
        if (collection != null && collection.size() != 0) {
            iter = collection.iterator();
            if (iter.hasNext()) {
                value = (String)iter.next();
                tempBuffer.append(DNS).append(EQ).append(QUOTE).append(value).append(QUOTE);
            }
            while (iter.hasNext()) {
                value = (String)iter.next();
                tempBuffer.append(SPACE).append(OR).append(SPACE);
                tempBuffer.append(DNS).append(EQ).append(QUOTE).append(value).append(QUOTE);
            }
        }
        if (ipBuffer.length() != 0) {
            ipBuffer.append(SPACE).append(OR).append(SPACE).append(tempBuffer);
        } else {
            ipBuffer.append(tempBuffer);
        }
        if (ipBuffer.length() != 0) {
            if (bindRule.length() > 0) {
                bindRule.append(NEWLINE).append(SPACE).append(AND);
            }
            bindRule.append(SPACE).append(OPENPARENTH).append(ipBuffer).append(CLOSEPARENTH);
        }
        tempBuffer.setLength(0);
        collection = this.getDaysOfWeek();
        if (collection != null && collection.size() != 0) {
            iter = collection.iterator();
            if (iter.hasNext()) {
                value = (String)iter.next();
                tempBuffer.append(DAYOFWEEK).append(EQ).append(QUOTE).append(value);
            }
            while (iter.hasNext()) {
                value = (String)iter.next();
                tempBuffer.append(COMMA).append(SPACE).append(value);
            }
            tempBuffer.append(QUOTE).append(SPACE);
        }
        if (tempBuffer.length() != 0) {
            if (bindRule.length() > 0) {
                bindRule.append(NEWLINE).append(SPACE).append(AND).append(SPACE);
            }
            bindRule.append(OPENPARENTH).append(tempBuffer).append(CLOSEPARENTH);
        }
        tempBuffer.setLength(0);
        collection = this.getTimesOfDay();
        if (collection != null && collection.size() != 0) {
            iter = collection.iterator();
            if (iter.hasNext()) {
                value = (String)iter.next();
                tempBuffer.append(TIMEOFDAY).append(GE).append(QUOTE).append(value).append(QUOTE);
            }
            if (iter.hasNext()) {
                value = (String)iter.next();
                tempBuffer.append(SPACE).append(AND).append(SPACE);
                tempBuffer.append(TIMEOFDAY).append(LE).append(QUOTE).append(value).append(QUOTE);
            }
            while (iter.hasNext()) {
                value = (String)iter.next();
                tempBuffer.append(SPACE).append(OR).append(SPACE);
                tempBuffer.append(TIMEOFDAY).append(GE).append(QUOTE).append(value).append(QUOTE);
                if (!iter.hasNext()) continue;
                value = (String)iter.next();
                tempBuffer.append(SPACE).append(AND).append(SPACE);
                tempBuffer.append(TIMEOFDAY).append(LE).append(QUOTE).append(value).append(QUOTE);
            }
        }
        if (tempBuffer.length() != 0) {
            if (bindRule.length() > 0) {
                bindRule.append(NEWLINE).append(SPACE).append(AND).append(SPACE);
            }
            bindRule.append(OPENPARENTH).append(tempBuffer).append(CLOSEPARENTH);
        }
        if (bindRule.length() != 0) {
            aci.append(bindRule);
        }
        aci.append(SEMICOLON).append(SPACE).append(CLOSEPARENTH);
        return aci.toString().replace('\n', ' ');
    }

    public static ACI valueOf(String aciText) throws ACIParseException {
        return ACIParser.parseACI(aciText);
    }

    public void setUserDNAttrs(Collection values) {
        this._userDNAttrs = values;
    }

    public Collection getUserDNAttrs() {
        return this._userDNAttrs;
    }

    public void setGroupDNAttrs(Collection values) {
        this._groupDNAttrs = values;
    }

    Collection getGroupDNAttrs() {
        return this._groupDNAttrs;
    }

    public void setUserAttrs(Collection values) {
        this._userAttrs = values;
    }

    public Collection getUserAttrs() {
        return this._userAttrs;
    }

    public void setACIText(String aciText) {
        this._aciText = aciText;
    }

    public String getACIText() {
        return this._aciText;
    }

    public void setACR(ACR acr) {
        this.setVersion(acr.getVersion());
        this.setName(acr.getName());
        this.setPermissions(acr.getPermissions());
        BindRule br = acr.getBindRule();
        this.setUsers(br.getUsers());
        this.setGroups(br.getGroups());
        this.setRoles(br.getRoles());
        this.setUserDNAttrs(br.getUserDNAttrs());
        this.setGroupDNAttrs(br.getGroupDNAttrs());
        this.setUserAttrs(br.getUserAttrs());
        this.setAuthMethods(br.getAuthMethods());
        this.setClientIP(br.getClientIP());
        this.setClientHostNames(br.getClientHostNames());
        this.setDaysOfWeek(br.getDaysOfWeek());
        this.setTimesOfDay(br.getTimesOfDay());
    }

    public void setVersion(String version) {
        this._version = version;
    }

    public String getVersion() {
        return this._version;
    }
}

