/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import org.apache.catalina.Globals;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.core.ApplicationFilterChain;
import org.apache.catalina.core.ApplicationFilterConfig;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.FilterMap;
import org.jboss.servlet.http.HttpEventFilter;

public final class ApplicationFilterFactory {
    private static final int ERROR = 1;
    public static final Integer ERROR_INTEGER = new Integer(1);
    private static final int FORWARD = 2;
    public static final Integer FORWARD_INTEGER = new Integer(2);
    private static final int INCLUDE = 4;
    public static final Integer INCLUDE_INTEGER = new Integer(4);
    private static final int REQUEST = 8;
    public static final Integer REQUEST_INTEGER = new Integer(8);
    private static final int ASYNC = 16;
    public static final Integer ASYNC_INTEGER = new Integer(16);
    public static final String DISPATCHER_TYPE_ATTR = "org.apache.catalina.core.DISPATCHER_TYPE";
    public static final String DISPATCHER_REQUEST_PATH_ATTR = "org.apache.catalina.core.DISPATCHER_REQUEST_PATH";
    private static ApplicationFilterFactory factory = null;

    private ApplicationFilterFactory() {
    }

    public static ApplicationFilterFactory getInstance() {
        if (factory == null) {
            factory = new ApplicationFilterFactory();
        }
        return factory;
    }

    public ApplicationFilterChain createFilterChain(ServletRequest request, Wrapper wrapper, Servlet servlet) {
        boolean isEventFilter;
        ApplicationFilterConfig filterConfig;
        int i;
        int dispatcher = -1;
        if (request.getAttribute(DISPATCHER_TYPE_ATTR) != null) {
            Integer dispatcherInt = (Integer)request.getAttribute(DISPATCHER_TYPE_ATTR);
            dispatcher = dispatcherInt;
        }
        String requestPath = null;
        Object attribute = request.getAttribute(DISPATCHER_REQUEST_PATH_ATTR);
        if (attribute != null) {
            requestPath = attribute.toString();
        }
        if (wrapper.getServlet() == null) {
            return null;
        }
        boolean event = false;
        RequestFacade requestFacade = null;
        if (request instanceof Request) {
            Request coreRequest = (Request)request;
            event = coreRequest.isEventMode();
            requestFacade = (RequestFacade)coreRequest.getRequest();
        } else {
            ServletRequest current = request;
            while (current != null) {
                if (current instanceof RequestFacade) {
                    requestFacade = (RequestFacade)current;
                    break;
                }
                current = ((ServletRequestWrapper)current).getRequest();
            }
        }
        ApplicationFilterChain filterChain = null;
        if (requestFacade == null) {
            filterChain = new ApplicationFilterChain();
        } else {
            requestFacade.nextFilterChain();
            if (Globals.IS_SECURITY_ENABLED) {
                filterChain = new ApplicationFilterChain();
                requestFacade.setFilterChain(filterChain);
            } else {
                filterChain = requestFacade.getFilterChain();
                if (filterChain == null) {
                    filterChain = new ApplicationFilterChain();
                    requestFacade.setFilterChain(filterChain);
                }
            }
            filterChain.setRequestFacade(requestFacade);
        }
        filterChain.setWrapper(wrapper);
        filterChain.setServlet(servlet);
        StandardContext context = (StandardContext)wrapper.getParent();
        FilterMap[] filterMaps = context.findFilterMaps();
        if (filterMaps == null || filterMaps.length == 0) {
            return filterChain;
        }
        String servletName = wrapper.getName();
        for (i = 0; i < filterMaps.length; ++i) {
            if (!this.matchDispatcher(filterMaps[i], dispatcher) || !this.matchFiltersURL(filterMaps[i], requestPath) || (filterConfig = (ApplicationFilterConfig)context.findFilterConfig(filterMaps[i].getFilterName())) == null) continue;
            isEventFilter = false;
            if (event) {
                try {
                    isEventFilter = filterConfig.getFilter() instanceof HttpEventFilter;
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (!isEventFilter) continue;
                filterChain.addFilter(filterConfig);
                continue;
            }
            filterChain.addFilter(filterConfig);
        }
        for (i = 0; i < filterMaps.length; ++i) {
            if (!this.matchDispatcher(filterMaps[i], dispatcher) || !this.matchFiltersServlet(filterMaps[i], servletName) || (filterConfig = (ApplicationFilterConfig)context.findFilterConfig(filterMaps[i].getFilterName())) == null) continue;
            isEventFilter = false;
            if (event) {
                try {
                    isEventFilter = filterConfig.getFilter() instanceof HttpEventFilter;
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (!isEventFilter) continue;
                filterChain.addFilter(filterConfig);
                continue;
            }
            filterChain.addFilter(filterConfig);
        }
        return filterChain;
    }

    private boolean matchFiltersURL(FilterMap filterMap, String requestPath) {
        if (filterMap.getMatchAllUrlPatterns()) {
            return true;
        }
        if (requestPath == null) {
            return false;
        }
        String[] testPaths = filterMap.getURLPatterns();
        for (int i = 0; i < testPaths.length; ++i) {
            if (!this.matchFiltersURL(testPaths[i], requestPath)) continue;
            return true;
        }
        return false;
    }

    private boolean matchFiltersURL(String testPath, String requestPath) {
        if (testPath == null) {
            return false;
        }
        if (testPath.equals(requestPath)) {
            return true;
        }
        if (testPath.equals("/*")) {
            return true;
        }
        if (testPath.endsWith("/*")) {
            if (testPath.regionMatches(0, requestPath, 0, testPath.length() - 2)) {
                if (requestPath.length() == testPath.length() - 2) {
                    return true;
                }
                if ('/' == requestPath.charAt(testPath.length() - 2)) {
                    return true;
                }
            }
            return false;
        }
        if (testPath.startsWith("*.")) {
            int slash = requestPath.lastIndexOf(47);
            int period = requestPath.lastIndexOf(46);
            if (slash >= 0 && period > slash && period != requestPath.length() - 1 && requestPath.length() - period == testPath.length() - 1) {
                return testPath.regionMatches(2, requestPath, period + 1, testPath.length() - 2);
            }
        }
        return false;
    }

    private boolean matchFiltersServlet(FilterMap filterMap, String servletName) {
        if (servletName == null) {
            return false;
        }
        if (filterMap.getMatchAllServletNames()) {
            return true;
        }
        String[] servletNames = filterMap.getServletNames();
        for (int i = 0; i < servletNames.length; ++i) {
            if (!servletName.equals(servletNames[i])) continue;
            return true;
        }
        return false;
    }

    private boolean matchDispatcher(FilterMap filterMap, int dispatcher) {
        switch (dispatcher) {
            case 2: {
                if ((filterMap.getDispatcherMapping() & 2) != 2) break;
                return true;
            }
            case 4: {
                if ((filterMap.getDispatcherMapping() & 4) != 4) break;
                return true;
            }
            case 8: {
                if ((filterMap.getDispatcherMapping() & 8) != 8) break;
                return true;
            }
            case 1: {
                if ((filterMap.getDispatcherMapping() & 1) != 1) break;
                return true;
            }
            case 16: {
                if ((filterMap.getDispatcherMapping() & 0x10) != 16) break;
                return true;
            }
        }
        return false;
    }
}

