/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.cli.tools;

import com.sun.identity.cli.annotation.Macro;
import com.sun.identity.cli.annotation.SubCommandInfo;
import com.sun.identity.cli.definition.AccessManager;
import com.sun.identity.federation.cli.definition.FederationManager;
import com.sun.identity.federation.cli.tools.WebHelperMethodCreator;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebHelperCreator {
    public static void main(String[] argv) {
        if (argv.length < 1) {
            System.err.println("clihelper-output system property is not set");
            System.exit(1);
        }
        String outfile = argv[0];
        try {
            Class[] classes = new Class[]{AccessManager.class, FederationManager.class};
            StringBuffer buff = new StringBuffer();
            WebHelperCreator.getCommands(classes, buff);
            BufferedWriter out = new BufferedWriter(new FileWriter(outfile));
            out.write(buff.toString());
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void getCommands(Class[] classes, StringBuffer buff) throws Exception {
        buff.append("package com.sun.identity.qatest.common;\n\n");
        buff.append("import com.gargoylesoftware.htmlunit.html.HtmlForm;\n");
        buff.append("import com.gargoylesoftware.htmlunit.html.HtmlCheckBoxInput;\n");
        buff.append("import com.gargoylesoftware.htmlunit.html.HtmlHiddenInput;\n");
        buff.append("import com.gargoylesoftware.htmlunit.html.HtmlPage;\n");
        buff.append("import com.gargoylesoftware.htmlunit.html.HtmlSelect;\n");
        buff.append("import com.gargoylesoftware.htmlunit.html.HtmlTextArea;\n");
        buff.append("import com.gargoylesoftware.htmlunit.html.HtmlTextInput;\n");
        buff.append("import com.gargoylesoftware.htmlunit.WebClient;\n");
        buff.append("import java.io.BufferedReader;\n");
        buff.append("import java.io.FileReader;\n");
        buff.append("import java.lang.StringBuffer;\n");
        buff.append("import java.net.URL;\n");
        buff.append("import java.util.Iterator;\n");
        buff.append("import java.util.List;\n\n");
        buff.append("public class FederationManager {\n");
        buff.append("    private String amadmUrl;\n");
        buff.append("    private String amUrl;\n\n");
        buff.append("    public FederationManager(String url) {\n");
        buff.append("        amUrl = url;\n");
        buff.append("        amadmUrl = url + \"/ssoadm.jsp?cmd=\";\n");
        buff.append("    }\n\n\n");
        buff.append("    public static int getExitCode(HtmlPage p) {\n");
        buff.append("        int val = -1;\n");
        buff.append("        String content = ").append("p.getWebResponse().getContentAsString();\n");
        buff.append("        int start = content.indexOf(\"").append("<!-- CLI Exit Code: \");\n");
        buff.append("        if (start != -1) {\n");
        buff.append("            int end = content.indexOf(\"").append("-->\", start);\n");
        buff.append("            if (end != -1) {\n");
        buff.append("                String exitCode = ").append("content.substring(start+20, end-1);\n");
        buff.append("                val = Integer.parseInt(exitCode);\n");
        buff.append("            }\n");
        buff.append("        }\n");
        buff.append("        return val;\n");
        buff.append("    }\n");
        for (int i = 0; i < classes.length; ++i) {
            Field[] fields;
            Class clazz = classes[i];
            for (Field fld : fields = clazz.getDeclaredFields()) {
                SubCommandInfo info = fld.getAnnotation(SubCommandInfo.class);
                if (info == null) continue;
                if (info.implClassName() == null || info.description() == null) {
                    throw new Exception("Incorrect Definition, class=" + clazz.getName() + " field=" + fld.toString());
                }
                if (!info.webSupport().equals("true")) continue;
                List<String> mandatoryOptions = WebHelperCreator.toList(info.mandatoryOptions());
                List<String> optionalOptions = WebHelperCreator.toList(info.optionalOptions());
                List<String> optionAliases = WebHelperCreator.toList(info.optionAliases());
                if (info.macro() != null && info.macro().length() > 0) {
                    Field fldMarco = clazz.getDeclaredField(info.macro());
                    Macro macroInfo = fldMarco.getAnnotation(Macro.class);
                    WebHelperCreator.appendToList(mandatoryOptions, macroInfo.mandatoryOptions());
                    WebHelperCreator.appendToList(optionalOptions, macroInfo.optionalOptions());
                    WebHelperCreator.appendToList(optionAliases, macroInfo.optionAliases());
                }
                WebHelperMethodCreator wMethod = new WebHelperMethodCreator(fld.getName(), info.description(), mandatoryOptions, optionalOptions, optionAliases);
                wMethod.genMethod(buff);
            }
        }
        buff.append("}\n");
    }

    public static List<String> toList(String[] array) {
        ArrayList<String> list = new ArrayList<String>();
        if (array != null && array.length > 0) {
            for (int i = 0; i < array.length; ++i) {
                list.add(array[i]);
            }
        }
        return list;
    }

    public static void appendToList(List<String> list, String[] array) {
        if (array != null && array.length > 0) {
            for (int i = 0; i < array.length; ++i) {
                list.add(array[i]);
            }
        }
    }
}

