/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.internal.InternalInjectorCreator;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InjectorBuilder {
    private final InternalInjectorCreator creator = new InternalInjectorCreator();
    private Stage stage = Stage.DEVELOPMENT;
    private boolean jitDisabled = false;
    private boolean allowCircularProxy = true;

    public InjectorBuilder stage(Stage stage) {
        this.stage = stage;
        return this;
    }

    public InjectorBuilder requireExplicitBindings() {
        this.jitDisabled = true;
        return this;
    }

    public InjectorBuilder disableCircularProxies() {
        this.allowCircularProxy = false;
        return this;
    }

    public InjectorBuilder addModules(Iterable<? extends Module> modules) {
        this.creator.addModules(modules);
        return this;
    }

    public InjectorBuilder addModules(Module ... modules) {
        this.creator.addModules(Arrays.asList(modules));
        return this;
    }

    public Injector build() {
        this.creator.injectorOptions(new InternalInjectorCreator.InjectorOptions(this.stage, this.jitDisabled, this.allowCircularProxy));
        return this.creator.build();
    }
}

